package io.github.opensabe.mapstruct.processor;


import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;

public class MapperRegister {

    private String className;

    private String name;

    private String target;

    private String source;

    public MapperRegister(@Nonnull String className, @Nullable String source,  @Nonnull String target) {
        this.className = className;
        this.name = className.substring(className.lastIndexOf(".")+1);
        this.source = source;
        this.target = target;
    }


    public String getClassName() {
        return className;
    }

    public String getName() {
        return name;
    }

    public String getTarget() {
        return target;
    }

    public String getSource() {
        return source;
    }
}
