/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.mapstruct.processor;

import io.github.opensabe.mapstruct.core.CommonCopyMapper;
import io.github.opensabe.mapstruct.core.FromMapMapper;
import io.github.opensabe.mapstruct.core.MapperRegister;
import io.github.opensabe.mapstruct.processor.CustomerMapper;
import io.github.opensabe.mapstruct.processor.FreeMarkerProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mapstruct.Mapper;

@SupportedAnnotationTypes(value={"io.github.opensabe.mapstruct.core.RegisterRepository"})
public class CustomerRegisterProcessor
extends FreeMarkerProcessor {
    private final List<CustomerMapper> mappers = new ArrayList<CustomerMapper>();
    private Types typeUtils;
    private Elements elementUtils;
    private TypeMirror commonMirror;
    private TypeMirror mapMirror;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.commonMirror = this.typeUtils.erasure(this.elementUtils.getTypeElement(CommonCopyMapper.class.getName()).asType());
        this.mapMirror = this.typeUtils.erasure(this.elementUtils.getTypeElement(FromMapMapper.class.getName()).asType());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            for (TypeElement typeElement : annotations) {
                Set<? extends Element> mappers = roundEnv.getElementsAnnotatedWith(typeElement);
                for (Element element : mappers) {
                    if (!this.hasMapperAnnotation(element) || !(element instanceof TypeElement)) continue;
                    TypeElement typeElement2 = (TypeElement)element;
                    typeElement2.getInterfaces().stream().filter(this::isSubtype).filter(m -> m instanceof DeclaredType).findFirst().ifPresent(m -> {
                        List<? extends TypeMirror> arguments = ((DeclaredType)m).getTypeArguments();
                        if (arguments.size() == 2) {
                            this.mappers.add(new CustomerMapper(mapper.toString(), arguments.get(0).toString(), arguments.get(1).toString()));
                        } else {
                            this.mappers.add(new CustomerMapper(mapper.toString(), null, arguments.get(0).toString()));
                        }
                    });
                }
            }
        } else {
            TypeElement interfaceName = this.elementUtils.getTypeElement(MapperRegister.class.getName());
            String string = interfaceName.toString() + "Impl";
            this.writeClass(string, MapperRegister.class.getSimpleName() + ".ftl", Map.of("mappers", this.mappers));
            this.mappers.clear();
        }
        return false;
    }

    private boolean isSubtype(TypeMirror type) {
        return this.typeUtils.isSubtype(type, this.mapMirror) || this.typeUtils.isSubtype(type, this.commonMirror);
    }

    private boolean hasMapperAnnotation(Element mapper) {
        return this.elementUtils.getAllAnnotationMirrors(mapper).stream().anyMatch(a -> this.typeUtils.isSameType(this.elementUtils.getTypeElement(Mapper.class.getName()).asType(), a.getAnnotationType()));
    }
}

