/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.mapstruct.processor;

import io.github.opensabe.mapstruct.core.Binding;
import io.github.opensabe.mapstruct.processor.AbstractMapper;
import io.github.opensabe.mapstruct.processor.FreeMarkerProcessor;
import io.github.opensabe.mapstruct.processor.MapperRep;
import io.github.opensabe.mapstruct.processor.MetaDataFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

@SupportedAnnotationTypes(value={"io.github.opensabe.mapstruct.core.Binding"})
public class MapperGeneratorProcessor
extends FreeMarkerProcessor {
    private Elements elementUtils;
    private Types typeUtils;
    private TypeMirror bindingMirror;
    static MapperRep mappers = new MapperRep();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.elementUtils = processingEnv.getElementUtils();
        this.typeUtils = processingEnv.getTypeUtils();
        this.bindingMirror = this.elementUtils.getTypeElement(Binding.class.getName()).asType();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            HashSet<? extends AbstractMapper> maps = new HashSet<AbstractMapper>();
            for (TypeElement typeElement : annotations) {
                Set<? extends Element> beans = roundEnv.getElementsAnnotatedWith(typeElement);
                for (Element element : beans) {
                    List bindings = element.getAnnotationMirrors().stream().filter(m -> this.typeUtils.isSameType(m.getAnnotationType(), this.bindingMirror)).collect(Collectors.toList());
                    maps.addAll(MetaDataFactory.create(this.elementUtils, element, bindings));
                }
            }
            for (AbstractMapper abstractMapper : maps) {
                if (mappers.contains(abstractMapper)) continue;
                String className = abstractMapper.getPackageName() + "." + abstractMapper.getMapperName();
                this.writeClass(className, abstractMapper.template(), abstractMapper);
                mappers.add(abstractMapper);
            }
        }
        return false;
    }
}

