/*
 * Decompiled with CFR 0.152.
 */
package io.github.opensabe.mapstruct.processor;

import com.google.common.collect.Sets;
import io.github.opensabe.mapstruct.processor.AbstractMapper;
import io.github.opensabe.mapstruct.processor.CommonMapper;
import io.github.opensabe.mapstruct.processor.MapMapper;
import io.github.opensabe.mapstruct.processor.SelfMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.util.Elements;
import org.springframework.util.StringUtils;

public class MetaDataFactory {
    static BinaryOperator<BindRelation> reducer = (a, b) -> {
        a.values.addAll(b.values);
        return new BindRelation(a.cycle || b.cycle, a.values);
    };

    static Set<? extends AbstractMapper> create(Elements elementUtils, Element bean, List<? extends AnnotationMirror> binding) {
        String packageName = elementUtils.getPackageOf(bean).toString() + ".mapper";
        HashSet<AbstractMapper> result = new HashSet<AbstractMapper>();
        BindRelation relations = BindRelation.resolveBinding(elementUtils, binding).stream().reduce(reducer).orElseThrow();
        result.add(relations.createMapMapper(packageName, bean));
        result.addAll(relations.createCommonMapper(packageName, bean));
        return result;
    }

    private static List<String> resolveElements(String v) {
        return Arrays.stream(v.replace("{", "").replace("}", "").replace(".class", "").split(",")).map(String::trim).toList();
    }

    record BindRelation(boolean cycle, Set<String> values) {
        Set<AbstractMapper> createCommonMapper(String packageName, Element bean) {
            SelfMapper self = new SelfMapper(packageName, bean.toString(), bean.getSimpleName() + "Mapper", this.cycle);
            HashSet list = Sets.newHashSet((Object[])new AbstractMapper[]{self});
            if (this.values.isEmpty()) {
                return list;
            }
            this.values.remove(bean.toString());
            if (this.values.isEmpty()) {
                return list;
            }
            list.addAll(this.values.stream().filter(StringUtils::hasText).map(v -> {
                String name = bean.getSimpleName() + v.substring(v.lastIndexOf(".") + 1) + "Mapper";
                return new CommonMapper(packageName, bean.toString(), name, (String)v, this.cycle);
            }).toList());
            return list;
        }

        MapMapper createMapMapper(String packageName, Element bean) {
            return new MapMapper(packageName, bean.toString(), bean.getSimpleName() + "MapMapper", this.cycle);
        }

        static List<BindRelation> resolveBinding(Elements elementUtils, List<? extends AnnotationMirror> binding) {
            ArrayList<BindRelation> eles = new ArrayList<BindRelation>();
            for (AnnotationMirror annotationMirror : binding) {
                boolean cycle = false;
                HashSet<String> values = new HashSet<String>();
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : elementUtils.getElementValuesWithDefaults(annotationMirror).entrySet()) {
                    switch (e.getKey().getSimpleName().toString()) {
                        case "value": {
                            values.addAll(MetaDataFactory.resolveElements(e.getValue().toString()));
                            break;
                        }
                        case "cycle": {
                            cycle = cycle || (Boolean)e.getValue().getValue() != false;
                        }
                    }
                }
                eles.add(new BindRelation(cycle, values));
            }
            return eles;
        }
    }
}

