/*
 * Decompiled with CFR 0.152.
 */
package io.github.pigaut.orestack.api.event;

import io.github.pigaut.voxel.event.PlayerEvent;
import io.github.pigaut.yaml.util.Preconditions;
import java.util.Collection;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratorMineEvent
extends PlayerEvent {
    private static final HandlerList HANDLERS = new HandlerList();
    private final Block blockMined;
    private boolean idle = false;
    @Nullable
    private Collection<ItemStack> drops = null;
    private int expToDrop = 0;
    private int toolDamage = 0;

    public GeneratorMineEvent(@NotNull Player player, @NotNull Block blockMined) {
        super(player);
        this.blockMined = blockMined;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }

    public HandlerList getHandlers() {
        return HANDLERS;
    }

    @NotNull
    public Block getBlockMined() {
        return this.blockMined;
    }

    public boolean isIdle() {
        return this.idle;
    }

    public void setIdle(boolean idle) {
        this.idle = idle;
    }

    @Nullable
    public Collection<ItemStack> getItemDrops() {
        return this.drops;
    }

    public void setItemDrops(@Nullable Collection<ItemStack> drops) {
        this.drops = drops;
    }

    public int getExpDrops() {
        return this.expToDrop;
    }

    public void setExpDrops(int expToDrop) {
        Preconditions.checkArgument((expToDrop > -1 ? 1 : 0) != 0, (String)"Exp drop must be a positive amount");
        this.expToDrop = expToDrop;
    }

    public int getToolDamage() {
        return this.toolDamage;
    }

    public void setToolDamage(int toolDamage) {
        Preconditions.checkArgument((toolDamage > -1 ? 1 : 0) != 0, (String)"Tool damage must be a positive amount");
        this.toolDamage = toolDamage;
    }
}

