package io.github.pigaut.sql;

import com.zaxxer.hikari.*;
import io.github.pigaut.sql.database.*;

import java.io.*;

public class SQLib {

    private SQLib() {}

    public static HikariDataSource createDataSource(File h2DatabaseFile) {
        HikariConfig config = new HikariConfig();
        config.setDataSourceClassName("org.h2.jdbcx.JdbcDataSource");
        config.setConnectionTestQuery("VALUES 1");
        config.addDataSourceProperty("URL", "jdbc:h2:file:" + h2DatabaseFile.getAbsolutePath() + ";TRACE_LEVEL_FILE=0;DB_CLOSE_ON_EXIT=FALSE");
        return new HikariDataSource(config);
    }

    public static HikariDataSource createDataSource(String database, String host, String port, String username, String password) {
        HikariConfig config = new HikariConfig();
        String jdbcUrl = String.format("jdbc:mysql://%s:%s/%s", host, port, database);
        config.setJdbcUrl(jdbcUrl);
        config.setUsername(username);
        config.setPassword(password);

        return new HikariDataSource(config);
    }

    public static Database createDatabase(File file) {
        return new FileDatabase(file);
    }

    public static Database createDatabase(File parent, String name) {
        return createDatabase(new File(parent, name));
    }

}
