/*
 * Decompiled with CFR 0.152.
 */
package io.github.pigaut.sql.database;

import com.zaxxer.hikari.HikariDataSource;
import io.github.pigaut.sql.Database;
import io.github.pigaut.sql.DatabaseStatement;
import io.github.pigaut.sql.SQLib;
import io.github.pigaut.sql.database.statement.QueryReader;
import io.github.pigaut.sql.database.statement.SimpleDatabaseStatement;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import javax.sql.DataSource;

public class FileDatabase
implements Database {
    private final File file;
    private HikariDataSource dataSource = null;

    public FileDatabase(File file) {
        this.file = file;
    }

    @Override
    public boolean isConnected() {
        return this.dataSource != null && this.dataSource.isRunning();
    }

    @Override
    public void openConnection() {
        if (this.dataSource == null || !this.dataSource.isRunning()) {
            this.dataSource = SQLib.createDataSource(this.file);
        }
    }

    @Override
    public void closeConnection() {
        if (this.dataSource != null && !this.dataSource.isRunning()) {
            this.dataSource.close();
            this.dataSource = null;
        }
    }

    @Override
    public DatabaseStatement createStatement(String sql) {
        return new SimpleDatabaseStatement(this, sql);
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public void createTableIfNotExists(String name, String ... columns) {
        String columnsDef = String.join((CharSequence)", ", columns);
        String createTableSQL = String.format("CREATE TABLE IF NOT EXISTS %s (%s);", name, columnsDef);
        this.execute(createTableSQL);
    }

    @Override
    public void dropTable(String table) {
        String dropTableSQL = String.format("DROP TABLE %s;", table);
        this.execute(dropTableSQL);
    }

    @Override
    public void renameTable(String table, String newName) {
        String renameTableSQL = String.format("ALTER TABLE %s RENAME TO %s;", table, newName);
        this.execute(renameTableSQL);
    }

    @Override
    public void addColumn(String table, String columnDefinition) {
        String addColumnStmt = String.format("ALTER TABLE %s ADD %s;", table, columnDefinition);
        this.execute(addColumnStmt);
    }

    @Override
    public void renameColumn(String table, String column, String newName) {
        String renameColumnStmt = String.format("ALTER TABLE %s RENAME COLUMN %s TO %s", table, column, newName);
        this.execute(renameColumnStmt);
    }

    @Override
    public void clearTable(String table) {
        String deleteFromSQL = String.format("TRUNCATE TABLE %s", table);
        this.executeUpdate(deleteFromSQL);
    }

    @Override
    public DatabaseStatement insert(String table, String ... columns) {
        String columnsDef = String.join((CharSequence)", ", columns);
        String values = String.join((CharSequence)", ", Collections.nCopies(columns.length, "?"));
        String insertIntoSQL = String.format("INSERT INTO %s (%s) VALUES (%s);", table, columnsDef, values);
        return new SimpleDatabaseStatement(this, insertIntoSQL);
    }

    @Override
    public DatabaseStatement merge(String table, String primaryKey, String ... columns) {
        String columnsDef = String.join((CharSequence)", ", columns);
        String values = String.join((CharSequence)", ", Collections.nCopies(columns.length, "?"));
        String insertIntoSQL = String.format("MERGE INTO %s (%s) KEY(%s) VALUES (%s)", table, columnsDef, primaryKey, values);
        return new SimpleDatabaseStatement(this, insertIntoSQL);
    }

    @Override
    public DatabaseStatement selectAll(String table) {
        String selectAllSQL = String.format("SELECT * FROM %s;", table);
        return new SimpleDatabaseStatement(this, selectAllSQL);
    }

    /*
     * Exception decompiling
     */
    private <T> T executeStatement(StatementExecutor<T> executor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void execute(String sql) {
        this.executeStatement(statement -> statement.execute(sql));
    }

    @Override
    public int executeUpdate(String sql) {
        return this.executeStatement(statement -> statement.executeUpdate(sql));
    }

    @Override
    public long executeLargeUpdate(String sql) {
        return this.executeStatement(statement -> statement.executeLargeUpdate(sql));
    }

    @Override
    public void executeQuery(String sql, QueryReader reader) {
        this.executeStatement(statement -> {
            try (ResultSet results = statement.executeQuery(sql);){
                reader.read(results);
            }
            return null;
        });
    }

    @Override
    public void executeRowQuery(String sql, QueryReader reader) {
        this.executeStatement(preparedStatement -> {
            try (ResultSet results = preparedStatement.executeQuery(sql);){
                while (results.next()) {
                    reader.read(results);
                }
            }
            return null;
        });
    }

    @FunctionalInterface
    private static interface StatementExecutor<T> {
        public T execute(Statement var1) throws SQLException;
    }
}

