/*
 * Decompiled with CFR 0.152.
 */
package io.github.pigaut.sql.database.statement;

import io.github.pigaut.sql.Database;
import io.github.pigaut.sql.DatabaseStatement;
import io.github.pigaut.sql.database.statement.QueryReader;
import io.github.pigaut.sql.database.statement.StatementOption;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class SimpleDatabaseStatement
implements DatabaseStatement {
    private final Database database;
    private String sql;
    private final List<StatementOption> options = new ArrayList<StatementOption>();
    private int currentParameter = 1;

    public SimpleDatabaseStatement(Database database, String sql) {
        this.database = database;
        this.sql = sql;
    }

    @Override
    public DatabaseStatement replace(String placeholder, String value) {
        this.sql = this.sql.replaceAll(placeholder, value);
        return this;
    }

    @Override
    public DatabaseStatement addOption(StatementOption option) {
        this.options.add(option);
        return this;
    }

    @Override
    public void clearOptions() {
        this.options.clear();
        this.currentParameter = 1;
    }

    @Override
    public DatabaseStatement addBatch() {
        this.options.add(PreparedStatement::addBatch);
        this.currentParameter = 1;
        return this;
    }

    @Override
    public DatabaseStatement withNullParameter() {
        int parameterIndex = this.currentParameter++;
        this.options.add(stmt -> stmt.setNull(parameterIndex, 0));
        return this;
    }

    @Override
    public DatabaseStatement withParameter(Object object) {
        int parameterIndex = this.currentParameter++;
        this.options.add(stmt -> stmt.setObject(parameterIndex, object));
        return this;
    }

    @Override
    public DatabaseStatement withParameter(Object object, int sqlType) {
        int parameterIndex = this.currentParameter++;
        this.options.add(stmt -> stmt.setObject(parameterIndex, object, sqlType));
        return this;
    }

    @Override
    public DatabaseStatement withParameter(boolean value) {
        int parameterIndex = this.currentParameter++;
        this.options.add(stmt -> stmt.setBoolean(parameterIndex, value));
        return this;
    }

    @Override
    public DatabaseStatement withParameter(String value) {
        int parameterIndex = this.currentParameter++;
        this.options.add(stmt -> stmt.setString(parameterIndex, value));
        return this;
    }

    @Override
    public DatabaseStatement withParameter(int value) {
        int parameterIndex = this.currentParameter++;
        this.options.add(stmt -> stmt.setInt(parameterIndex, value));
        return this;
    }

    @Override
    public DatabaseStatement withParameter(long value) {
        int parameterIndex = this.currentParameter++;
        this.options.add(stmt -> stmt.setLong(parameterIndex, value));
        return this;
    }

    @Override
    public DatabaseStatement withParameter(short value) {
        int parameterIndex = this.currentParameter++;
        this.options.add(stmt -> stmt.setShort(parameterIndex, value));
        return this;
    }

    @Override
    public DatabaseStatement withParameter(byte value) {
        int parameterIndex = this.currentParameter++;
        this.options.add(stmt -> stmt.setByte(parameterIndex, value));
        return this;
    }

    @Override
    public DatabaseStatement withParameter(float value) {
        int parameterIndex = this.currentParameter++;
        this.options.add(stmt -> stmt.setFloat(parameterIndex, value));
        return this;
    }

    @Override
    public DatabaseStatement withParameter(double value) {
        int parameterIndex = this.currentParameter++;
        this.options.add(stmt -> stmt.setDouble(parameterIndex, value));
        return this;
    }

    @Override
    public DatabaseStatement withParameter(InputStream inputStream) {
        int parameterIndex = this.currentParameter++;
        this.options.add(stmt -> stmt.setBinaryStream(parameterIndex, inputStream));
        return this;
    }

    @Override
    public boolean execute() {
        return this.executeStatement(PreparedStatement::execute);
    }

    @Override
    public int executeUpdate() {
        return this.executeStatement(PreparedStatement::executeUpdate);
    }

    @Override
    public long executeLargeUpdate() {
        return this.executeStatement(PreparedStatement::executeLargeUpdate);
    }

    @Override
    public void executeQuery(QueryReader reader) {
        this.executeStatement(preparedStatement -> {
            try (ResultSet results = preparedStatement.executeQuery();){
                reader.read(results);
            }
            return null;
        });
    }

    @Override
    public void fetchRow(QueryReader reader) {
        this.executeStatement(preparedStatement -> {
            try (ResultSet results = preparedStatement.executeQuery();){
                if (results.next()) {
                    reader.read(results);
                }
            }
            return null;
        });
    }

    @Override
    public void fetchAllRows(QueryReader reader) {
        this.executeStatement(preparedStatement -> {
            try (ResultSet results = preparedStatement.executeQuery();){
                while (results.next()) {
                    reader.read(results);
                }
            }
            return null;
        });
    }

    @Override
    public int[] executeBatch() {
        return this.executeStatement(Statement::executeBatch);
    }

    @Override
    public long[] executeLargeBatch() {
        return this.executeStatement(Statement::executeLargeBatch);
    }

    /*
     * Exception decompiling
     */
    private <T> T executeStatement(StatementExecutor<T> executor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @FunctionalInterface
    private static interface StatementExecutor<T> {
        public T execute(PreparedStatement var1) throws SQLException;
    }
}

