/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.api;

import com.google.gson.reflect.TypeToken;
import io.github.pod4dev.libpodj.ApiCallback;
import io.github.pod4dev.libpodj.ApiClient;
import io.github.pod4dev.libpodj.ApiException;
import io.github.pod4dev.libpodj.ApiResponse;
import io.github.pod4dev.libpodj.Configuration;
import io.github.pod4dev.libpodj.Pair;
import io.github.pod4dev.libpodj.model.DisconnectOptions;
import io.github.pod4dev.libpodj.model.Network;
import io.github.pod4dev.libpodj.model.NetworkConnectOptions;
import io.github.pod4dev.libpodj.model.NetworkCreateLibpod;
import io.github.pod4dev.libpodj.model.NetworkInspectReport;
import io.github.pod4dev.libpodj.model.NetworkPruneReport;
import io.github.pod4dev.libpodj.model.NetworkRmReport;
import io.github.pod4dev.libpodj.model.NetworkUpdateOptions;
import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class NetworksApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public NetworksApi() {
        this(Configuration.getDefaultApiClient());
    }

    public NetworksApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call networkConnectLibpodCall(String name, NetworkConnectOptions create, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkConnectOptions localVarPostBody = create;
        String localVarPath = "/libpod/networks/{name}/connect".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkConnectLibpodValidateBeforeCall(String name, NetworkConnectOptions create, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling networkConnectLibpod(Async)");
        }
        return this.networkConnectLibpodCall(name, create, _callback);
    }

    private ApiResponse<Void> networkConnectLibpodWithHttpInfo(@NotNull String name, NetworkConnectOptions create) throws ApiException {
        Call localVarCall = this.networkConnectLibpodValidateBeforeCall(name, create, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call networkConnectLibpodAsync(String name, NetworkConnectOptions create, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.networkConnectLibpodValidateBeforeCall(name, create, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APInetworkConnectLibpodRequest networkConnectLibpod(String name) {
        return new APInetworkConnectLibpodRequest(name);
    }

    private Call networkCreateLibpodCall(NetworkCreateLibpod create, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkCreateLibpod localVarPostBody = create;
        String localVarPath = "/libpod/networks/create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkCreateLibpodValidateBeforeCall(NetworkCreateLibpod create, ApiCallback _callback) throws ApiException {
        return this.networkCreateLibpodCall(create, _callback);
    }

    private ApiResponse<Network> networkCreateLibpodWithHttpInfo(NetworkCreateLibpod create) throws ApiException {
        Call localVarCall = this.networkCreateLibpodValidateBeforeCall(create, null);
        Type localVarReturnType = new TypeToken<Network>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call networkCreateLibpodAsync(NetworkCreateLibpod create, ApiCallback<Network> _callback) throws ApiException {
        Call localVarCall = this.networkCreateLibpodValidateBeforeCall(create, _callback);
        Type localVarReturnType = new TypeToken<Network>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APInetworkCreateLibpodRequest networkCreateLibpod() {
        return new APInetworkCreateLibpodRequest();
    }

    private Call networkDeleteLibpodCall(String name, Boolean force, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/networks/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (force != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("force", force));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkDeleteLibpodValidateBeforeCall(String name, Boolean force, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling networkDeleteLibpod(Async)");
        }
        return this.networkDeleteLibpodCall(name, force, _callback);
    }

    private ApiResponse<List<NetworkRmReport>> networkDeleteLibpodWithHttpInfo(@NotNull String name, Boolean force) throws ApiException {
        Call localVarCall = this.networkDeleteLibpodValidateBeforeCall(name, force, null);
        Type localVarReturnType = new TypeToken<List<NetworkRmReport>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call networkDeleteLibpodAsync(String name, Boolean force, ApiCallback<List<NetworkRmReport>> _callback) throws ApiException {
        Call localVarCall = this.networkDeleteLibpodValidateBeforeCall(name, force, _callback);
        Type localVarReturnType = new TypeToken<List<NetworkRmReport>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APInetworkDeleteLibpodRequest networkDeleteLibpod(String name) {
        return new APInetworkDeleteLibpodRequest(name);
    }

    private Call networkDisconnectLibpodCall(String name, DisconnectOptions create, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        DisconnectOptions localVarPostBody = create;
        String localVarPath = "/libpod/networks/{name}/disconnect".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkDisconnectLibpodValidateBeforeCall(String name, DisconnectOptions create, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling networkDisconnectLibpod(Async)");
        }
        return this.networkDisconnectLibpodCall(name, create, _callback);
    }

    private ApiResponse<Void> networkDisconnectLibpodWithHttpInfo(@NotNull String name, DisconnectOptions create) throws ApiException {
        Call localVarCall = this.networkDisconnectLibpodValidateBeforeCall(name, create, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call networkDisconnectLibpodAsync(String name, DisconnectOptions create, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.networkDisconnectLibpodValidateBeforeCall(name, create, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APInetworkDisconnectLibpodRequest networkDisconnectLibpod(String name) {
        return new APInetworkDisconnectLibpodRequest(name);
    }

    private Call networkExistsLibpodCall(String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/networks/{name}/exists".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkExistsLibpodValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling networkExistsLibpod(Async)");
        }
        return this.networkExistsLibpodCall(name, _callback);
    }

    private ApiResponse<Void> networkExistsLibpodWithHttpInfo(@NotNull String name) throws ApiException {
        Call localVarCall = this.networkExistsLibpodValidateBeforeCall(name, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call networkExistsLibpodAsync(String name, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.networkExistsLibpodValidateBeforeCall(name, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APInetworkExistsLibpodRequest networkExistsLibpod(String name) {
        return new APInetworkExistsLibpodRequest(name);
    }

    private Call networkInspectLibpodCall(String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/networks/{name}/json".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkInspectLibpodValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling networkInspectLibpod(Async)");
        }
        return this.networkInspectLibpodCall(name, _callback);
    }

    private ApiResponse<NetworkInspectReport> networkInspectLibpodWithHttpInfo(@NotNull String name) throws ApiException {
        Call localVarCall = this.networkInspectLibpodValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<NetworkInspectReport>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call networkInspectLibpodAsync(String name, ApiCallback<NetworkInspectReport> _callback) throws ApiException {
        Call localVarCall = this.networkInspectLibpodValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<NetworkInspectReport>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APInetworkInspectLibpodRequest networkInspectLibpod(String name) {
        return new APInetworkInspectLibpodRequest(name);
    }

    private Call networkListLibpodCall(String filters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/networks/json";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkListLibpodValidateBeforeCall(String filters, ApiCallback _callback) throws ApiException {
        return this.networkListLibpodCall(filters, _callback);
    }

    private ApiResponse<List<Network>> networkListLibpodWithHttpInfo(String filters) throws ApiException {
        Call localVarCall = this.networkListLibpodValidateBeforeCall(filters, null);
        Type localVarReturnType = new TypeToken<List<Network>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call networkListLibpodAsync(String filters, ApiCallback<List<Network>> _callback) throws ApiException {
        Call localVarCall = this.networkListLibpodValidateBeforeCall(filters, _callback);
        Type localVarReturnType = new TypeToken<List<Network>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APInetworkListLibpodRequest networkListLibpod() {
        return new APInetworkListLibpodRequest();
    }

    private Call networkPruneLibpodCall(String filters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/networks/prune";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkPruneLibpodValidateBeforeCall(String filters, ApiCallback _callback) throws ApiException {
        return this.networkPruneLibpodCall(filters, _callback);
    }

    private ApiResponse<List<NetworkPruneReport>> networkPruneLibpodWithHttpInfo(String filters) throws ApiException {
        Call localVarCall = this.networkPruneLibpodValidateBeforeCall(filters, null);
        Type localVarReturnType = new TypeToken<List<NetworkPruneReport>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call networkPruneLibpodAsync(String filters, ApiCallback<List<NetworkPruneReport>> _callback) throws ApiException {
        Call localVarCall = this.networkPruneLibpodValidateBeforeCall(filters, _callback);
        Type localVarReturnType = new TypeToken<List<NetworkPruneReport>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APInetworkPruneLibpodRequest networkPruneLibpod() {
        return new APInetworkPruneLibpodRequest();
    }

    private Call networkUpdateLibpodCall(String name, NetworkUpdateOptions update, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        NetworkUpdateOptions localVarPostBody = update;
        String localVarPath = "/libpod/networks/{name}/update".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call networkUpdateLibpodValidateBeforeCall(String name, NetworkUpdateOptions update, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling networkUpdateLibpod(Async)");
        }
        return this.networkUpdateLibpodCall(name, update, _callback);
    }

    private ApiResponse<Void> networkUpdateLibpodWithHttpInfo(@NotNull String name, NetworkUpdateOptions update) throws ApiException {
        Call localVarCall = this.networkUpdateLibpodValidateBeforeCall(name, update, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call networkUpdateLibpodAsync(String name, NetworkUpdateOptions update, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.networkUpdateLibpodValidateBeforeCall(name, update, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APInetworkUpdateLibpodRequest networkUpdateLibpod(String name) {
        return new APInetworkUpdateLibpodRequest(name);
    }

    public class APInetworkConnectLibpodRequest {
        private final String name;
        private NetworkConnectOptions create;

        private APInetworkConnectLibpodRequest(String name) {
            this.name = name;
        }

        public APInetworkConnectLibpodRequest create(NetworkConnectOptions create) {
            this.create = create;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworksApi.this.networkConnectLibpodCall(this.name, this.create, _callback);
        }

        public void execute() throws ApiException {
            NetworksApi.this.networkConnectLibpodWithHttpInfo(this.name, this.create);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return NetworksApi.this.networkConnectLibpodWithHttpInfo(this.name, this.create);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return NetworksApi.this.networkConnectLibpodAsync(this.name, this.create, _callback);
        }
    }

    public class APInetworkCreateLibpodRequest {
        private NetworkCreateLibpod create;

        private APInetworkCreateLibpodRequest() {
        }

        public APInetworkCreateLibpodRequest create(NetworkCreateLibpod create) {
            this.create = create;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworksApi.this.networkCreateLibpodCall(this.create, _callback);
        }

        public Network execute() throws ApiException {
            ApiResponse<Network> localVarResp = NetworksApi.this.networkCreateLibpodWithHttpInfo(this.create);
            return localVarResp.getData();
        }

        public ApiResponse<Network> executeWithHttpInfo() throws ApiException {
            return NetworksApi.this.networkCreateLibpodWithHttpInfo(this.create);
        }

        public Call executeAsync(ApiCallback<Network> _callback) throws ApiException {
            return NetworksApi.this.networkCreateLibpodAsync(this.create, _callback);
        }
    }

    public class APInetworkDeleteLibpodRequest {
        private final String name;
        private Boolean force;

        private APInetworkDeleteLibpodRequest(String name) {
            this.name = name;
        }

        public APInetworkDeleteLibpodRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworksApi.this.networkDeleteLibpodCall(this.name, this.force, _callback);
        }

        public List<NetworkRmReport> execute() throws ApiException {
            ApiResponse<List<NetworkRmReport>> localVarResp = NetworksApi.this.networkDeleteLibpodWithHttpInfo(this.name, this.force);
            return localVarResp.getData();
        }

        public ApiResponse<List<NetworkRmReport>> executeWithHttpInfo() throws ApiException {
            return NetworksApi.this.networkDeleteLibpodWithHttpInfo(this.name, this.force);
        }

        public Call executeAsync(ApiCallback<List<NetworkRmReport>> _callback) throws ApiException {
            return NetworksApi.this.networkDeleteLibpodAsync(this.name, this.force, _callback);
        }
    }

    public class APInetworkDisconnectLibpodRequest {
        private final String name;
        private DisconnectOptions create;

        private APInetworkDisconnectLibpodRequest(String name) {
            this.name = name;
        }

        public APInetworkDisconnectLibpodRequest create(DisconnectOptions create) {
            this.create = create;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworksApi.this.networkDisconnectLibpodCall(this.name, this.create, _callback);
        }

        public void execute() throws ApiException {
            NetworksApi.this.networkDisconnectLibpodWithHttpInfo(this.name, this.create);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return NetworksApi.this.networkDisconnectLibpodWithHttpInfo(this.name, this.create);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return NetworksApi.this.networkDisconnectLibpodAsync(this.name, this.create, _callback);
        }
    }

    public class APInetworkExistsLibpodRequest {
        private final String name;

        private APInetworkExistsLibpodRequest(String name) {
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworksApi.this.networkExistsLibpodCall(this.name, _callback);
        }

        public void execute() throws ApiException {
            NetworksApi.this.networkExistsLibpodWithHttpInfo(this.name);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return NetworksApi.this.networkExistsLibpodWithHttpInfo(this.name);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return NetworksApi.this.networkExistsLibpodAsync(this.name, _callback);
        }
    }

    public class APInetworkInspectLibpodRequest {
        private final String name;

        private APInetworkInspectLibpodRequest(String name) {
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworksApi.this.networkInspectLibpodCall(this.name, _callback);
        }

        public NetworkInspectReport execute() throws ApiException {
            ApiResponse<NetworkInspectReport> localVarResp = NetworksApi.this.networkInspectLibpodWithHttpInfo(this.name);
            return localVarResp.getData();
        }

        public ApiResponse<NetworkInspectReport> executeWithHttpInfo() throws ApiException {
            return NetworksApi.this.networkInspectLibpodWithHttpInfo(this.name);
        }

        public Call executeAsync(ApiCallback<NetworkInspectReport> _callback) throws ApiException {
            return NetworksApi.this.networkInspectLibpodAsync(this.name, _callback);
        }
    }

    public class APInetworkListLibpodRequest {
        private String filters;

        private APInetworkListLibpodRequest() {
        }

        public APInetworkListLibpodRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworksApi.this.networkListLibpodCall(this.filters, _callback);
        }

        public List<Network> execute() throws ApiException {
            ApiResponse<List<Network>> localVarResp = NetworksApi.this.networkListLibpodWithHttpInfo(this.filters);
            return localVarResp.getData();
        }

        public ApiResponse<List<Network>> executeWithHttpInfo() throws ApiException {
            return NetworksApi.this.networkListLibpodWithHttpInfo(this.filters);
        }

        public Call executeAsync(ApiCallback<List<Network>> _callback) throws ApiException {
            return NetworksApi.this.networkListLibpodAsync(this.filters, _callback);
        }
    }

    public class APInetworkPruneLibpodRequest {
        private String filters;

        private APInetworkPruneLibpodRequest() {
        }

        public APInetworkPruneLibpodRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworksApi.this.networkPruneLibpodCall(this.filters, _callback);
        }

        public List<NetworkPruneReport> execute() throws ApiException {
            ApiResponse<List<NetworkPruneReport>> localVarResp = NetworksApi.this.networkPruneLibpodWithHttpInfo(this.filters);
            return localVarResp.getData();
        }

        public ApiResponse<List<NetworkPruneReport>> executeWithHttpInfo() throws ApiException {
            return NetworksApi.this.networkPruneLibpodWithHttpInfo(this.filters);
        }

        public Call executeAsync(ApiCallback<List<NetworkPruneReport>> _callback) throws ApiException {
            return NetworksApi.this.networkPruneLibpodAsync(this.filters, _callback);
        }
    }

    public class APInetworkUpdateLibpodRequest {
        private final String name;
        private NetworkUpdateOptions update;

        private APInetworkUpdateLibpodRequest(String name) {
            this.name = name;
        }

        public APInetworkUpdateLibpodRequest update(NetworkUpdateOptions update) {
            this.update = update;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return NetworksApi.this.networkUpdateLibpodCall(this.name, this.update, _callback);
        }

        public void execute() throws ApiException {
            NetworksApi.this.networkUpdateLibpodWithHttpInfo(this.name, this.update);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return NetworksApi.this.networkUpdateLibpodWithHttpInfo(this.name, this.update);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return NetworksApi.this.networkUpdateLibpodAsync(this.name, this.update, _callback);
        }
    }
}

