/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.api;

import com.google.gson.reflect.TypeToken;
import io.github.pod4dev.libpodj.ApiCallback;
import io.github.pod4dev.libpodj.ApiClient;
import io.github.pod4dev.libpodj.ApiException;
import io.github.pod4dev.libpodj.ApiResponse;
import io.github.pod4dev.libpodj.Configuration;
import io.github.pod4dev.libpodj.Pair;
import io.github.pod4dev.libpodj.model.SecretCreateLibpod201Response;
import io.github.pod4dev.libpodj.model.SecretInfoReport;
import jakarta.validation.constraints.NotNull;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;

public class SecretsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SecretsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SecretsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call secretCreateLibpodCall(String name, String driver, String driveropts, String labels, String request, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        String localVarPostBody = request;
        String localVarPath = "/libpod/secrets/create";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (name != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("name", name));
        }
        if (driver != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("driver", driver));
        }
        if (driveropts != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("driveropts", driveropts));
        }
        if (labels != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("labels", labels));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[]{"application/json", "application/x-tar"})) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call secretCreateLibpodValidateBeforeCall(String name, String driver, String driveropts, String labels, String request, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling secretCreateLibpod(Async)");
        }
        return this.secretCreateLibpodCall(name, driver, driveropts, labels, request, _callback);
    }

    private ApiResponse<SecretCreateLibpod201Response> secretCreateLibpodWithHttpInfo(@NotNull String name, String driver, String driveropts, String labels, String request) throws ApiException {
        Call localVarCall = this.secretCreateLibpodValidateBeforeCall(name, driver, driveropts, labels, request, null);
        Type localVarReturnType = new TypeToken<SecretCreateLibpod201Response>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call secretCreateLibpodAsync(String name, String driver, String driveropts, String labels, String request, ApiCallback<SecretCreateLibpod201Response> _callback) throws ApiException {
        Call localVarCall = this.secretCreateLibpodValidateBeforeCall(name, driver, driveropts, labels, request, _callback);
        Type localVarReturnType = new TypeToken<SecretCreateLibpod201Response>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIsecretCreateLibpodRequest secretCreateLibpod(String name) {
        return new APIsecretCreateLibpodRequest(name);
    }

    private Call secretDeleteLibpodCall(String name, Boolean all, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/secrets/{name}".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (all != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("all", all));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call secretDeleteLibpodValidateBeforeCall(String name, Boolean all, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling secretDeleteLibpod(Async)");
        }
        return this.secretDeleteLibpodCall(name, all, _callback);
    }

    private ApiResponse<Void> secretDeleteLibpodWithHttpInfo(@NotNull String name, Boolean all) throws ApiException {
        Call localVarCall = this.secretDeleteLibpodValidateBeforeCall(name, all, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call secretDeleteLibpodAsync(String name, Boolean all, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.secretDeleteLibpodValidateBeforeCall(name, all, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIsecretDeleteLibpodRequest secretDeleteLibpod(String name) {
        return new APIsecretDeleteLibpodRequest(name);
    }

    private Call secretExistsLibpodCall(String name, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/secrets/{name}/exists".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call secretExistsLibpodValidateBeforeCall(String name, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling secretExistsLibpod(Async)");
        }
        return this.secretExistsLibpodCall(name, _callback);
    }

    private ApiResponse<Void> secretExistsLibpodWithHttpInfo(@NotNull String name) throws ApiException {
        Call localVarCall = this.secretExistsLibpodValidateBeforeCall(name, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call secretExistsLibpodAsync(String name, ApiCallback<Void> _callback) throws ApiException {
        Call localVarCall = this.secretExistsLibpodValidateBeforeCall(name, _callback);
        this.localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public APIsecretExistsLibpodRequest secretExistsLibpod(String name) {
        return new APIsecretExistsLibpodRequest(name);
    }

    private Call secretInspectLibpodCall(String name, Boolean showsecret, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/secrets/{name}/json".replace("{name}", this.localVarApiClient.escapeString(name.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (showsecret != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("showsecret", showsecret));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call secretInspectLibpodValidateBeforeCall(String name, Boolean showsecret, ApiCallback _callback) throws ApiException {
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling secretInspectLibpod(Async)");
        }
        return this.secretInspectLibpodCall(name, showsecret, _callback);
    }

    private ApiResponse<SecretInfoReport> secretInspectLibpodWithHttpInfo(@NotNull String name, Boolean showsecret) throws ApiException {
        Call localVarCall = this.secretInspectLibpodValidateBeforeCall(name, showsecret, null);
        Type localVarReturnType = new TypeToken<SecretInfoReport>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call secretInspectLibpodAsync(String name, Boolean showsecret, ApiCallback<SecretInfoReport> _callback) throws ApiException {
        Call localVarCall = this.secretInspectLibpodValidateBeforeCall(name, showsecret, _callback);
        Type localVarReturnType = new TypeToken<SecretInfoReport>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIsecretInspectLibpodRequest secretInspectLibpod(String name) {
        return new APIsecretInspectLibpodRequest(name);
    }

    private Call secretListLibpodCall(String filters, ApiCallback _callback) throws ApiException {
        String[] localVarContentTypes;
        String localVarContentType;
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/libpod/secrets/json";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (filters != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("filters", filters));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        if ((localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes = new String[0])) != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        String[] localVarAuthNames = new String[]{};
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call secretListLibpodValidateBeforeCall(String filters, ApiCallback _callback) throws ApiException {
        return this.secretListLibpodCall(filters, _callback);
    }

    private ApiResponse<List<SecretInfoReport>> secretListLibpodWithHttpInfo(String filters) throws ApiException {
        Call localVarCall = this.secretListLibpodValidateBeforeCall(filters, null);
        Type localVarReturnType = new TypeToken<List<SecretInfoReport>>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call secretListLibpodAsync(String filters, ApiCallback<List<SecretInfoReport>> _callback) throws ApiException {
        Call localVarCall = this.secretListLibpodValidateBeforeCall(filters, _callback);
        Type localVarReturnType = new TypeToken<List<SecretInfoReport>>(){}.getType();
        this.localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public APIsecretListLibpodRequest secretListLibpod() {
        return new APIsecretListLibpodRequest();
    }

    public class APIsecretCreateLibpodRequest {
        private final String name;
        private String driver;
        private String driveropts;
        private String labels;
        private String request;

        private APIsecretCreateLibpodRequest(String name) {
            this.name = name;
        }

        public APIsecretCreateLibpodRequest driver(String driver) {
            this.driver = driver;
            return this;
        }

        public APIsecretCreateLibpodRequest driveropts(String driveropts) {
            this.driveropts = driveropts;
            return this;
        }

        public APIsecretCreateLibpodRequest labels(String labels) {
            this.labels = labels;
            return this;
        }

        public APIsecretCreateLibpodRequest request(String request) {
            this.request = request;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SecretsApi.this.secretCreateLibpodCall(this.name, this.driver, this.driveropts, this.labels, this.request, _callback);
        }

        public SecretCreateLibpod201Response execute() throws ApiException {
            ApiResponse<SecretCreateLibpod201Response> localVarResp = SecretsApi.this.secretCreateLibpodWithHttpInfo(this.name, this.driver, this.driveropts, this.labels, this.request);
            return localVarResp.getData();
        }

        public ApiResponse<SecretCreateLibpod201Response> executeWithHttpInfo() throws ApiException {
            return SecretsApi.this.secretCreateLibpodWithHttpInfo(this.name, this.driver, this.driveropts, this.labels, this.request);
        }

        public Call executeAsync(ApiCallback<SecretCreateLibpod201Response> _callback) throws ApiException {
            return SecretsApi.this.secretCreateLibpodAsync(this.name, this.driver, this.driveropts, this.labels, this.request, _callback);
        }
    }

    public class APIsecretDeleteLibpodRequest {
        private final String name;
        private Boolean all;

        private APIsecretDeleteLibpodRequest(String name) {
            this.name = name;
        }

        public APIsecretDeleteLibpodRequest all(Boolean all) {
            this.all = all;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SecretsApi.this.secretDeleteLibpodCall(this.name, this.all, _callback);
        }

        public void execute() throws ApiException {
            SecretsApi.this.secretDeleteLibpodWithHttpInfo(this.name, this.all);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return SecretsApi.this.secretDeleteLibpodWithHttpInfo(this.name, this.all);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return SecretsApi.this.secretDeleteLibpodAsync(this.name, this.all, _callback);
        }
    }

    public class APIsecretExistsLibpodRequest {
        private final String name;

        private APIsecretExistsLibpodRequest(String name) {
            this.name = name;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SecretsApi.this.secretExistsLibpodCall(this.name, _callback);
        }

        public void execute() throws ApiException {
            SecretsApi.this.secretExistsLibpodWithHttpInfo(this.name);
        }

        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return SecretsApi.this.secretExistsLibpodWithHttpInfo(this.name);
        }

        public Call executeAsync(ApiCallback<Void> _callback) throws ApiException {
            return SecretsApi.this.secretExistsLibpodAsync(this.name, _callback);
        }
    }

    public class APIsecretInspectLibpodRequest {
        private final String name;
        private Boolean showsecret;

        private APIsecretInspectLibpodRequest(String name) {
            this.name = name;
        }

        public APIsecretInspectLibpodRequest showsecret(Boolean showsecret) {
            this.showsecret = showsecret;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SecretsApi.this.secretInspectLibpodCall(this.name, this.showsecret, _callback);
        }

        public SecretInfoReport execute() throws ApiException {
            ApiResponse<SecretInfoReport> localVarResp = SecretsApi.this.secretInspectLibpodWithHttpInfo(this.name, this.showsecret);
            return localVarResp.getData();
        }

        public ApiResponse<SecretInfoReport> executeWithHttpInfo() throws ApiException {
            return SecretsApi.this.secretInspectLibpodWithHttpInfo(this.name, this.showsecret);
        }

        public Call executeAsync(ApiCallback<SecretInfoReport> _callback) throws ApiException {
            return SecretsApi.this.secretInspectLibpodAsync(this.name, this.showsecret, _callback);
        }
    }

    public class APIsecretListLibpodRequest {
        private String filters;

        private APIsecretListLibpodRequest() {
        }

        public APIsecretListLibpodRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return SecretsApi.this.secretListLibpodCall(this.filters, _callback);
        }

        public List<SecretInfoReport> execute() throws ApiException {
            ApiResponse<List<SecretInfoReport>> localVarResp = SecretsApi.this.secretListLibpodWithHttpInfo(this.filters);
            return localVarResp.getData();
        }

        public ApiResponse<List<SecretInfoReport>> executeWithHttpInfo() throws ApiException {
            return SecretsApi.this.secretListLibpodWithHttpInfo(this.filters);
        }

        public Call executeAsync(ApiCallback<List<SecretInfoReport>> _callback) throws ApiException {
            return SecretsApi.this.secretListLibpodAsync(this.filters, _callback);
        }
    }
}

