/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.Namespace;
import io.github.pod4dev.libpodj.model.PerNetworkOptions;
import io.github.pod4dev.libpodj.model.PortMapping;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ContainerNetworkConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_NETWORKS = "Networks";
    @SerializedName(value="Networks")
    private Map<String, PerNetworkOptions> networks = new HashMap<String, PerNetworkOptions>();
    public static final String SERIALIZED_NAME_BASE_HOSTS_FILE = "base_hosts_file";
    @SerializedName(value="base_hosts_file")
    private String baseHostsFile;
    public static final String SERIALIZED_NAME_CNI_NETWORKS = "cni_networks";
    @SerializedName(value="cni_networks")
    private List<String> cniNetworks = new ArrayList<String>();
    public static final String SERIALIZED_NAME_DNS_OPTION = "dns_option";
    @SerializedName(value="dns_option")
    private List<String> dnsOption = new ArrayList<String>();
    public static final String SERIALIZED_NAME_DNS_SEARCH = "dns_search";
    @SerializedName(value="dns_search")
    private List<String> dnsSearch = new ArrayList<String>();
    public static final String SERIALIZED_NAME_DNS_SERVER = "dns_server";
    @SerializedName(value="dns_server")
    private List<String> dnsServer = new ArrayList<String>();
    public static final String SERIALIZED_NAME_EXPOSE = "expose";
    @SerializedName(value="expose")
    private Object expose;
    public static final String SERIALIZED_NAME_HOSTADD = "hostadd";
    @SerializedName(value="hostadd")
    private List<String> hostadd = new ArrayList<String>();
    public static final String SERIALIZED_NAME_NETNS = "netns";
    @SerializedName(value="netns")
    private Namespace netns;
    public static final String SERIALIZED_NAME_NETWORK_OPTIONS = "network_options";
    @SerializedName(value="network_options")
    private Map<String, List<String>> networkOptions = new HashMap<String, List<String>>();
    public static final String SERIALIZED_NAME_PORTMAPPINGS = "portmappings";
    @SerializedName(value="portmappings")
    private List<@Valid PortMapping> portmappings = new ArrayList<PortMapping>();
    public static final String SERIALIZED_NAME_PUBLISH_IMAGE_PORTS = "publish_image_ports";
    @SerializedName(value="publish_image_ports")
    private Boolean publishImagePorts;
    public static final String SERIALIZED_NAME_USE_IMAGE_HOSTS = "use_image_hosts";
    @SerializedName(value="use_image_hosts")
    private Boolean useImageHosts;
    public static final String SERIALIZED_NAME_USE_IMAGE_RESOLVE_CONF = "use_image_resolve_conf";
    @SerializedName(value="use_image_resolve_conf")
    private Boolean useImageResolveConf;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ContainerNetworkConfig networks(Map<String, PerNetworkOptions> networks) {
        this.networks = networks;
        return this;
    }

    public ContainerNetworkConfig putNetworksItem(String key, PerNetworkOptions networksItem) {
        if (this.networks == null) {
            this.networks = new HashMap<String, PerNetworkOptions>();
        }
        this.networks.put(key, networksItem);
        return this;
    }

    @Nullable
    @Valid
    public Map<String, PerNetworkOptions> getNetworks() {
        return this.networks;
    }

    public void setNetworks(Map<String, PerNetworkOptions> networks) {
        this.networks = networks;
    }

    public ContainerNetworkConfig baseHostsFile(String baseHostsFile) {
        this.baseHostsFile = baseHostsFile;
        return this;
    }

    @Nullable
    public String getBaseHostsFile() {
        return this.baseHostsFile;
    }

    public void setBaseHostsFile(String baseHostsFile) {
        this.baseHostsFile = baseHostsFile;
    }

    public ContainerNetworkConfig cniNetworks(List<String> cniNetworks) {
        this.cniNetworks = cniNetworks;
        return this;
    }

    public ContainerNetworkConfig addCniNetworksItem(String cniNetworksItem) {
        if (this.cniNetworks == null) {
            this.cniNetworks = new ArrayList<String>();
        }
        this.cniNetworks.add(cniNetworksItem);
        return this;
    }

    @Nullable
    public List<String> getCniNetworks() {
        return this.cniNetworks;
    }

    public void setCniNetworks(List<String> cniNetworks) {
        this.cniNetworks = cniNetworks;
    }

    public ContainerNetworkConfig dnsOption(List<String> dnsOption) {
        this.dnsOption = dnsOption;
        return this;
    }

    public ContainerNetworkConfig addDnsOptionItem(String dnsOptionItem) {
        if (this.dnsOption == null) {
            this.dnsOption = new ArrayList<String>();
        }
        this.dnsOption.add(dnsOptionItem);
        return this;
    }

    @Nullable
    public List<String> getDnsOption() {
        return this.dnsOption;
    }

    public void setDnsOption(List<String> dnsOption) {
        this.dnsOption = dnsOption;
    }

    public ContainerNetworkConfig dnsSearch(List<String> dnsSearch) {
        this.dnsSearch = dnsSearch;
        return this;
    }

    public ContainerNetworkConfig addDnsSearchItem(String dnsSearchItem) {
        if (this.dnsSearch == null) {
            this.dnsSearch = new ArrayList<String>();
        }
        this.dnsSearch.add(dnsSearchItem);
        return this;
    }

    @Nullable
    public List<String> getDnsSearch() {
        return this.dnsSearch;
    }

    public void setDnsSearch(List<String> dnsSearch) {
        this.dnsSearch = dnsSearch;
    }

    public ContainerNetworkConfig dnsServer(List<String> dnsServer) {
        this.dnsServer = dnsServer;
        return this;
    }

    public ContainerNetworkConfig addDnsServerItem(String dnsServerItem) {
        if (this.dnsServer == null) {
            this.dnsServer = new ArrayList<String>();
        }
        this.dnsServer.add(dnsServerItem);
        return this;
    }

    @Nullable
    public List<String> getDnsServer() {
        return this.dnsServer;
    }

    public void setDnsServer(List<String> dnsServer) {
        this.dnsServer = dnsServer;
    }

    public ContainerNetworkConfig expose(Object expose) {
        this.expose = expose;
        return this;
    }

    @Nullable
    public Object getExpose() {
        return this.expose;
    }

    public void setExpose(Object expose) {
        this.expose = expose;
    }

    public ContainerNetworkConfig hostadd(List<String> hostadd) {
        this.hostadd = hostadd;
        return this;
    }

    public ContainerNetworkConfig addHostaddItem(String hostaddItem) {
        if (this.hostadd == null) {
            this.hostadd = new ArrayList<String>();
        }
        this.hostadd.add(hostaddItem);
        return this;
    }

    @Nullable
    public List<String> getHostadd() {
        return this.hostadd;
    }

    public void setHostadd(List<String> hostadd) {
        this.hostadd = hostadd;
    }

    public ContainerNetworkConfig netns(Namespace netns) {
        this.netns = netns;
        return this;
    }

    @Nullable
    @Valid
    public Namespace getNetns() {
        return this.netns;
    }

    public void setNetns(Namespace netns) {
        this.netns = netns;
    }

    public ContainerNetworkConfig networkOptions(Map<String, List<String>> networkOptions) {
        this.networkOptions = networkOptions;
        return this;
    }

    public ContainerNetworkConfig putNetworkOptionsItem(String key, List<String> networkOptionsItem) {
        if (this.networkOptions == null) {
            this.networkOptions = new HashMap<String, List<String>>();
        }
        this.networkOptions.put(key, networkOptionsItem);
        return this;
    }

    @Nullable
    @Valid
    public Map<String, List<String>> getNetworkOptions() {
        return this.networkOptions;
    }

    public void setNetworkOptions(Map<String, List<String>> networkOptions) {
        this.networkOptions = networkOptions;
    }

    public ContainerNetworkConfig portmappings(List<@Valid PortMapping> portmappings) {
        this.portmappings = portmappings;
        return this;
    }

    public ContainerNetworkConfig addPortmappingsItem(PortMapping portmappingsItem) {
        if (this.portmappings == null) {
            this.portmappings = new ArrayList<PortMapping>();
        }
        this.portmappings.add(portmappingsItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid PortMapping> getPortmappings() {
        return this.portmappings;
    }

    public void setPortmappings(List<@Valid PortMapping> portmappings) {
        this.portmappings = portmappings;
    }

    public ContainerNetworkConfig publishImagePorts(Boolean publishImagePorts) {
        this.publishImagePorts = publishImagePorts;
        return this;
    }

    @Nullable
    public Boolean getPublishImagePorts() {
        return this.publishImagePorts;
    }

    public void setPublishImagePorts(Boolean publishImagePorts) {
        this.publishImagePorts = publishImagePorts;
    }

    public ContainerNetworkConfig useImageHosts(Boolean useImageHosts) {
        this.useImageHosts = useImageHosts;
        return this;
    }

    @Nullable
    public Boolean getUseImageHosts() {
        return this.useImageHosts;
    }

    public void setUseImageHosts(Boolean useImageHosts) {
        this.useImageHosts = useImageHosts;
    }

    public ContainerNetworkConfig useImageResolveConf(Boolean useImageResolveConf) {
        this.useImageResolveConf = useImageResolveConf;
        return this;
    }

    @Nullable
    public Boolean getUseImageResolveConf() {
        return this.useImageResolveConf;
    }

    public void setUseImageResolveConf(Boolean useImageResolveConf) {
        this.useImageResolveConf = useImageResolveConf;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ContainerNetworkConfig containerNetworkConfig = (ContainerNetworkConfig)o;
        return Objects.equals(this.networks, containerNetworkConfig.networks) && Objects.equals(this.baseHostsFile, containerNetworkConfig.baseHostsFile) && Objects.equals(this.cniNetworks, containerNetworkConfig.cniNetworks) && Objects.equals(this.dnsOption, containerNetworkConfig.dnsOption) && Objects.equals(this.dnsSearch, containerNetworkConfig.dnsSearch) && Objects.equals(this.dnsServer, containerNetworkConfig.dnsServer) && Objects.equals(this.expose, containerNetworkConfig.expose) && Objects.equals(this.hostadd, containerNetworkConfig.hostadd) && Objects.equals(this.netns, containerNetworkConfig.netns) && Objects.equals(this.networkOptions, containerNetworkConfig.networkOptions) && Objects.equals(this.portmappings, containerNetworkConfig.portmappings) && Objects.equals(this.publishImagePorts, containerNetworkConfig.publishImagePorts) && Objects.equals(this.useImageHosts, containerNetworkConfig.useImageHosts) && Objects.equals(this.useImageResolveConf, containerNetworkConfig.useImageResolveConf);
    }

    public int hashCode() {
        return Objects.hash(this.networks, this.baseHostsFile, this.cniNetworks, this.dnsOption, this.dnsSearch, this.dnsServer, this.expose, this.hostadd, this.netns, this.networkOptions, this.portmappings, this.publishImagePorts, this.useImageHosts, this.useImageResolveConf);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ContainerNetworkConfig {\n");
        sb.append("    networks: ").append(this.toIndentedString(this.networks)).append("\n");
        sb.append("    baseHostsFile: ").append(this.toIndentedString(this.baseHostsFile)).append("\n");
        sb.append("    cniNetworks: ").append(this.toIndentedString(this.cniNetworks)).append("\n");
        sb.append("    dnsOption: ").append(this.toIndentedString(this.dnsOption)).append("\n");
        sb.append("    dnsSearch: ").append(this.toIndentedString(this.dnsSearch)).append("\n");
        sb.append("    dnsServer: ").append(this.toIndentedString(this.dnsServer)).append("\n");
        sb.append("    expose: ").append(this.toIndentedString(this.expose)).append("\n");
        sb.append("    hostadd: ").append(this.toIndentedString(this.hostadd)).append("\n");
        sb.append("    netns: ").append(this.toIndentedString(this.netns)).append("\n");
        sb.append("    networkOptions: ").append(this.toIndentedString(this.networkOptions)).append("\n");
        sb.append("    portmappings: ").append(this.toIndentedString(this.portmappings)).append("\n");
        sb.append("    publishImagePorts: ").append(this.toIndentedString(this.publishImagePorts)).append("\n");
        sb.append("    useImageHosts: ").append(this.toIndentedString(this.useImageHosts)).append("\n");
        sb.append("    useImageResolveConf: ").append(this.toIndentedString(this.useImageResolveConf)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayportmappings;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in ContainerNetworkConfig is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ContainerNetworkConfig` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_BASE_HOSTS_FILE) != null && !jsonObj.get(SERIALIZED_NAME_BASE_HOSTS_FILE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_BASE_HOSTS_FILE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `base_hosts_file` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_BASE_HOSTS_FILE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CNI_NETWORKS) != null && !jsonObj.get(SERIALIZED_NAME_CNI_NETWORKS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CNI_NETWORKS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `cni_networks` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CNI_NETWORKS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DNS_OPTION) != null && !jsonObj.get(SERIALIZED_NAME_DNS_OPTION).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DNS_OPTION).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `dns_option` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DNS_OPTION).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DNS_SEARCH) != null && !jsonObj.get(SERIALIZED_NAME_DNS_SEARCH).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DNS_SEARCH).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `dns_search` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DNS_SEARCH).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DNS_SERVER) != null && !jsonObj.get(SERIALIZED_NAME_DNS_SERVER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DNS_SERVER).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `dns_server` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DNS_SERVER).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOSTADD) != null && !jsonObj.get(SERIALIZED_NAME_HOSTADD).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HOSTADD).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `hostadd` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOSTADD).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETNS) != null && !jsonObj.get(SERIALIZED_NAME_NETNS).isJsonNull()) {
            Namespace.validateJsonElement(jsonObj.get(SERIALIZED_NAME_NETNS));
        }
        if (jsonObj.get(SERIALIZED_NAME_PORTMAPPINGS) != null && !jsonObj.get(SERIALIZED_NAME_PORTMAPPINGS).isJsonNull() && (jsonArrayportmappings = jsonObj.getAsJsonArray(SERIALIZED_NAME_PORTMAPPINGS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PORTMAPPINGS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `portmappings` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PORTMAPPINGS).toString()));
            }
            for (int i = 0; i < jsonArrayportmappings.size(); ++i) {
                PortMapping.validateJsonElement(jsonArrayportmappings.get(i));
            }
        }
    }

    public static ContainerNetworkConfig fromJson(String jsonString) throws IOException {
        return (ContainerNetworkConfig)JSON.getGson().fromJson(jsonString, ContainerNetworkConfig.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NETWORKS);
        openapiFields.add(SERIALIZED_NAME_BASE_HOSTS_FILE);
        openapiFields.add(SERIALIZED_NAME_CNI_NETWORKS);
        openapiFields.add(SERIALIZED_NAME_DNS_OPTION);
        openapiFields.add(SERIALIZED_NAME_DNS_SEARCH);
        openapiFields.add(SERIALIZED_NAME_DNS_SERVER);
        openapiFields.add(SERIALIZED_NAME_EXPOSE);
        openapiFields.add(SERIALIZED_NAME_HOSTADD);
        openapiFields.add(SERIALIZED_NAME_NETNS);
        openapiFields.add(SERIALIZED_NAME_NETWORK_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_PORTMAPPINGS);
        openapiFields.add(SERIALIZED_NAME_PUBLISH_IMAGE_PORTS);
        openapiFields.add(SERIALIZED_NAME_USE_IMAGE_HOSTS);
        openapiFields.add(SERIALIZED_NAME_USE_IMAGE_RESOLVE_CONF);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ContainerNetworkConfig.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ContainerNetworkConfig.class));
            return new TypeAdapter<ContainerNetworkConfig>(){

                public void write(JsonWriter out, ContainerNetworkConfig value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ContainerNetworkConfig read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    ContainerNetworkConfig.validateJsonElement(jsonElement);
                    return (ContainerNetworkConfig)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

