/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class DeviceRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CAPABILITIES = "Capabilities";
    @SerializedName(value="Capabilities")
    private List<List<String>> capabilities = new ArrayList<List<String>>();
    public static final String SERIALIZED_NAME_COUNT = "Count";
    @SerializedName(value="Count")
    private Long count;
    public static final String SERIALIZED_NAME_DEVICE_I_DS = "DeviceIDs";
    @SerializedName(value="DeviceIDs")
    private List<String> deviceIDs = new ArrayList<String>();
    public static final String SERIALIZED_NAME_DRIVER = "Driver";
    @SerializedName(value="Driver")
    private String driver;
    public static final String SERIALIZED_NAME_OPTIONS = "Options";
    @SerializedName(value="Options")
    private Map<String, String> options = new HashMap<String, String>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public DeviceRequest capabilities(List<List<String>> capabilities) {
        this.capabilities = capabilities;
        return this;
    }

    public DeviceRequest addCapabilitiesItem(List<String> capabilitiesItem) {
        if (this.capabilities == null) {
            this.capabilities = new ArrayList<List<String>>();
        }
        this.capabilities.add(capabilitiesItem);
        return this;
    }

    @Nullable
    @Valid
    public List<List<String>> getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(List<List<String>> capabilities) {
        this.capabilities = capabilities;
    }

    public DeviceRequest count(Long count) {
        this.count = count;
        return this;
    }

    @Nullable
    public Long getCount() {
        return this.count;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public DeviceRequest deviceIDs(List<String> deviceIDs) {
        this.deviceIDs = deviceIDs;
        return this;
    }

    public DeviceRequest addDeviceIDsItem(String deviceIDsItem) {
        if (this.deviceIDs == null) {
            this.deviceIDs = new ArrayList<String>();
        }
        this.deviceIDs.add(deviceIDsItem);
        return this;
    }

    @Nullable
    public List<String> getDeviceIDs() {
        return this.deviceIDs;
    }

    public void setDeviceIDs(List<String> deviceIDs) {
        this.deviceIDs = deviceIDs;
    }

    public DeviceRequest driver(String driver) {
        this.driver = driver;
        return this;
    }

    @Nullable
    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public DeviceRequest options(Map<String, String> options) {
        this.options = options;
        return this;
    }

    public DeviceRequest putOptionsItem(String key, String optionsItem) {
        if (this.options == null) {
            this.options = new HashMap<String, String>();
        }
        this.options.put(key, optionsItem);
        return this;
    }

    @Nullable
    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeviceRequest deviceRequest = (DeviceRequest)o;
        return Objects.equals(this.capabilities, deviceRequest.capabilities) && Objects.equals(this.count, deviceRequest.count) && Objects.equals(this.deviceIDs, deviceRequest.deviceIDs) && Objects.equals(this.driver, deviceRequest.driver) && Objects.equals(this.options, deviceRequest.options);
    }

    public int hashCode() {
        return Objects.hash(this.capabilities, this.count, this.deviceIDs, this.driver, this.options);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeviceRequest {\n");
        sb.append("    capabilities: ").append(this.toIndentedString(this.capabilities)).append("\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    deviceIDs: ").append(this.toIndentedString(this.deviceIDs)).append("\n");
        sb.append("    driver: ").append(this.toIndentedString(this.driver)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in DeviceRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `DeviceRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CAPABILITIES) != null && !jsonObj.get(SERIALIZED_NAME_CAPABILITIES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CAPABILITIES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Capabilities` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CAPABILITIES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEVICE_I_DS) != null && !jsonObj.get(SERIALIZED_NAME_DEVICE_I_DS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DEVICE_I_DS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `DeviceIDs` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEVICE_I_DS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DRIVER) != null && !jsonObj.get(SERIALIZED_NAME_DRIVER).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DRIVER).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Driver` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DRIVER).toString()));
        }
    }

    public static DeviceRequest fromJson(String jsonString) throws IOException {
        return (DeviceRequest)JSON.getGson().fromJson(jsonString, DeviceRequest.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CAPABILITIES);
        openapiFields.add(SERIALIZED_NAME_COUNT);
        openapiFields.add(SERIALIZED_NAME_DEVICE_I_DS);
        openapiFields.add(SERIALIZED_NAME_DRIVER);
        openapiFields.add(SERIALIZED_NAME_OPTIONS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!DeviceRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(DeviceRequest.class));
            return new TypeAdapter<DeviceRequest>(){

                public void write(JsonWriter out, DeviceRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public DeviceRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    DeviceRequest.validateJsonElement(jsonElement);
                    return (DeviceRequest)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

