/*
 * supports a RESTful API for the Libpod library
 * This documentation describes the Podman v2.x+ RESTful API. It consists of a Docker-compatible API and a Libpod API providing support for Podman’s unique features such as pods.  To start the service and keep it running for 5,000 seconds (-t 0 runs forever):  podman system service -t 5000 &  You can then use cURL on the socket using requests documented below.  NOTE: if you install the package podman-docker, it will create a symbolic link for /run/docker.sock to /run/podman/podman.sock  NOTE: Some fields in the API response JSON are encoded as omitempty, which means that if said field has a zero value, they will not be encoded in the API response. This is a feature to help reduce the size of the JSON responses returned via the API.  NOTE: Due to the limitations of [go-swagger](https://github.com/go-swagger/go-swagger), some field values that have a complex type show up as null in the docs as well as in the API responses. This is because the zero value for the field type is null. The field description in the docs will state what type the field is expected to be for such cases.  See podman-system-service(1) for more information.  Quick Examples:  'podman info'  curl --unix-socket /run/podman/podman.sock http://d/v5.0.0/libpod/info  'podman pull quay.io/containers/podman'  curl -XPOST --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/images/create?fromImage=quay.io%2Fcontainers%2Fpodman'  'podman list images'  curl --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/libpod/images/json' | jq
 *
 * The version of the OpenAPI document: 5.0.0
 * Contact: podman@lists.podman.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.pod4dev.libpodj.api;

import io.github.pod4dev.libpodj.ApiCallback;
import io.github.pod4dev.libpodj.ApiClient;
import io.github.pod4dev.libpodj.ApiException;
import io.github.pod4dev.libpodj.ApiResponse;
import io.github.pod4dev.libpodj.Configuration;
import io.github.pod4dev.libpodj.Pair;
import io.github.pod4dev.libpodj.ProgressRequestBody;
import io.github.pod4dev.libpodj.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;

import javax.validation.constraints.*;

import io.github.pod4dev.libpodj.model.ConnectOptions;
import io.github.pod4dev.libpodj.model.CreateRequest;
import io.github.pod4dev.libpodj.model.DisconnectOptions;
import io.github.pod4dev.libpodj.model.ErrorModel;
import io.github.pod4dev.libpodj.model.Inspect;
import io.github.pod4dev.libpodj.model.NetworkCreate201Response;
import io.github.pod4dev.libpodj.model.NetworkPrune200Response;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericType;

public class NetworksCompatApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public NetworksCompatApi() {
        this(Configuration.getDefaultApiClient());
    }

    public NetworksCompatApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private okhttp3.Call networkConnectCall(String name, ConnectOptions create, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = create;

        // create path and map variables
        String localVarPath = "/networks/{name}/connect"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json", "application/x-tar"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call networkConnectValidateBeforeCall(String name, ConnectOptions create, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling networkConnect(Async)");
        }
        

        okhttp3.Call localVarCall = networkConnectCall(name, create, _callback);
        return localVarCall;

    }


    private ApiResponse<Void> networkConnectWithHttpInfo( @NotNull String name, ConnectOptions create) throws ApiException {
        okhttp3.Call localVarCall = networkConnectValidateBeforeCall(name, create, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call networkConnectAsync(String name, ConnectOptions create, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = networkConnectValidateBeforeCall(name, create, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APInetworkConnectRequest {
        private final String name;
        private ConnectOptions create;

        private APInetworkConnectRequest(String name) {
            this.name = name;
        }

        /**
         * Set create
         * @param create attributes for connecting a container to a network (optional)
         * @return APInetworkConnectRequest
         */
        public APInetworkConnectRequest create(ConnectOptions create) {
            this.create = create;
            return this;
        }

        /**
         * Build call for networkConnect
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 403 </td><td> Network is already connected and container is running or transitioning to the running state (&#39;initialized&#39;) </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return networkConnectCall(name, create, _callback);
        }

        /**
         * Execute networkConnect request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 403 </td><td> Network is already connected and container is running or transitioning to the running state (&#39;initialized&#39;) </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            networkConnectWithHttpInfo(name, create);
        }

        /**
         * Execute networkConnect request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 403 </td><td> Network is already connected and container is running or transitioning to the running state (&#39;initialized&#39;) </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return networkConnectWithHttpInfo(name, create);
        }

        /**
         * Execute networkConnect request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 403 </td><td> Network is already connected and container is running or transitioning to the running state (&#39;initialized&#39;) </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return networkConnectAsync(name, create, _callback);
        }
    }

    /**
     * Connect container to network
     * Connect a container to a network
     * @param name the name of the network (required)
     * @return APInetworkConnectRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 403 </td><td> Network is already connected and container is running or transitioning to the running state (&#39;initialized&#39;) </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APInetworkConnectRequest networkConnect(String name) {
        return new APInetworkConnectRequest(name);
    }
    private okhttp3.Call networkCreateCall(CreateRequest create, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = create;

        // create path and map variables
        String localVarPath = "/networks/create";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json", "application/x-tar"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call networkCreateValidateBeforeCall(CreateRequest create, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = networkCreateCall(create, _callback);
        return localVarCall;

    }


    private ApiResponse<NetworkCreate201Response> networkCreateWithHttpInfo(CreateRequest create) throws ApiException {
        okhttp3.Call localVarCall = networkCreateValidateBeforeCall(create, null);
        Type localVarReturnType = new TypeToken<NetworkCreate201Response>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call networkCreateAsync(CreateRequest create, final ApiCallback<NetworkCreate201Response> _callback) throws ApiException {

        okhttp3.Call localVarCall = networkCreateValidateBeforeCall(create, _callback);
        Type localVarReturnType = new TypeToken<NetworkCreate201Response>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APInetworkCreateRequest {
        private CreateRequest create;

        private APInetworkCreateRequest() {
        }

        /**
         * Set create
         * @param create attributes for creating a network (optional)
         * @return APInetworkCreateRequest
         */
        public APInetworkCreateRequest create(CreateRequest create) {
            this.create = create;
            return this;
        }

        /**
         * Build call for networkCreate
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> network created </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return networkCreateCall(create, _callback);
        }

        /**
         * Execute networkCreate request
         * @return NetworkCreate201Response
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> network created </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public NetworkCreate201Response execute() throws ApiException {
            ApiResponse<NetworkCreate201Response> localVarResp = networkCreateWithHttpInfo(create);
            return localVarResp.getData();
        }

        /**
         * Execute networkCreate request with HTTP info returned
         * @return ApiResponse&lt;NetworkCreate201Response&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> network created </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<NetworkCreate201Response> executeWithHttpInfo() throws ApiException {
            return networkCreateWithHttpInfo(create);
        }

        /**
         * Execute networkCreate request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> network created </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<NetworkCreate201Response> _callback) throws ApiException {
            return networkCreateAsync(create, _callback);
        }
    }

    /**
     * Create network
     * Create a network configuration
     * @return APInetworkCreateRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> network created </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APInetworkCreateRequest networkCreate() {
        return new APInetworkCreateRequest();
    }
    private okhttp3.Call networkDeleteCall(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/networks/{name}"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call networkDeleteValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling networkDelete(Async)");
        }
        

        okhttp3.Call localVarCall = networkDeleteCall(name, _callback);
        return localVarCall;

    }


    private ApiResponse<Void> networkDeleteWithHttpInfo( @NotNull String name) throws ApiException {
        okhttp3.Call localVarCall = networkDeleteValidateBeforeCall(name, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call networkDeleteAsync(String name, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = networkDeleteValidateBeforeCall(name, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APInetworkDeleteRequest {
        private final String name;

        private APInetworkDeleteRequest(String name) {
            this.name = name;
        }

        /**
         * Build call for networkDelete
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such network </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return networkDeleteCall(name, _callback);
        }

        /**
         * Execute networkDelete request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such network </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            networkDeleteWithHttpInfo(name);
        }

        /**
         * Execute networkDelete request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such network </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return networkDeleteWithHttpInfo(name);
        }

        /**
         * Execute networkDelete request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such network </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return networkDeleteAsync(name, _callback);
        }
    }

    /**
     * Remove a network
     * Remove a network
     * @param name the name of the network (required)
     * @return APInetworkDeleteRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such network </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APInetworkDeleteRequest networkDelete(String name) {
        return new APInetworkDeleteRequest(name);
    }
    private okhttp3.Call networkDisconnectCall(String name, DisconnectOptions create, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = create;

        // create path and map variables
        String localVarPath = "/networks/{name}/disconnect"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json", "application/x-tar"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call networkDisconnectValidateBeforeCall(String name, DisconnectOptions create, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling networkDisconnect(Async)");
        }
        

        okhttp3.Call localVarCall = networkDisconnectCall(name, create, _callback);
        return localVarCall;

    }


    private ApiResponse<Void> networkDisconnectWithHttpInfo( @NotNull String name, DisconnectOptions create) throws ApiException {
        okhttp3.Call localVarCall = networkDisconnectValidateBeforeCall(name, create, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call networkDisconnectAsync(String name, DisconnectOptions create, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = networkDisconnectValidateBeforeCall(name, create, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APInetworkDisconnectRequest {
        private final String name;
        private DisconnectOptions create;

        private APInetworkDisconnectRequest(String name) {
            this.name = name;
        }

        /**
         * Set create
         * @param create attributes for disconnecting a container from a network (optional)
         * @return APInetworkDisconnectRequest
         */
        public APInetworkDisconnectRequest create(DisconnectOptions create) {
            this.create = create;
            return this;
        }

        /**
         * Build call for networkDisconnect
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return networkDisconnectCall(name, create, _callback);
        }

        /**
         * Execute networkDisconnect request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            networkDisconnectWithHttpInfo(name, create);
        }

        /**
         * Execute networkDisconnect request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return networkDisconnectWithHttpInfo(name, create);
        }

        /**
         * Execute networkDisconnect request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return networkDisconnectAsync(name, create, _callback);
        }
    }

    /**
     * Disconnect container from network
     * Disconnect a container from a network
     * @param name the name of the network (required)
     * @return APInetworkDisconnectRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APInetworkDisconnectRequest networkDisconnect(String name) {
        return new APInetworkDisconnectRequest(name);
    }
    private okhttp3.Call networkInspectCall(String name, Boolean verbose, String scope, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/networks/{name}"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (verbose != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("verbose", verbose));
        }

        if (scope != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("scope", scope));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call networkInspectValidateBeforeCall(String name, Boolean verbose, String scope, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling networkInspect(Async)");
        }
        

        okhttp3.Call localVarCall = networkInspectCall(name, verbose, scope, _callback);
        return localVarCall;

    }


    private ApiResponse<Inspect> networkInspectWithHttpInfo( @NotNull String name, Boolean verbose, String scope) throws ApiException {
        okhttp3.Call localVarCall = networkInspectValidateBeforeCall(name, verbose, scope, null);
        Type localVarReturnType = new TypeToken<Inspect>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call networkInspectAsync(String name, Boolean verbose, String scope, final ApiCallback<Inspect> _callback) throws ApiException {

        okhttp3.Call localVarCall = networkInspectValidateBeforeCall(name, verbose, scope, _callback);
        Type localVarReturnType = new TypeToken<Inspect>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APInetworkInspectRequest {
        private final String name;
        private Boolean verbose;
        private String scope;

        private APInetworkInspectRequest(String name) {
            this.name = name;
        }

        /**
         * Set verbose
         * @param verbose Detailed inspect output for troubleshooting (optional)
         * @return APInetworkInspectRequest
         */
        public APInetworkInspectRequest verbose(Boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        /**
         * Set scope
         * @param scope Filter the network by scope (swarm, global, or local) (optional)
         * @return APInetworkInspectRequest
         */
        public APInetworkInspectRequest scope(String scope) {
            this.scope = scope;
            return this;
        }

        /**
         * Build call for networkInspect
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Network inspect </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such network </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return networkInspectCall(name, verbose, scope, _callback);
        }

        /**
         * Execute networkInspect request
         * @return Inspect
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Network inspect </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such network </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public Inspect execute() throws ApiException {
            ApiResponse<Inspect> localVarResp = networkInspectWithHttpInfo(name, verbose, scope);
            return localVarResp.getData();
        }

        /**
         * Execute networkInspect request with HTTP info returned
         * @return ApiResponse&lt;Inspect&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Network inspect </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such network </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Inspect> executeWithHttpInfo() throws ApiException {
            return networkInspectWithHttpInfo(name, verbose, scope);
        }

        /**
         * Execute networkInspect request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Network inspect </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such network </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Inspect> _callback) throws ApiException {
            return networkInspectAsync(name, verbose, scope, _callback);
        }
    }

    /**
     * Inspect a network
     * Display low level configuration network
     * @param name the name of the network (required)
     * @return APInetworkInspectRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Network inspect </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such network </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APInetworkInspectRequest networkInspect(String name) {
        return new APInetworkInspectRequest(name);
    }
    private okhttp3.Call networkListCall(String filters, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/networks";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (filters != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("filters", filters));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call networkListValidateBeforeCall(String filters, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = networkListCall(filters, _callback);
        return localVarCall;

    }


    private ApiResponse<List<Inspect>> networkListWithHttpInfo(String filters) throws ApiException {
        okhttp3.Call localVarCall = networkListValidateBeforeCall(filters, null);
        Type localVarReturnType = new TypeToken<List<Inspect>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call networkListAsync(String filters, final ApiCallback<List<Inspect>> _callback) throws ApiException {

        okhttp3.Call localVarCall = networkListValidateBeforeCall(filters, _callback);
        Type localVarReturnType = new TypeToken<List<Inspect>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APInetworkListRequest {
        private String filters;

        private APInetworkListRequest() {
        }

        /**
         * Set filters
         * @param filters JSON encoded value of the filters (a &#x60;map[string][]string&#x60;) to process on the network list. Currently available filters:   - &#x60;name&#x3D;[name]&#x60; Matches network name (accepts regex).   - &#x60;id&#x3D;[id]&#x60; Matches for full or partial ID.   - &#x60;driver&#x3D;[driver]&#x60; Only bridge is supported.   - &#x60;label&#x3D;[key]&#x60; or &#x60;label&#x3D;[key&#x3D;value]&#x60; Matches networks based on the presence of a label alone or a label and a value.  (optional)
         * @return APInetworkListRequest
         */
        public APInetworkListRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        /**
         * Build call for networkList
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Network list </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return networkListCall(filters, _callback);
        }

        /**
         * Execute networkList request
         * @return List&lt;Inspect&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Network list </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public List<Inspect> execute() throws ApiException {
            ApiResponse<List<Inspect>> localVarResp = networkListWithHttpInfo(filters);
            return localVarResp.getData();
        }

        /**
         * Execute networkList request with HTTP info returned
         * @return ApiResponse&lt;List&lt;Inspect&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Network list </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<Inspect>> executeWithHttpInfo() throws ApiException {
            return networkListWithHttpInfo(filters);
        }

        /**
         * Execute networkList request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Network list </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<Inspect>> _callback) throws ApiException {
            return networkListAsync(filters, _callback);
        }
    }

    /**
     * List networks
     * Display summary of network configurations
     * @return APInetworkListRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Network list </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APInetworkListRequest networkList() {
        return new APInetworkListRequest();
    }
    private okhttp3.Call networkPruneCall(String filters, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/networks/prune";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (filters != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("filters", filters));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call networkPruneValidateBeforeCall(String filters, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = networkPruneCall(filters, _callback);
        return localVarCall;

    }


    private ApiResponse<NetworkPrune200Response> networkPruneWithHttpInfo(String filters) throws ApiException {
        okhttp3.Call localVarCall = networkPruneValidateBeforeCall(filters, null);
        Type localVarReturnType = new TypeToken<NetworkPrune200Response>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call networkPruneAsync(String filters, final ApiCallback<NetworkPrune200Response> _callback) throws ApiException {

        okhttp3.Call localVarCall = networkPruneValidateBeforeCall(filters, _callback);
        Type localVarReturnType = new TypeToken<NetworkPrune200Response>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APInetworkPruneRequest {
        private String filters;

        private APInetworkPruneRequest() {
        }

        /**
         * Set filters
         * @param filters Filters to process on the prune list, encoded as JSON (a map[string][]string). Available filters:   - &#x60;until&#x3D;&lt;timestamp&gt;&#x60; Prune networks created before this timestamp. The &lt;timestamp&gt; can be Unix timestamps, date formatted timestamps, or Go duration strings (e.g. &#x60;10m&#x60;, &#x60;1h30m&#x60;) computed relative to the daemon machine’s time.   - &#x60;label&#x60; (&#x60;label&#x3D;&lt;key&gt;&#x60;, &#x60;label&#x3D;&lt;key&gt;&#x3D;&lt;value&gt;&#x60;, &#x60;label!&#x3D;&lt;key&gt;&#x60;, or &#x60;label!&#x3D;&lt;key&gt;&#x3D;&lt;value&gt;&#x60;) Prune networks with (or without, in case &#x60;label!&#x3D;...&#x60; is used) the specified labels.  (optional)
         * @return APInetworkPruneRequest
         */
        public APInetworkPruneRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        /**
         * Build call for networkPrune
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return networkPruneCall(filters, _callback);
        }

        /**
         * Execute networkPrune request
         * @return NetworkPrune200Response
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public NetworkPrune200Response execute() throws ApiException {
            ApiResponse<NetworkPrune200Response> localVarResp = networkPruneWithHttpInfo(filters);
            return localVarResp.getData();
        }

        /**
         * Execute networkPrune request with HTTP info returned
         * @return ApiResponse&lt;NetworkPrune200Response&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<NetworkPrune200Response> executeWithHttpInfo() throws ApiException {
            return networkPruneWithHttpInfo(filters);
        }

        /**
         * Execute networkPrune request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<NetworkPrune200Response> _callback) throws ApiException {
            return networkPruneAsync(filters, _callback);
        }
    }

    /**
     * Delete unused networks
     * Remove networks that do not have containers
     * @return APInetworkPruneRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APInetworkPruneRequest networkPrune() {
        return new APInetworkPruneRequest();
    }
}
