/*
 * supports a RESTful API for the Libpod library
 * This documentation describes the Podman v2.x+ RESTful API. It consists of a Docker-compatible API and a Libpod API providing support for Podman’s unique features such as pods.  To start the service and keep it running for 5,000 seconds (-t 0 runs forever):  podman system service -t 5000 &  You can then use cURL on the socket using requests documented below.  NOTE: if you install the package podman-docker, it will create a symbolic link for /run/docker.sock to /run/podman/podman.sock  NOTE: Some fields in the API response JSON are encoded as omitempty, which means that if said field has a zero value, they will not be encoded in the API response. This is a feature to help reduce the size of the JSON responses returned via the API.  NOTE: Due to the limitations of [go-swagger](https://github.com/go-swagger/go-swagger), some field values that have a complex type show up as null in the docs as well as in the API responses. This is because the zero value for the field type is null. The field description in the docs will state what type the field is expected to be for such cases.  See podman-system-service(1) for more information.  Quick Examples:  'podman info'  curl --unix-socket /run/podman/podman.sock http://d/v5.0.0/libpod/info  'podman pull quay.io/containers/podman'  curl -XPOST --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/images/create?fromImage=quay.io%2Fcontainers%2Fpodman'  'podman list images'  curl --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/libpod/images/json' | jq
 *
 * The version of the OpenAPI document: 5.0.0
 * Contact: podman@lists.podman.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.pod4dev.libpodj.api;

import io.github.pod4dev.libpodj.ApiCallback;
import io.github.pod4dev.libpodj.ApiClient;
import io.github.pod4dev.libpodj.ApiException;
import io.github.pod4dev.libpodj.ApiResponse;
import io.github.pod4dev.libpodj.Configuration;
import io.github.pod4dev.libpodj.Pair;
import io.github.pod4dev.libpodj.ProgressRequestBody;
import io.github.pod4dev.libpodj.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;

import javax.validation.constraints.*;

import io.github.pod4dev.libpodj.model.ErrorModel;
import io.github.pod4dev.libpodj.model.SecretCreateLibpod201Response;
import io.github.pod4dev.libpodj.model.SecretDeleteLibpod404Response;
import io.github.pod4dev.libpodj.model.SecretInfoReport;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericType;

public class SecretsApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SecretsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SecretsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private okhttp3.Call secretCreateLibpodCall(String name, String driver, String driveropts, String labels, String request, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = request;

        // create path and map variables
        String localVarPath = "/libpod/secrets/create";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (name != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("name", name));
        }

        if (driver != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("driver", driver));
        }

        if (driveropts != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("driveropts", driveropts));
        }

        if (labels != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("labels", labels));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json", "application/x-tar"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call secretCreateLibpodValidateBeforeCall(String name, String driver, String driveropts, String labels, String request, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling secretCreateLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = secretCreateLibpodCall(name, driver, driveropts, labels, request, _callback);
        return localVarCall;

    }


    private ApiResponse<SecretCreateLibpod201Response> secretCreateLibpodWithHttpInfo( @NotNull String name, String driver, String driveropts, String labels, String request) throws ApiException {
        okhttp3.Call localVarCall = secretCreateLibpodValidateBeforeCall(name, driver, driveropts, labels, request, null);
        Type localVarReturnType = new TypeToken<SecretCreateLibpod201Response>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call secretCreateLibpodAsync(String name, String driver, String driveropts, String labels, String request, final ApiCallback<SecretCreateLibpod201Response> _callback) throws ApiException {

        okhttp3.Call localVarCall = secretCreateLibpodValidateBeforeCall(name, driver, driveropts, labels, request, _callback);
        Type localVarReturnType = new TypeToken<SecretCreateLibpod201Response>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIsecretCreateLibpodRequest {
        private final String name;
        private String driver;
        private String driveropts;
        private String labels;
        private String request;

        private APIsecretCreateLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set driver
         * @param driver Secret driver (optional, default to file)
         * @return APIsecretCreateLibpodRequest
         */
        public APIsecretCreateLibpodRequest driver(String driver) {
            this.driver = driver;
            return this;
        }

        /**
         * Set driveropts
         * @param driveropts Secret driver options (optional)
         * @return APIsecretCreateLibpodRequest
         */
        public APIsecretCreateLibpodRequest driveropts(String driveropts) {
            this.driveropts = driveropts;
            return this;
        }

        /**
         * Set labels
         * @param labels Labels on the secret (optional)
         * @return APIsecretCreateLibpodRequest
         */
        public APIsecretCreateLibpodRequest labels(String labels) {
            this.labels = labels;
            return this;
        }

        /**
         * Set request
         * @param request Secret (optional)
         * @return APIsecretCreateLibpodRequest
         */
        public APIsecretCreateLibpodRequest request(String request) {
            this.request = request;
            return this;
        }

        /**
         * Build call for secretCreateLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> Secret create response </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return secretCreateLibpodCall(name, driver, driveropts, labels, request, _callback);
        }

        /**
         * Execute secretCreateLibpod request
         * @return SecretCreateLibpod201Response
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> Secret create response </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public SecretCreateLibpod201Response execute() throws ApiException {
            ApiResponse<SecretCreateLibpod201Response> localVarResp = secretCreateLibpodWithHttpInfo(name, driver, driveropts, labels, request);
            return localVarResp.getData();
        }

        /**
         * Execute secretCreateLibpod request with HTTP info returned
         * @return ApiResponse&lt;SecretCreateLibpod201Response&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> Secret create response </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<SecretCreateLibpod201Response> executeWithHttpInfo() throws ApiException {
            return secretCreateLibpodWithHttpInfo(name, driver, driveropts, labels, request);
        }

        /**
         * Execute secretCreateLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> Secret create response </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<SecretCreateLibpod201Response> _callback) throws ApiException {
            return secretCreateLibpodAsync(name, driver, driveropts, labels, request, _callback);
        }
    }

    /**
     * Create a secret
     * 
     * @param name User-defined name of the secret. (required)
     * @return APIsecretCreateLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> Secret create response </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIsecretCreateLibpodRequest secretCreateLibpod(String name) {
        return new APIsecretCreateLibpodRequest(name);
    }
    private okhttp3.Call secretDeleteLibpodCall(String name, Boolean all, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/secrets/{name}"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (all != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("all", all));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call secretDeleteLibpodValidateBeforeCall(String name, Boolean all, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling secretDeleteLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = secretDeleteLibpodCall(name, all, _callback);
        return localVarCall;

    }


    private ApiResponse<Void> secretDeleteLibpodWithHttpInfo( @NotNull String name, Boolean all) throws ApiException {
        okhttp3.Call localVarCall = secretDeleteLibpodValidateBeforeCall(name, all, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call secretDeleteLibpodAsync(String name, Boolean all, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = secretDeleteLibpodValidateBeforeCall(name, all, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIsecretDeleteLibpodRequest {
        private final String name;
        private Boolean all;

        private APIsecretDeleteLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set all
         * @param all Remove all secrets (optional, default to false)
         * @return APIsecretDeleteLibpodRequest
         */
        public APIsecretDeleteLibpodRequest all(Boolean all) {
            this.all = all;
            return this;
        }

        /**
         * Build call for secretDeleteLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such secret </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return secretDeleteLibpodCall(name, all, _callback);
        }

        /**
         * Execute secretDeleteLibpod request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such secret </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            secretDeleteLibpodWithHttpInfo(name, all);
        }

        /**
         * Execute secretDeleteLibpod request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such secret </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return secretDeleteLibpodWithHttpInfo(name, all);
        }

        /**
         * Execute secretDeleteLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such secret </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return secretDeleteLibpodAsync(name, all, _callback);
        }
    }

    /**
     * Remove secret
     * 
     * @param name the name or ID of the secret (required)
     * @return APIsecretDeleteLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such secret </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIsecretDeleteLibpodRequest secretDeleteLibpod(String name) {
        return new APIsecretDeleteLibpodRequest(name);
    }
    private okhttp3.Call secretExistsLibpodCall(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/secrets/{name}/exists"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call secretExistsLibpodValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling secretExistsLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = secretExistsLibpodCall(name, _callback);
        return localVarCall;

    }


    private ApiResponse<Void> secretExistsLibpodWithHttpInfo( @NotNull String name) throws ApiException {
        okhttp3.Call localVarCall = secretExistsLibpodValidateBeforeCall(name, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call secretExistsLibpodAsync(String name, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = secretExistsLibpodValidateBeforeCall(name, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIsecretExistsLibpodRequest {
        private final String name;

        private APIsecretExistsLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Build call for secretExistsLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> secret exists </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such secret </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return secretExistsLibpodCall(name, _callback);
        }

        /**
         * Execute secretExistsLibpod request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> secret exists </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such secret </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            secretExistsLibpodWithHttpInfo(name);
        }

        /**
         * Execute secretExistsLibpod request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> secret exists </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such secret </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return secretExistsLibpodWithHttpInfo(name);
        }

        /**
         * Execute secretExistsLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> secret exists </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such secret </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return secretExistsLibpodAsync(name, _callback);
        }
    }

    /**
     * Secret exists
     * 
     * @param name the name or ID of the secret (required)
     * @return APIsecretExistsLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> secret exists </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such secret </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIsecretExistsLibpodRequest secretExistsLibpod(String name) {
        return new APIsecretExistsLibpodRequest(name);
    }
    private okhttp3.Call secretInspectLibpodCall(String name, Boolean showsecret, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/secrets/{name}/json"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (showsecret != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("showsecret", showsecret));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call secretInspectLibpodValidateBeforeCall(String name, Boolean showsecret, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling secretInspectLibpod(Async)");
        }
        

        okhttp3.Call localVarCall = secretInspectLibpodCall(name, showsecret, _callback);
        return localVarCall;

    }


    private ApiResponse<SecretInfoReport> secretInspectLibpodWithHttpInfo( @NotNull String name, Boolean showsecret) throws ApiException {
        okhttp3.Call localVarCall = secretInspectLibpodValidateBeforeCall(name, showsecret, null);
        Type localVarReturnType = new TypeToken<SecretInfoReport>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call secretInspectLibpodAsync(String name, Boolean showsecret, final ApiCallback<SecretInfoReport> _callback) throws ApiException {

        okhttp3.Call localVarCall = secretInspectLibpodValidateBeforeCall(name, showsecret, _callback);
        Type localVarReturnType = new TypeToken<SecretInfoReport>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIsecretInspectLibpodRequest {
        private final String name;
        private Boolean showsecret;

        private APIsecretInspectLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set showsecret
         * @param showsecret Display Secret (optional, default to false)
         * @return APIsecretInspectLibpodRequest
         */
        public APIsecretInspectLibpodRequest showsecret(Boolean showsecret) {
            this.showsecret = showsecret;
            return this;
        }

        /**
         * Build call for secretInspectLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Secret inspect response </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such secret </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return secretInspectLibpodCall(name, showsecret, _callback);
        }

        /**
         * Execute secretInspectLibpod request
         * @return SecretInfoReport
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Secret inspect response </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such secret </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public SecretInfoReport execute() throws ApiException {
            ApiResponse<SecretInfoReport> localVarResp = secretInspectLibpodWithHttpInfo(name, showsecret);
            return localVarResp.getData();
        }

        /**
         * Execute secretInspectLibpod request with HTTP info returned
         * @return ApiResponse&lt;SecretInfoReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Secret inspect response </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such secret </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<SecretInfoReport> executeWithHttpInfo() throws ApiException {
            return secretInspectLibpodWithHttpInfo(name, showsecret);
        }

        /**
         * Execute secretInspectLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Secret inspect response </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such secret </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<SecretInfoReport> _callback) throws ApiException {
            return secretInspectLibpodAsync(name, showsecret, _callback);
        }
    }

    /**
     * Inspect secret
     * 
     * @param name the name or ID of the secret (required)
     * @return APIsecretInspectLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Secret inspect response </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such secret </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIsecretInspectLibpodRequest secretInspectLibpod(String name) {
        return new APIsecretInspectLibpodRequest(name);
    }
    private okhttp3.Call secretListLibpodCall(String filters, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/secrets/json";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (filters != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("filters", filters));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call secretListLibpodValidateBeforeCall(String filters, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = secretListLibpodCall(filters, _callback);
        return localVarCall;

    }


    private ApiResponse<List<SecretInfoReport>> secretListLibpodWithHttpInfo(String filters) throws ApiException {
        okhttp3.Call localVarCall = secretListLibpodValidateBeforeCall(filters, null);
        Type localVarReturnType = new TypeToken<List<SecretInfoReport>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call secretListLibpodAsync(String filters, final ApiCallback<List<SecretInfoReport>> _callback) throws ApiException {

        okhttp3.Call localVarCall = secretListLibpodValidateBeforeCall(filters, _callback);
        Type localVarReturnType = new TypeToken<List<SecretInfoReport>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIsecretListLibpodRequest {
        private String filters;

        private APIsecretListLibpodRequest() {
        }

        /**
         * Set filters
         * @param filters JSON encoded value of the filters (a &#x60;map[string][]string&#x60;) to process on the secrets list. Currently available filters:   - &#x60;name&#x3D;[name]&#x60; Matches secrets name (accepts regex).   - &#x60;id&#x3D;[id]&#x60; Matches for full or partial ID.  (optional)
         * @return APIsecretListLibpodRequest
         */
        public APIsecretListLibpodRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        /**
         * Build call for secretListLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Secret list response </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return secretListLibpodCall(filters, _callback);
        }

        /**
         * Execute secretListLibpod request
         * @return List&lt;SecretInfoReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Secret list response </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public List<SecretInfoReport> execute() throws ApiException {
            ApiResponse<List<SecretInfoReport>> localVarResp = secretListLibpodWithHttpInfo(filters);
            return localVarResp.getData();
        }

        /**
         * Execute secretListLibpod request with HTTP info returned
         * @return ApiResponse&lt;List&lt;SecretInfoReport&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Secret list response </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<SecretInfoReport>> executeWithHttpInfo() throws ApiException {
            return secretListLibpodWithHttpInfo(filters);
        }

        /**
         * Execute secretListLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Secret list response </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<SecretInfoReport>> _callback) throws ApiException {
            return secretListLibpodAsync(filters, _callback);
        }
    }

    /**
     * List secrets
     * Returns a list of secrets
     * @return APIsecretListLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Secret list response </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIsecretListLibpodRequest secretListLibpod() {
        return new APIsecretListLibpodRequest();
    }
}
