/*
 * supports a RESTful API for the Libpod library
 * This documentation describes the Podman v2.x+ RESTful API. It consists of a Docker-compatible API and a Libpod API providing support for Podman’s unique features such as pods.  To start the service and keep it running for 5,000 seconds (-t 0 runs forever):  podman system service -t 5000 &  You can then use cURL on the socket using requests documented below.  NOTE: if you install the package podman-docker, it will create a symbolic link for /run/docker.sock to /run/podman/podman.sock  NOTE: Some fields in the API response JSON are encoded as omitempty, which means that if said field has a zero value, they will not be encoded in the API response. This is a feature to help reduce the size of the JSON responses returned via the API.  NOTE: Due to the limitations of [go-swagger](https://github.com/go-swagger/go-swagger), some field values that have a complex type show up as null in the docs as well as in the API responses. This is because the zero value for the field type is null. The field description in the docs will state what type the field is expected to be for such cases.  See podman-system-service(1) for more information.  Quick Examples:  'podman info'  curl --unix-socket /run/podman/podman.sock http://d/v5.0.0/libpod/info  'podman pull quay.io/containers/podman'  curl -XPOST --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/images/create?fromImage=quay.io%2Fcontainers%2Fpodman'  'podman list images'  curl --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/libpod/images/json' | jq
 *
 * The version of the OpenAPI document: 5.0.0
 * Contact: podman@lists.podman.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.pod4dev.libpodj.api;

import io.github.pod4dev.libpodj.ApiCallback;
import io.github.pod4dev.libpodj.ApiClient;
import io.github.pod4dev.libpodj.ApiException;
import io.github.pod4dev.libpodj.ApiResponse;
import io.github.pod4dev.libpodj.Configuration;
import io.github.pod4dev.libpodj.Pair;
import io.github.pod4dev.libpodj.ProgressRequestBody;
import io.github.pod4dev.libpodj.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;

import javax.validation.constraints.*;

import io.github.pod4dev.libpodj.model.ErrorModel;
import io.github.pod4dev.libpodj.model.LibpodInfo;
import io.github.pod4dev.libpodj.model.SystemCheckReport;
import io.github.pod4dev.libpodj.model.SystemComponentVersion;
import io.github.pod4dev.libpodj.model.SystemDfReport;
import io.github.pod4dev.libpodj.model.SystemPruneReport;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericType;

public class SystemApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public SystemApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SystemApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private okhttp3.Call systemCheckLibpodCall(Boolean quick, Boolean repair, Boolean repairLossy, String unreferencedLayerMaxAge, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/system/check";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (quick != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("quick", quick));
        }

        if (repair != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("repair", repair));
        }

        if (repairLossy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("repair_lossy", repairLossy));
        }

        if (unreferencedLayerMaxAge != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("unreferenced_layer_max_age", unreferencedLayerMaxAge));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call systemCheckLibpodValidateBeforeCall(Boolean quick, Boolean repair, Boolean repairLossy, String unreferencedLayerMaxAge, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = systemCheckLibpodCall(quick, repair, repairLossy, unreferencedLayerMaxAge, _callback);
        return localVarCall;

    }


    private ApiResponse<SystemCheckReport> systemCheckLibpodWithHttpInfo(Boolean quick, Boolean repair, Boolean repairLossy, String unreferencedLayerMaxAge) throws ApiException {
        okhttp3.Call localVarCall = systemCheckLibpodValidateBeforeCall(quick, repair, repairLossy, unreferencedLayerMaxAge, null);
        Type localVarReturnType = new TypeToken<SystemCheckReport>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call systemCheckLibpodAsync(Boolean quick, Boolean repair, Boolean repairLossy, String unreferencedLayerMaxAge, final ApiCallback<SystemCheckReport> _callback) throws ApiException {

        okhttp3.Call localVarCall = systemCheckLibpodValidateBeforeCall(quick, repair, repairLossy, unreferencedLayerMaxAge, _callback);
        Type localVarReturnType = new TypeToken<SystemCheckReport>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIsystemCheckLibpodRequest {
        private Boolean quick;
        private Boolean repair;
        private Boolean repairLossy;
        private String unreferencedLayerMaxAge;

        private APIsystemCheckLibpodRequest() {
        }

        /**
         * Set quick
         * @param quick Skip time-consuming checks (optional)
         * @return APIsystemCheckLibpodRequest
         */
        public APIsystemCheckLibpodRequest quick(Boolean quick) {
            this.quick = quick;
            return this;
        }

        /**
         * Set repair
         * @param repair Remove inconsistent images (optional)
         * @return APIsystemCheckLibpodRequest
         */
        public APIsystemCheckLibpodRequest repair(Boolean repair) {
            this.repair = repair;
            return this;
        }

        /**
         * Set repairLossy
         * @param repairLossy Remove inconsistent containers and images (optional)
         * @return APIsystemCheckLibpodRequest
         */
        public APIsystemCheckLibpodRequest repairLossy(Boolean repairLossy) {
            this.repairLossy = repairLossy;
            return this;
        }

        /**
         * Set unreferencedLayerMaxAge
         * @param unreferencedLayerMaxAge Maximum allowed age of unreferenced layers (optional, default to 24h0m0s)
         * @return APIsystemCheckLibpodRequest
         */
        public APIsystemCheckLibpodRequest unreferencedLayerMaxAge(String unreferencedLayerMaxAge) {
            this.unreferencedLayerMaxAge = unreferencedLayerMaxAge;
            return this;
        }

        /**
         * Build call for systemCheckLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Check </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return systemCheckLibpodCall(quick, repair, repairLossy, unreferencedLayerMaxAge, _callback);
        }

        /**
         * Execute systemCheckLibpod request
         * @return SystemCheckReport
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Check </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public SystemCheckReport execute() throws ApiException {
            ApiResponse<SystemCheckReport> localVarResp = systemCheckLibpodWithHttpInfo(quick, repair, repairLossy, unreferencedLayerMaxAge);
            return localVarResp.getData();
        }

        /**
         * Execute systemCheckLibpod request with HTTP info returned
         * @return ApiResponse&lt;SystemCheckReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Check </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<SystemCheckReport> executeWithHttpInfo() throws ApiException {
            return systemCheckLibpodWithHttpInfo(quick, repair, repairLossy, unreferencedLayerMaxAge);
        }

        /**
         * Execute systemCheckLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Check </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<SystemCheckReport> _callback) throws ApiException {
            return systemCheckLibpodAsync(quick, repair, repairLossy, unreferencedLayerMaxAge, _callback);
        }
    }

    /**
     * Performs consistency checks on storage, optionally removing items which fail checks
     * 
     * @return APIsystemCheckLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Check </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIsystemCheckLibpodRequest systemCheckLibpod() {
        return new APIsystemCheckLibpodRequest();
    }
    private okhttp3.Call systemDataUsageLibpodCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/system/df";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call systemDataUsageLibpodValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = systemDataUsageLibpodCall(_callback);
        return localVarCall;

    }


    private ApiResponse<SystemDfReport> systemDataUsageLibpodWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = systemDataUsageLibpodValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<SystemDfReport>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call systemDataUsageLibpodAsync(final ApiCallback<SystemDfReport> _callback) throws ApiException {

        okhttp3.Call localVarCall = systemDataUsageLibpodValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<SystemDfReport>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIsystemDataUsageLibpodRequest {

        private APIsystemDataUsageLibpodRequest() {
        }

        /**
         * Build call for systemDataUsageLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Disk usage </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return systemDataUsageLibpodCall(_callback);
        }

        /**
         * Execute systemDataUsageLibpod request
         * @return SystemDfReport
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Disk usage </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public SystemDfReport execute() throws ApiException {
            ApiResponse<SystemDfReport> localVarResp = systemDataUsageLibpodWithHttpInfo();
            return localVarResp.getData();
        }

        /**
         * Execute systemDataUsageLibpod request with HTTP info returned
         * @return ApiResponse&lt;SystemDfReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Disk usage </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<SystemDfReport> executeWithHttpInfo() throws ApiException {
            return systemDataUsageLibpodWithHttpInfo();
        }

        /**
         * Execute systemDataUsageLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Disk usage </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<SystemDfReport> _callback) throws ApiException {
            return systemDataUsageLibpodAsync(_callback);
        }
    }

    /**
     * Show disk usage
     * Return information about disk usage for containers, images, and volumes
     * @return APIsystemDataUsageLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Disk usage </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIsystemDataUsageLibpodRequest systemDataUsageLibpod() {
        return new APIsystemDataUsageLibpodRequest();
    }
    private okhttp3.Call systemEventsLibpodCall(String since, String until, String filters, Boolean stream, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/events";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (since != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("since", since));
        }

        if (until != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("until", until));
        }

        if (filters != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("filters", filters));
        }

        if (stream != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("stream", stream));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call systemEventsLibpodValidateBeforeCall(String since, String until, String filters, Boolean stream, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = systemEventsLibpodCall(since, until, filters, stream, _callback);
        return localVarCall;

    }


    private ApiResponse<Void> systemEventsLibpodWithHttpInfo(String since, String until, String filters, Boolean stream) throws ApiException {
        okhttp3.Call localVarCall = systemEventsLibpodValidateBeforeCall(since, until, filters, stream, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call systemEventsLibpodAsync(String since, String until, String filters, Boolean stream, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = systemEventsLibpodValidateBeforeCall(since, until, filters, stream, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIsystemEventsLibpodRequest {
        private String since;
        private String until;
        private String filters;
        private Boolean stream;

        private APIsystemEventsLibpodRequest() {
        }

        /**
         * Set since
         * @param since start streaming events from this time (optional)
         * @return APIsystemEventsLibpodRequest
         */
        public APIsystemEventsLibpodRequest since(String since) {
            this.since = since;
            return this;
        }

        /**
         * Set until
         * @param until stop streaming events later than this (optional)
         * @return APIsystemEventsLibpodRequest
         */
        public APIsystemEventsLibpodRequest until(String until) {
            this.until = until;
            return this;
        }

        /**
         * Set filters
         * @param filters JSON encoded map[string][]string of constraints (optional)
         * @return APIsystemEventsLibpodRequest
         */
        public APIsystemEventsLibpodRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        /**
         * Set stream
         * @param stream when false, do not follow events (optional, default to true)
         * @return APIsystemEventsLibpodRequest
         */
        public APIsystemEventsLibpodRequest stream(Boolean stream) {
            this.stream = stream;
            return this;
        }

        /**
         * Build call for systemEventsLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> returns a string of json data describing an event </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return systemEventsLibpodCall(since, until, filters, stream, _callback);
        }

        /**
         * Execute systemEventsLibpod request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> returns a string of json data describing an event </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            systemEventsLibpodWithHttpInfo(since, until, filters, stream);
        }

        /**
         * Execute systemEventsLibpod request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> returns a string of json data describing an event </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return systemEventsLibpodWithHttpInfo(since, until, filters, stream);
        }

        /**
         * Execute systemEventsLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> returns a string of json data describing an event </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return systemEventsLibpodAsync(since, until, filters, stream, _callback);
        }
    }

    /**
     * Get events
     * Returns events filtered on query parameters
     * @return APIsystemEventsLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> returns a string of json data describing an event </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIsystemEventsLibpodRequest systemEventsLibpod() {
        return new APIsystemEventsLibpodRequest();
    }
    private okhttp3.Call systemInfoLibpodCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/info";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call systemInfoLibpodValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = systemInfoLibpodCall(_callback);
        return localVarCall;

    }


    private ApiResponse<LibpodInfo> systemInfoLibpodWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = systemInfoLibpodValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<LibpodInfo>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call systemInfoLibpodAsync(final ApiCallback<LibpodInfo> _callback) throws ApiException {

        okhttp3.Call localVarCall = systemInfoLibpodValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<LibpodInfo>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIsystemInfoLibpodRequest {

        private APIsystemInfoLibpodRequest() {
        }

        /**
         * Build call for systemInfoLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Info </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return systemInfoLibpodCall(_callback);
        }

        /**
         * Execute systemInfoLibpod request
         * @return LibpodInfo
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Info </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public LibpodInfo execute() throws ApiException {
            ApiResponse<LibpodInfo> localVarResp = systemInfoLibpodWithHttpInfo();
            return localVarResp.getData();
        }

        /**
         * Execute systemInfoLibpod request with HTTP info returned
         * @return ApiResponse&lt;LibpodInfo&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Info </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<LibpodInfo> executeWithHttpInfo() throws ApiException {
            return systemInfoLibpodWithHttpInfo();
        }

        /**
         * Execute systemInfoLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Info </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<LibpodInfo> _callback) throws ApiException {
            return systemInfoLibpodAsync(_callback);
        }
    }

    /**
     * Get info
     * Returns information on the system and libpod configuration
     * @return APIsystemInfoLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Info </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIsystemInfoLibpodRequest systemInfoLibpod() {
        return new APIsystemInfoLibpodRequest();
    }
    private okhttp3.Call systemPingCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/_ping";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call systemPingValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = systemPingCall(_callback);
        return localVarCall;

    }


    private ApiResponse<String> systemPingWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = systemPingValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call systemPingAsync(final ApiCallback<String> _callback) throws ApiException {

        okhttp3.Call localVarCall = systemPingValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<String>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIsystemPingRequest {

        private APIsystemPingRequest() {
        }

        /**
         * Build call for systemPing
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Success </td><td>  * Docker-Experimental - If the server is running with experimental mode enabled, always true <br>  * Cache-Control - always no-cache <br>  * Libpod-Buildah-Version - Default version of libpod image builder.   Available if service is backed by Podman, therefore may be used to   determine if talking to Podman engine or another engine  <br>  * Libpod-API-Version - Max Podman API Version the server supports. Available if service is backed by Podman, therefore may be used to determine if talking to Podman engine or another engine  <br>  * BuildKit-Version - Default version of docker image builder <br>  * Pragma - always no-cache <br>  * API-Version - Max compatibility API Version the server supports <br>  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return systemPingCall(_callback);
        }

        /**
         * Execute systemPing request
         * @return String
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Success </td><td>  * Docker-Experimental - If the server is running with experimental mode enabled, always true <br>  * Cache-Control - always no-cache <br>  * Libpod-Buildah-Version - Default version of libpod image builder.   Available if service is backed by Podman, therefore may be used to   determine if talking to Podman engine or another engine  <br>  * Libpod-API-Version - Max Podman API Version the server supports. Available if service is backed by Podman, therefore may be used to determine if talking to Podman engine or another engine  <br>  * BuildKit-Version - Default version of docker image builder <br>  * Pragma - always no-cache <br>  * API-Version - Max compatibility API Version the server supports <br>  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public String execute() throws ApiException {
            ApiResponse<String> localVarResp = systemPingWithHttpInfo();
            return localVarResp.getData();
        }

        /**
         * Execute systemPing request with HTTP info returned
         * @return ApiResponse&lt;String&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Success </td><td>  * Docker-Experimental - If the server is running with experimental mode enabled, always true <br>  * Cache-Control - always no-cache <br>  * Libpod-Buildah-Version - Default version of libpod image builder.   Available if service is backed by Podman, therefore may be used to   determine if talking to Podman engine or another engine  <br>  * Libpod-API-Version - Max Podman API Version the server supports. Available if service is backed by Podman, therefore may be used to determine if talking to Podman engine or another engine  <br>  * BuildKit-Version - Default version of docker image builder <br>  * Pragma - always no-cache <br>  * API-Version - Max compatibility API Version the server supports <br>  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<String> executeWithHttpInfo() throws ApiException {
            return systemPingWithHttpInfo();
        }

        /**
         * Execute systemPing request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Success </td><td>  * Docker-Experimental - If the server is running with experimental mode enabled, always true <br>  * Cache-Control - always no-cache <br>  * Libpod-Buildah-Version - Default version of libpod image builder.   Available if service is backed by Podman, therefore may be used to   determine if talking to Podman engine or another engine  <br>  * Libpod-API-Version - Max Podman API Version the server supports. Available if service is backed by Podman, therefore may be used to determine if talking to Podman engine or another engine  <br>  * BuildKit-Version - Default version of docker image builder <br>  * Pragma - always no-cache <br>  * API-Version - Max compatibility API Version the server supports <br>  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<String> _callback) throws ApiException {
            return systemPingAsync(_callback);
        }
    }

    /**
     * Ping service
     * Return protocol information in response headers. &#x60;HEAD /libpod/_ping&#x60; is also supported. &#x60;/_ping&#x60; is available for compatibility with other engines. The &#39;_ping&#39; endpoints are not versioned. 
     * @return APIsystemPingRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Success </td><td>  * Docker-Experimental - If the server is running with experimental mode enabled, always true <br>  * Cache-Control - always no-cache <br>  * Libpod-Buildah-Version - Default version of libpod image builder.   Available if service is backed by Podman, therefore may be used to   determine if talking to Podman engine or another engine  <br>  * Libpod-API-Version - Max Podman API Version the server supports. Available if service is backed by Podman, therefore may be used to determine if talking to Podman engine or another engine  <br>  * BuildKit-Version - Default version of docker image builder <br>  * Pragma - always no-cache <br>  * API-Version - Max compatibility API Version the server supports <br>  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIsystemPingRequest systemPing() {
        return new APIsystemPingRequest();
    }
    private okhttp3.Call systemPruneLibpodCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/system/prune";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call systemPruneLibpodValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = systemPruneLibpodCall(_callback);
        return localVarCall;

    }


    private ApiResponse<SystemPruneReport> systemPruneLibpodWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = systemPruneLibpodValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<SystemPruneReport>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call systemPruneLibpodAsync(final ApiCallback<SystemPruneReport> _callback) throws ApiException {

        okhttp3.Call localVarCall = systemPruneLibpodValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<SystemPruneReport>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIsystemPruneLibpodRequest {

        private APIsystemPruneLibpodRequest() {
        }

        /**
         * Build call for systemPruneLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> System Prune results </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return systemPruneLibpodCall(_callback);
        }

        /**
         * Execute systemPruneLibpod request
         * @return SystemPruneReport
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> System Prune results </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public SystemPruneReport execute() throws ApiException {
            ApiResponse<SystemPruneReport> localVarResp = systemPruneLibpodWithHttpInfo();
            return localVarResp.getData();
        }

        /**
         * Execute systemPruneLibpod request with HTTP info returned
         * @return ApiResponse&lt;SystemPruneReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> System Prune results </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<SystemPruneReport> executeWithHttpInfo() throws ApiException {
            return systemPruneLibpodWithHttpInfo();
        }

        /**
         * Execute systemPruneLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> System Prune results </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<SystemPruneReport> _callback) throws ApiException {
            return systemPruneLibpodAsync(_callback);
        }
    }

    /**
     * Prune unused data
     * 
     * @return APIsystemPruneLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> System Prune results </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIsystemPruneLibpodRequest systemPruneLibpod() {
        return new APIsystemPruneLibpodRequest();
    }
    private okhttp3.Call systemVersionLibpodCall(final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/version";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call systemVersionLibpodValidateBeforeCall(final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = systemVersionLibpodCall(_callback);
        return localVarCall;

    }


    private ApiResponse<SystemComponentVersion> systemVersionLibpodWithHttpInfo() throws ApiException {
        okhttp3.Call localVarCall = systemVersionLibpodValidateBeforeCall(null);
        Type localVarReturnType = new TypeToken<SystemComponentVersion>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call systemVersionLibpodAsync(final ApiCallback<SystemComponentVersion> _callback) throws ApiException {

        okhttp3.Call localVarCall = systemVersionLibpodValidateBeforeCall(_callback);
        Type localVarReturnType = new TypeToken<SystemComponentVersion>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIsystemVersionLibpodRequest {

        private APIsystemVersionLibpodRequest() {
        }

        /**
         * Build call for systemVersionLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Version </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return systemVersionLibpodCall(_callback);
        }

        /**
         * Execute systemVersionLibpod request
         * @return SystemComponentVersion
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Version </td><td>  -  </td></tr>
         </table>
         */
        public SystemComponentVersion execute() throws ApiException {
            ApiResponse<SystemComponentVersion> localVarResp = systemVersionLibpodWithHttpInfo();
            return localVarResp.getData();
        }

        /**
         * Execute systemVersionLibpod request with HTTP info returned
         * @return ApiResponse&lt;SystemComponentVersion&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Version </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<SystemComponentVersion> executeWithHttpInfo() throws ApiException {
            return systemVersionLibpodWithHttpInfo();
        }

        /**
         * Execute systemVersionLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Version </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<SystemComponentVersion> _callback) throws ApiException {
            return systemVersionLibpodAsync(_callback);
        }
    }

    /**
     * Component Version information
     * 
     * @return APIsystemVersionLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Version </td><td>  -  </td></tr>
     </table>
     */
    public APIsystemVersionLibpodRequest systemVersionLibpod() {
        return new APIsystemVersionLibpodRequest();
    }
}
