/*
 * supports a RESTful API for the Libpod library
 * This documentation describes the Podman v2.x+ RESTful API. It consists of a Docker-compatible API and a Libpod API providing support for Podman’s unique features such as pods.  To start the service and keep it running for 5,000 seconds (-t 0 runs forever):  podman system service -t 5000 &  You can then use cURL on the socket using requests documented below.  NOTE: if you install the package podman-docker, it will create a symbolic link for /run/docker.sock to /run/podman/podman.sock  NOTE: Some fields in the API response JSON are encoded as omitempty, which means that if said field has a zero value, they will not be encoded in the API response. This is a feature to help reduce the size of the JSON responses returned via the API.  NOTE: Due to the limitations of [go-swagger](https://github.com/go-swagger/go-swagger), some field values that have a complex type show up as null in the docs as well as in the API responses. This is because the zero value for the field type is null. The field description in the docs will state what type the field is expected to be for such cases.  See podman-system-service(1) for more information.  Quick Examples:  'podman info'  curl --unix-socket /run/podman/podman.sock http://d/v5.0.0/libpod/info  'podman pull quay.io/containers/podman'  curl -XPOST --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/images/create?fromImage=quay.io%2Fcontainers%2Fpodman'  'podman list images'  curl --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/libpod/images/json' | jq
 *
 * The version of the OpenAPI document: 5.0.0
 * Contact: podman@lists.podman.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.pod4dev.libpodj.api;

import io.github.pod4dev.libpodj.ApiCallback;
import io.github.pod4dev.libpodj.ApiClient;
import io.github.pod4dev.libpodj.ApiException;
import io.github.pod4dev.libpodj.ApiResponse;
import io.github.pod4dev.libpodj.Configuration;
import io.github.pod4dev.libpodj.Pair;
import io.github.pod4dev.libpodj.ProgressRequestBody;
import io.github.pod4dev.libpodj.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;

import javax.validation.constraints.*;

import io.github.pod4dev.libpodj.model.ErrorModel;
import io.github.pod4dev.libpodj.model.ListResponse;
import io.github.pod4dev.libpodj.model.PruneReport;
import io.github.pod4dev.libpodj.model.Volume;
import io.github.pod4dev.libpodj.model.VolumeCreate;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.GenericType;

public class VolumesCompatApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public VolumesCompatApi() {
        this(Configuration.getDefaultApiClient());
    }

    public VolumesCompatApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private okhttp3.Call volumeCreateCall(VolumeCreate create, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = create;

        // create path and map variables
        String localVarPath = "/volumes/create";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/json", "application/x-tar"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call volumeCreateValidateBeforeCall(VolumeCreate create, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = volumeCreateCall(create, _callback);
        return localVarCall;

    }


    private ApiResponse<Volume> volumeCreateWithHttpInfo(VolumeCreate create) throws ApiException {
        okhttp3.Call localVarCall = volumeCreateValidateBeforeCall(create, null);
        Type localVarReturnType = new TypeToken<Volume>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call volumeCreateAsync(VolumeCreate create, final ApiCallback<Volume> _callback) throws ApiException {

        okhttp3.Call localVarCall = volumeCreateValidateBeforeCall(create, _callback);
        Type localVarReturnType = new TypeToken<Volume>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIvolumeCreateRequest {
        private VolumeCreate create;

        private APIvolumeCreateRequest() {
        }

        /**
         * Set create
         * @param create attributes for creating a volume. Note: If a volume by the same name exists, a 201 response with that volume&#39;s information will be generated.  (optional)
         * @return APIvolumeCreateRequest
         */
        public APIvolumeCreateRequest create(VolumeCreate create) {
            this.create = create;
            return this;
        }

        /**
         * Build call for volumeCreate
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> This response definition is used for both the create and inspect endpoints </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return volumeCreateCall(create, _callback);
        }

        /**
         * Execute volumeCreate request
         * @return Volume
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> This response definition is used for both the create and inspect endpoints </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public Volume execute() throws ApiException {
            ApiResponse<Volume> localVarResp = volumeCreateWithHttpInfo(create);
            return localVarResp.getData();
        }

        /**
         * Execute volumeCreate request with HTTP info returned
         * @return ApiResponse&lt;Volume&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> This response definition is used for both the create and inspect endpoints </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Volume> executeWithHttpInfo() throws ApiException {
            return volumeCreateWithHttpInfo(create);
        }

        /**
         * Execute volumeCreate request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> This response definition is used for both the create and inspect endpoints </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Volume> _callback) throws ApiException {
            return volumeCreateAsync(create, _callback);
        }
    }

    /**
     * Create a volume
     * 
     * @return APIvolumeCreateRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> This response definition is used for both the create and inspect endpoints </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIvolumeCreateRequest volumeCreate() {
        return new APIvolumeCreateRequest();
    }
    private okhttp3.Call volumeDeleteCall(String name, Boolean force, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/volumes/{name}"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (force != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("force", force));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call volumeDeleteValidateBeforeCall(String name, Boolean force, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling volumeDelete(Async)");
        }
        

        okhttp3.Call localVarCall = volumeDeleteCall(name, force, _callback);
        return localVarCall;

    }


    private ApiResponse<Void> volumeDeleteWithHttpInfo( @NotNull String name, Boolean force) throws ApiException {
        okhttp3.Call localVarCall = volumeDeleteValidateBeforeCall(name, force, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call volumeDeleteAsync(String name, Boolean force, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = volumeDeleteValidateBeforeCall(name, force, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIvolumeDeleteRequest {
        private final String name;
        private Boolean force;

        private APIvolumeDeleteRequest(String name) {
            this.name = name;
        }

        /**
         * Set force
         * @param force Force removal of the volume. This actually only causes errors due to the names volume not being found to be suppressed, which is the behaviour Docker implements.  (optional)
         * @return APIvolumeDeleteRequest
         */
        public APIvolumeDeleteRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        /**
         * Build call for volumeDelete
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such volume </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Volume is in use and cannot be removed </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return volumeDeleteCall(name, force, _callback);
        }

        /**
         * Execute volumeDelete request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such volume </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Volume is in use and cannot be removed </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            volumeDeleteWithHttpInfo(name, force);
        }

        /**
         * Execute volumeDelete request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such volume </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Volume is in use and cannot be removed </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return volumeDeleteWithHttpInfo(name, force);
        }

        /**
         * Execute volumeDelete request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such volume </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Volume is in use and cannot be removed </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return volumeDeleteAsync(name, force, _callback);
        }
    }

    /**
     * Remove volume
     * 
     * @param name the name or ID of the volume (required)
     * @return APIvolumeDeleteRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such volume </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Volume is in use and cannot be removed </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIvolumeDeleteRequest volumeDelete(String name) {
        return new APIvolumeDeleteRequest(name);
    }
    private okhttp3.Call volumeInspectCall(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/volumes/{name}"
            .replaceAll("\\{" + "name" + "\\}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call volumeInspectValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling volumeInspect(Async)");
        }
        

        okhttp3.Call localVarCall = volumeInspectCall(name, _callback);
        return localVarCall;

    }


    private ApiResponse<Volume> volumeInspectWithHttpInfo( @NotNull String name) throws ApiException {
        okhttp3.Call localVarCall = volumeInspectValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<Volume>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call volumeInspectAsync(String name, final ApiCallback<Volume> _callback) throws ApiException {

        okhttp3.Call localVarCall = volumeInspectValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<Volume>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIvolumeInspectRequest {
        private final String name;

        private APIvolumeInspectRequest(String name) {
            this.name = name;
        }

        /**
         * Build call for volumeInspect
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> This response definition is used for both the create and inspect endpoints </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return volumeInspectCall(name, _callback);
        }

        /**
         * Execute volumeInspect request
         * @return Volume
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> This response definition is used for both the create and inspect endpoints </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public Volume execute() throws ApiException {
            ApiResponse<Volume> localVarResp = volumeInspectWithHttpInfo(name);
            return localVarResp.getData();
        }

        /**
         * Execute volumeInspect request with HTTP info returned
         * @return ApiResponse&lt;Volume&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> This response definition is used for both the create and inspect endpoints </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Volume> executeWithHttpInfo() throws ApiException {
            return volumeInspectWithHttpInfo(name);
        }

        /**
         * Execute volumeInspect request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> This response definition is used for both the create and inspect endpoints </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Volume> _callback) throws ApiException {
            return volumeInspectAsync(name, _callback);
        }
    }

    /**
     * Inspect volume
     * 
     * @param name the name or ID of the volume (required)
     * @return APIvolumeInspectRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> This response definition is used for both the create and inspect endpoints </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIvolumeInspectRequest volumeInspect(String name) {
        return new APIvolumeInspectRequest(name);
    }
    private okhttp3.Call volumeListCall(String filters, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/volumes";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (filters != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("filters", filters));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call volumeListValidateBeforeCall(String filters, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = volumeListCall(filters, _callback);
        return localVarCall;

    }


    private ApiResponse<ListResponse> volumeListWithHttpInfo(String filters) throws ApiException {
        okhttp3.Call localVarCall = volumeListValidateBeforeCall(filters, null);
        Type localVarReturnType = new TypeToken<ListResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call volumeListAsync(String filters, final ApiCallback<ListResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = volumeListValidateBeforeCall(filters, _callback);
        Type localVarReturnType = new TypeToken<ListResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIvolumeListRequest {
        private String filters;

        private APIvolumeListRequest() {
        }

        /**
         * Set filters
         * @param filters JSON encoded value of the filters (a map[string][]string) to process on the volumes list. Available filters:   - driver&#x3D;&lt;volume-driver-name&gt; Matches volumes based on their driver.   - label&#x3D;&lt;key&gt; or label&#x3D;&lt;key&gt;:&lt;value&gt; Matches volumes based on the presence of a label alone or a label and a value.   - name&#x3D;&lt;volume-name&gt; Matches all of volume name.   - &#x60;until&#x3D;&lt;timestamp&gt;&#x60; List volumes created before this timestamp. The &#x60;&lt;timestamp&gt;&#x60; can be Unix timestamps, date formatted timestamps, or Go duration strings (e.g. &#x60;10m&#x60;, &#x60;1h30m&#x60;) computed relative to the daemon machine’s time.  Note:   The boolean &#x60;dangling&#x60; filter is not yet implemented for this endpoint.  (optional)
         * @return APIvolumeListRequest
         */
        public APIvolumeListRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        /**
         * Build call for volumeList
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Volume List </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return volumeListCall(filters, _callback);
        }

        /**
         * Execute volumeList request
         * @return ListResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Volume List </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ListResponse execute() throws ApiException {
            ApiResponse<ListResponse> localVarResp = volumeListWithHttpInfo(filters);
            return localVarResp.getData();
        }

        /**
         * Execute volumeList request with HTTP info returned
         * @return ApiResponse&lt;ListResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Volume List </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<ListResponse> executeWithHttpInfo() throws ApiException {
            return volumeListWithHttpInfo(filters);
        }

        /**
         * Execute volumeList request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Volume List </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<ListResponse> _callback) throws ApiException {
            return volumeListAsync(filters, _callback);
        }
    }

    /**
     * List volumes
     * Returns a list of volume
     * @return APIvolumeListRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Volume List </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIvolumeListRequest volumeList() {
        return new APIvolumeListRequest();
    }
    private okhttp3.Call volumePruneCall(String filters, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/volumes/prune";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (filters != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("filters", filters));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call volumePruneValidateBeforeCall(String filters, final ApiCallback _callback) throws ApiException {
        

        okhttp3.Call localVarCall = volumePruneCall(filters, _callback);
        return localVarCall;

    }


    private ApiResponse<PruneReport> volumePruneWithHttpInfo(String filters) throws ApiException {
        okhttp3.Call localVarCall = volumePruneValidateBeforeCall(filters, null);
        Type localVarReturnType = new TypeToken<PruneReport>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call volumePruneAsync(String filters, final ApiCallback<PruneReport> _callback) throws ApiException {

        okhttp3.Call localVarCall = volumePruneValidateBeforeCall(filters, _callback);
        Type localVarReturnType = new TypeToken<PruneReport>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIvolumePruneRequest {
        private String filters;

        private APIvolumePruneRequest() {
        }

        /**
         * Set filters
         * @param filters JSON encoded value of filters (a map[string][]string) to match volumes against before pruning. Available filters:   - &#x60;until&#x3D;&lt;timestamp&gt;&#x60; Prune volumes created before this timestamp. The &#x60;&lt;timestamp&gt;&#x60; can be Unix timestamps, date formatted timestamps, or Go duration strings (e.g. &#x60;10m&#x60;, &#x60;1h30m&#x60;) computed relative to the daemon machine’s time.   - &#x60;label&#x60; (&#x60;label&#x3D;&lt;key&gt;&#x60;, &#x60;label&#x3D;&lt;key&gt;&#x3D;&lt;value&gt;&#x60;, &#x60;label!&#x3D;&lt;key&gt;&#x60;, or &#x60;label!&#x3D;&lt;key&gt;&#x3D;&lt;value&gt;&#x60;) Prune volumes with (or without, in case &#x60;label!&#x3D;...&#x60; is used) the specified labels.  (optional)
         * @return APIvolumePruneRequest
         */
        public APIvolumePruneRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        /**
         * Build call for volumePrune
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Volume prune </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return volumePruneCall(filters, _callback);
        }

        /**
         * Execute volumePrune request
         * @return PruneReport
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Volume prune </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public PruneReport execute() throws ApiException {
            ApiResponse<PruneReport> localVarResp = volumePruneWithHttpInfo(filters);
            return localVarResp.getData();
        }

        /**
         * Execute volumePrune request with HTTP info returned
         * @return ApiResponse&lt;PruneReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Volume prune </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<PruneReport> executeWithHttpInfo() throws ApiException {
            return volumePruneWithHttpInfo(filters);
        }

        /**
         * Execute volumePrune request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Volume prune </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<PruneReport> _callback) throws ApiException {
            return volumePruneAsync(filters, _callback);
        }
    }

    /**
     * Prune volumes
     * 
     * @return APIvolumePruneRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Volume prune </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIvolumePruneRequest volumePrune() {
        return new APIvolumePruneRequest();
    }
}
