/*
 * supports a RESTful API for the Libpod library
 * This documentation describes the Podman v2.x+ RESTful API. It consists of a Docker-compatible API and a Libpod API providing support for Podman’s unique features such as pods.  To start the service and keep it running for 5,000 seconds (-t 0 runs forever):  podman system service -t 5000 &  You can then use cURL on the socket using requests documented below.  NOTE: if you install the package podman-docker, it will create a symbolic link for /run/docker.sock to /run/podman/podman.sock  NOTE: Some fields in the API response JSON are encoded as omitempty, which means that if said field has a zero value, they will not be encoded in the API response. This is a feature to help reduce the size of the JSON responses returned via the API.  NOTE: Due to the limitations of [go-swagger](https://github.com/go-swagger/go-swagger), some field values that have a complex type show up as null in the docs as well as in the API responses. This is because the zero value for the field type is null. The field description in the docs will state what type the field is expected to be for such cases.  See podman-system-service(1) for more information.  Quick Examples:  'podman info'  curl --unix-socket /run/podman/podman.sock http://d/v5.0.0/libpod/info  'podman pull quay.io/containers/podman'  curl -XPOST --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/images/create?fromImage=quay.io%2Fcontainers%2Fpodman'  'podman list images'  curl --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/libpod/images/json' | jq
 *
 * The version of the OpenAPI document: 5.0.0
 * Contact: podman@lists.podman.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.pod4dev.libpodj.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.model.LinuxPersonality;
import io.github.pod4dev.libpodj.model.LogConfigLibpod;
import io.github.pod4dev.libpodj.model.Namespace;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.io.Serializable;
import javax.validation.constraints.*;
import javax.validation.Valid;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import io.github.pod4dev.libpodj.JSON;

/**
 * ContainerBasicConfig
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class ContainerBasicConfig implements Serializable {
  private static final long serialVersionUID = 1L;

  public static final String SERIALIZED_NAME_ANNOTATIONS = "annotations";
  @SerializedName(SERIALIZED_NAME_ANNOTATIONS)
  private Map<String, String> annotations = null;

  public static final String SERIALIZED_NAME_COMMAND = "command";
  @SerializedName(SERIALIZED_NAME_COMMAND)
  private List<String> command = null;

  public static final String SERIALIZED_NAME_CONMON_PID_FILE = "conmon_pid_file";
  @SerializedName(SERIALIZED_NAME_CONMON_PID_FILE)
  private String conmonPidFile;

  public static final String SERIALIZED_NAME_CONTAINER_CREATE_COMMAND = "containerCreateCommand";
  @SerializedName(SERIALIZED_NAME_CONTAINER_CREATE_COMMAND)
  private List<String> containerCreateCommand = null;

  public static final String SERIALIZED_NAME_DEPENDENCY_CONTAINERS = "dependencyContainers";
  @SerializedName(SERIALIZED_NAME_DEPENDENCY_CONTAINERS)
  private List<String> dependencyContainers = null;

  public static final String SERIALIZED_NAME_ENTRYPOINT = "entrypoint";
  @SerializedName(SERIALIZED_NAME_ENTRYPOINT)
  private List<String> entrypoint = null;

  public static final String SERIALIZED_NAME_ENV = "env";
  @SerializedName(SERIALIZED_NAME_ENV)
  private Map<String, String> env = null;

  public static final String SERIALIZED_NAME_ENV_HOST = "env_host";
  @SerializedName(SERIALIZED_NAME_ENV_HOST)
  private Boolean envHost;

  public static final String SERIALIZED_NAME_ENVMERGE = "envmerge";
  @SerializedName(SERIALIZED_NAME_ENVMERGE)
  private List<String> envmerge = null;

  public static final String SERIALIZED_NAME_GROUP_ENTRY = "group_entry";
  @SerializedName(SERIALIZED_NAME_GROUP_ENTRY)
  private String groupEntry;

  public static final String SERIALIZED_NAME_HOSTNAME = "hostname";
  @SerializedName(SERIALIZED_NAME_HOSTNAME)
  private String hostname;

  public static final String SERIALIZED_NAME_HOSTUSERS = "hostusers";
  @SerializedName(SERIALIZED_NAME_HOSTUSERS)
  private List<String> hostusers = null;

  public static final String SERIALIZED_NAME_HTTPPROXY = "httpproxy";
  @SerializedName(SERIALIZED_NAME_HTTPPROXY)
  private Boolean httpproxy;

  public static final String SERIALIZED_NAME_INIT_CONTAINER_TYPE = "init_container_type";
  @SerializedName(SERIALIZED_NAME_INIT_CONTAINER_TYPE)
  private String initContainerType;

  public static final String SERIALIZED_NAME_LABELS = "labels";
  @SerializedName(SERIALIZED_NAME_LABELS)
  private Map<String, String> labels = null;

  public static final String SERIALIZED_NAME_LOG_CONFIGURATION = "log_configuration";
  @SerializedName(SERIALIZED_NAME_LOG_CONFIGURATION)
  private LogConfigLibpod logConfiguration;

  public static final String SERIALIZED_NAME_MANAGE_PASSWORD = "manage_password";
  @SerializedName(SERIALIZED_NAME_MANAGE_PASSWORD)
  private Boolean managePassword;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_OCI_RUNTIME = "oci_runtime";
  @SerializedName(SERIALIZED_NAME_OCI_RUNTIME)
  private String ociRuntime;

  public static final String SERIALIZED_NAME_PASSWD_ENTRY = "passwd_entry";
  @SerializedName(SERIALIZED_NAME_PASSWD_ENTRY)
  private String passwdEntry;

  public static final String SERIALIZED_NAME_PERSONALITY = "personality";
  @SerializedName(SERIALIZED_NAME_PERSONALITY)
  private LinuxPersonality personality;

  public static final String SERIALIZED_NAME_PIDNS = "pidns";
  @SerializedName(SERIALIZED_NAME_PIDNS)
  private Namespace pidns;

  public static final String SERIALIZED_NAME_POD = "pod";
  @SerializedName(SERIALIZED_NAME_POD)
  private String pod;

  public static final String SERIALIZED_NAME_REMOVE = "remove";
  @SerializedName(SERIALIZED_NAME_REMOVE)
  private Boolean remove;

  public static final String SERIALIZED_NAME_REMOVE_IMAGE = "removeImage";
  @SerializedName(SERIALIZED_NAME_REMOVE_IMAGE)
  private Boolean removeImage;

  public static final String SERIALIZED_NAME_RESTART_POLICY = "restart_policy";
  @SerializedName(SERIALIZED_NAME_RESTART_POLICY)
  private String restartPolicy;

  public static final String SERIALIZED_NAME_RESTART_TRIES = "restart_tries";
  @SerializedName(SERIALIZED_NAME_RESTART_TRIES)
  private Integer restartTries;

  public static final String SERIALIZED_NAME_SDNOTIFY_MODE = "sdnotifyMode";
  @SerializedName(SERIALIZED_NAME_SDNOTIFY_MODE)
  private String sdnotifyMode;

  public static final String SERIALIZED_NAME_SECRET_ENV = "secret_env";
  @SerializedName(SERIALIZED_NAME_SECRET_ENV)
  private Map<String, String> secretEnv = null;

  public static final String SERIALIZED_NAME_STDIN = "stdin";
  @SerializedName(SERIALIZED_NAME_STDIN)
  private Boolean stdin;

  public static final String SERIALIZED_NAME_STOP_SIGNAL = "stop_signal";
  @SerializedName(SERIALIZED_NAME_STOP_SIGNAL)
  private Long stopSignal;

  public static final String SERIALIZED_NAME_STOP_TIMEOUT = "stop_timeout";
  @SerializedName(SERIALIZED_NAME_STOP_TIMEOUT)
  private Integer stopTimeout;

  public static final String SERIALIZED_NAME_SYSCTL = "sysctl";
  @SerializedName(SERIALIZED_NAME_SYSCTL)
  private Map<String, String> sysctl = null;

  public static final String SERIALIZED_NAME_SYSTEMD = "systemd";
  @SerializedName(SERIALIZED_NAME_SYSTEMD)
  private String systemd;

  public static final String SERIALIZED_NAME_TERMINAL = "terminal";
  @SerializedName(SERIALIZED_NAME_TERMINAL)
  private Boolean terminal;

  public static final String SERIALIZED_NAME_TIMEOUT = "timeout";
  @SerializedName(SERIALIZED_NAME_TIMEOUT)
  private Integer timeout;

  public static final String SERIALIZED_NAME_TIMEZONE = "timezone";
  @SerializedName(SERIALIZED_NAME_TIMEZONE)
  private String timezone;

  public static final String SERIALIZED_NAME_UNSETENV = "unsetenv";
  @SerializedName(SERIALIZED_NAME_UNSETENV)
  private List<String> unsetenv = null;

  public static final String SERIALIZED_NAME_UNSETENVALL = "unsetenvall";
  @SerializedName(SERIALIZED_NAME_UNSETENVALL)
  private Boolean unsetenvall;

  public static final String SERIALIZED_NAME_UTSNS = "utsns";
  @SerializedName(SERIALIZED_NAME_UTSNS)
  private Namespace utsns;

  public ContainerBasicConfig() {
  }

  public ContainerBasicConfig annotations(Map<String, String> annotations) {
    
    this.annotations = annotations;
    return this;
  }

  public ContainerBasicConfig putAnnotationsItem(String key, String annotationsItem) {
    if (this.annotations == null) {
      this.annotations = new HashMap<>();
    }
    this.annotations.put(key, annotationsItem);
    return this;
  }

   /**
   * Annotations are key-value options passed into the container runtime that can be used to trigger special behavior. Optional.
   * @return annotations
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Annotations are key-value options passed into the container runtime that can be used to trigger special behavior. Optional.")

  public Map<String, String> getAnnotations() {
    return annotations;
  }


  public void setAnnotations(Map<String, String> annotations) {
    this.annotations = annotations;
  }


  public ContainerBasicConfig command(List<String> command) {
    
    this.command = command;
    return this;
  }

  public ContainerBasicConfig addCommandItem(String commandItem) {
    if (this.command == null) {
      this.command = new ArrayList<>();
    }
    this.command.add(commandItem);
    return this;
  }

   /**
   * Command is the container&#39;s command. If not given and Image is specified, this will be populated by the image&#39;s configuration. Optional.
   * @return command
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Command is the container's command. If not given and Image is specified, this will be populated by the image's configuration. Optional.")

  public List<String> getCommand() {
    return command;
  }


  public void setCommand(List<String> command) {
    this.command = command;
  }


  public ContainerBasicConfig conmonPidFile(String conmonPidFile) {
    
    this.conmonPidFile = conmonPidFile;
    return this;
  }

   /**
   * ConmonPidFile is a path at which a PID file for Conmon will be placed. If not given, a default location will be used. Optional.
   * @return conmonPidFile
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "ConmonPidFile is a path at which a PID file for Conmon will be placed. If not given, a default location will be used. Optional.")

  public String getConmonPidFile() {
    return conmonPidFile;
  }


  public void setConmonPidFile(String conmonPidFile) {
    this.conmonPidFile = conmonPidFile;
  }


  public ContainerBasicConfig containerCreateCommand(List<String> containerCreateCommand) {
    
    this.containerCreateCommand = containerCreateCommand;
    return this;
  }

  public ContainerBasicConfig addContainerCreateCommandItem(String containerCreateCommandItem) {
    if (this.containerCreateCommand == null) {
      this.containerCreateCommand = new ArrayList<>();
    }
    this.containerCreateCommand.add(containerCreateCommandItem);
    return this;
  }

   /**
   * ContainerCreateCommand is the command that was used to create this container. This will be shown in the output of Inspect() on the container, and may also be used by some tools that wish to recreate the container (e.g. &#x60;podman generate systemd --new&#x60;). Optional.
   * @return containerCreateCommand
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "ContainerCreateCommand is the command that was used to create this container. This will be shown in the output of Inspect() on the container, and may also be used by some tools that wish to recreate the container (e.g. `podman generate systemd --new`). Optional.")

  public List<String> getContainerCreateCommand() {
    return containerCreateCommand;
  }


  public void setContainerCreateCommand(List<String> containerCreateCommand) {
    this.containerCreateCommand = containerCreateCommand;
  }


  public ContainerBasicConfig dependencyContainers(List<String> dependencyContainers) {
    
    this.dependencyContainers = dependencyContainers;
    return this;
  }

  public ContainerBasicConfig addDependencyContainersItem(String dependencyContainersItem) {
    if (this.dependencyContainers == null) {
      this.dependencyContainers = new ArrayList<>();
    }
    this.dependencyContainers.add(dependencyContainersItem);
    return this;
  }

   /**
   * DependencyContainers is an array of containers this container depends on. Dependency containers must be started before this container. Dependencies can be specified by name or full/partial ID. Optional.
   * @return dependencyContainers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "DependencyContainers is an array of containers this container depends on. Dependency containers must be started before this container. Dependencies can be specified by name or full/partial ID. Optional.")

  public List<String> getDependencyContainers() {
    return dependencyContainers;
  }


  public void setDependencyContainers(List<String> dependencyContainers) {
    this.dependencyContainers = dependencyContainers;
  }


  public ContainerBasicConfig entrypoint(List<String> entrypoint) {
    
    this.entrypoint = entrypoint;
    return this;
  }

  public ContainerBasicConfig addEntrypointItem(String entrypointItem) {
    if (this.entrypoint == null) {
      this.entrypoint = new ArrayList<>();
    }
    this.entrypoint.add(entrypointItem);
    return this;
  }

   /**
   * Entrypoint is the container&#39;s entrypoint. If not given and Image is specified, this will be populated by the image&#39;s configuration. Optional.
   * @return entrypoint
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Entrypoint is the container's entrypoint. If not given and Image is specified, this will be populated by the image's configuration. Optional.")

  public List<String> getEntrypoint() {
    return entrypoint;
  }


  public void setEntrypoint(List<String> entrypoint) {
    this.entrypoint = entrypoint;
  }


  public ContainerBasicConfig env(Map<String, String> env) {
    
    this.env = env;
    return this;
  }

  public ContainerBasicConfig putEnvItem(String key, String envItem) {
    if (this.env == null) {
      this.env = new HashMap<>();
    }
    this.env.put(key, envItem);
    return this;
  }

   /**
   * Env is a set of environment variables that will be set in the container. Optional.
   * @return env
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Env is a set of environment variables that will be set in the container. Optional.")

  public Map<String, String> getEnv() {
    return env;
  }


  public void setEnv(Map<String, String> env) {
    this.env = env;
  }


  public ContainerBasicConfig envHost(Boolean envHost) {
    
    this.envHost = envHost;
    return this;
  }

   /**
   * EnvHost indicates that the host environment should be added to container Optional.
   * @return envHost
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "EnvHost indicates that the host environment should be added to container Optional.")

  public Boolean getEnvHost() {
    return envHost;
  }


  public void setEnvHost(Boolean envHost) {
    this.envHost = envHost;
  }


  public ContainerBasicConfig envmerge(List<String> envmerge) {
    
    this.envmerge = envmerge;
    return this;
  }

  public ContainerBasicConfig addEnvmergeItem(String envmergeItem) {
    if (this.envmerge == null) {
      this.envmerge = new ArrayList<>();
    }
    this.envmerge.add(envmergeItem);
    return this;
  }

   /**
   * EnvMerge takes the specified environment variables from image and preprocess them before injecting them into the container. Optional.
   * @return envmerge
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "EnvMerge takes the specified environment variables from image and preprocess them before injecting them into the container. Optional.")

  public List<String> getEnvmerge() {
    return envmerge;
  }


  public void setEnvmerge(List<String> envmerge) {
    this.envmerge = envmerge;
  }


  public ContainerBasicConfig groupEntry(String groupEntry) {
    
    this.groupEntry = groupEntry;
    return this;
  }

   /**
   * GroupEntry specifies an arbitrary string to append to the container&#39;s /etc/group file. Optional.
   * @return groupEntry
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "GroupEntry specifies an arbitrary string to append to the container's /etc/group file. Optional.")

  public String getGroupEntry() {
    return groupEntry;
  }


  public void setGroupEntry(String groupEntry) {
    this.groupEntry = groupEntry;
  }


  public ContainerBasicConfig hostname(String hostname) {
    
    this.hostname = hostname;
    return this;
  }

   /**
   * Hostname is the container&#39;s hostname. If not set, the hostname will not be modified (if UtsNS is not private) or will be set to the container ID (if UtsNS is private). Conflicts with UtsNS if UtsNS is not set to private. Optional.
   * @return hostname
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Hostname is the container's hostname. If not set, the hostname will not be modified (if UtsNS is not private) or will be set to the container ID (if UtsNS is private). Conflicts with UtsNS if UtsNS is not set to private. Optional.")

  public String getHostname() {
    return hostname;
  }


  public void setHostname(String hostname) {
    this.hostname = hostname;
  }


  public ContainerBasicConfig hostusers(List<String> hostusers) {
    
    this.hostusers = hostusers;
    return this;
  }

  public ContainerBasicConfig addHostusersItem(String hostusersItem) {
    if (this.hostusers == null) {
      this.hostusers = new ArrayList<>();
    }
    this.hostusers.add(hostusersItem);
    return this;
  }

   /**
   * HostUsers is a list of host usernames or UIDs to add to the container etc/passwd file
   * @return hostusers
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "HostUsers is a list of host usernames or UIDs to add to the container etc/passwd file")

  public List<String> getHostusers() {
    return hostusers;
  }


  public void setHostusers(List<String> hostusers) {
    this.hostusers = hostusers;
  }


  public ContainerBasicConfig httpproxy(Boolean httpproxy) {
    
    this.httpproxy = httpproxy;
    return this;
  }

   /**
   * EnvHTTPProxy indicates that the http host proxy environment variables should be added to container Optional.
   * @return httpproxy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "EnvHTTPProxy indicates that the http host proxy environment variables should be added to container Optional.")

  public Boolean getHttpproxy() {
    return httpproxy;
  }


  public void setHttpproxy(Boolean httpproxy) {
    this.httpproxy = httpproxy;
  }


  public ContainerBasicConfig initContainerType(String initContainerType) {
    
    this.initContainerType = initContainerType;
    return this;
  }

   /**
   * InitContainerType describes if this container is an init container and if so, what type: always or once. Optional.
   * @return initContainerType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "InitContainerType describes if this container is an init container and if so, what type: always or once. Optional.")

  public String getInitContainerType() {
    return initContainerType;
  }


  public void setInitContainerType(String initContainerType) {
    this.initContainerType = initContainerType;
  }


  public ContainerBasicConfig labels(Map<String, String> labels) {
    
    this.labels = labels;
    return this;
  }

  public ContainerBasicConfig putLabelsItem(String key, String labelsItem) {
    if (this.labels == null) {
      this.labels = new HashMap<>();
    }
    this.labels.put(key, labelsItem);
    return this;
  }

   /**
   * Labels are key-value pairs that are used to add metadata to containers. Optional.
   * @return labels
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Labels are key-value pairs that are used to add metadata to containers. Optional.")

  public Map<String, String> getLabels() {
    return labels;
  }


  public void setLabels(Map<String, String> labels) {
    this.labels = labels;
  }


  public ContainerBasicConfig logConfiguration(LogConfigLibpod logConfiguration) {
    
    this.logConfiguration = logConfiguration;
    return this;
  }

   /**
   * Get logConfiguration
   * @return logConfiguration
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public LogConfigLibpod getLogConfiguration() {
    return logConfiguration;
  }


  public void setLogConfiguration(LogConfigLibpod logConfiguration) {
    this.logConfiguration = logConfiguration;
  }


  public ContainerBasicConfig managePassword(Boolean managePassword) {
    
    this.managePassword = managePassword;
    return this;
  }

   /**
   * Passwd is a container run option that determines if we are validating users/groups before running the container
   * @return managePassword
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Passwd is a container run option that determines if we are validating users/groups before running the container")

  public Boolean getManagePassword() {
    return managePassword;
  }


  public void setManagePassword(Boolean managePassword) {
    this.managePassword = managePassword;
  }


  public ContainerBasicConfig name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * Name is the name the container will be given. If no name is provided, one will be randomly generated. Optional.
   * @return name
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Name is the name the container will be given. If no name is provided, one will be randomly generated. Optional.")

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public ContainerBasicConfig ociRuntime(String ociRuntime) {
    
    this.ociRuntime = ociRuntime;
    return this;
  }

   /**
   * OCIRuntime is the name of the OCI runtime that will be used to create the container. If not specified, the default will be used. Optional.
   * @return ociRuntime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "OCIRuntime is the name of the OCI runtime that will be used to create the container. If not specified, the default will be used. Optional.")

  public String getOciRuntime() {
    return ociRuntime;
  }


  public void setOciRuntime(String ociRuntime) {
    this.ociRuntime = ociRuntime;
  }


  public ContainerBasicConfig passwdEntry(String passwdEntry) {
    
    this.passwdEntry = passwdEntry;
    return this;
  }

   /**
   * PasswdEntry specifies an arbitrary string to append to the container&#39;s /etc/passwd file. Optional.
   * @return passwdEntry
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "PasswdEntry specifies an arbitrary string to append to the container's /etc/passwd file. Optional.")

  public String getPasswdEntry() {
    return passwdEntry;
  }


  public void setPasswdEntry(String passwdEntry) {
    this.passwdEntry = passwdEntry;
  }


  public ContainerBasicConfig personality(LinuxPersonality personality) {
    
    this.personality = personality;
    return this;
  }

   /**
   * Get personality
   * @return personality
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public LinuxPersonality getPersonality() {
    return personality;
  }


  public void setPersonality(LinuxPersonality personality) {
    this.personality = personality;
  }


  public ContainerBasicConfig pidns(Namespace pidns) {
    
    this.pidns = pidns;
    return this;
  }

   /**
   * Get pidns
   * @return pidns
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public Namespace getPidns() {
    return pidns;
  }


  public void setPidns(Namespace pidns) {
    this.pidns = pidns;
  }


  public ContainerBasicConfig pod(String pod) {
    
    this.pod = pod;
    return this;
  }

   /**
   * Pod is the ID of the pod the container will join. Optional.
   * @return pod
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Pod is the ID of the pod the container will join. Optional.")

  public String getPod() {
    return pod;
  }


  public void setPod(String pod) {
    this.pod = pod;
  }


  public ContainerBasicConfig remove(Boolean remove) {
    
    this.remove = remove;
    return this;
  }

   /**
   * Remove indicates if the container should be removed once it has been started and exits. Optional.
   * @return remove
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Remove indicates if the container should be removed once it has been started and exits. Optional.")

  public Boolean getRemove() {
    return remove;
  }


  public void setRemove(Boolean remove) {
    this.remove = remove;
  }


  public ContainerBasicConfig removeImage(Boolean removeImage) {
    
    this.removeImage = removeImage;
    return this;
  }

   /**
   * RemoveImage indicates that the container should remove the image it was created from after it exits. Only allowed if Remove is set to true and Image, not Rootfs, is in use. Optional.
   * @return removeImage
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "RemoveImage indicates that the container should remove the image it was created from after it exits. Only allowed if Remove is set to true and Image, not Rootfs, is in use. Optional.")

  public Boolean getRemoveImage() {
    return removeImage;
  }


  public void setRemoveImage(Boolean removeImage) {
    this.removeImage = removeImage;
  }


  public ContainerBasicConfig restartPolicy(String restartPolicy) {
    
    this.restartPolicy = restartPolicy;
    return this;
  }

   /**
   * RestartPolicy is the container&#39;s restart policy - an action which will be taken when the container exits. If not given, the default policy, which does nothing, will be used. Optional.
   * @return restartPolicy
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "RestartPolicy is the container's restart policy - an action which will be taken when the container exits. If not given, the default policy, which does nothing, will be used. Optional.")

  public String getRestartPolicy() {
    return restartPolicy;
  }


  public void setRestartPolicy(String restartPolicy) {
    this.restartPolicy = restartPolicy;
  }


  public ContainerBasicConfig restartTries(Integer restartTries) {
    
    this.restartTries = restartTries;
    return this;
  }

   /**
   * RestartRetries is the number of attempts that will be made to restart the container. Only available when RestartPolicy is set to \&quot;on-failure\&quot;. Optional.
   * @return restartTries
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "RestartRetries is the number of attempts that will be made to restart the container. Only available when RestartPolicy is set to \"on-failure\". Optional.")

  public Integer getRestartTries() {
    return restartTries;
  }


  public void setRestartTries(Integer restartTries) {
    this.restartTries = restartTries;
  }


  public ContainerBasicConfig sdnotifyMode(String sdnotifyMode) {
    
    this.sdnotifyMode = sdnotifyMode;
    return this;
  }

   /**
   * Determine how to handle the NOTIFY_SOCKET - do we participate or pass it through \&quot;container\&quot; - let the OCI runtime deal with it, advertise conmon&#39;s MAINPID \&quot;conmon-only\&quot; - advertise conmon&#39;s MAINPID, send READY when started, don&#39;t pass to OCI \&quot;ignore\&quot; - unset NOTIFY_SOCKET Optional.
   * @return sdnotifyMode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Determine how to handle the NOTIFY_SOCKET - do we participate or pass it through \"container\" - let the OCI runtime deal with it, advertise conmon's MAINPID \"conmon-only\" - advertise conmon's MAINPID, send READY when started, don't pass to OCI \"ignore\" - unset NOTIFY_SOCKET Optional.")

  public String getSdnotifyMode() {
    return sdnotifyMode;
  }


  public void setSdnotifyMode(String sdnotifyMode) {
    this.sdnotifyMode = sdnotifyMode;
  }


  public ContainerBasicConfig secretEnv(Map<String, String> secretEnv) {
    
    this.secretEnv = secretEnv;
    return this;
  }

  public ContainerBasicConfig putSecretEnvItem(String key, String secretEnvItem) {
    if (this.secretEnv == null) {
      this.secretEnv = new HashMap<>();
    }
    this.secretEnv.put(key, secretEnvItem);
    return this;
  }

   /**
   * EnvSecrets are secrets that will be set as environment variables Optional.
   * @return secretEnv
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "EnvSecrets are secrets that will be set as environment variables Optional.")

  public Map<String, String> getSecretEnv() {
    return secretEnv;
  }


  public void setSecretEnv(Map<String, String> secretEnv) {
    this.secretEnv = secretEnv;
  }


  public ContainerBasicConfig stdin(Boolean stdin) {
    
    this.stdin = stdin;
    return this;
  }

   /**
   * Stdin is whether the container will keep its STDIN open. Optional.
   * @return stdin
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Stdin is whether the container will keep its STDIN open. Optional.")

  public Boolean getStdin() {
    return stdin;
  }


  public void setStdin(Boolean stdin) {
    this.stdin = stdin;
  }


  public ContainerBasicConfig stopSignal(Long stopSignal) {
    
    this.stopSignal = stopSignal;
    return this;
  }

   /**
   * It implements the [os.Signal] interface.
   * @return stopSignal
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "It implements the [os.Signal] interface.")

  public Long getStopSignal() {
    return stopSignal;
  }


  public void setStopSignal(Long stopSignal) {
    this.stopSignal = stopSignal;
  }


  public ContainerBasicConfig stopTimeout(Integer stopTimeout) {
    
    this.stopTimeout = stopTimeout;
    return this;
  }

   /**
   * StopTimeout is a timeout between the container&#39;s stop signal being sent and SIGKILL being sent. If not provided, the default will be used. If 0 is used, stop signal will not be sent, and SIGKILL will be sent instead. Optional.
   * @return stopTimeout
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "StopTimeout is a timeout between the container's stop signal being sent and SIGKILL being sent. If not provided, the default will be used. If 0 is used, stop signal will not be sent, and SIGKILL will be sent instead. Optional.")

  public Integer getStopTimeout() {
    return stopTimeout;
  }


  public void setStopTimeout(Integer stopTimeout) {
    this.stopTimeout = stopTimeout;
  }


  public ContainerBasicConfig sysctl(Map<String, String> sysctl) {
    
    this.sysctl = sysctl;
    return this;
  }

  public ContainerBasicConfig putSysctlItem(String key, String sysctlItem) {
    if (this.sysctl == null) {
      this.sysctl = new HashMap<>();
    }
    this.sysctl.put(key, sysctlItem);
    return this;
  }

   /**
   * Sysctl sets kernel parameters for the container
   * @return sysctl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Sysctl sets kernel parameters for the container")

  public Map<String, String> getSysctl() {
    return sysctl;
  }


  public void setSysctl(Map<String, String> sysctl) {
    this.sysctl = sysctl;
  }


  public ContainerBasicConfig systemd(String systemd) {
    
    this.systemd = systemd;
    return this;
  }

   /**
   * Systemd is whether the container will be started in systemd mode. Valid options are \&quot;true\&quot;, \&quot;false\&quot;, and \&quot;always\&quot;. \&quot;true\&quot; enables this mode only if the binary run in the container is sbin/init or systemd. \&quot;always\&quot; unconditionally enables systemd mode. \&quot;false\&quot; unconditionally disables systemd mode. If enabled, mounts and stop signal will be modified. If set to \&quot;always\&quot; or set to \&quot;true\&quot; and conditionally triggered, conflicts with StopSignal. If not specified, \&quot;false\&quot; will be assumed. Optional.
   * @return systemd
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Systemd is whether the container will be started in systemd mode. Valid options are \"true\", \"false\", and \"always\". \"true\" enables this mode only if the binary run in the container is sbin/init or systemd. \"always\" unconditionally enables systemd mode. \"false\" unconditionally disables systemd mode. If enabled, mounts and stop signal will be modified. If set to \"always\" or set to \"true\" and conditionally triggered, conflicts with StopSignal. If not specified, \"false\" will be assumed. Optional.")

  public String getSystemd() {
    return systemd;
  }


  public void setSystemd(String systemd) {
    this.systemd = systemd;
  }


  public ContainerBasicConfig terminal(Boolean terminal) {
    
    this.terminal = terminal;
    return this;
  }

   /**
   * Terminal is whether the container will create a PTY. Optional.
   * @return terminal
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Terminal is whether the container will create a PTY. Optional.")

  public Boolean getTerminal() {
    return terminal;
  }


  public void setTerminal(Boolean terminal) {
    this.terminal = terminal;
  }


  public ContainerBasicConfig timeout(Integer timeout) {
    
    this.timeout = timeout;
    return this;
  }

   /**
   * Timeout is a maximum time in seconds the container will run before main process is sent SIGKILL. If 0 is used, signal will not be sent. Container can run indefinitely if they do not stop after the default termination signal. Optional.
   * @return timeout
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Timeout is a maximum time in seconds the container will run before main process is sent SIGKILL. If 0 is used, signal will not be sent. Container can run indefinitely if they do not stop after the default termination signal. Optional.")

  public Integer getTimeout() {
    return timeout;
  }


  public void setTimeout(Integer timeout) {
    this.timeout = timeout;
  }


  public ContainerBasicConfig timezone(String timezone) {
    
    this.timezone = timezone;
    return this;
  }

   /**
   * Timezone is the timezone inside the container. Local means it has the same timezone as the host machine Optional.
   * @return timezone
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Timezone is the timezone inside the container. Local means it has the same timezone as the host machine Optional.")

  public String getTimezone() {
    return timezone;
  }


  public void setTimezone(String timezone) {
    this.timezone = timezone;
  }


  public ContainerBasicConfig unsetenv(List<String> unsetenv) {
    
    this.unsetenv = unsetenv;
    return this;
  }

  public ContainerBasicConfig addUnsetenvItem(String unsetenvItem) {
    if (this.unsetenv == null) {
      this.unsetenv = new ArrayList<>();
    }
    this.unsetenv.add(unsetenvItem);
    return this;
  }

   /**
   * UnsetEnv unsets the specified default environment variables from the image or from built-in or containers.conf Optional.
   * @return unsetenv
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "UnsetEnv unsets the specified default environment variables from the image or from built-in or containers.conf Optional.")

  public List<String> getUnsetenv() {
    return unsetenv;
  }


  public void setUnsetenv(List<String> unsetenv) {
    this.unsetenv = unsetenv;
  }


  public ContainerBasicConfig unsetenvall(Boolean unsetenvall) {
    
    this.unsetenvall = unsetenvall;
    return this;
  }

   /**
   * UnsetEnvAll unsetall default environment variables from the image or from built-in or containers.conf UnsetEnvAll unsets all default environment variables from the image or from built-in Optional.
   * @return unsetenvall
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "UnsetEnvAll unsetall default environment variables from the image or from built-in or containers.conf UnsetEnvAll unsets all default environment variables from the image or from built-in Optional.")

  public Boolean getUnsetenvall() {
    return unsetenvall;
  }


  public void setUnsetenvall(Boolean unsetenvall) {
    this.unsetenvall = unsetenvall;
  }


  public ContainerBasicConfig utsns(Namespace utsns) {
    
    this.utsns = utsns;
    return this;
  }

   /**
   * Get utsns
   * @return utsns
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public Namespace getUtsns() {
    return utsns;
  }


  public void setUtsns(Namespace utsns) {
    this.utsns = utsns;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ContainerBasicConfig containerBasicConfig = (ContainerBasicConfig) o;
    return Objects.equals(this.annotations, containerBasicConfig.annotations) &&
        Objects.equals(this.command, containerBasicConfig.command) &&
        Objects.equals(this.conmonPidFile, containerBasicConfig.conmonPidFile) &&
        Objects.equals(this.containerCreateCommand, containerBasicConfig.containerCreateCommand) &&
        Objects.equals(this.dependencyContainers, containerBasicConfig.dependencyContainers) &&
        Objects.equals(this.entrypoint, containerBasicConfig.entrypoint) &&
        Objects.equals(this.env, containerBasicConfig.env) &&
        Objects.equals(this.envHost, containerBasicConfig.envHost) &&
        Objects.equals(this.envmerge, containerBasicConfig.envmerge) &&
        Objects.equals(this.groupEntry, containerBasicConfig.groupEntry) &&
        Objects.equals(this.hostname, containerBasicConfig.hostname) &&
        Objects.equals(this.hostusers, containerBasicConfig.hostusers) &&
        Objects.equals(this.httpproxy, containerBasicConfig.httpproxy) &&
        Objects.equals(this.initContainerType, containerBasicConfig.initContainerType) &&
        Objects.equals(this.labels, containerBasicConfig.labels) &&
        Objects.equals(this.logConfiguration, containerBasicConfig.logConfiguration) &&
        Objects.equals(this.managePassword, containerBasicConfig.managePassword) &&
        Objects.equals(this.name, containerBasicConfig.name) &&
        Objects.equals(this.ociRuntime, containerBasicConfig.ociRuntime) &&
        Objects.equals(this.passwdEntry, containerBasicConfig.passwdEntry) &&
        Objects.equals(this.personality, containerBasicConfig.personality) &&
        Objects.equals(this.pidns, containerBasicConfig.pidns) &&
        Objects.equals(this.pod, containerBasicConfig.pod) &&
        Objects.equals(this.remove, containerBasicConfig.remove) &&
        Objects.equals(this.removeImage, containerBasicConfig.removeImage) &&
        Objects.equals(this.restartPolicy, containerBasicConfig.restartPolicy) &&
        Objects.equals(this.restartTries, containerBasicConfig.restartTries) &&
        Objects.equals(this.sdnotifyMode, containerBasicConfig.sdnotifyMode) &&
        Objects.equals(this.secretEnv, containerBasicConfig.secretEnv) &&
        Objects.equals(this.stdin, containerBasicConfig.stdin) &&
        Objects.equals(this.stopSignal, containerBasicConfig.stopSignal) &&
        Objects.equals(this.stopTimeout, containerBasicConfig.stopTimeout) &&
        Objects.equals(this.sysctl, containerBasicConfig.sysctl) &&
        Objects.equals(this.systemd, containerBasicConfig.systemd) &&
        Objects.equals(this.terminal, containerBasicConfig.terminal) &&
        Objects.equals(this.timeout, containerBasicConfig.timeout) &&
        Objects.equals(this.timezone, containerBasicConfig.timezone) &&
        Objects.equals(this.unsetenv, containerBasicConfig.unsetenv) &&
        Objects.equals(this.unsetenvall, containerBasicConfig.unsetenvall) &&
        Objects.equals(this.utsns, containerBasicConfig.utsns);
  }

  @Override
  public int hashCode() {
    return Objects.hash(annotations, command, conmonPidFile, containerCreateCommand, dependencyContainers, entrypoint, env, envHost, envmerge, groupEntry, hostname, hostusers, httpproxy, initContainerType, labels, logConfiguration, managePassword, name, ociRuntime, passwdEntry, personality, pidns, pod, remove, removeImage, restartPolicy, restartTries, sdnotifyMode, secretEnv, stdin, stopSignal, stopTimeout, sysctl, systemd, terminal, timeout, timezone, unsetenv, unsetenvall, utsns);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ContainerBasicConfig {\n");
    sb.append("    annotations: ").append(toIndentedString(annotations)).append("\n");
    sb.append("    command: ").append(toIndentedString(command)).append("\n");
    sb.append("    conmonPidFile: ").append(toIndentedString(conmonPidFile)).append("\n");
    sb.append("    containerCreateCommand: ").append(toIndentedString(containerCreateCommand)).append("\n");
    sb.append("    dependencyContainers: ").append(toIndentedString(dependencyContainers)).append("\n");
    sb.append("    entrypoint: ").append(toIndentedString(entrypoint)).append("\n");
    sb.append("    env: ").append(toIndentedString(env)).append("\n");
    sb.append("    envHost: ").append(toIndentedString(envHost)).append("\n");
    sb.append("    envmerge: ").append(toIndentedString(envmerge)).append("\n");
    sb.append("    groupEntry: ").append(toIndentedString(groupEntry)).append("\n");
    sb.append("    hostname: ").append(toIndentedString(hostname)).append("\n");
    sb.append("    hostusers: ").append(toIndentedString(hostusers)).append("\n");
    sb.append("    httpproxy: ").append(toIndentedString(httpproxy)).append("\n");
    sb.append("    initContainerType: ").append(toIndentedString(initContainerType)).append("\n");
    sb.append("    labels: ").append(toIndentedString(labels)).append("\n");
    sb.append("    logConfiguration: ").append(toIndentedString(logConfiguration)).append("\n");
    sb.append("    managePassword: ").append(toIndentedString(managePassword)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    ociRuntime: ").append(toIndentedString(ociRuntime)).append("\n");
    sb.append("    passwdEntry: ").append(toIndentedString(passwdEntry)).append("\n");
    sb.append("    personality: ").append(toIndentedString(personality)).append("\n");
    sb.append("    pidns: ").append(toIndentedString(pidns)).append("\n");
    sb.append("    pod: ").append(toIndentedString(pod)).append("\n");
    sb.append("    remove: ").append(toIndentedString(remove)).append("\n");
    sb.append("    removeImage: ").append(toIndentedString(removeImage)).append("\n");
    sb.append("    restartPolicy: ").append(toIndentedString(restartPolicy)).append("\n");
    sb.append("    restartTries: ").append(toIndentedString(restartTries)).append("\n");
    sb.append("    sdnotifyMode: ").append(toIndentedString(sdnotifyMode)).append("\n");
    sb.append("    secretEnv: ").append(toIndentedString(secretEnv)).append("\n");
    sb.append("    stdin: ").append(toIndentedString(stdin)).append("\n");
    sb.append("    stopSignal: ").append(toIndentedString(stopSignal)).append("\n");
    sb.append("    stopTimeout: ").append(toIndentedString(stopTimeout)).append("\n");
    sb.append("    sysctl: ").append(toIndentedString(sysctl)).append("\n");
    sb.append("    systemd: ").append(toIndentedString(systemd)).append("\n");
    sb.append("    terminal: ").append(toIndentedString(terminal)).append("\n");
    sb.append("    timeout: ").append(toIndentedString(timeout)).append("\n");
    sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
    sb.append("    unsetenv: ").append(toIndentedString(unsetenv)).append("\n");
    sb.append("    unsetenvall: ").append(toIndentedString(unsetenvall)).append("\n");
    sb.append("    utsns: ").append(toIndentedString(utsns)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("annotations");
    openapiFields.add("command");
    openapiFields.add("conmon_pid_file");
    openapiFields.add("containerCreateCommand");
    openapiFields.add("dependencyContainers");
    openapiFields.add("entrypoint");
    openapiFields.add("env");
    openapiFields.add("env_host");
    openapiFields.add("envmerge");
    openapiFields.add("group_entry");
    openapiFields.add("hostname");
    openapiFields.add("hostusers");
    openapiFields.add("httpproxy");
    openapiFields.add("init_container_type");
    openapiFields.add("labels");
    openapiFields.add("log_configuration");
    openapiFields.add("manage_password");
    openapiFields.add("name");
    openapiFields.add("oci_runtime");
    openapiFields.add("passwd_entry");
    openapiFields.add("personality");
    openapiFields.add("pidns");
    openapiFields.add("pod");
    openapiFields.add("remove");
    openapiFields.add("removeImage");
    openapiFields.add("restart_policy");
    openapiFields.add("restart_tries");
    openapiFields.add("sdnotifyMode");
    openapiFields.add("secret_env");
    openapiFields.add("stdin");
    openapiFields.add("stop_signal");
    openapiFields.add("stop_timeout");
    openapiFields.add("sysctl");
    openapiFields.add("systemd");
    openapiFields.add("terminal");
    openapiFields.add("timeout");
    openapiFields.add("timezone");
    openapiFields.add("unsetenv");
    openapiFields.add("unsetenvall");
    openapiFields.add("utsns");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to ContainerBasicConfig
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (ContainerBasicConfig.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in ContainerBasicConfig is not found in the empty JSON string", ContainerBasicConfig.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!ContainerBasicConfig.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ContainerBasicConfig` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      // ensure the json data is an array
      if ((jsonObj.get("command") != null && !jsonObj.get("command").isJsonNull()) && !jsonObj.get("command").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `command` to be an array in the JSON string but got `%s`", jsonObj.get("command").toString()));
      }
      if ((jsonObj.get("conmon_pid_file") != null && !jsonObj.get("conmon_pid_file").isJsonNull()) && !jsonObj.get("conmon_pid_file").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `conmon_pid_file` to be a primitive type in the JSON string but got `%s`", jsonObj.get("conmon_pid_file").toString()));
      }
      // ensure the json data is an array
      if ((jsonObj.get("containerCreateCommand") != null && !jsonObj.get("containerCreateCommand").isJsonNull()) && !jsonObj.get("containerCreateCommand").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `containerCreateCommand` to be an array in the JSON string but got `%s`", jsonObj.get("containerCreateCommand").toString()));
      }
      // ensure the json data is an array
      if ((jsonObj.get("dependencyContainers") != null && !jsonObj.get("dependencyContainers").isJsonNull()) && !jsonObj.get("dependencyContainers").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `dependencyContainers` to be an array in the JSON string but got `%s`", jsonObj.get("dependencyContainers").toString()));
      }
      // ensure the json data is an array
      if ((jsonObj.get("entrypoint") != null && !jsonObj.get("entrypoint").isJsonNull()) && !jsonObj.get("entrypoint").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `entrypoint` to be an array in the JSON string but got `%s`", jsonObj.get("entrypoint").toString()));
      }
      // ensure the json data is an array
      if ((jsonObj.get("envmerge") != null && !jsonObj.get("envmerge").isJsonNull()) && !jsonObj.get("envmerge").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `envmerge` to be an array in the JSON string but got `%s`", jsonObj.get("envmerge").toString()));
      }
      if ((jsonObj.get("group_entry") != null && !jsonObj.get("group_entry").isJsonNull()) && !jsonObj.get("group_entry").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `group_entry` to be a primitive type in the JSON string but got `%s`", jsonObj.get("group_entry").toString()));
      }
      if ((jsonObj.get("hostname") != null && !jsonObj.get("hostname").isJsonNull()) && !jsonObj.get("hostname").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `hostname` to be a primitive type in the JSON string but got `%s`", jsonObj.get("hostname").toString()));
      }
      // ensure the json data is an array
      if ((jsonObj.get("hostusers") != null && !jsonObj.get("hostusers").isJsonNull()) && !jsonObj.get("hostusers").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `hostusers` to be an array in the JSON string but got `%s`", jsonObj.get("hostusers").toString()));
      }
      if ((jsonObj.get("init_container_type") != null && !jsonObj.get("init_container_type").isJsonNull()) && !jsonObj.get("init_container_type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `init_container_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("init_container_type").toString()));
      }
      // validate the optional field `log_configuration`
      if (jsonObj.get("log_configuration") != null && !jsonObj.get("log_configuration").isJsonNull()) {
        LogConfigLibpod.validateJsonObject(jsonObj.getAsJsonObject("log_configuration"));
      }
      if ((jsonObj.get("name") != null && !jsonObj.get("name").isJsonNull()) && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      if ((jsonObj.get("oci_runtime") != null && !jsonObj.get("oci_runtime").isJsonNull()) && !jsonObj.get("oci_runtime").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `oci_runtime` to be a primitive type in the JSON string but got `%s`", jsonObj.get("oci_runtime").toString()));
      }
      if ((jsonObj.get("passwd_entry") != null && !jsonObj.get("passwd_entry").isJsonNull()) && !jsonObj.get("passwd_entry").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `passwd_entry` to be a primitive type in the JSON string but got `%s`", jsonObj.get("passwd_entry").toString()));
      }
      // validate the optional field `personality`
      if (jsonObj.get("personality") != null && !jsonObj.get("personality").isJsonNull()) {
        LinuxPersonality.validateJsonObject(jsonObj.getAsJsonObject("personality"));
      }
      // validate the optional field `pidns`
      if (jsonObj.get("pidns") != null && !jsonObj.get("pidns").isJsonNull()) {
        Namespace.validateJsonObject(jsonObj.getAsJsonObject("pidns"));
      }
      if ((jsonObj.get("pod") != null && !jsonObj.get("pod").isJsonNull()) && !jsonObj.get("pod").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `pod` to be a primitive type in the JSON string but got `%s`", jsonObj.get("pod").toString()));
      }
      if ((jsonObj.get("restart_policy") != null && !jsonObj.get("restart_policy").isJsonNull()) && !jsonObj.get("restart_policy").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `restart_policy` to be a primitive type in the JSON string but got `%s`", jsonObj.get("restart_policy").toString()));
      }
      if ((jsonObj.get("sdnotifyMode") != null && !jsonObj.get("sdnotifyMode").isJsonNull()) && !jsonObj.get("sdnotifyMode").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `sdnotifyMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get("sdnotifyMode").toString()));
      }
      if ((jsonObj.get("systemd") != null && !jsonObj.get("systemd").isJsonNull()) && !jsonObj.get("systemd").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `systemd` to be a primitive type in the JSON string but got `%s`", jsonObj.get("systemd").toString()));
      }
      if ((jsonObj.get("timezone") != null && !jsonObj.get("timezone").isJsonNull()) && !jsonObj.get("timezone").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `timezone` to be a primitive type in the JSON string but got `%s`", jsonObj.get("timezone").toString()));
      }
      // ensure the json data is an array
      if ((jsonObj.get("unsetenv") != null && !jsonObj.get("unsetenv").isJsonNull()) && !jsonObj.get("unsetenv").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `unsetenv` to be an array in the JSON string but got `%s`", jsonObj.get("unsetenv").toString()));
      }
      // validate the optional field `utsns`
      if (jsonObj.get("utsns") != null && !jsonObj.get("utsns").isJsonNull()) {
        Namespace.validateJsonObject(jsonObj.getAsJsonObject("utsns"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!ContainerBasicConfig.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'ContainerBasicConfig' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<ContainerBasicConfig> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(ContainerBasicConfig.class));

       return (TypeAdapter<T>) new TypeAdapter<ContainerBasicConfig>() {
           @Override
           public void write(JsonWriter out, ContainerBasicConfig value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public ContainerBasicConfig read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of ContainerBasicConfig given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of ContainerBasicConfig
  * @throws IOException if the JSON string is invalid with respect to ContainerBasicConfig
  */
  public static ContainerBasicConfig fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, ContainerBasicConfig.class);
  }

 /**
  * Convert an instance of ContainerBasicConfig to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

