/*
 * supports a RESTful API for the Libpod library
 * This documentation describes the Podman v2.x+ RESTful API. It consists of a Docker-compatible API and a Libpod API providing support for Podman’s unique features such as pods.  To start the service and keep it running for 5,000 seconds (-t 0 runs forever):  podman system service -t 5000 &  You can then use cURL on the socket using requests documented below.  NOTE: if you install the package podman-docker, it will create a symbolic link for /run/docker.sock to /run/podman/podman.sock  NOTE: Some fields in the API response JSON are encoded as omitempty, which means that if said field has a zero value, they will not be encoded in the API response. This is a feature to help reduce the size of the JSON responses returned via the API.  NOTE: Due to the limitations of [go-swagger](https://github.com/go-swagger/go-swagger), some field values that have a complex type show up as null in the docs as well as in the API responses. This is because the zero value for the field type is null. The field description in the docs will state what type the field is expected to be for such cases.  See podman-system-service(1) for more information.  Quick Examples:  'podman info'  curl --unix-socket /run/podman/podman.sock http://d/v5.0.0/libpod/info  'podman pull quay.io/containers/podman'  curl -XPOST --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/images/create?fromImage=quay.io%2Fcontainers%2Fpodman'  'podman list images'  curl --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/libpod/images/json' | jq
 *
 * The version of the OpenAPI document: 5.0.0
 * Contact: podman@lists.podman.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.pod4dev.libpodj.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.model.DeviceMapping;
import io.github.pod4dev.libpodj.model.DeviceRequest;
import io.github.pod4dev.libpodj.model.LogConfig;
import io.github.pod4dev.libpodj.model.Mount;
import io.github.pod4dev.libpodj.model.PortBinding;
import io.github.pod4dev.libpodj.model.RestartPolicy;
import io.github.pod4dev.libpodj.model.ThrottleDevice;
import io.github.pod4dev.libpodj.model.Ulimit;
import io.github.pod4dev.libpodj.model.WeightDevice;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.io.Serializable;
import javax.validation.constraints.*;
import javax.validation.Valid;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import io.github.pod4dev.libpodj.JSON;

/**
 * Here, \&quot;non-portable\&quot; means \&quot;dependent of the host we are running on\&quot;. Portable information *should* appear in Config.
 */
@ApiModel(description = "Here, \"non-portable\" means \"dependent of the host we are running on\". Portable information *should* appear in Config.")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class HostConfig implements Serializable {
  private static final long serialVersionUID = 1L;

  public static final String SERIALIZED_NAME_ANNOTATIONS = "Annotations";
  @SerializedName(SERIALIZED_NAME_ANNOTATIONS)
  private Map<String, String> annotations = null;

  public static final String SERIALIZED_NAME_AUTO_REMOVE = "AutoRemove";
  @SerializedName(SERIALIZED_NAME_AUTO_REMOVE)
  private Boolean autoRemove;

  public static final String SERIALIZED_NAME_BINDS = "Binds";
  @SerializedName(SERIALIZED_NAME_BINDS)
  private List<String> binds = null;

  public static final String SERIALIZED_NAME_BLKIO_DEVICE_READ_BPS = "BlkioDeviceReadBps";
  @SerializedName(SERIALIZED_NAME_BLKIO_DEVICE_READ_BPS)
  private List<ThrottleDevice> blkioDeviceReadBps = null;

  public static final String SERIALIZED_NAME_BLKIO_DEVICE_READ_I_OPS = "BlkioDeviceReadIOps";
  @SerializedName(SERIALIZED_NAME_BLKIO_DEVICE_READ_I_OPS)
  private List<ThrottleDevice> blkioDeviceReadIOps = null;

  public static final String SERIALIZED_NAME_BLKIO_DEVICE_WRITE_BPS = "BlkioDeviceWriteBps";
  @SerializedName(SERIALIZED_NAME_BLKIO_DEVICE_WRITE_BPS)
  private List<ThrottleDevice> blkioDeviceWriteBps = null;

  public static final String SERIALIZED_NAME_BLKIO_DEVICE_WRITE_I_OPS = "BlkioDeviceWriteIOps";
  @SerializedName(SERIALIZED_NAME_BLKIO_DEVICE_WRITE_I_OPS)
  private List<ThrottleDevice> blkioDeviceWriteIOps = null;

  public static final String SERIALIZED_NAME_BLKIO_WEIGHT = "BlkioWeight";
  @SerializedName(SERIALIZED_NAME_BLKIO_WEIGHT)
  private Integer blkioWeight;

  public static final String SERIALIZED_NAME_BLKIO_WEIGHT_DEVICE = "BlkioWeightDevice";
  @SerializedName(SERIALIZED_NAME_BLKIO_WEIGHT_DEVICE)
  private List<WeightDevice> blkioWeightDevice = null;

  public static final String SERIALIZED_NAME_CAP_ADD = "CapAdd";
  @SerializedName(SERIALIZED_NAME_CAP_ADD)
  private List<String> capAdd = null;

  public static final String SERIALIZED_NAME_CAP_DROP = "CapDrop";
  @SerializedName(SERIALIZED_NAME_CAP_DROP)
  private List<String> capDrop = null;

  public static final String SERIALIZED_NAME_CGROUP = "Cgroup";
  @SerializedName(SERIALIZED_NAME_CGROUP)
  private String cgroup;

  public static final String SERIALIZED_NAME_CGROUP_PARENT = "CgroupParent";
  @SerializedName(SERIALIZED_NAME_CGROUP_PARENT)
  private String cgroupParent;

  public static final String SERIALIZED_NAME_CGROUPNS_MODE = "CgroupnsMode";
  @SerializedName(SERIALIZED_NAME_CGROUPNS_MODE)
  private String cgroupnsMode;

  public static final String SERIALIZED_NAME_CONSOLE_SIZE = "ConsoleSize";
  @SerializedName(SERIALIZED_NAME_CONSOLE_SIZE)
  private List<Integer> consoleSize = null;

  public static final String SERIALIZED_NAME_CONTAINER_I_D_FILE = "ContainerIDFile";
  @SerializedName(SERIALIZED_NAME_CONTAINER_I_D_FILE)
  private String containerIDFile;

  public static final String SERIALIZED_NAME_CPU_COUNT = "CpuCount";
  @SerializedName(SERIALIZED_NAME_CPU_COUNT)
  private Long cpuCount;

  public static final String SERIALIZED_NAME_CPU_PERCENT = "CpuPercent";
  @SerializedName(SERIALIZED_NAME_CPU_PERCENT)
  private Long cpuPercent;

  public static final String SERIALIZED_NAME_CPU_PERIOD = "CpuPeriod";
  @SerializedName(SERIALIZED_NAME_CPU_PERIOD)
  private Long cpuPeriod;

  public static final String SERIALIZED_NAME_CPU_QUOTA = "CpuQuota";
  @SerializedName(SERIALIZED_NAME_CPU_QUOTA)
  private Long cpuQuota;

  public static final String SERIALIZED_NAME_CPU_REALTIME_PERIOD = "CpuRealtimePeriod";
  @SerializedName(SERIALIZED_NAME_CPU_REALTIME_PERIOD)
  private Long cpuRealtimePeriod;

  public static final String SERIALIZED_NAME_CPU_REALTIME_RUNTIME = "CpuRealtimeRuntime";
  @SerializedName(SERIALIZED_NAME_CPU_REALTIME_RUNTIME)
  private Long cpuRealtimeRuntime;

  public static final String SERIALIZED_NAME_CPU_SHARES = "CpuShares";
  @SerializedName(SERIALIZED_NAME_CPU_SHARES)
  private Long cpuShares;

  public static final String SERIALIZED_NAME_CPUSET_CPUS = "CpusetCpus";
  @SerializedName(SERIALIZED_NAME_CPUSET_CPUS)
  private String cpusetCpus;

  public static final String SERIALIZED_NAME_CPUSET_MEMS = "CpusetMems";
  @SerializedName(SERIALIZED_NAME_CPUSET_MEMS)
  private String cpusetMems;

  public static final String SERIALIZED_NAME_DEVICE_CGROUP_RULES = "DeviceCgroupRules";
  @SerializedName(SERIALIZED_NAME_DEVICE_CGROUP_RULES)
  private List<String> deviceCgroupRules = null;

  public static final String SERIALIZED_NAME_DEVICE_REQUESTS = "DeviceRequests";
  @SerializedName(SERIALIZED_NAME_DEVICE_REQUESTS)
  private List<DeviceRequest> deviceRequests = null;

  public static final String SERIALIZED_NAME_DEVICES = "Devices";
  @SerializedName(SERIALIZED_NAME_DEVICES)
  private List<DeviceMapping> devices = null;

  public static final String SERIALIZED_NAME_DNS = "Dns";
  @SerializedName(SERIALIZED_NAME_DNS)
  private List<String> dns = null;

  public static final String SERIALIZED_NAME_DNS_OPTIONS = "DnsOptions";
  @SerializedName(SERIALIZED_NAME_DNS_OPTIONS)
  private List<String> dnsOptions = null;

  public static final String SERIALIZED_NAME_DNS_SEARCH = "DnsSearch";
  @SerializedName(SERIALIZED_NAME_DNS_SEARCH)
  private List<String> dnsSearch = null;

  public static final String SERIALIZED_NAME_EXTRA_HOSTS = "ExtraHosts";
  @SerializedName(SERIALIZED_NAME_EXTRA_HOSTS)
  private List<String> extraHosts = null;

  public static final String SERIALIZED_NAME_GROUP_ADD = "GroupAdd";
  @SerializedName(SERIALIZED_NAME_GROUP_ADD)
  private List<String> groupAdd = null;

  public static final String SERIALIZED_NAME_IO_MAXIMUM_BANDWIDTH = "IOMaximumBandwidth";
  @SerializedName(SERIALIZED_NAME_IO_MAXIMUM_BANDWIDTH)
  private Integer ioMaximumBandwidth;

  public static final String SERIALIZED_NAME_IO_MAXIMUM_I_OPS = "IOMaximumIOps";
  @SerializedName(SERIALIZED_NAME_IO_MAXIMUM_I_OPS)
  private Integer ioMaximumIOps;

  public static final String SERIALIZED_NAME_INIT = "Init";
  @SerializedName(SERIALIZED_NAME_INIT)
  private Boolean init;

  public static final String SERIALIZED_NAME_IPC_MODE = "IpcMode";
  @SerializedName(SERIALIZED_NAME_IPC_MODE)
  private String ipcMode;

  public static final String SERIALIZED_NAME_ISOLATION = "Isolation";
  @SerializedName(SERIALIZED_NAME_ISOLATION)
  private String isolation;

  public static final String SERIALIZED_NAME_KERNEL_MEMORY = "KernelMemory";
  @SerializedName(SERIALIZED_NAME_KERNEL_MEMORY)
  private Long kernelMemory;

  public static final String SERIALIZED_NAME_KERNEL_MEMORY_T_C_P = "KernelMemoryTCP";
  @SerializedName(SERIALIZED_NAME_KERNEL_MEMORY_T_C_P)
  private Long kernelMemoryTCP;

  public static final String SERIALIZED_NAME_LINKS = "Links";
  @SerializedName(SERIALIZED_NAME_LINKS)
  private List<String> links = null;

  public static final String SERIALIZED_NAME_LOG_CONFIG = "LogConfig";
  @SerializedName(SERIALIZED_NAME_LOG_CONFIG)
  private LogConfig logConfig;

  public static final String SERIALIZED_NAME_MASKED_PATHS = "MaskedPaths";
  @SerializedName(SERIALIZED_NAME_MASKED_PATHS)
  private List<String> maskedPaths = null;

  public static final String SERIALIZED_NAME_MEMORY = "Memory";
  @SerializedName(SERIALIZED_NAME_MEMORY)
  private Long memory;

  public static final String SERIALIZED_NAME_MEMORY_RESERVATION = "MemoryReservation";
  @SerializedName(SERIALIZED_NAME_MEMORY_RESERVATION)
  private Long memoryReservation;

  public static final String SERIALIZED_NAME_MEMORY_SWAP = "MemorySwap";
  @SerializedName(SERIALIZED_NAME_MEMORY_SWAP)
  private Long memorySwap;

  public static final String SERIALIZED_NAME_MEMORY_SWAPPINESS = "MemorySwappiness";
  @SerializedName(SERIALIZED_NAME_MEMORY_SWAPPINESS)
  private Long memorySwappiness;

  public static final String SERIALIZED_NAME_MOUNTS = "Mounts";
  @SerializedName(SERIALIZED_NAME_MOUNTS)
  private List<Mount> mounts = null;

  public static final String SERIALIZED_NAME_NANO_CPUS = "NanoCpus";
  @SerializedName(SERIALIZED_NAME_NANO_CPUS)
  private Long nanoCpus;

  public static final String SERIALIZED_NAME_NETWORK_MODE = "NetworkMode";
  @SerializedName(SERIALIZED_NAME_NETWORK_MODE)
  private String networkMode;

  public static final String SERIALIZED_NAME_OOM_KILL_DISABLE = "OomKillDisable";
  @SerializedName(SERIALIZED_NAME_OOM_KILL_DISABLE)
  private Boolean oomKillDisable;

  public static final String SERIALIZED_NAME_OOM_SCORE_ADJ = "OomScoreAdj";
  @SerializedName(SERIALIZED_NAME_OOM_SCORE_ADJ)
  private Long oomScoreAdj;

  public static final String SERIALIZED_NAME_PID_MODE = "PidMode";
  @SerializedName(SERIALIZED_NAME_PID_MODE)
  private String pidMode;

  public static final String SERIALIZED_NAME_PIDS_LIMIT = "PidsLimit";
  @SerializedName(SERIALIZED_NAME_PIDS_LIMIT)
  private Long pidsLimit;

  public static final String SERIALIZED_NAME_PORT_BINDINGS = "PortBindings";
  @SerializedName(SERIALIZED_NAME_PORT_BINDINGS)
  private Map<String, List<PortBinding>> portBindings = null;

  public static final String SERIALIZED_NAME_PRIVILEGED = "Privileged";
  @SerializedName(SERIALIZED_NAME_PRIVILEGED)
  private Boolean privileged;

  public static final String SERIALIZED_NAME_PUBLISH_ALL_PORTS = "PublishAllPorts";
  @SerializedName(SERIALIZED_NAME_PUBLISH_ALL_PORTS)
  private Boolean publishAllPorts;

  public static final String SERIALIZED_NAME_READONLY_PATHS = "ReadonlyPaths";
  @SerializedName(SERIALIZED_NAME_READONLY_PATHS)
  private List<String> readonlyPaths = null;

  public static final String SERIALIZED_NAME_READONLY_ROOTFS = "ReadonlyRootfs";
  @SerializedName(SERIALIZED_NAME_READONLY_ROOTFS)
  private Boolean readonlyRootfs;

  public static final String SERIALIZED_NAME_RESTART_POLICY = "RestartPolicy";
  @SerializedName(SERIALIZED_NAME_RESTART_POLICY)
  private RestartPolicy restartPolicy;

  public static final String SERIALIZED_NAME_RUNTIME = "Runtime";
  @SerializedName(SERIALIZED_NAME_RUNTIME)
  private String runtime;

  public static final String SERIALIZED_NAME_SECURITY_OPT = "SecurityOpt";
  @SerializedName(SERIALIZED_NAME_SECURITY_OPT)
  private List<String> securityOpt = null;

  public static final String SERIALIZED_NAME_SHM_SIZE = "ShmSize";
  @SerializedName(SERIALIZED_NAME_SHM_SIZE)
  private Long shmSize;

  public static final String SERIALIZED_NAME_STORAGE_OPT = "StorageOpt";
  @SerializedName(SERIALIZED_NAME_STORAGE_OPT)
  private Map<String, String> storageOpt = null;

  public static final String SERIALIZED_NAME_SYSCTLS = "Sysctls";
  @SerializedName(SERIALIZED_NAME_SYSCTLS)
  private Map<String, String> sysctls = null;

  public static final String SERIALIZED_NAME_TMPFS = "Tmpfs";
  @SerializedName(SERIALIZED_NAME_TMPFS)
  private Map<String, String> tmpfs = null;

  public static final String SERIALIZED_NAME_UT_S_MODE = "UTSMode";
  @SerializedName(SERIALIZED_NAME_UT_S_MODE)
  private String utSMode;

  public static final String SERIALIZED_NAME_ULIMITS = "Ulimits";
  @SerializedName(SERIALIZED_NAME_ULIMITS)
  private List<Ulimit> ulimits = null;

  public static final String SERIALIZED_NAME_USERNS_MODE = "UsernsMode";
  @SerializedName(SERIALIZED_NAME_USERNS_MODE)
  private String usernsMode;

  public static final String SERIALIZED_NAME_VOLUME_DRIVER = "VolumeDriver";
  @SerializedName(SERIALIZED_NAME_VOLUME_DRIVER)
  private String volumeDriver;

  public static final String SERIALIZED_NAME_VOLUMES_FROM = "VolumesFrom";
  @SerializedName(SERIALIZED_NAME_VOLUMES_FROM)
  private List<String> volumesFrom = null;

  public HostConfig() {
  }

  public HostConfig annotations(Map<String, String> annotations) {
    
    this.annotations = annotations;
    return this;
  }

  public HostConfig putAnnotationsItem(String key, String annotationsItem) {
    if (this.annotations == null) {
      this.annotations = new HashMap<>();
    }
    this.annotations.put(key, annotationsItem);
    return this;
  }

   /**
   * Get annotations
   * @return annotations
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Map<String, String> getAnnotations() {
    return annotations;
  }


  public void setAnnotations(Map<String, String> annotations) {
    this.annotations = annotations;
  }


  public HostConfig autoRemove(Boolean autoRemove) {
    
    this.autoRemove = autoRemove;
    return this;
  }

   /**
   * Get autoRemove
   * @return autoRemove
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Boolean getAutoRemove() {
    return autoRemove;
  }


  public void setAutoRemove(Boolean autoRemove) {
    this.autoRemove = autoRemove;
  }


  public HostConfig binds(List<String> binds) {
    
    this.binds = binds;
    return this;
  }

  public HostConfig addBindsItem(String bindsItem) {
    if (this.binds == null) {
      this.binds = new ArrayList<>();
    }
    this.binds.add(bindsItem);
    return this;
  }

   /**
   * Applicable to all platforms
   * @return binds
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Applicable to all platforms")

  public List<String> getBinds() {
    return binds;
  }


  public void setBinds(List<String> binds) {
    this.binds = binds;
  }


  public HostConfig blkioDeviceReadBps(List<ThrottleDevice> blkioDeviceReadBps) {
    
    this.blkioDeviceReadBps = blkioDeviceReadBps;
    return this;
  }

  public HostConfig addBlkioDeviceReadBpsItem(ThrottleDevice blkioDeviceReadBpsItem) {
    if (this.blkioDeviceReadBps == null) {
      this.blkioDeviceReadBps = new ArrayList<>();
    }
    this.blkioDeviceReadBps.add(blkioDeviceReadBpsItem);
    return this;
  }

   /**
   * Get blkioDeviceReadBps
   * @return blkioDeviceReadBps
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public List<ThrottleDevice> getBlkioDeviceReadBps() {
    return blkioDeviceReadBps;
  }


  public void setBlkioDeviceReadBps(List<ThrottleDevice> blkioDeviceReadBps) {
    this.blkioDeviceReadBps = blkioDeviceReadBps;
  }


  public HostConfig blkioDeviceReadIOps(List<ThrottleDevice> blkioDeviceReadIOps) {
    
    this.blkioDeviceReadIOps = blkioDeviceReadIOps;
    return this;
  }

  public HostConfig addBlkioDeviceReadIOpsItem(ThrottleDevice blkioDeviceReadIOpsItem) {
    if (this.blkioDeviceReadIOps == null) {
      this.blkioDeviceReadIOps = new ArrayList<>();
    }
    this.blkioDeviceReadIOps.add(blkioDeviceReadIOpsItem);
    return this;
  }

   /**
   * Get blkioDeviceReadIOps
   * @return blkioDeviceReadIOps
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public List<ThrottleDevice> getBlkioDeviceReadIOps() {
    return blkioDeviceReadIOps;
  }


  public void setBlkioDeviceReadIOps(List<ThrottleDevice> blkioDeviceReadIOps) {
    this.blkioDeviceReadIOps = blkioDeviceReadIOps;
  }


  public HostConfig blkioDeviceWriteBps(List<ThrottleDevice> blkioDeviceWriteBps) {
    
    this.blkioDeviceWriteBps = blkioDeviceWriteBps;
    return this;
  }

  public HostConfig addBlkioDeviceWriteBpsItem(ThrottleDevice blkioDeviceWriteBpsItem) {
    if (this.blkioDeviceWriteBps == null) {
      this.blkioDeviceWriteBps = new ArrayList<>();
    }
    this.blkioDeviceWriteBps.add(blkioDeviceWriteBpsItem);
    return this;
  }

   /**
   * Get blkioDeviceWriteBps
   * @return blkioDeviceWriteBps
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public List<ThrottleDevice> getBlkioDeviceWriteBps() {
    return blkioDeviceWriteBps;
  }


  public void setBlkioDeviceWriteBps(List<ThrottleDevice> blkioDeviceWriteBps) {
    this.blkioDeviceWriteBps = blkioDeviceWriteBps;
  }


  public HostConfig blkioDeviceWriteIOps(List<ThrottleDevice> blkioDeviceWriteIOps) {
    
    this.blkioDeviceWriteIOps = blkioDeviceWriteIOps;
    return this;
  }

  public HostConfig addBlkioDeviceWriteIOpsItem(ThrottleDevice blkioDeviceWriteIOpsItem) {
    if (this.blkioDeviceWriteIOps == null) {
      this.blkioDeviceWriteIOps = new ArrayList<>();
    }
    this.blkioDeviceWriteIOps.add(blkioDeviceWriteIOpsItem);
    return this;
  }

   /**
   * Get blkioDeviceWriteIOps
   * @return blkioDeviceWriteIOps
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public List<ThrottleDevice> getBlkioDeviceWriteIOps() {
    return blkioDeviceWriteIOps;
  }


  public void setBlkioDeviceWriteIOps(List<ThrottleDevice> blkioDeviceWriteIOps) {
    this.blkioDeviceWriteIOps = blkioDeviceWriteIOps;
  }


  public HostConfig blkioWeight(Integer blkioWeight) {
    
    this.blkioWeight = blkioWeight;
    return this;
  }

   /**
   * Get blkioWeight
   * @return blkioWeight
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Integer getBlkioWeight() {
    return blkioWeight;
  }


  public void setBlkioWeight(Integer blkioWeight) {
    this.blkioWeight = blkioWeight;
  }


  public HostConfig blkioWeightDevice(List<WeightDevice> blkioWeightDevice) {
    
    this.blkioWeightDevice = blkioWeightDevice;
    return this;
  }

  public HostConfig addBlkioWeightDeviceItem(WeightDevice blkioWeightDeviceItem) {
    if (this.blkioWeightDevice == null) {
      this.blkioWeightDevice = new ArrayList<>();
    }
    this.blkioWeightDevice.add(blkioWeightDeviceItem);
    return this;
  }

   /**
   * Get blkioWeightDevice
   * @return blkioWeightDevice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public List<WeightDevice> getBlkioWeightDevice() {
    return blkioWeightDevice;
  }


  public void setBlkioWeightDevice(List<WeightDevice> blkioWeightDevice) {
    this.blkioWeightDevice = blkioWeightDevice;
  }


  public HostConfig capAdd(List<String> capAdd) {
    
    this.capAdd = capAdd;
    return this;
  }

  public HostConfig addCapAddItem(String capAddItem) {
    if (this.capAdd == null) {
      this.capAdd = new ArrayList<>();
    }
    this.capAdd.add(capAddItem);
    return this;
  }

   /**
   * We need to override the json decoder to accept both options.
   * @return capAdd
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "We need to override the json decoder to accept both options.")

  public List<String> getCapAdd() {
    return capAdd;
  }


  public void setCapAdd(List<String> capAdd) {
    this.capAdd = capAdd;
  }


  public HostConfig capDrop(List<String> capDrop) {
    
    this.capDrop = capDrop;
    return this;
  }

  public HostConfig addCapDropItem(String capDropItem) {
    if (this.capDrop == null) {
      this.capDrop = new ArrayList<>();
    }
    this.capDrop.add(capDropItem);
    return this;
  }

   /**
   * We need to override the json decoder to accept both options.
   * @return capDrop
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "We need to override the json decoder to accept both options.")

  public List<String> getCapDrop() {
    return capDrop;
  }


  public void setCapDrop(List<String> capDrop) {
    this.capDrop = capDrop;
  }


  public HostConfig cgroup(String cgroup) {
    
    this.cgroup = cgroup;
    return this;
  }

   /**
   * Get cgroup
   * @return cgroup
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getCgroup() {
    return cgroup;
  }


  public void setCgroup(String cgroup) {
    this.cgroup = cgroup;
  }


  public HostConfig cgroupParent(String cgroupParent) {
    
    this.cgroupParent = cgroupParent;
    return this;
  }

   /**
   * Applicable to UNIX platforms
   * @return cgroupParent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Applicable to UNIX platforms")

  public String getCgroupParent() {
    return cgroupParent;
  }


  public void setCgroupParent(String cgroupParent) {
    this.cgroupParent = cgroupParent;
  }


  public HostConfig cgroupnsMode(String cgroupnsMode) {
    
    this.cgroupnsMode = cgroupnsMode;
    return this;
  }

   /**
   * CgroupnsMode represents the cgroup namespace mode of the container
   * @return cgroupnsMode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "CgroupnsMode represents the cgroup namespace mode of the container")

  public String getCgroupnsMode() {
    return cgroupnsMode;
  }


  public void setCgroupnsMode(String cgroupnsMode) {
    this.cgroupnsMode = cgroupnsMode;
  }


  public HostConfig consoleSize(List<Integer> consoleSize) {
    
    this.consoleSize = consoleSize;
    return this;
  }

  public HostConfig addConsoleSizeItem(Integer consoleSizeItem) {
    if (this.consoleSize == null) {
      this.consoleSize = new ArrayList<>();
    }
    this.consoleSize.add(consoleSizeItem);
    return this;
  }

   /**
   * Get consoleSize
   * @return consoleSize
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<Integer> getConsoleSize() {
    return consoleSize;
  }


  public void setConsoleSize(List<Integer> consoleSize) {
    this.consoleSize = consoleSize;
  }


  public HostConfig containerIDFile(String containerIDFile) {
    
    this.containerIDFile = containerIDFile;
    return this;
  }

   /**
   * Get containerIDFile
   * @return containerIDFile
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getContainerIDFile() {
    return containerIDFile;
  }


  public void setContainerIDFile(String containerIDFile) {
    this.containerIDFile = containerIDFile;
  }


  public HostConfig cpuCount(Long cpuCount) {
    
    this.cpuCount = cpuCount;
    return this;
  }

   /**
   * Applicable to Windows
   * @return cpuCount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Applicable to Windows")

  public Long getCpuCount() {
    return cpuCount;
  }


  public void setCpuCount(Long cpuCount) {
    this.cpuCount = cpuCount;
  }


  public HostConfig cpuPercent(Long cpuPercent) {
    
    this.cpuPercent = cpuPercent;
    return this;
  }

   /**
   * Get cpuPercent
   * @return cpuPercent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getCpuPercent() {
    return cpuPercent;
  }


  public void setCpuPercent(Long cpuPercent) {
    this.cpuPercent = cpuPercent;
  }


  public HostConfig cpuPeriod(Long cpuPeriod) {
    
    this.cpuPeriod = cpuPeriod;
    return this;
  }

   /**
   * Get cpuPeriod
   * @return cpuPeriod
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getCpuPeriod() {
    return cpuPeriod;
  }


  public void setCpuPeriod(Long cpuPeriod) {
    this.cpuPeriod = cpuPeriod;
  }


  public HostConfig cpuQuota(Long cpuQuota) {
    
    this.cpuQuota = cpuQuota;
    return this;
  }

   /**
   * Get cpuQuota
   * @return cpuQuota
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getCpuQuota() {
    return cpuQuota;
  }


  public void setCpuQuota(Long cpuQuota) {
    this.cpuQuota = cpuQuota;
  }


  public HostConfig cpuRealtimePeriod(Long cpuRealtimePeriod) {
    
    this.cpuRealtimePeriod = cpuRealtimePeriod;
    return this;
  }

   /**
   * Get cpuRealtimePeriod
   * @return cpuRealtimePeriod
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getCpuRealtimePeriod() {
    return cpuRealtimePeriod;
  }


  public void setCpuRealtimePeriod(Long cpuRealtimePeriod) {
    this.cpuRealtimePeriod = cpuRealtimePeriod;
  }


  public HostConfig cpuRealtimeRuntime(Long cpuRealtimeRuntime) {
    
    this.cpuRealtimeRuntime = cpuRealtimeRuntime;
    return this;
  }

   /**
   * Get cpuRealtimeRuntime
   * @return cpuRealtimeRuntime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getCpuRealtimeRuntime() {
    return cpuRealtimeRuntime;
  }


  public void setCpuRealtimeRuntime(Long cpuRealtimeRuntime) {
    this.cpuRealtimeRuntime = cpuRealtimeRuntime;
  }


  public HostConfig cpuShares(Long cpuShares) {
    
    this.cpuShares = cpuShares;
    return this;
  }

   /**
   * Applicable to all platforms
   * @return cpuShares
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Applicable to all platforms")

  public Long getCpuShares() {
    return cpuShares;
  }


  public void setCpuShares(Long cpuShares) {
    this.cpuShares = cpuShares;
  }


  public HostConfig cpusetCpus(String cpusetCpus) {
    
    this.cpusetCpus = cpusetCpus;
    return this;
  }

   /**
   * Get cpusetCpus
   * @return cpusetCpus
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getCpusetCpus() {
    return cpusetCpus;
  }


  public void setCpusetCpus(String cpusetCpus) {
    this.cpusetCpus = cpusetCpus;
  }


  public HostConfig cpusetMems(String cpusetMems) {
    
    this.cpusetMems = cpusetMems;
    return this;
  }

   /**
   * Get cpusetMems
   * @return cpusetMems
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getCpusetMems() {
    return cpusetMems;
  }


  public void setCpusetMems(String cpusetMems) {
    this.cpusetMems = cpusetMems;
  }


  public HostConfig deviceCgroupRules(List<String> deviceCgroupRules) {
    
    this.deviceCgroupRules = deviceCgroupRules;
    return this;
  }

  public HostConfig addDeviceCgroupRulesItem(String deviceCgroupRulesItem) {
    if (this.deviceCgroupRules == null) {
      this.deviceCgroupRules = new ArrayList<>();
    }
    this.deviceCgroupRules.add(deviceCgroupRulesItem);
    return this;
  }

   /**
   * Get deviceCgroupRules
   * @return deviceCgroupRules
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<String> getDeviceCgroupRules() {
    return deviceCgroupRules;
  }


  public void setDeviceCgroupRules(List<String> deviceCgroupRules) {
    this.deviceCgroupRules = deviceCgroupRules;
  }


  public HostConfig deviceRequests(List<DeviceRequest> deviceRequests) {
    
    this.deviceRequests = deviceRequests;
    return this;
  }

  public HostConfig addDeviceRequestsItem(DeviceRequest deviceRequestsItem) {
    if (this.deviceRequests == null) {
      this.deviceRequests = new ArrayList<>();
    }
    this.deviceRequests.add(deviceRequestsItem);
    return this;
  }

   /**
   * Get deviceRequests
   * @return deviceRequests
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public List<DeviceRequest> getDeviceRequests() {
    return deviceRequests;
  }


  public void setDeviceRequests(List<DeviceRequest> deviceRequests) {
    this.deviceRequests = deviceRequests;
  }


  public HostConfig devices(List<DeviceMapping> devices) {
    
    this.devices = devices;
    return this;
  }

  public HostConfig addDevicesItem(DeviceMapping devicesItem) {
    if (this.devices == null) {
      this.devices = new ArrayList<>();
    }
    this.devices.add(devicesItem);
    return this;
  }

   /**
   * Get devices
   * @return devices
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public List<DeviceMapping> getDevices() {
    return devices;
  }


  public void setDevices(List<DeviceMapping> devices) {
    this.devices = devices;
  }


  public HostConfig dns(List<String> dns) {
    
    this.dns = dns;
    return this;
  }

  public HostConfig addDnsItem(String dnsItem) {
    if (this.dns == null) {
      this.dns = new ArrayList<>();
    }
    this.dns.add(dnsItem);
    return this;
  }

   /**
   * Get dns
   * @return dns
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<String> getDns() {
    return dns;
  }


  public void setDns(List<String> dns) {
    this.dns = dns;
  }


  public HostConfig dnsOptions(List<String> dnsOptions) {
    
    this.dnsOptions = dnsOptions;
    return this;
  }

  public HostConfig addDnsOptionsItem(String dnsOptionsItem) {
    if (this.dnsOptions == null) {
      this.dnsOptions = new ArrayList<>();
    }
    this.dnsOptions.add(dnsOptionsItem);
    return this;
  }

   /**
   * Get dnsOptions
   * @return dnsOptions
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<String> getDnsOptions() {
    return dnsOptions;
  }


  public void setDnsOptions(List<String> dnsOptions) {
    this.dnsOptions = dnsOptions;
  }


  public HostConfig dnsSearch(List<String> dnsSearch) {
    
    this.dnsSearch = dnsSearch;
    return this;
  }

  public HostConfig addDnsSearchItem(String dnsSearchItem) {
    if (this.dnsSearch == null) {
      this.dnsSearch = new ArrayList<>();
    }
    this.dnsSearch.add(dnsSearchItem);
    return this;
  }

   /**
   * Get dnsSearch
   * @return dnsSearch
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<String> getDnsSearch() {
    return dnsSearch;
  }


  public void setDnsSearch(List<String> dnsSearch) {
    this.dnsSearch = dnsSearch;
  }


  public HostConfig extraHosts(List<String> extraHosts) {
    
    this.extraHosts = extraHosts;
    return this;
  }

  public HostConfig addExtraHostsItem(String extraHostsItem) {
    if (this.extraHosts == null) {
      this.extraHosts = new ArrayList<>();
    }
    this.extraHosts.add(extraHostsItem);
    return this;
  }

   /**
   * Get extraHosts
   * @return extraHosts
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<String> getExtraHosts() {
    return extraHosts;
  }


  public void setExtraHosts(List<String> extraHosts) {
    this.extraHosts = extraHosts;
  }


  public HostConfig groupAdd(List<String> groupAdd) {
    
    this.groupAdd = groupAdd;
    return this;
  }

  public HostConfig addGroupAddItem(String groupAddItem) {
    if (this.groupAdd == null) {
      this.groupAdd = new ArrayList<>();
    }
    this.groupAdd.add(groupAddItem);
    return this;
  }

   /**
   * Get groupAdd
   * @return groupAdd
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<String> getGroupAdd() {
    return groupAdd;
  }


  public void setGroupAdd(List<String> groupAdd) {
    this.groupAdd = groupAdd;
  }


  public HostConfig ioMaximumBandwidth(Integer ioMaximumBandwidth) {
    
    this.ioMaximumBandwidth = ioMaximumBandwidth;
    return this;
  }

   /**
   * Get ioMaximumBandwidth
   * @return ioMaximumBandwidth
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Integer getIoMaximumBandwidth() {
    return ioMaximumBandwidth;
  }


  public void setIoMaximumBandwidth(Integer ioMaximumBandwidth) {
    this.ioMaximumBandwidth = ioMaximumBandwidth;
  }


  public HostConfig ioMaximumIOps(Integer ioMaximumIOps) {
    
    this.ioMaximumIOps = ioMaximumIOps;
    return this;
  }

   /**
   * Get ioMaximumIOps
   * @return ioMaximumIOps
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Integer getIoMaximumIOps() {
    return ioMaximumIOps;
  }


  public void setIoMaximumIOps(Integer ioMaximumIOps) {
    this.ioMaximumIOps = ioMaximumIOps;
  }


  public HostConfig init(Boolean init) {
    
    this.init = init;
    return this;
  }

   /**
   * Run a custom init inside the container, if null, use the daemon&#39;s configured settings
   * @return init
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Run a custom init inside the container, if null, use the daemon's configured settings")

  public Boolean getInit() {
    return init;
  }


  public void setInit(Boolean init) {
    this.init = init;
  }


  public HostConfig ipcMode(String ipcMode) {
    
    this.ipcMode = ipcMode;
    return this;
  }

   /**
   * Get ipcMode
   * @return ipcMode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getIpcMode() {
    return ipcMode;
  }


  public void setIpcMode(String ipcMode) {
    this.ipcMode = ipcMode;
  }


  public HostConfig isolation(String isolation) {
    
    this.isolation = isolation;
    return this;
  }

   /**
   * Isolation represents the isolation technology of a container. The supported values are platform specific
   * @return isolation
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Isolation represents the isolation technology of a container. The supported values are platform specific")

  public String getIsolation() {
    return isolation;
  }


  public void setIsolation(String isolation) {
    this.isolation = isolation;
  }


  public HostConfig kernelMemory(Long kernelMemory) {
    
    this.kernelMemory = kernelMemory;
    return this;
  }

   /**
   * KernelMemory specifies the kernel memory limit (in bytes) for the container. Deprecated: kernel 5.4 deprecated kmem.limit_in_bytes.
   * @return kernelMemory
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "KernelMemory specifies the kernel memory limit (in bytes) for the container. Deprecated: kernel 5.4 deprecated kmem.limit_in_bytes.")

  public Long getKernelMemory() {
    return kernelMemory;
  }


  public void setKernelMemory(Long kernelMemory) {
    this.kernelMemory = kernelMemory;
  }


  public HostConfig kernelMemoryTCP(Long kernelMemoryTCP) {
    
    this.kernelMemoryTCP = kernelMemoryTCP;
    return this;
  }

   /**
   * Get kernelMemoryTCP
   * @return kernelMemoryTCP
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getKernelMemoryTCP() {
    return kernelMemoryTCP;
  }


  public void setKernelMemoryTCP(Long kernelMemoryTCP) {
    this.kernelMemoryTCP = kernelMemoryTCP;
  }


  public HostConfig links(List<String> links) {
    
    this.links = links;
    return this;
  }

  public HostConfig addLinksItem(String linksItem) {
    if (this.links == null) {
      this.links = new ArrayList<>();
    }
    this.links.add(linksItem);
    return this;
  }

   /**
   * Get links
   * @return links
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<String> getLinks() {
    return links;
  }


  public void setLinks(List<String> links) {
    this.links = links;
  }


  public HostConfig logConfig(LogConfig logConfig) {
    
    this.logConfig = logConfig;
    return this;
  }

   /**
   * Get logConfig
   * @return logConfig
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public LogConfig getLogConfig() {
    return logConfig;
  }


  public void setLogConfig(LogConfig logConfig) {
    this.logConfig = logConfig;
  }


  public HostConfig maskedPaths(List<String> maskedPaths) {
    
    this.maskedPaths = maskedPaths;
    return this;
  }

  public HostConfig addMaskedPathsItem(String maskedPathsItem) {
    if (this.maskedPaths == null) {
      this.maskedPaths = new ArrayList<>();
    }
    this.maskedPaths.add(maskedPathsItem);
    return this;
  }

   /**
   * MaskedPaths is the list of paths to be masked inside the container (this overrides the default set of paths)
   * @return maskedPaths
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "MaskedPaths is the list of paths to be masked inside the container (this overrides the default set of paths)")

  public List<String> getMaskedPaths() {
    return maskedPaths;
  }


  public void setMaskedPaths(List<String> maskedPaths) {
    this.maskedPaths = maskedPaths;
  }


  public HostConfig memory(Long memory) {
    
    this.memory = memory;
    return this;
  }

   /**
   * Get memory
   * @return memory
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getMemory() {
    return memory;
  }


  public void setMemory(Long memory) {
    this.memory = memory;
  }


  public HostConfig memoryReservation(Long memoryReservation) {
    
    this.memoryReservation = memoryReservation;
    return this;
  }

   /**
   * Get memoryReservation
   * @return memoryReservation
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getMemoryReservation() {
    return memoryReservation;
  }


  public void setMemoryReservation(Long memoryReservation) {
    this.memoryReservation = memoryReservation;
  }


  public HostConfig memorySwap(Long memorySwap) {
    
    this.memorySwap = memorySwap;
    return this;
  }

   /**
   * Get memorySwap
   * @return memorySwap
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getMemorySwap() {
    return memorySwap;
  }


  public void setMemorySwap(Long memorySwap) {
    this.memorySwap = memorySwap;
  }


  public HostConfig memorySwappiness(Long memorySwappiness) {
    
    this.memorySwappiness = memorySwappiness;
    return this;
  }

   /**
   * Get memorySwappiness
   * @return memorySwappiness
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getMemorySwappiness() {
    return memorySwappiness;
  }


  public void setMemorySwappiness(Long memorySwappiness) {
    this.memorySwappiness = memorySwappiness;
  }


  public HostConfig mounts(List<Mount> mounts) {
    
    this.mounts = mounts;
    return this;
  }

  public HostConfig addMountsItem(Mount mountsItem) {
    if (this.mounts == null) {
      this.mounts = new ArrayList<>();
    }
    this.mounts.add(mountsItem);
    return this;
  }

   /**
   * Mounts specs used by the container
   * @return mounts
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Mounts specs used by the container")

  public List<Mount> getMounts() {
    return mounts;
  }


  public void setMounts(List<Mount> mounts) {
    this.mounts = mounts;
  }


  public HostConfig nanoCpus(Long nanoCpus) {
    
    this.nanoCpus = nanoCpus;
    return this;
  }

   /**
   * Get nanoCpus
   * @return nanoCpus
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getNanoCpus() {
    return nanoCpus;
  }


  public void setNanoCpus(Long nanoCpus) {
    this.nanoCpus = nanoCpus;
  }


  public HostConfig networkMode(String networkMode) {
    
    this.networkMode = networkMode;
    return this;
  }

   /**
   * Get networkMode
   * @return networkMode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getNetworkMode() {
    return networkMode;
  }


  public void setNetworkMode(String networkMode) {
    this.networkMode = networkMode;
  }


  public HostConfig oomKillDisable(Boolean oomKillDisable) {
    
    this.oomKillDisable = oomKillDisable;
    return this;
  }

   /**
   * Get oomKillDisable
   * @return oomKillDisable
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Boolean getOomKillDisable() {
    return oomKillDisable;
  }


  public void setOomKillDisable(Boolean oomKillDisable) {
    this.oomKillDisable = oomKillDisable;
  }


  public HostConfig oomScoreAdj(Long oomScoreAdj) {
    
    this.oomScoreAdj = oomScoreAdj;
    return this;
  }

   /**
   * Get oomScoreAdj
   * @return oomScoreAdj
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getOomScoreAdj() {
    return oomScoreAdj;
  }


  public void setOomScoreAdj(Long oomScoreAdj) {
    this.oomScoreAdj = oomScoreAdj;
  }


  public HostConfig pidMode(String pidMode) {
    
    this.pidMode = pidMode;
    return this;
  }

   /**
   * Get pidMode
   * @return pidMode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getPidMode() {
    return pidMode;
  }


  public void setPidMode(String pidMode) {
    this.pidMode = pidMode;
  }


  public HostConfig pidsLimit(Long pidsLimit) {
    
    this.pidsLimit = pidsLimit;
    return this;
  }

   /**
   * Get pidsLimit
   * @return pidsLimit
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getPidsLimit() {
    return pidsLimit;
  }


  public void setPidsLimit(Long pidsLimit) {
    this.pidsLimit = pidsLimit;
  }


  public HostConfig portBindings(Map<String, List<PortBinding>> portBindings) {
    
    this.portBindings = portBindings;
    return this;
  }

  public HostConfig putPortBindingsItem(String key, List<PortBinding> portBindingsItem) {
    if (this.portBindings == null) {
      this.portBindings = new HashMap<>();
    }
    this.portBindings.put(key, portBindingsItem);
    return this;
  }

   /**
   * PortMap is a collection of PortBinding indexed by Port
   * @return portBindings
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "PortMap is a collection of PortBinding indexed by Port")

  public Map<String, List<PortBinding>> getPortBindings() {
    return portBindings;
  }


  public void setPortBindings(Map<String, List<PortBinding>> portBindings) {
    this.portBindings = portBindings;
  }


  public HostConfig privileged(Boolean privileged) {
    
    this.privileged = privileged;
    return this;
  }

   /**
   * Get privileged
   * @return privileged
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Boolean getPrivileged() {
    return privileged;
  }


  public void setPrivileged(Boolean privileged) {
    this.privileged = privileged;
  }


  public HostConfig publishAllPorts(Boolean publishAllPorts) {
    
    this.publishAllPorts = publishAllPorts;
    return this;
  }

   /**
   * Get publishAllPorts
   * @return publishAllPorts
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Boolean getPublishAllPorts() {
    return publishAllPorts;
  }


  public void setPublishAllPorts(Boolean publishAllPorts) {
    this.publishAllPorts = publishAllPorts;
  }


  public HostConfig readonlyPaths(List<String> readonlyPaths) {
    
    this.readonlyPaths = readonlyPaths;
    return this;
  }

  public HostConfig addReadonlyPathsItem(String readonlyPathsItem) {
    if (this.readonlyPaths == null) {
      this.readonlyPaths = new ArrayList<>();
    }
    this.readonlyPaths.add(readonlyPathsItem);
    return this;
  }

   /**
   * ReadonlyPaths is the list of paths to be set as read-only inside the container (this overrides the default set of paths)
   * @return readonlyPaths
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "ReadonlyPaths is the list of paths to be set as read-only inside the container (this overrides the default set of paths)")

  public List<String> getReadonlyPaths() {
    return readonlyPaths;
  }


  public void setReadonlyPaths(List<String> readonlyPaths) {
    this.readonlyPaths = readonlyPaths;
  }


  public HostConfig readonlyRootfs(Boolean readonlyRootfs) {
    
    this.readonlyRootfs = readonlyRootfs;
    return this;
  }

   /**
   * Get readonlyRootfs
   * @return readonlyRootfs
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Boolean getReadonlyRootfs() {
    return readonlyRootfs;
  }


  public void setReadonlyRootfs(Boolean readonlyRootfs) {
    this.readonlyRootfs = readonlyRootfs;
  }


  public HostConfig restartPolicy(RestartPolicy restartPolicy) {
    
    this.restartPolicy = restartPolicy;
    return this;
  }

   /**
   * Get restartPolicy
   * @return restartPolicy
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public RestartPolicy getRestartPolicy() {
    return restartPolicy;
  }


  public void setRestartPolicy(RestartPolicy restartPolicy) {
    this.restartPolicy = restartPolicy;
  }


  public HostConfig runtime(String runtime) {
    
    this.runtime = runtime;
    return this;
  }

   /**
   * Get runtime
   * @return runtime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getRuntime() {
    return runtime;
  }


  public void setRuntime(String runtime) {
    this.runtime = runtime;
  }


  public HostConfig securityOpt(List<String> securityOpt) {
    
    this.securityOpt = securityOpt;
    return this;
  }

  public HostConfig addSecurityOptItem(String securityOptItem) {
    if (this.securityOpt == null) {
      this.securityOpt = new ArrayList<>();
    }
    this.securityOpt.add(securityOptItem);
    return this;
  }

   /**
   * Get securityOpt
   * @return securityOpt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<String> getSecurityOpt() {
    return securityOpt;
  }


  public void setSecurityOpt(List<String> securityOpt) {
    this.securityOpt = securityOpt;
  }


  public HostConfig shmSize(Long shmSize) {
    
    this.shmSize = shmSize;
    return this;
  }

   /**
   * Get shmSize
   * @return shmSize
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getShmSize() {
    return shmSize;
  }


  public void setShmSize(Long shmSize) {
    this.shmSize = shmSize;
  }


  public HostConfig storageOpt(Map<String, String> storageOpt) {
    
    this.storageOpt = storageOpt;
    return this;
  }

  public HostConfig putStorageOptItem(String key, String storageOptItem) {
    if (this.storageOpt == null) {
      this.storageOpt = new HashMap<>();
    }
    this.storageOpt.put(key, storageOptItem);
    return this;
  }

   /**
   * Get storageOpt
   * @return storageOpt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Map<String, String> getStorageOpt() {
    return storageOpt;
  }


  public void setStorageOpt(Map<String, String> storageOpt) {
    this.storageOpt = storageOpt;
  }


  public HostConfig sysctls(Map<String, String> sysctls) {
    
    this.sysctls = sysctls;
    return this;
  }

  public HostConfig putSysctlsItem(String key, String sysctlsItem) {
    if (this.sysctls == null) {
      this.sysctls = new HashMap<>();
    }
    this.sysctls.put(key, sysctlsItem);
    return this;
  }

   /**
   * Get sysctls
   * @return sysctls
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Map<String, String> getSysctls() {
    return sysctls;
  }


  public void setSysctls(Map<String, String> sysctls) {
    this.sysctls = sysctls;
  }


  public HostConfig tmpfs(Map<String, String> tmpfs) {
    
    this.tmpfs = tmpfs;
    return this;
  }

  public HostConfig putTmpfsItem(String key, String tmpfsItem) {
    if (this.tmpfs == null) {
      this.tmpfs = new HashMap<>();
    }
    this.tmpfs.put(key, tmpfsItem);
    return this;
  }

   /**
   * Get tmpfs
   * @return tmpfs
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Map<String, String> getTmpfs() {
    return tmpfs;
  }


  public void setTmpfs(Map<String, String> tmpfs) {
    this.tmpfs = tmpfs;
  }


  public HostConfig utSMode(String utSMode) {
    
    this.utSMode = utSMode;
    return this;
  }

   /**
   * Get utSMode
   * @return utSMode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getUtSMode() {
    return utSMode;
  }


  public void setUtSMode(String utSMode) {
    this.utSMode = utSMode;
  }


  public HostConfig ulimits(List<Ulimit> ulimits) {
    
    this.ulimits = ulimits;
    return this;
  }

  public HostConfig addUlimitsItem(Ulimit ulimitsItem) {
    if (this.ulimits == null) {
      this.ulimits = new ArrayList<>();
    }
    this.ulimits.add(ulimitsItem);
    return this;
  }

   /**
   * Get ulimits
   * @return ulimits
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public List<Ulimit> getUlimits() {
    return ulimits;
  }


  public void setUlimits(List<Ulimit> ulimits) {
    this.ulimits = ulimits;
  }


  public HostConfig usernsMode(String usernsMode) {
    
    this.usernsMode = usernsMode;
    return this;
  }

   /**
   * Get usernsMode
   * @return usernsMode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getUsernsMode() {
    return usernsMode;
  }


  public void setUsernsMode(String usernsMode) {
    this.usernsMode = usernsMode;
  }


  public HostConfig volumeDriver(String volumeDriver) {
    
    this.volumeDriver = volumeDriver;
    return this;
  }

   /**
   * Get volumeDriver
   * @return volumeDriver
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getVolumeDriver() {
    return volumeDriver;
  }


  public void setVolumeDriver(String volumeDriver) {
    this.volumeDriver = volumeDriver;
  }


  public HostConfig volumesFrom(List<String> volumesFrom) {
    
    this.volumesFrom = volumesFrom;
    return this;
  }

  public HostConfig addVolumesFromItem(String volumesFromItem) {
    if (this.volumesFrom == null) {
      this.volumesFrom = new ArrayList<>();
    }
    this.volumesFrom.add(volumesFromItem);
    return this;
  }

   /**
   * Get volumesFrom
   * @return volumesFrom
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<String> getVolumesFrom() {
    return volumesFrom;
  }


  public void setVolumesFrom(List<String> volumesFrom) {
    this.volumesFrom = volumesFrom;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    HostConfig hostConfig = (HostConfig) o;
    return Objects.equals(this.annotations, hostConfig.annotations) &&
        Objects.equals(this.autoRemove, hostConfig.autoRemove) &&
        Objects.equals(this.binds, hostConfig.binds) &&
        Objects.equals(this.blkioDeviceReadBps, hostConfig.blkioDeviceReadBps) &&
        Objects.equals(this.blkioDeviceReadIOps, hostConfig.blkioDeviceReadIOps) &&
        Objects.equals(this.blkioDeviceWriteBps, hostConfig.blkioDeviceWriteBps) &&
        Objects.equals(this.blkioDeviceWriteIOps, hostConfig.blkioDeviceWriteIOps) &&
        Objects.equals(this.blkioWeight, hostConfig.blkioWeight) &&
        Objects.equals(this.blkioWeightDevice, hostConfig.blkioWeightDevice) &&
        Objects.equals(this.capAdd, hostConfig.capAdd) &&
        Objects.equals(this.capDrop, hostConfig.capDrop) &&
        Objects.equals(this.cgroup, hostConfig.cgroup) &&
        Objects.equals(this.cgroupParent, hostConfig.cgroupParent) &&
        Objects.equals(this.cgroupnsMode, hostConfig.cgroupnsMode) &&
        Objects.equals(this.consoleSize, hostConfig.consoleSize) &&
        Objects.equals(this.containerIDFile, hostConfig.containerIDFile) &&
        Objects.equals(this.cpuCount, hostConfig.cpuCount) &&
        Objects.equals(this.cpuPercent, hostConfig.cpuPercent) &&
        Objects.equals(this.cpuPeriod, hostConfig.cpuPeriod) &&
        Objects.equals(this.cpuQuota, hostConfig.cpuQuota) &&
        Objects.equals(this.cpuRealtimePeriod, hostConfig.cpuRealtimePeriod) &&
        Objects.equals(this.cpuRealtimeRuntime, hostConfig.cpuRealtimeRuntime) &&
        Objects.equals(this.cpuShares, hostConfig.cpuShares) &&
        Objects.equals(this.cpusetCpus, hostConfig.cpusetCpus) &&
        Objects.equals(this.cpusetMems, hostConfig.cpusetMems) &&
        Objects.equals(this.deviceCgroupRules, hostConfig.deviceCgroupRules) &&
        Objects.equals(this.deviceRequests, hostConfig.deviceRequests) &&
        Objects.equals(this.devices, hostConfig.devices) &&
        Objects.equals(this.dns, hostConfig.dns) &&
        Objects.equals(this.dnsOptions, hostConfig.dnsOptions) &&
        Objects.equals(this.dnsSearch, hostConfig.dnsSearch) &&
        Objects.equals(this.extraHosts, hostConfig.extraHosts) &&
        Objects.equals(this.groupAdd, hostConfig.groupAdd) &&
        Objects.equals(this.ioMaximumBandwidth, hostConfig.ioMaximumBandwidth) &&
        Objects.equals(this.ioMaximumIOps, hostConfig.ioMaximumIOps) &&
        Objects.equals(this.init, hostConfig.init) &&
        Objects.equals(this.ipcMode, hostConfig.ipcMode) &&
        Objects.equals(this.isolation, hostConfig.isolation) &&
        Objects.equals(this.kernelMemory, hostConfig.kernelMemory) &&
        Objects.equals(this.kernelMemoryTCP, hostConfig.kernelMemoryTCP) &&
        Objects.equals(this.links, hostConfig.links) &&
        Objects.equals(this.logConfig, hostConfig.logConfig) &&
        Objects.equals(this.maskedPaths, hostConfig.maskedPaths) &&
        Objects.equals(this.memory, hostConfig.memory) &&
        Objects.equals(this.memoryReservation, hostConfig.memoryReservation) &&
        Objects.equals(this.memorySwap, hostConfig.memorySwap) &&
        Objects.equals(this.memorySwappiness, hostConfig.memorySwappiness) &&
        Objects.equals(this.mounts, hostConfig.mounts) &&
        Objects.equals(this.nanoCpus, hostConfig.nanoCpus) &&
        Objects.equals(this.networkMode, hostConfig.networkMode) &&
        Objects.equals(this.oomKillDisable, hostConfig.oomKillDisable) &&
        Objects.equals(this.oomScoreAdj, hostConfig.oomScoreAdj) &&
        Objects.equals(this.pidMode, hostConfig.pidMode) &&
        Objects.equals(this.pidsLimit, hostConfig.pidsLimit) &&
        Objects.equals(this.portBindings, hostConfig.portBindings) &&
        Objects.equals(this.privileged, hostConfig.privileged) &&
        Objects.equals(this.publishAllPorts, hostConfig.publishAllPorts) &&
        Objects.equals(this.readonlyPaths, hostConfig.readonlyPaths) &&
        Objects.equals(this.readonlyRootfs, hostConfig.readonlyRootfs) &&
        Objects.equals(this.restartPolicy, hostConfig.restartPolicy) &&
        Objects.equals(this.runtime, hostConfig.runtime) &&
        Objects.equals(this.securityOpt, hostConfig.securityOpt) &&
        Objects.equals(this.shmSize, hostConfig.shmSize) &&
        Objects.equals(this.storageOpt, hostConfig.storageOpt) &&
        Objects.equals(this.sysctls, hostConfig.sysctls) &&
        Objects.equals(this.tmpfs, hostConfig.tmpfs) &&
        Objects.equals(this.utSMode, hostConfig.utSMode) &&
        Objects.equals(this.ulimits, hostConfig.ulimits) &&
        Objects.equals(this.usernsMode, hostConfig.usernsMode) &&
        Objects.equals(this.volumeDriver, hostConfig.volumeDriver) &&
        Objects.equals(this.volumesFrom, hostConfig.volumesFrom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(annotations, autoRemove, binds, blkioDeviceReadBps, blkioDeviceReadIOps, blkioDeviceWriteBps, blkioDeviceWriteIOps, blkioWeight, blkioWeightDevice, capAdd, capDrop, cgroup, cgroupParent, cgroupnsMode, consoleSize, containerIDFile, cpuCount, cpuPercent, cpuPeriod, cpuQuota, cpuRealtimePeriod, cpuRealtimeRuntime, cpuShares, cpusetCpus, cpusetMems, deviceCgroupRules, deviceRequests, devices, dns, dnsOptions, dnsSearch, extraHosts, groupAdd, ioMaximumBandwidth, ioMaximumIOps, init, ipcMode, isolation, kernelMemory, kernelMemoryTCP, links, logConfig, maskedPaths, memory, memoryReservation, memorySwap, memorySwappiness, mounts, nanoCpus, networkMode, oomKillDisable, oomScoreAdj, pidMode, pidsLimit, portBindings, privileged, publishAllPorts, readonlyPaths, readonlyRootfs, restartPolicy, runtime, securityOpt, shmSize, storageOpt, sysctls, tmpfs, utSMode, ulimits, usernsMode, volumeDriver, volumesFrom);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class HostConfig {\n");
    sb.append("    annotations: ").append(toIndentedString(annotations)).append("\n");
    sb.append("    autoRemove: ").append(toIndentedString(autoRemove)).append("\n");
    sb.append("    binds: ").append(toIndentedString(binds)).append("\n");
    sb.append("    blkioDeviceReadBps: ").append(toIndentedString(blkioDeviceReadBps)).append("\n");
    sb.append("    blkioDeviceReadIOps: ").append(toIndentedString(blkioDeviceReadIOps)).append("\n");
    sb.append("    blkioDeviceWriteBps: ").append(toIndentedString(blkioDeviceWriteBps)).append("\n");
    sb.append("    blkioDeviceWriteIOps: ").append(toIndentedString(blkioDeviceWriteIOps)).append("\n");
    sb.append("    blkioWeight: ").append(toIndentedString(blkioWeight)).append("\n");
    sb.append("    blkioWeightDevice: ").append(toIndentedString(blkioWeightDevice)).append("\n");
    sb.append("    capAdd: ").append(toIndentedString(capAdd)).append("\n");
    sb.append("    capDrop: ").append(toIndentedString(capDrop)).append("\n");
    sb.append("    cgroup: ").append(toIndentedString(cgroup)).append("\n");
    sb.append("    cgroupParent: ").append(toIndentedString(cgroupParent)).append("\n");
    sb.append("    cgroupnsMode: ").append(toIndentedString(cgroupnsMode)).append("\n");
    sb.append("    consoleSize: ").append(toIndentedString(consoleSize)).append("\n");
    sb.append("    containerIDFile: ").append(toIndentedString(containerIDFile)).append("\n");
    sb.append("    cpuCount: ").append(toIndentedString(cpuCount)).append("\n");
    sb.append("    cpuPercent: ").append(toIndentedString(cpuPercent)).append("\n");
    sb.append("    cpuPeriod: ").append(toIndentedString(cpuPeriod)).append("\n");
    sb.append("    cpuQuota: ").append(toIndentedString(cpuQuota)).append("\n");
    sb.append("    cpuRealtimePeriod: ").append(toIndentedString(cpuRealtimePeriod)).append("\n");
    sb.append("    cpuRealtimeRuntime: ").append(toIndentedString(cpuRealtimeRuntime)).append("\n");
    sb.append("    cpuShares: ").append(toIndentedString(cpuShares)).append("\n");
    sb.append("    cpusetCpus: ").append(toIndentedString(cpusetCpus)).append("\n");
    sb.append("    cpusetMems: ").append(toIndentedString(cpusetMems)).append("\n");
    sb.append("    deviceCgroupRules: ").append(toIndentedString(deviceCgroupRules)).append("\n");
    sb.append("    deviceRequests: ").append(toIndentedString(deviceRequests)).append("\n");
    sb.append("    devices: ").append(toIndentedString(devices)).append("\n");
    sb.append("    dns: ").append(toIndentedString(dns)).append("\n");
    sb.append("    dnsOptions: ").append(toIndentedString(dnsOptions)).append("\n");
    sb.append("    dnsSearch: ").append(toIndentedString(dnsSearch)).append("\n");
    sb.append("    extraHosts: ").append(toIndentedString(extraHosts)).append("\n");
    sb.append("    groupAdd: ").append(toIndentedString(groupAdd)).append("\n");
    sb.append("    ioMaximumBandwidth: ").append(toIndentedString(ioMaximumBandwidth)).append("\n");
    sb.append("    ioMaximumIOps: ").append(toIndentedString(ioMaximumIOps)).append("\n");
    sb.append("    init: ").append(toIndentedString(init)).append("\n");
    sb.append("    ipcMode: ").append(toIndentedString(ipcMode)).append("\n");
    sb.append("    isolation: ").append(toIndentedString(isolation)).append("\n");
    sb.append("    kernelMemory: ").append(toIndentedString(kernelMemory)).append("\n");
    sb.append("    kernelMemoryTCP: ").append(toIndentedString(kernelMemoryTCP)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    logConfig: ").append(toIndentedString(logConfig)).append("\n");
    sb.append("    maskedPaths: ").append(toIndentedString(maskedPaths)).append("\n");
    sb.append("    memory: ").append(toIndentedString(memory)).append("\n");
    sb.append("    memoryReservation: ").append(toIndentedString(memoryReservation)).append("\n");
    sb.append("    memorySwap: ").append(toIndentedString(memorySwap)).append("\n");
    sb.append("    memorySwappiness: ").append(toIndentedString(memorySwappiness)).append("\n");
    sb.append("    mounts: ").append(toIndentedString(mounts)).append("\n");
    sb.append("    nanoCpus: ").append(toIndentedString(nanoCpus)).append("\n");
    sb.append("    networkMode: ").append(toIndentedString(networkMode)).append("\n");
    sb.append("    oomKillDisable: ").append(toIndentedString(oomKillDisable)).append("\n");
    sb.append("    oomScoreAdj: ").append(toIndentedString(oomScoreAdj)).append("\n");
    sb.append("    pidMode: ").append(toIndentedString(pidMode)).append("\n");
    sb.append("    pidsLimit: ").append(toIndentedString(pidsLimit)).append("\n");
    sb.append("    portBindings: ").append(toIndentedString(portBindings)).append("\n");
    sb.append("    privileged: ").append(toIndentedString(privileged)).append("\n");
    sb.append("    publishAllPorts: ").append(toIndentedString(publishAllPorts)).append("\n");
    sb.append("    readonlyPaths: ").append(toIndentedString(readonlyPaths)).append("\n");
    sb.append("    readonlyRootfs: ").append(toIndentedString(readonlyRootfs)).append("\n");
    sb.append("    restartPolicy: ").append(toIndentedString(restartPolicy)).append("\n");
    sb.append("    runtime: ").append(toIndentedString(runtime)).append("\n");
    sb.append("    securityOpt: ").append(toIndentedString(securityOpt)).append("\n");
    sb.append("    shmSize: ").append(toIndentedString(shmSize)).append("\n");
    sb.append("    storageOpt: ").append(toIndentedString(storageOpt)).append("\n");
    sb.append("    sysctls: ").append(toIndentedString(sysctls)).append("\n");
    sb.append("    tmpfs: ").append(toIndentedString(tmpfs)).append("\n");
    sb.append("    utSMode: ").append(toIndentedString(utSMode)).append("\n");
    sb.append("    ulimits: ").append(toIndentedString(ulimits)).append("\n");
    sb.append("    usernsMode: ").append(toIndentedString(usernsMode)).append("\n");
    sb.append("    volumeDriver: ").append(toIndentedString(volumeDriver)).append("\n");
    sb.append("    volumesFrom: ").append(toIndentedString(volumesFrom)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("Annotations");
    openapiFields.add("AutoRemove");
    openapiFields.add("Binds");
    openapiFields.add("BlkioDeviceReadBps");
    openapiFields.add("BlkioDeviceReadIOps");
    openapiFields.add("BlkioDeviceWriteBps");
    openapiFields.add("BlkioDeviceWriteIOps");
    openapiFields.add("BlkioWeight");
    openapiFields.add("BlkioWeightDevice");
    openapiFields.add("CapAdd");
    openapiFields.add("CapDrop");
    openapiFields.add("Cgroup");
    openapiFields.add("CgroupParent");
    openapiFields.add("CgroupnsMode");
    openapiFields.add("ConsoleSize");
    openapiFields.add("ContainerIDFile");
    openapiFields.add("CpuCount");
    openapiFields.add("CpuPercent");
    openapiFields.add("CpuPeriod");
    openapiFields.add("CpuQuota");
    openapiFields.add("CpuRealtimePeriod");
    openapiFields.add("CpuRealtimeRuntime");
    openapiFields.add("CpuShares");
    openapiFields.add("CpusetCpus");
    openapiFields.add("CpusetMems");
    openapiFields.add("DeviceCgroupRules");
    openapiFields.add("DeviceRequests");
    openapiFields.add("Devices");
    openapiFields.add("Dns");
    openapiFields.add("DnsOptions");
    openapiFields.add("DnsSearch");
    openapiFields.add("ExtraHosts");
    openapiFields.add("GroupAdd");
    openapiFields.add("IOMaximumBandwidth");
    openapiFields.add("IOMaximumIOps");
    openapiFields.add("Init");
    openapiFields.add("IpcMode");
    openapiFields.add("Isolation");
    openapiFields.add("KernelMemory");
    openapiFields.add("KernelMemoryTCP");
    openapiFields.add("Links");
    openapiFields.add("LogConfig");
    openapiFields.add("MaskedPaths");
    openapiFields.add("Memory");
    openapiFields.add("MemoryReservation");
    openapiFields.add("MemorySwap");
    openapiFields.add("MemorySwappiness");
    openapiFields.add("Mounts");
    openapiFields.add("NanoCpus");
    openapiFields.add("NetworkMode");
    openapiFields.add("OomKillDisable");
    openapiFields.add("OomScoreAdj");
    openapiFields.add("PidMode");
    openapiFields.add("PidsLimit");
    openapiFields.add("PortBindings");
    openapiFields.add("Privileged");
    openapiFields.add("PublishAllPorts");
    openapiFields.add("ReadonlyPaths");
    openapiFields.add("ReadonlyRootfs");
    openapiFields.add("RestartPolicy");
    openapiFields.add("Runtime");
    openapiFields.add("SecurityOpt");
    openapiFields.add("ShmSize");
    openapiFields.add("StorageOpt");
    openapiFields.add("Sysctls");
    openapiFields.add("Tmpfs");
    openapiFields.add("UTSMode");
    openapiFields.add("Ulimits");
    openapiFields.add("UsernsMode");
    openapiFields.add("VolumeDriver");
    openapiFields.add("VolumesFrom");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to HostConfig
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (HostConfig.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in HostConfig is not found in the empty JSON string", HostConfig.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!HostConfig.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `HostConfig` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      // ensure the json data is an array
      if ((jsonObj.get("Binds") != null && !jsonObj.get("Binds").isJsonNull()) && !jsonObj.get("Binds").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `Binds` to be an array in the JSON string but got `%s`", jsonObj.get("Binds").toString()));
      }
      if (jsonObj.get("BlkioDeviceReadBps") != null && !jsonObj.get("BlkioDeviceReadBps").isJsonNull()) {
        JsonArray jsonArrayblkioDeviceReadBps = jsonObj.getAsJsonArray("BlkioDeviceReadBps");
        if (jsonArrayblkioDeviceReadBps != null) {
          // ensure the json data is an array
          if (!jsonObj.get("BlkioDeviceReadBps").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `BlkioDeviceReadBps` to be an array in the JSON string but got `%s`", jsonObj.get("BlkioDeviceReadBps").toString()));
          }

          // validate the optional field `BlkioDeviceReadBps` (array)
          for (int i = 0; i < jsonArrayblkioDeviceReadBps.size(); i++) {
            ThrottleDevice.validateJsonObject(jsonArrayblkioDeviceReadBps.get(i).getAsJsonObject());
          };
        }
      }
      if (jsonObj.get("BlkioDeviceReadIOps") != null && !jsonObj.get("BlkioDeviceReadIOps").isJsonNull()) {
        JsonArray jsonArrayblkioDeviceReadIOps = jsonObj.getAsJsonArray("BlkioDeviceReadIOps");
        if (jsonArrayblkioDeviceReadIOps != null) {
          // ensure the json data is an array
          if (!jsonObj.get("BlkioDeviceReadIOps").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `BlkioDeviceReadIOps` to be an array in the JSON string but got `%s`", jsonObj.get("BlkioDeviceReadIOps").toString()));
          }

          // validate the optional field `BlkioDeviceReadIOps` (array)
          for (int i = 0; i < jsonArrayblkioDeviceReadIOps.size(); i++) {
            ThrottleDevice.validateJsonObject(jsonArrayblkioDeviceReadIOps.get(i).getAsJsonObject());
          };
        }
      }
      if (jsonObj.get("BlkioDeviceWriteBps") != null && !jsonObj.get("BlkioDeviceWriteBps").isJsonNull()) {
        JsonArray jsonArrayblkioDeviceWriteBps = jsonObj.getAsJsonArray("BlkioDeviceWriteBps");
        if (jsonArrayblkioDeviceWriteBps != null) {
          // ensure the json data is an array
          if (!jsonObj.get("BlkioDeviceWriteBps").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `BlkioDeviceWriteBps` to be an array in the JSON string but got `%s`", jsonObj.get("BlkioDeviceWriteBps").toString()));
          }

          // validate the optional field `BlkioDeviceWriteBps` (array)
          for (int i = 0; i < jsonArrayblkioDeviceWriteBps.size(); i++) {
            ThrottleDevice.validateJsonObject(jsonArrayblkioDeviceWriteBps.get(i).getAsJsonObject());
          };
        }
      }
      if (jsonObj.get("BlkioDeviceWriteIOps") != null && !jsonObj.get("BlkioDeviceWriteIOps").isJsonNull()) {
        JsonArray jsonArrayblkioDeviceWriteIOps = jsonObj.getAsJsonArray("BlkioDeviceWriteIOps");
        if (jsonArrayblkioDeviceWriteIOps != null) {
          // ensure the json data is an array
          if (!jsonObj.get("BlkioDeviceWriteIOps").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `BlkioDeviceWriteIOps` to be an array in the JSON string but got `%s`", jsonObj.get("BlkioDeviceWriteIOps").toString()));
          }

          // validate the optional field `BlkioDeviceWriteIOps` (array)
          for (int i = 0; i < jsonArrayblkioDeviceWriteIOps.size(); i++) {
            ThrottleDevice.validateJsonObject(jsonArrayblkioDeviceWriteIOps.get(i).getAsJsonObject());
          };
        }
      }
      if (jsonObj.get("BlkioWeightDevice") != null && !jsonObj.get("BlkioWeightDevice").isJsonNull()) {
        JsonArray jsonArrayblkioWeightDevice = jsonObj.getAsJsonArray("BlkioWeightDevice");
        if (jsonArrayblkioWeightDevice != null) {
          // ensure the json data is an array
          if (!jsonObj.get("BlkioWeightDevice").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `BlkioWeightDevice` to be an array in the JSON string but got `%s`", jsonObj.get("BlkioWeightDevice").toString()));
          }

          // validate the optional field `BlkioWeightDevice` (array)
          for (int i = 0; i < jsonArrayblkioWeightDevice.size(); i++) {
            WeightDevice.validateJsonObject(jsonArrayblkioWeightDevice.get(i).getAsJsonObject());
          };
        }
      }
      // ensure the json data is an array
      if ((jsonObj.get("CapAdd") != null && !jsonObj.get("CapAdd").isJsonNull()) && !jsonObj.get("CapAdd").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `CapAdd` to be an array in the JSON string but got `%s`", jsonObj.get("CapAdd").toString()));
      }
      // ensure the json data is an array
      if ((jsonObj.get("CapDrop") != null && !jsonObj.get("CapDrop").isJsonNull()) && !jsonObj.get("CapDrop").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `CapDrop` to be an array in the JSON string but got `%s`", jsonObj.get("CapDrop").toString()));
      }
      if ((jsonObj.get("Cgroup") != null && !jsonObj.get("Cgroup").isJsonNull()) && !jsonObj.get("Cgroup").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `Cgroup` to be a primitive type in the JSON string but got `%s`", jsonObj.get("Cgroup").toString()));
      }
      if ((jsonObj.get("CgroupParent") != null && !jsonObj.get("CgroupParent").isJsonNull()) && !jsonObj.get("CgroupParent").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `CgroupParent` to be a primitive type in the JSON string but got `%s`", jsonObj.get("CgroupParent").toString()));
      }
      if ((jsonObj.get("CgroupnsMode") != null && !jsonObj.get("CgroupnsMode").isJsonNull()) && !jsonObj.get("CgroupnsMode").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `CgroupnsMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get("CgroupnsMode").toString()));
      }
      // ensure the json data is an array
      if ((jsonObj.get("ConsoleSize") != null && !jsonObj.get("ConsoleSize").isJsonNull()) && !jsonObj.get("ConsoleSize").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `ConsoleSize` to be an array in the JSON string but got `%s`", jsonObj.get("ConsoleSize").toString()));
      }
      if ((jsonObj.get("ContainerIDFile") != null && !jsonObj.get("ContainerIDFile").isJsonNull()) && !jsonObj.get("ContainerIDFile").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `ContainerIDFile` to be a primitive type in the JSON string but got `%s`", jsonObj.get("ContainerIDFile").toString()));
      }
      if ((jsonObj.get("CpusetCpus") != null && !jsonObj.get("CpusetCpus").isJsonNull()) && !jsonObj.get("CpusetCpus").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `CpusetCpus` to be a primitive type in the JSON string but got `%s`", jsonObj.get("CpusetCpus").toString()));
      }
      if ((jsonObj.get("CpusetMems") != null && !jsonObj.get("CpusetMems").isJsonNull()) && !jsonObj.get("CpusetMems").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `CpusetMems` to be a primitive type in the JSON string but got `%s`", jsonObj.get("CpusetMems").toString()));
      }
      // ensure the json data is an array
      if ((jsonObj.get("DeviceCgroupRules") != null && !jsonObj.get("DeviceCgroupRules").isJsonNull()) && !jsonObj.get("DeviceCgroupRules").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `DeviceCgroupRules` to be an array in the JSON string but got `%s`", jsonObj.get("DeviceCgroupRules").toString()));
      }
      if (jsonObj.get("DeviceRequests") != null && !jsonObj.get("DeviceRequests").isJsonNull()) {
        JsonArray jsonArraydeviceRequests = jsonObj.getAsJsonArray("DeviceRequests");
        if (jsonArraydeviceRequests != null) {
          // ensure the json data is an array
          if (!jsonObj.get("DeviceRequests").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `DeviceRequests` to be an array in the JSON string but got `%s`", jsonObj.get("DeviceRequests").toString()));
          }

          // validate the optional field `DeviceRequests` (array)
          for (int i = 0; i < jsonArraydeviceRequests.size(); i++) {
            DeviceRequest.validateJsonObject(jsonArraydeviceRequests.get(i).getAsJsonObject());
          };
        }
      }
      if (jsonObj.get("Devices") != null && !jsonObj.get("Devices").isJsonNull()) {
        JsonArray jsonArraydevices = jsonObj.getAsJsonArray("Devices");
        if (jsonArraydevices != null) {
          // ensure the json data is an array
          if (!jsonObj.get("Devices").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Devices` to be an array in the JSON string but got `%s`", jsonObj.get("Devices").toString()));
          }

          // validate the optional field `Devices` (array)
          for (int i = 0; i < jsonArraydevices.size(); i++) {
            DeviceMapping.validateJsonObject(jsonArraydevices.get(i).getAsJsonObject());
          };
        }
      }
      // ensure the json data is an array
      if ((jsonObj.get("Dns") != null && !jsonObj.get("Dns").isJsonNull()) && !jsonObj.get("Dns").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `Dns` to be an array in the JSON string but got `%s`", jsonObj.get("Dns").toString()));
      }
      // ensure the json data is an array
      if ((jsonObj.get("DnsOptions") != null && !jsonObj.get("DnsOptions").isJsonNull()) && !jsonObj.get("DnsOptions").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `DnsOptions` to be an array in the JSON string but got `%s`", jsonObj.get("DnsOptions").toString()));
      }
      // ensure the json data is an array
      if ((jsonObj.get("DnsSearch") != null && !jsonObj.get("DnsSearch").isJsonNull()) && !jsonObj.get("DnsSearch").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `DnsSearch` to be an array in the JSON string but got `%s`", jsonObj.get("DnsSearch").toString()));
      }
      // ensure the json data is an array
      if ((jsonObj.get("ExtraHosts") != null && !jsonObj.get("ExtraHosts").isJsonNull()) && !jsonObj.get("ExtraHosts").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `ExtraHosts` to be an array in the JSON string but got `%s`", jsonObj.get("ExtraHosts").toString()));
      }
      // ensure the json data is an array
      if ((jsonObj.get("GroupAdd") != null && !jsonObj.get("GroupAdd").isJsonNull()) && !jsonObj.get("GroupAdd").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `GroupAdd` to be an array in the JSON string but got `%s`", jsonObj.get("GroupAdd").toString()));
      }
      if ((jsonObj.get("IpcMode") != null && !jsonObj.get("IpcMode").isJsonNull()) && !jsonObj.get("IpcMode").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `IpcMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get("IpcMode").toString()));
      }
      if ((jsonObj.get("Isolation") != null && !jsonObj.get("Isolation").isJsonNull()) && !jsonObj.get("Isolation").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `Isolation` to be a primitive type in the JSON string but got `%s`", jsonObj.get("Isolation").toString()));
      }
      // ensure the json data is an array
      if ((jsonObj.get("Links") != null && !jsonObj.get("Links").isJsonNull()) && !jsonObj.get("Links").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `Links` to be an array in the JSON string but got `%s`", jsonObj.get("Links").toString()));
      }
      // validate the optional field `LogConfig`
      if (jsonObj.get("LogConfig") != null && !jsonObj.get("LogConfig").isJsonNull()) {
        LogConfig.validateJsonObject(jsonObj.getAsJsonObject("LogConfig"));
      }
      // ensure the json data is an array
      if ((jsonObj.get("MaskedPaths") != null && !jsonObj.get("MaskedPaths").isJsonNull()) && !jsonObj.get("MaskedPaths").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `MaskedPaths` to be an array in the JSON string but got `%s`", jsonObj.get("MaskedPaths").toString()));
      }
      if (jsonObj.get("Mounts") != null && !jsonObj.get("Mounts").isJsonNull()) {
        JsonArray jsonArraymounts = jsonObj.getAsJsonArray("Mounts");
        if (jsonArraymounts != null) {
          // ensure the json data is an array
          if (!jsonObj.get("Mounts").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Mounts` to be an array in the JSON string but got `%s`", jsonObj.get("Mounts").toString()));
          }

          // validate the optional field `Mounts` (array)
          for (int i = 0; i < jsonArraymounts.size(); i++) {
            Mount.validateJsonObject(jsonArraymounts.get(i).getAsJsonObject());
          };
        }
      }
      if ((jsonObj.get("NetworkMode") != null && !jsonObj.get("NetworkMode").isJsonNull()) && !jsonObj.get("NetworkMode").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `NetworkMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get("NetworkMode").toString()));
      }
      if ((jsonObj.get("PidMode") != null && !jsonObj.get("PidMode").isJsonNull()) && !jsonObj.get("PidMode").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `PidMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get("PidMode").toString()));
      }
      // ensure the json data is an array
      if ((jsonObj.get("ReadonlyPaths") != null && !jsonObj.get("ReadonlyPaths").isJsonNull()) && !jsonObj.get("ReadonlyPaths").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `ReadonlyPaths` to be an array in the JSON string but got `%s`", jsonObj.get("ReadonlyPaths").toString()));
      }
      // validate the optional field `RestartPolicy`
      if (jsonObj.get("RestartPolicy") != null && !jsonObj.get("RestartPolicy").isJsonNull()) {
        RestartPolicy.validateJsonObject(jsonObj.getAsJsonObject("RestartPolicy"));
      }
      if ((jsonObj.get("Runtime") != null && !jsonObj.get("Runtime").isJsonNull()) && !jsonObj.get("Runtime").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `Runtime` to be a primitive type in the JSON string but got `%s`", jsonObj.get("Runtime").toString()));
      }
      // ensure the json data is an array
      if ((jsonObj.get("SecurityOpt") != null && !jsonObj.get("SecurityOpt").isJsonNull()) && !jsonObj.get("SecurityOpt").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `SecurityOpt` to be an array in the JSON string but got `%s`", jsonObj.get("SecurityOpt").toString()));
      }
      if ((jsonObj.get("UTSMode") != null && !jsonObj.get("UTSMode").isJsonNull()) && !jsonObj.get("UTSMode").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `UTSMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get("UTSMode").toString()));
      }
      if (jsonObj.get("Ulimits") != null && !jsonObj.get("Ulimits").isJsonNull()) {
        JsonArray jsonArrayulimits = jsonObj.getAsJsonArray("Ulimits");
        if (jsonArrayulimits != null) {
          // ensure the json data is an array
          if (!jsonObj.get("Ulimits").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Ulimits` to be an array in the JSON string but got `%s`", jsonObj.get("Ulimits").toString()));
          }

          // validate the optional field `Ulimits` (array)
          for (int i = 0; i < jsonArrayulimits.size(); i++) {
            Ulimit.validateJsonObject(jsonArrayulimits.get(i).getAsJsonObject());
          };
        }
      }
      if ((jsonObj.get("UsernsMode") != null && !jsonObj.get("UsernsMode").isJsonNull()) && !jsonObj.get("UsernsMode").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `UsernsMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get("UsernsMode").toString()));
      }
      if ((jsonObj.get("VolumeDriver") != null && !jsonObj.get("VolumeDriver").isJsonNull()) && !jsonObj.get("VolumeDriver").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `VolumeDriver` to be a primitive type in the JSON string but got `%s`", jsonObj.get("VolumeDriver").toString()));
      }
      // ensure the json data is an array
      if ((jsonObj.get("VolumesFrom") != null && !jsonObj.get("VolumesFrom").isJsonNull()) && !jsonObj.get("VolumesFrom").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `VolumesFrom` to be an array in the JSON string but got `%s`", jsonObj.get("VolumesFrom").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!HostConfig.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'HostConfig' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<HostConfig> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(HostConfig.class));

       return (TypeAdapter<T>) new TypeAdapter<HostConfig>() {
           @Override
           public void write(JsonWriter out, HostConfig value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public HostConfig read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of HostConfig given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of HostConfig
  * @throws IOException if the JSON string is invalid with respect to HostConfig
  */
  public static HostConfig fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, HostConfig.class);
  }

 /**
  * Convert an instance of HostConfig to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

