/*
 * supports a RESTful API for the Libpod library
 * This documentation describes the Podman v2.x+ RESTful API. It consists of a Docker-compatible API and a Libpod API providing support for Podman’s unique features such as pods.  To start the service and keep it running for 5,000 seconds (-t 0 runs forever):  podman system service -t 5000 &  You can then use cURL on the socket using requests documented below.  NOTE: if you install the package podman-docker, it will create a symbolic link for /run/docker.sock to /run/podman/podman.sock  NOTE: Some fields in the API response JSON are encoded as omitempty, which means that if said field has a zero value, they will not be encoded in the API response. This is a feature to help reduce the size of the JSON responses returned via the API.  NOTE: Due to the limitations of [go-swagger](https://github.com/go-swagger/go-swagger), some field values that have a complex type show up as null in the docs as well as in the API responses. This is because the zero value for the field type is null. The field description in the docs will state what type the field is expected to be for such cases.  See podman-system-service(1) for more information.  Quick Examples:  'podman info'  curl --unix-socket /run/podman/podman.sock http://d/v5.0.0/libpod/info  'podman pull quay.io/containers/podman'  curl -XPOST --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/images/create?fromImage=quay.io%2Fcontainers%2Fpodman'  'podman list images'  curl --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/libpod/images/json' | jq
 *
 * The version of the OpenAPI document: 5.0.0
 * Contact: podman@lists.podman.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.pod4dev.libpodj.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.model.ImageVolume;
import io.github.pod4dev.libpodj.model.Mount;
import io.github.pod4dev.libpodj.model.NamedVolume;
import io.github.pod4dev.libpodj.model.OverlayVolume;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.io.Serializable;
import javax.validation.constraints.*;
import javax.validation.Valid;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import io.github.pod4dev.libpodj.JSON;

/**
 * PodStorageConfig
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class PodStorageConfig implements Serializable {
  private static final long serialVersionUID = 1L;

  public static final String SERIALIZED_NAME_IMAGE_VOLUMES = "image_volumes";
  @SerializedName(SERIALIZED_NAME_IMAGE_VOLUMES)
  private List<ImageVolume> imageVolumes = null;

  public static final String SERIALIZED_NAME_MOUNTS = "mounts";
  @SerializedName(SERIALIZED_NAME_MOUNTS)
  private List<Mount> mounts = null;

  public static final String SERIALIZED_NAME_OVERLAY_VOLUMES = "overlay_volumes";
  @SerializedName(SERIALIZED_NAME_OVERLAY_VOLUMES)
  private List<OverlayVolume> overlayVolumes = null;

  public static final String SERIALIZED_NAME_SHM_SIZE = "shm_size";
  @SerializedName(SERIALIZED_NAME_SHM_SIZE)
  private Long shmSize;

  public static final String SERIALIZED_NAME_SHM_SIZE_SYSTEMD = "shm_size_systemd";
  @SerializedName(SERIALIZED_NAME_SHM_SIZE_SYSTEMD)
  private Long shmSizeSystemd;

  public static final String SERIALIZED_NAME_VOLUMES = "volumes";
  @SerializedName(SERIALIZED_NAME_VOLUMES)
  private List<NamedVolume> volumes = null;

  public static final String SERIALIZED_NAME_VOLUMES_FROM = "volumes_from";
  @SerializedName(SERIALIZED_NAME_VOLUMES_FROM)
  private List<String> volumesFrom = null;

  public PodStorageConfig() {
  }

  public PodStorageConfig imageVolumes(List<ImageVolume> imageVolumes) {
    
    this.imageVolumes = imageVolumes;
    return this;
  }

  public PodStorageConfig addImageVolumesItem(ImageVolume imageVolumesItem) {
    if (this.imageVolumes == null) {
      this.imageVolumes = new ArrayList<>();
    }
    this.imageVolumes.add(imageVolumesItem);
    return this;
  }

   /**
   * Image volumes bind-mount a container-image mount into the pod&#39;s infra container. Optional.
   * @return imageVolumes
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Image volumes bind-mount a container-image mount into the pod's infra container. Optional.")

  public List<ImageVolume> getImageVolumes() {
    return imageVolumes;
  }


  public void setImageVolumes(List<ImageVolume> imageVolumes) {
    this.imageVolumes = imageVolumes;
  }


  public PodStorageConfig mounts(List<Mount> mounts) {
    
    this.mounts = mounts;
    return this;
  }

  public PodStorageConfig addMountsItem(Mount mountsItem) {
    if (this.mounts == null) {
      this.mounts = new ArrayList<>();
    }
    this.mounts.add(mountsItem);
    return this;
  }

   /**
   * Mounts are mounts that will be added to the pod. These will supersede Image Volumes and VolumesFrom volumes where there are conflicts. Optional.
   * @return mounts
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Mounts are mounts that will be added to the pod. These will supersede Image Volumes and VolumesFrom volumes where there are conflicts. Optional.")

  public List<Mount> getMounts() {
    return mounts;
  }


  public void setMounts(List<Mount> mounts) {
    this.mounts = mounts;
  }


  public PodStorageConfig overlayVolumes(List<OverlayVolume> overlayVolumes) {
    
    this.overlayVolumes = overlayVolumes;
    return this;
  }

  public PodStorageConfig addOverlayVolumesItem(OverlayVolume overlayVolumesItem) {
    if (this.overlayVolumes == null) {
      this.overlayVolumes = new ArrayList<>();
    }
    this.overlayVolumes.add(overlayVolumesItem);
    return this;
  }

   /**
   * Overlay volumes are named volumes that will be added to the pod. Optional.
   * @return overlayVolumes
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Overlay volumes are named volumes that will be added to the pod. Optional.")

  public List<OverlayVolume> getOverlayVolumes() {
    return overlayVolumes;
  }


  public void setOverlayVolumes(List<OverlayVolume> overlayVolumes) {
    this.overlayVolumes = overlayVolumes;
  }


  public PodStorageConfig shmSize(Long shmSize) {
    
    this.shmSize = shmSize;
    return this;
  }

   /**
   * ShmSize is the size of the tmpfs to mount in at /dev/shm, in bytes. Conflicts with ShmSize if IpcNS is not private. Optional.
   * @return shmSize
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "ShmSize is the size of the tmpfs to mount in at /dev/shm, in bytes. Conflicts with ShmSize if IpcNS is not private. Optional.")

  public Long getShmSize() {
    return shmSize;
  }


  public void setShmSize(Long shmSize) {
    this.shmSize = shmSize;
  }


  public PodStorageConfig shmSizeSystemd(Long shmSizeSystemd) {
    
    this.shmSizeSystemd = shmSizeSystemd;
    return this;
  }

   /**
   * ShmSizeSystemd is the size of systemd-specific tmpfs mounts specifically /run, /run/lock, /var/log/journal and /tmp. Optional
   * @return shmSizeSystemd
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "ShmSizeSystemd is the size of systemd-specific tmpfs mounts specifically /run, /run/lock, /var/log/journal and /tmp. Optional")

  public Long getShmSizeSystemd() {
    return shmSizeSystemd;
  }


  public void setShmSizeSystemd(Long shmSizeSystemd) {
    this.shmSizeSystemd = shmSizeSystemd;
  }


  public PodStorageConfig volumes(List<NamedVolume> volumes) {
    
    this.volumes = volumes;
    return this;
  }

  public PodStorageConfig addVolumesItem(NamedVolume volumesItem) {
    if (this.volumes == null) {
      this.volumes = new ArrayList<>();
    }
    this.volumes.add(volumesItem);
    return this;
  }

   /**
   * Volumes are named volumes that will be added to the pod. These will supersede Image Volumes and VolumesFrom  volumes where there are conflicts. Optional.
   * @return volumes
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "Volumes are named volumes that will be added to the pod. These will supersede Image Volumes and VolumesFrom  volumes where there are conflicts. Optional.")

  public List<NamedVolume> getVolumes() {
    return volumes;
  }


  public void setVolumes(List<NamedVolume> volumes) {
    this.volumes = volumes;
  }


  public PodStorageConfig volumesFrom(List<String> volumesFrom) {
    
    this.volumesFrom = volumesFrom;
    return this;
  }

  public PodStorageConfig addVolumesFromItem(String volumesFromItem) {
    if (this.volumesFrom == null) {
      this.volumesFrom = new ArrayList<>();
    }
    this.volumesFrom.add(volumesFromItem);
    return this;
  }

   /**
   * VolumesFrom is a set of containers whose volumes will be added to this pod. The name or ID of the container must be provided, and may optionally be followed by a : and then one or more comma-separated options. Valid options are &#39;ro&#39;, &#39;rw&#39;, and &#39;z&#39;. Options will be used for all volumes sourced from the container.
   * @return volumesFrom
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "VolumesFrom is a set of containers whose volumes will be added to this pod. The name or ID of the container must be provided, and may optionally be followed by a : and then one or more comma-separated options. Valid options are 'ro', 'rw', and 'z'. Options will be used for all volumes sourced from the container.")

  public List<String> getVolumesFrom() {
    return volumesFrom;
  }


  public void setVolumesFrom(List<String> volumesFrom) {
    this.volumesFrom = volumesFrom;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PodStorageConfig podStorageConfig = (PodStorageConfig) o;
    return Objects.equals(this.imageVolumes, podStorageConfig.imageVolumes) &&
        Objects.equals(this.mounts, podStorageConfig.mounts) &&
        Objects.equals(this.overlayVolumes, podStorageConfig.overlayVolumes) &&
        Objects.equals(this.shmSize, podStorageConfig.shmSize) &&
        Objects.equals(this.shmSizeSystemd, podStorageConfig.shmSizeSystemd) &&
        Objects.equals(this.volumes, podStorageConfig.volumes) &&
        Objects.equals(this.volumesFrom, podStorageConfig.volumesFrom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(imageVolumes, mounts, overlayVolumes, shmSize, shmSizeSystemd, volumes, volumesFrom);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PodStorageConfig {\n");
    sb.append("    imageVolumes: ").append(toIndentedString(imageVolumes)).append("\n");
    sb.append("    mounts: ").append(toIndentedString(mounts)).append("\n");
    sb.append("    overlayVolumes: ").append(toIndentedString(overlayVolumes)).append("\n");
    sb.append("    shmSize: ").append(toIndentedString(shmSize)).append("\n");
    sb.append("    shmSizeSystemd: ").append(toIndentedString(shmSizeSystemd)).append("\n");
    sb.append("    volumes: ").append(toIndentedString(volumes)).append("\n");
    sb.append("    volumesFrom: ").append(toIndentedString(volumesFrom)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("image_volumes");
    openapiFields.add("mounts");
    openapiFields.add("overlay_volumes");
    openapiFields.add("shm_size");
    openapiFields.add("shm_size_systemd");
    openapiFields.add("volumes");
    openapiFields.add("volumes_from");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to PodStorageConfig
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (PodStorageConfig.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in PodStorageConfig is not found in the empty JSON string", PodStorageConfig.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!PodStorageConfig.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PodStorageConfig` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if (jsonObj.get("image_volumes") != null && !jsonObj.get("image_volumes").isJsonNull()) {
        JsonArray jsonArrayimageVolumes = jsonObj.getAsJsonArray("image_volumes");
        if (jsonArrayimageVolumes != null) {
          // ensure the json data is an array
          if (!jsonObj.get("image_volumes").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `image_volumes` to be an array in the JSON string but got `%s`", jsonObj.get("image_volumes").toString()));
          }

          // validate the optional field `image_volumes` (array)
          for (int i = 0; i < jsonArrayimageVolumes.size(); i++) {
            ImageVolume.validateJsonObject(jsonArrayimageVolumes.get(i).getAsJsonObject());
          };
        }
      }
      if (jsonObj.get("mounts") != null && !jsonObj.get("mounts").isJsonNull()) {
        JsonArray jsonArraymounts = jsonObj.getAsJsonArray("mounts");
        if (jsonArraymounts != null) {
          // ensure the json data is an array
          if (!jsonObj.get("mounts").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `mounts` to be an array in the JSON string but got `%s`", jsonObj.get("mounts").toString()));
          }

          // validate the optional field `mounts` (array)
          for (int i = 0; i < jsonArraymounts.size(); i++) {
            Mount.validateJsonObject(jsonArraymounts.get(i).getAsJsonObject());
          };
        }
      }
      if (jsonObj.get("overlay_volumes") != null && !jsonObj.get("overlay_volumes").isJsonNull()) {
        JsonArray jsonArrayoverlayVolumes = jsonObj.getAsJsonArray("overlay_volumes");
        if (jsonArrayoverlayVolumes != null) {
          // ensure the json data is an array
          if (!jsonObj.get("overlay_volumes").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `overlay_volumes` to be an array in the JSON string but got `%s`", jsonObj.get("overlay_volumes").toString()));
          }

          // validate the optional field `overlay_volumes` (array)
          for (int i = 0; i < jsonArrayoverlayVolumes.size(); i++) {
            OverlayVolume.validateJsonObject(jsonArrayoverlayVolumes.get(i).getAsJsonObject());
          };
        }
      }
      if (jsonObj.get("volumes") != null && !jsonObj.get("volumes").isJsonNull()) {
        JsonArray jsonArrayvolumes = jsonObj.getAsJsonArray("volumes");
        if (jsonArrayvolumes != null) {
          // ensure the json data is an array
          if (!jsonObj.get("volumes").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `volumes` to be an array in the JSON string but got `%s`", jsonObj.get("volumes").toString()));
          }

          // validate the optional field `volumes` (array)
          for (int i = 0; i < jsonArrayvolumes.size(); i++) {
            NamedVolume.validateJsonObject(jsonArrayvolumes.get(i).getAsJsonObject());
          };
        }
      }
      // ensure the json data is an array
      if ((jsonObj.get("volumes_from") != null && !jsonObj.get("volumes_from").isJsonNull()) && !jsonObj.get("volumes_from").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `volumes_from` to be an array in the JSON string but got `%s`", jsonObj.get("volumes_from").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!PodStorageConfig.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'PodStorageConfig' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<PodStorageConfig> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(PodStorageConfig.class));

       return (TypeAdapter<T>) new TypeAdapter<PodStorageConfig>() {
           @Override
           public void write(JsonWriter out, PodStorageConfig value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public PodStorageConfig read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of PodStorageConfig given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of PodStorageConfig
  * @throws IOException if the JSON string is invalid with respect to PodStorageConfig
  */
  public static PodStorageConfig fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, PodStorageConfig.class);
  }

 /**
  * Convert an instance of PodStorageConfig to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

