/*
 * supports a RESTful API for the Libpod library
 * This documentation describes the Podman v2.x+ RESTful API. It consists of a Docker-compatible API and a Libpod API providing support for Podman’s unique features such as pods.  To start the service and keep it running for 5,000 seconds (-t 0 runs forever):  podman system service -t 5000 &  You can then use cURL on the socket using requests documented below.  NOTE: if you install the package podman-docker, it will create a symbolic link for /run/docker.sock to /run/podman/podman.sock  NOTE: Some fields in the API response JSON are encoded as omitempty, which means that if said field has a zero value, they will not be encoded in the API response. This is a feature to help reduce the size of the JSON responses returned via the API.  NOTE: Due to the limitations of [go-swagger](https://github.com/go-swagger/go-swagger), some field values that have a complex type show up as null in the docs as well as in the API responses. This is because the zero value for the field type is null. The field description in the docs will state what type the field is expected to be for such cases.  See podman-system-service(1) for more information.  Quick Examples:  'podman info'  curl --unix-socket /run/podman/podman.sock http://d/v5.0.0/libpod/info  'podman pull quay.io/containers/podman'  curl -XPOST --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/images/create?fromImage=quay.io%2Fcontainers%2Fpodman'  'podman list images'  curl --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/libpod/images/json' | jq
 *
 * The version of the OpenAPI document: 5.0.0
 * Contact: podman@lists.podman.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.pod4dev.libpodj.model;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.model.DeviceMapping;
import io.github.pod4dev.libpodj.model.DeviceRequest;
import io.github.pod4dev.libpodj.model.ThrottleDevice;
import io.github.pod4dev.libpodj.model.Ulimit;
import io.github.pod4dev.libpodj.model.WeightDevice;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.io.Serializable;
import javax.validation.constraints.*;
import javax.validation.Valid;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;

import io.github.pod4dev.libpodj.JSON;

/**
 * Resources contains container&#39;s resources (cgroups config, ulimits...)
 */
@ApiModel(description = "Resources contains container's resources (cgroups config, ulimits...)")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class Resources implements Serializable {
  private static final long serialVersionUID = 1L;

  public static final String SERIALIZED_NAME_BLKIO_DEVICE_READ_BPS = "BlkioDeviceReadBps";
  @SerializedName(SERIALIZED_NAME_BLKIO_DEVICE_READ_BPS)
  private List<ThrottleDevice> blkioDeviceReadBps = null;

  public static final String SERIALIZED_NAME_BLKIO_DEVICE_READ_I_OPS = "BlkioDeviceReadIOps";
  @SerializedName(SERIALIZED_NAME_BLKIO_DEVICE_READ_I_OPS)
  private List<ThrottleDevice> blkioDeviceReadIOps = null;

  public static final String SERIALIZED_NAME_BLKIO_DEVICE_WRITE_BPS = "BlkioDeviceWriteBps";
  @SerializedName(SERIALIZED_NAME_BLKIO_DEVICE_WRITE_BPS)
  private List<ThrottleDevice> blkioDeviceWriteBps = null;

  public static final String SERIALIZED_NAME_BLKIO_DEVICE_WRITE_I_OPS = "BlkioDeviceWriteIOps";
  @SerializedName(SERIALIZED_NAME_BLKIO_DEVICE_WRITE_I_OPS)
  private List<ThrottleDevice> blkioDeviceWriteIOps = null;

  public static final String SERIALIZED_NAME_BLKIO_WEIGHT = "BlkioWeight";
  @SerializedName(SERIALIZED_NAME_BLKIO_WEIGHT)
  private Integer blkioWeight;

  public static final String SERIALIZED_NAME_BLKIO_WEIGHT_DEVICE = "BlkioWeightDevice";
  @SerializedName(SERIALIZED_NAME_BLKIO_WEIGHT_DEVICE)
  private List<WeightDevice> blkioWeightDevice = null;

  public static final String SERIALIZED_NAME_CGROUP_PARENT = "CgroupParent";
  @SerializedName(SERIALIZED_NAME_CGROUP_PARENT)
  private String cgroupParent;

  public static final String SERIALIZED_NAME_CPU_COUNT = "CpuCount";
  @SerializedName(SERIALIZED_NAME_CPU_COUNT)
  private Long cpuCount;

  public static final String SERIALIZED_NAME_CPU_PERCENT = "CpuPercent";
  @SerializedName(SERIALIZED_NAME_CPU_PERCENT)
  private Long cpuPercent;

  public static final String SERIALIZED_NAME_CPU_PERIOD = "CpuPeriod";
  @SerializedName(SERIALIZED_NAME_CPU_PERIOD)
  private Long cpuPeriod;

  public static final String SERIALIZED_NAME_CPU_QUOTA = "CpuQuota";
  @SerializedName(SERIALIZED_NAME_CPU_QUOTA)
  private Long cpuQuota;

  public static final String SERIALIZED_NAME_CPU_REALTIME_PERIOD = "CpuRealtimePeriod";
  @SerializedName(SERIALIZED_NAME_CPU_REALTIME_PERIOD)
  private Long cpuRealtimePeriod;

  public static final String SERIALIZED_NAME_CPU_REALTIME_RUNTIME = "CpuRealtimeRuntime";
  @SerializedName(SERIALIZED_NAME_CPU_REALTIME_RUNTIME)
  private Long cpuRealtimeRuntime;

  public static final String SERIALIZED_NAME_CPU_SHARES = "CpuShares";
  @SerializedName(SERIALIZED_NAME_CPU_SHARES)
  private Long cpuShares;

  public static final String SERIALIZED_NAME_CPUSET_CPUS = "CpusetCpus";
  @SerializedName(SERIALIZED_NAME_CPUSET_CPUS)
  private String cpusetCpus;

  public static final String SERIALIZED_NAME_CPUSET_MEMS = "CpusetMems";
  @SerializedName(SERIALIZED_NAME_CPUSET_MEMS)
  private String cpusetMems;

  public static final String SERIALIZED_NAME_DEVICE_CGROUP_RULES = "DeviceCgroupRules";
  @SerializedName(SERIALIZED_NAME_DEVICE_CGROUP_RULES)
  private List<String> deviceCgroupRules = null;

  public static final String SERIALIZED_NAME_DEVICE_REQUESTS = "DeviceRequests";
  @SerializedName(SERIALIZED_NAME_DEVICE_REQUESTS)
  private List<DeviceRequest> deviceRequests = null;

  public static final String SERIALIZED_NAME_DEVICES = "Devices";
  @SerializedName(SERIALIZED_NAME_DEVICES)
  private List<DeviceMapping> devices = null;

  public static final String SERIALIZED_NAME_IO_MAXIMUM_BANDWIDTH = "IOMaximumBandwidth";
  @SerializedName(SERIALIZED_NAME_IO_MAXIMUM_BANDWIDTH)
  private Integer ioMaximumBandwidth;

  public static final String SERIALIZED_NAME_IO_MAXIMUM_I_OPS = "IOMaximumIOps";
  @SerializedName(SERIALIZED_NAME_IO_MAXIMUM_I_OPS)
  private Integer ioMaximumIOps;

  public static final String SERIALIZED_NAME_KERNEL_MEMORY = "KernelMemory";
  @SerializedName(SERIALIZED_NAME_KERNEL_MEMORY)
  private Long kernelMemory;

  public static final String SERIALIZED_NAME_KERNEL_MEMORY_T_C_P = "KernelMemoryTCP";
  @SerializedName(SERIALIZED_NAME_KERNEL_MEMORY_T_C_P)
  private Long kernelMemoryTCP;

  public static final String SERIALIZED_NAME_MEMORY = "Memory";
  @SerializedName(SERIALIZED_NAME_MEMORY)
  private Long memory;

  public static final String SERIALIZED_NAME_MEMORY_RESERVATION = "MemoryReservation";
  @SerializedName(SERIALIZED_NAME_MEMORY_RESERVATION)
  private Long memoryReservation;

  public static final String SERIALIZED_NAME_MEMORY_SWAP = "MemorySwap";
  @SerializedName(SERIALIZED_NAME_MEMORY_SWAP)
  private Long memorySwap;

  public static final String SERIALIZED_NAME_MEMORY_SWAPPINESS = "MemorySwappiness";
  @SerializedName(SERIALIZED_NAME_MEMORY_SWAPPINESS)
  private Long memorySwappiness;

  public static final String SERIALIZED_NAME_NANO_CPUS = "NanoCpus";
  @SerializedName(SERIALIZED_NAME_NANO_CPUS)
  private Long nanoCpus;

  public static final String SERIALIZED_NAME_OOM_KILL_DISABLE = "OomKillDisable";
  @SerializedName(SERIALIZED_NAME_OOM_KILL_DISABLE)
  private Boolean oomKillDisable;

  public static final String SERIALIZED_NAME_PIDS_LIMIT = "PidsLimit";
  @SerializedName(SERIALIZED_NAME_PIDS_LIMIT)
  private Long pidsLimit;

  public static final String SERIALIZED_NAME_ULIMITS = "Ulimits";
  @SerializedName(SERIALIZED_NAME_ULIMITS)
  private List<Ulimit> ulimits = null;

  public Resources() {
  }

  public Resources blkioDeviceReadBps(List<ThrottleDevice> blkioDeviceReadBps) {
    
    this.blkioDeviceReadBps = blkioDeviceReadBps;
    return this;
  }

  public Resources addBlkioDeviceReadBpsItem(ThrottleDevice blkioDeviceReadBpsItem) {
    if (this.blkioDeviceReadBps == null) {
      this.blkioDeviceReadBps = new ArrayList<>();
    }
    this.blkioDeviceReadBps.add(blkioDeviceReadBpsItem);
    return this;
  }

   /**
   * Get blkioDeviceReadBps
   * @return blkioDeviceReadBps
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public List<ThrottleDevice> getBlkioDeviceReadBps() {
    return blkioDeviceReadBps;
  }


  public void setBlkioDeviceReadBps(List<ThrottleDevice> blkioDeviceReadBps) {
    this.blkioDeviceReadBps = blkioDeviceReadBps;
  }


  public Resources blkioDeviceReadIOps(List<ThrottleDevice> blkioDeviceReadIOps) {
    
    this.blkioDeviceReadIOps = blkioDeviceReadIOps;
    return this;
  }

  public Resources addBlkioDeviceReadIOpsItem(ThrottleDevice blkioDeviceReadIOpsItem) {
    if (this.blkioDeviceReadIOps == null) {
      this.blkioDeviceReadIOps = new ArrayList<>();
    }
    this.blkioDeviceReadIOps.add(blkioDeviceReadIOpsItem);
    return this;
  }

   /**
   * Get blkioDeviceReadIOps
   * @return blkioDeviceReadIOps
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public List<ThrottleDevice> getBlkioDeviceReadIOps() {
    return blkioDeviceReadIOps;
  }


  public void setBlkioDeviceReadIOps(List<ThrottleDevice> blkioDeviceReadIOps) {
    this.blkioDeviceReadIOps = blkioDeviceReadIOps;
  }


  public Resources blkioDeviceWriteBps(List<ThrottleDevice> blkioDeviceWriteBps) {
    
    this.blkioDeviceWriteBps = blkioDeviceWriteBps;
    return this;
  }

  public Resources addBlkioDeviceWriteBpsItem(ThrottleDevice blkioDeviceWriteBpsItem) {
    if (this.blkioDeviceWriteBps == null) {
      this.blkioDeviceWriteBps = new ArrayList<>();
    }
    this.blkioDeviceWriteBps.add(blkioDeviceWriteBpsItem);
    return this;
  }

   /**
   * Get blkioDeviceWriteBps
   * @return blkioDeviceWriteBps
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public List<ThrottleDevice> getBlkioDeviceWriteBps() {
    return blkioDeviceWriteBps;
  }


  public void setBlkioDeviceWriteBps(List<ThrottleDevice> blkioDeviceWriteBps) {
    this.blkioDeviceWriteBps = blkioDeviceWriteBps;
  }


  public Resources blkioDeviceWriteIOps(List<ThrottleDevice> blkioDeviceWriteIOps) {
    
    this.blkioDeviceWriteIOps = blkioDeviceWriteIOps;
    return this;
  }

  public Resources addBlkioDeviceWriteIOpsItem(ThrottleDevice blkioDeviceWriteIOpsItem) {
    if (this.blkioDeviceWriteIOps == null) {
      this.blkioDeviceWriteIOps = new ArrayList<>();
    }
    this.blkioDeviceWriteIOps.add(blkioDeviceWriteIOpsItem);
    return this;
  }

   /**
   * Get blkioDeviceWriteIOps
   * @return blkioDeviceWriteIOps
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public List<ThrottleDevice> getBlkioDeviceWriteIOps() {
    return blkioDeviceWriteIOps;
  }


  public void setBlkioDeviceWriteIOps(List<ThrottleDevice> blkioDeviceWriteIOps) {
    this.blkioDeviceWriteIOps = blkioDeviceWriteIOps;
  }


  public Resources blkioWeight(Integer blkioWeight) {
    
    this.blkioWeight = blkioWeight;
    return this;
  }

   /**
   * Get blkioWeight
   * @return blkioWeight
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Integer getBlkioWeight() {
    return blkioWeight;
  }


  public void setBlkioWeight(Integer blkioWeight) {
    this.blkioWeight = blkioWeight;
  }


  public Resources blkioWeightDevice(List<WeightDevice> blkioWeightDevice) {
    
    this.blkioWeightDevice = blkioWeightDevice;
    return this;
  }

  public Resources addBlkioWeightDeviceItem(WeightDevice blkioWeightDeviceItem) {
    if (this.blkioWeightDevice == null) {
      this.blkioWeightDevice = new ArrayList<>();
    }
    this.blkioWeightDevice.add(blkioWeightDeviceItem);
    return this;
  }

   /**
   * Get blkioWeightDevice
   * @return blkioWeightDevice
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public List<WeightDevice> getBlkioWeightDevice() {
    return blkioWeightDevice;
  }


  public void setBlkioWeightDevice(List<WeightDevice> blkioWeightDevice) {
    this.blkioWeightDevice = blkioWeightDevice;
  }


  public Resources cgroupParent(String cgroupParent) {
    
    this.cgroupParent = cgroupParent;
    return this;
  }

   /**
   * Applicable to UNIX platforms
   * @return cgroupParent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Applicable to UNIX platforms")

  public String getCgroupParent() {
    return cgroupParent;
  }


  public void setCgroupParent(String cgroupParent) {
    this.cgroupParent = cgroupParent;
  }


  public Resources cpuCount(Long cpuCount) {
    
    this.cpuCount = cpuCount;
    return this;
  }

   /**
   * Applicable to Windows
   * @return cpuCount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Applicable to Windows")

  public Long getCpuCount() {
    return cpuCount;
  }


  public void setCpuCount(Long cpuCount) {
    this.cpuCount = cpuCount;
  }


  public Resources cpuPercent(Long cpuPercent) {
    
    this.cpuPercent = cpuPercent;
    return this;
  }

   /**
   * Get cpuPercent
   * @return cpuPercent
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getCpuPercent() {
    return cpuPercent;
  }


  public void setCpuPercent(Long cpuPercent) {
    this.cpuPercent = cpuPercent;
  }


  public Resources cpuPeriod(Long cpuPeriod) {
    
    this.cpuPeriod = cpuPeriod;
    return this;
  }

   /**
   * Get cpuPeriod
   * @return cpuPeriod
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getCpuPeriod() {
    return cpuPeriod;
  }


  public void setCpuPeriod(Long cpuPeriod) {
    this.cpuPeriod = cpuPeriod;
  }


  public Resources cpuQuota(Long cpuQuota) {
    
    this.cpuQuota = cpuQuota;
    return this;
  }

   /**
   * Get cpuQuota
   * @return cpuQuota
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getCpuQuota() {
    return cpuQuota;
  }


  public void setCpuQuota(Long cpuQuota) {
    this.cpuQuota = cpuQuota;
  }


  public Resources cpuRealtimePeriod(Long cpuRealtimePeriod) {
    
    this.cpuRealtimePeriod = cpuRealtimePeriod;
    return this;
  }

   /**
   * Get cpuRealtimePeriod
   * @return cpuRealtimePeriod
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getCpuRealtimePeriod() {
    return cpuRealtimePeriod;
  }


  public void setCpuRealtimePeriod(Long cpuRealtimePeriod) {
    this.cpuRealtimePeriod = cpuRealtimePeriod;
  }


  public Resources cpuRealtimeRuntime(Long cpuRealtimeRuntime) {
    
    this.cpuRealtimeRuntime = cpuRealtimeRuntime;
    return this;
  }

   /**
   * Get cpuRealtimeRuntime
   * @return cpuRealtimeRuntime
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getCpuRealtimeRuntime() {
    return cpuRealtimeRuntime;
  }


  public void setCpuRealtimeRuntime(Long cpuRealtimeRuntime) {
    this.cpuRealtimeRuntime = cpuRealtimeRuntime;
  }


  public Resources cpuShares(Long cpuShares) {
    
    this.cpuShares = cpuShares;
    return this;
  }

   /**
   * Applicable to all platforms
   * @return cpuShares
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Applicable to all platforms")

  public Long getCpuShares() {
    return cpuShares;
  }


  public void setCpuShares(Long cpuShares) {
    this.cpuShares = cpuShares;
  }


  public Resources cpusetCpus(String cpusetCpus) {
    
    this.cpusetCpus = cpusetCpus;
    return this;
  }

   /**
   * Get cpusetCpus
   * @return cpusetCpus
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getCpusetCpus() {
    return cpusetCpus;
  }


  public void setCpusetCpus(String cpusetCpus) {
    this.cpusetCpus = cpusetCpus;
  }


  public Resources cpusetMems(String cpusetMems) {
    
    this.cpusetMems = cpusetMems;
    return this;
  }

   /**
   * Get cpusetMems
   * @return cpusetMems
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public String getCpusetMems() {
    return cpusetMems;
  }


  public void setCpusetMems(String cpusetMems) {
    this.cpusetMems = cpusetMems;
  }


  public Resources deviceCgroupRules(List<String> deviceCgroupRules) {
    
    this.deviceCgroupRules = deviceCgroupRules;
    return this;
  }

  public Resources addDeviceCgroupRulesItem(String deviceCgroupRulesItem) {
    if (this.deviceCgroupRules == null) {
      this.deviceCgroupRules = new ArrayList<>();
    }
    this.deviceCgroupRules.add(deviceCgroupRulesItem);
    return this;
  }

   /**
   * Get deviceCgroupRules
   * @return deviceCgroupRules
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<String> getDeviceCgroupRules() {
    return deviceCgroupRules;
  }


  public void setDeviceCgroupRules(List<String> deviceCgroupRules) {
    this.deviceCgroupRules = deviceCgroupRules;
  }


  public Resources deviceRequests(List<DeviceRequest> deviceRequests) {
    
    this.deviceRequests = deviceRequests;
    return this;
  }

  public Resources addDeviceRequestsItem(DeviceRequest deviceRequestsItem) {
    if (this.deviceRequests == null) {
      this.deviceRequests = new ArrayList<>();
    }
    this.deviceRequests.add(deviceRequestsItem);
    return this;
  }

   /**
   * Get deviceRequests
   * @return deviceRequests
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public List<DeviceRequest> getDeviceRequests() {
    return deviceRequests;
  }


  public void setDeviceRequests(List<DeviceRequest> deviceRequests) {
    this.deviceRequests = deviceRequests;
  }


  public Resources devices(List<DeviceMapping> devices) {
    
    this.devices = devices;
    return this;
  }

  public Resources addDevicesItem(DeviceMapping devicesItem) {
    if (this.devices == null) {
      this.devices = new ArrayList<>();
    }
    this.devices.add(devicesItem);
    return this;
  }

   /**
   * Get devices
   * @return devices
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public List<DeviceMapping> getDevices() {
    return devices;
  }


  public void setDevices(List<DeviceMapping> devices) {
    this.devices = devices;
  }


  public Resources ioMaximumBandwidth(Integer ioMaximumBandwidth) {
    
    this.ioMaximumBandwidth = ioMaximumBandwidth;
    return this;
  }

   /**
   * Get ioMaximumBandwidth
   * @return ioMaximumBandwidth
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Integer getIoMaximumBandwidth() {
    return ioMaximumBandwidth;
  }


  public void setIoMaximumBandwidth(Integer ioMaximumBandwidth) {
    this.ioMaximumBandwidth = ioMaximumBandwidth;
  }


  public Resources ioMaximumIOps(Integer ioMaximumIOps) {
    
    this.ioMaximumIOps = ioMaximumIOps;
    return this;
  }

   /**
   * Get ioMaximumIOps
   * @return ioMaximumIOps
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Integer getIoMaximumIOps() {
    return ioMaximumIOps;
  }


  public void setIoMaximumIOps(Integer ioMaximumIOps) {
    this.ioMaximumIOps = ioMaximumIOps;
  }


  public Resources kernelMemory(Long kernelMemory) {
    
    this.kernelMemory = kernelMemory;
    return this;
  }

   /**
   * KernelMemory specifies the kernel memory limit (in bytes) for the container. Deprecated: kernel 5.4 deprecated kmem.limit_in_bytes.
   * @return kernelMemory
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "KernelMemory specifies the kernel memory limit (in bytes) for the container. Deprecated: kernel 5.4 deprecated kmem.limit_in_bytes.")

  public Long getKernelMemory() {
    return kernelMemory;
  }


  public void setKernelMemory(Long kernelMemory) {
    this.kernelMemory = kernelMemory;
  }


  public Resources kernelMemoryTCP(Long kernelMemoryTCP) {
    
    this.kernelMemoryTCP = kernelMemoryTCP;
    return this;
  }

   /**
   * Get kernelMemoryTCP
   * @return kernelMemoryTCP
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getKernelMemoryTCP() {
    return kernelMemoryTCP;
  }


  public void setKernelMemoryTCP(Long kernelMemoryTCP) {
    this.kernelMemoryTCP = kernelMemoryTCP;
  }


  public Resources memory(Long memory) {
    
    this.memory = memory;
    return this;
  }

   /**
   * Get memory
   * @return memory
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getMemory() {
    return memory;
  }


  public void setMemory(Long memory) {
    this.memory = memory;
  }


  public Resources memoryReservation(Long memoryReservation) {
    
    this.memoryReservation = memoryReservation;
    return this;
  }

   /**
   * Get memoryReservation
   * @return memoryReservation
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getMemoryReservation() {
    return memoryReservation;
  }


  public void setMemoryReservation(Long memoryReservation) {
    this.memoryReservation = memoryReservation;
  }


  public Resources memorySwap(Long memorySwap) {
    
    this.memorySwap = memorySwap;
    return this;
  }

   /**
   * Get memorySwap
   * @return memorySwap
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getMemorySwap() {
    return memorySwap;
  }


  public void setMemorySwap(Long memorySwap) {
    this.memorySwap = memorySwap;
  }


  public Resources memorySwappiness(Long memorySwappiness) {
    
    this.memorySwappiness = memorySwappiness;
    return this;
  }

   /**
   * Get memorySwappiness
   * @return memorySwappiness
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getMemorySwappiness() {
    return memorySwappiness;
  }


  public void setMemorySwappiness(Long memorySwappiness) {
    this.memorySwappiness = memorySwappiness;
  }


  public Resources nanoCpus(Long nanoCpus) {
    
    this.nanoCpus = nanoCpus;
    return this;
  }

   /**
   * Get nanoCpus
   * @return nanoCpus
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getNanoCpus() {
    return nanoCpus;
  }


  public void setNanoCpus(Long nanoCpus) {
    this.nanoCpus = nanoCpus;
  }


  public Resources oomKillDisable(Boolean oomKillDisable) {
    
    this.oomKillDisable = oomKillDisable;
    return this;
  }

   /**
   * Get oomKillDisable
   * @return oomKillDisable
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Boolean getOomKillDisable() {
    return oomKillDisable;
  }


  public void setOomKillDisable(Boolean oomKillDisable) {
    this.oomKillDisable = oomKillDisable;
  }


  public Resources pidsLimit(Long pidsLimit) {
    
    this.pidsLimit = pidsLimit;
    return this;
  }

   /**
   * Get pidsLimit
   * @return pidsLimit
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public Long getPidsLimit() {
    return pidsLimit;
  }


  public void setPidsLimit(Long pidsLimit) {
    this.pidsLimit = pidsLimit;
  }


  public Resources ulimits(List<Ulimit> ulimits) {
    
    this.ulimits = ulimits;
    return this;
  }

  public Resources addUlimitsItem(Ulimit ulimitsItem) {
    if (this.ulimits == null) {
      this.ulimits = new ArrayList<>();
    }
    this.ulimits.add(ulimitsItem);
    return this;
  }

   /**
   * Get ulimits
   * @return ulimits
  **/
  @javax.annotation.Nullable
  @Valid
  @ApiModelProperty(value = "")

  public List<Ulimit> getUlimits() {
    return ulimits;
  }


  public void setUlimits(List<Ulimit> ulimits) {
    this.ulimits = ulimits;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Resources resources = (Resources) o;
    return Objects.equals(this.blkioDeviceReadBps, resources.blkioDeviceReadBps) &&
        Objects.equals(this.blkioDeviceReadIOps, resources.blkioDeviceReadIOps) &&
        Objects.equals(this.blkioDeviceWriteBps, resources.blkioDeviceWriteBps) &&
        Objects.equals(this.blkioDeviceWriteIOps, resources.blkioDeviceWriteIOps) &&
        Objects.equals(this.blkioWeight, resources.blkioWeight) &&
        Objects.equals(this.blkioWeightDevice, resources.blkioWeightDevice) &&
        Objects.equals(this.cgroupParent, resources.cgroupParent) &&
        Objects.equals(this.cpuCount, resources.cpuCount) &&
        Objects.equals(this.cpuPercent, resources.cpuPercent) &&
        Objects.equals(this.cpuPeriod, resources.cpuPeriod) &&
        Objects.equals(this.cpuQuota, resources.cpuQuota) &&
        Objects.equals(this.cpuRealtimePeriod, resources.cpuRealtimePeriod) &&
        Objects.equals(this.cpuRealtimeRuntime, resources.cpuRealtimeRuntime) &&
        Objects.equals(this.cpuShares, resources.cpuShares) &&
        Objects.equals(this.cpusetCpus, resources.cpusetCpus) &&
        Objects.equals(this.cpusetMems, resources.cpusetMems) &&
        Objects.equals(this.deviceCgroupRules, resources.deviceCgroupRules) &&
        Objects.equals(this.deviceRequests, resources.deviceRequests) &&
        Objects.equals(this.devices, resources.devices) &&
        Objects.equals(this.ioMaximumBandwidth, resources.ioMaximumBandwidth) &&
        Objects.equals(this.ioMaximumIOps, resources.ioMaximumIOps) &&
        Objects.equals(this.kernelMemory, resources.kernelMemory) &&
        Objects.equals(this.kernelMemoryTCP, resources.kernelMemoryTCP) &&
        Objects.equals(this.memory, resources.memory) &&
        Objects.equals(this.memoryReservation, resources.memoryReservation) &&
        Objects.equals(this.memorySwap, resources.memorySwap) &&
        Objects.equals(this.memorySwappiness, resources.memorySwappiness) &&
        Objects.equals(this.nanoCpus, resources.nanoCpus) &&
        Objects.equals(this.oomKillDisable, resources.oomKillDisable) &&
        Objects.equals(this.pidsLimit, resources.pidsLimit) &&
        Objects.equals(this.ulimits, resources.ulimits);
  }

  @Override
  public int hashCode() {
    return Objects.hash(blkioDeviceReadBps, blkioDeviceReadIOps, blkioDeviceWriteBps, blkioDeviceWriteIOps, blkioWeight, blkioWeightDevice, cgroupParent, cpuCount, cpuPercent, cpuPeriod, cpuQuota, cpuRealtimePeriod, cpuRealtimeRuntime, cpuShares, cpusetCpus, cpusetMems, deviceCgroupRules, deviceRequests, devices, ioMaximumBandwidth, ioMaximumIOps, kernelMemory, kernelMemoryTCP, memory, memoryReservation, memorySwap, memorySwappiness, nanoCpus, oomKillDisable, pidsLimit, ulimits);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Resources {\n");
    sb.append("    blkioDeviceReadBps: ").append(toIndentedString(blkioDeviceReadBps)).append("\n");
    sb.append("    blkioDeviceReadIOps: ").append(toIndentedString(blkioDeviceReadIOps)).append("\n");
    sb.append("    blkioDeviceWriteBps: ").append(toIndentedString(blkioDeviceWriteBps)).append("\n");
    sb.append("    blkioDeviceWriteIOps: ").append(toIndentedString(blkioDeviceWriteIOps)).append("\n");
    sb.append("    blkioWeight: ").append(toIndentedString(blkioWeight)).append("\n");
    sb.append("    blkioWeightDevice: ").append(toIndentedString(blkioWeightDevice)).append("\n");
    sb.append("    cgroupParent: ").append(toIndentedString(cgroupParent)).append("\n");
    sb.append("    cpuCount: ").append(toIndentedString(cpuCount)).append("\n");
    sb.append("    cpuPercent: ").append(toIndentedString(cpuPercent)).append("\n");
    sb.append("    cpuPeriod: ").append(toIndentedString(cpuPeriod)).append("\n");
    sb.append("    cpuQuota: ").append(toIndentedString(cpuQuota)).append("\n");
    sb.append("    cpuRealtimePeriod: ").append(toIndentedString(cpuRealtimePeriod)).append("\n");
    sb.append("    cpuRealtimeRuntime: ").append(toIndentedString(cpuRealtimeRuntime)).append("\n");
    sb.append("    cpuShares: ").append(toIndentedString(cpuShares)).append("\n");
    sb.append("    cpusetCpus: ").append(toIndentedString(cpusetCpus)).append("\n");
    sb.append("    cpusetMems: ").append(toIndentedString(cpusetMems)).append("\n");
    sb.append("    deviceCgroupRules: ").append(toIndentedString(deviceCgroupRules)).append("\n");
    sb.append("    deviceRequests: ").append(toIndentedString(deviceRequests)).append("\n");
    sb.append("    devices: ").append(toIndentedString(devices)).append("\n");
    sb.append("    ioMaximumBandwidth: ").append(toIndentedString(ioMaximumBandwidth)).append("\n");
    sb.append("    ioMaximumIOps: ").append(toIndentedString(ioMaximumIOps)).append("\n");
    sb.append("    kernelMemory: ").append(toIndentedString(kernelMemory)).append("\n");
    sb.append("    kernelMemoryTCP: ").append(toIndentedString(kernelMemoryTCP)).append("\n");
    sb.append("    memory: ").append(toIndentedString(memory)).append("\n");
    sb.append("    memoryReservation: ").append(toIndentedString(memoryReservation)).append("\n");
    sb.append("    memorySwap: ").append(toIndentedString(memorySwap)).append("\n");
    sb.append("    memorySwappiness: ").append(toIndentedString(memorySwappiness)).append("\n");
    sb.append("    nanoCpus: ").append(toIndentedString(nanoCpus)).append("\n");
    sb.append("    oomKillDisable: ").append(toIndentedString(oomKillDisable)).append("\n");
    sb.append("    pidsLimit: ").append(toIndentedString(pidsLimit)).append("\n");
    sb.append("    ulimits: ").append(toIndentedString(ulimits)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("BlkioDeviceReadBps");
    openapiFields.add("BlkioDeviceReadIOps");
    openapiFields.add("BlkioDeviceWriteBps");
    openapiFields.add("BlkioDeviceWriteIOps");
    openapiFields.add("BlkioWeight");
    openapiFields.add("BlkioWeightDevice");
    openapiFields.add("CgroupParent");
    openapiFields.add("CpuCount");
    openapiFields.add("CpuPercent");
    openapiFields.add("CpuPeriod");
    openapiFields.add("CpuQuota");
    openapiFields.add("CpuRealtimePeriod");
    openapiFields.add("CpuRealtimeRuntime");
    openapiFields.add("CpuShares");
    openapiFields.add("CpusetCpus");
    openapiFields.add("CpusetMems");
    openapiFields.add("DeviceCgroupRules");
    openapiFields.add("DeviceRequests");
    openapiFields.add("Devices");
    openapiFields.add("IOMaximumBandwidth");
    openapiFields.add("IOMaximumIOps");
    openapiFields.add("KernelMemory");
    openapiFields.add("KernelMemoryTCP");
    openapiFields.add("Memory");
    openapiFields.add("MemoryReservation");
    openapiFields.add("MemorySwap");
    openapiFields.add("MemorySwappiness");
    openapiFields.add("NanoCpus");
    openapiFields.add("OomKillDisable");
    openapiFields.add("PidsLimit");
    openapiFields.add("Ulimits");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

 /**
  * Validates the JSON Object and throws an exception if issues found
  *
  * @param jsonObj JSON Object
  * @throws IOException if the JSON Object is invalid with respect to Resources
  */
  public static void validateJsonObject(JsonObject jsonObj) throws IOException {
      if (jsonObj == null) {
        if (Resources.openapiRequiredFields.isEmpty()) {
          return;
        } else { // has required fields
          throw new IllegalArgumentException(String.format("The required field(s) %s in Resources is not found in the empty JSON string", Resources.openapiRequiredFields.toString()));
        }
      }

      Set<Entry<String, JsonElement>> entries = jsonObj.entrySet();
      // check to see if the JSON string contains additional fields
      for (Entry<String, JsonElement> entry : entries) {
        if (!Resources.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Resources` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
      }
      if (jsonObj.get("BlkioDeviceReadBps") != null && !jsonObj.get("BlkioDeviceReadBps").isJsonNull()) {
        JsonArray jsonArrayblkioDeviceReadBps = jsonObj.getAsJsonArray("BlkioDeviceReadBps");
        if (jsonArrayblkioDeviceReadBps != null) {
          // ensure the json data is an array
          if (!jsonObj.get("BlkioDeviceReadBps").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `BlkioDeviceReadBps` to be an array in the JSON string but got `%s`", jsonObj.get("BlkioDeviceReadBps").toString()));
          }

          // validate the optional field `BlkioDeviceReadBps` (array)
          for (int i = 0; i < jsonArrayblkioDeviceReadBps.size(); i++) {
            ThrottleDevice.validateJsonObject(jsonArrayblkioDeviceReadBps.get(i).getAsJsonObject());
          };
        }
      }
      if (jsonObj.get("BlkioDeviceReadIOps") != null && !jsonObj.get("BlkioDeviceReadIOps").isJsonNull()) {
        JsonArray jsonArrayblkioDeviceReadIOps = jsonObj.getAsJsonArray("BlkioDeviceReadIOps");
        if (jsonArrayblkioDeviceReadIOps != null) {
          // ensure the json data is an array
          if (!jsonObj.get("BlkioDeviceReadIOps").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `BlkioDeviceReadIOps` to be an array in the JSON string but got `%s`", jsonObj.get("BlkioDeviceReadIOps").toString()));
          }

          // validate the optional field `BlkioDeviceReadIOps` (array)
          for (int i = 0; i < jsonArrayblkioDeviceReadIOps.size(); i++) {
            ThrottleDevice.validateJsonObject(jsonArrayblkioDeviceReadIOps.get(i).getAsJsonObject());
          };
        }
      }
      if (jsonObj.get("BlkioDeviceWriteBps") != null && !jsonObj.get("BlkioDeviceWriteBps").isJsonNull()) {
        JsonArray jsonArrayblkioDeviceWriteBps = jsonObj.getAsJsonArray("BlkioDeviceWriteBps");
        if (jsonArrayblkioDeviceWriteBps != null) {
          // ensure the json data is an array
          if (!jsonObj.get("BlkioDeviceWriteBps").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `BlkioDeviceWriteBps` to be an array in the JSON string but got `%s`", jsonObj.get("BlkioDeviceWriteBps").toString()));
          }

          // validate the optional field `BlkioDeviceWriteBps` (array)
          for (int i = 0; i < jsonArrayblkioDeviceWriteBps.size(); i++) {
            ThrottleDevice.validateJsonObject(jsonArrayblkioDeviceWriteBps.get(i).getAsJsonObject());
          };
        }
      }
      if (jsonObj.get("BlkioDeviceWriteIOps") != null && !jsonObj.get("BlkioDeviceWriteIOps").isJsonNull()) {
        JsonArray jsonArrayblkioDeviceWriteIOps = jsonObj.getAsJsonArray("BlkioDeviceWriteIOps");
        if (jsonArrayblkioDeviceWriteIOps != null) {
          // ensure the json data is an array
          if (!jsonObj.get("BlkioDeviceWriteIOps").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `BlkioDeviceWriteIOps` to be an array in the JSON string but got `%s`", jsonObj.get("BlkioDeviceWriteIOps").toString()));
          }

          // validate the optional field `BlkioDeviceWriteIOps` (array)
          for (int i = 0; i < jsonArrayblkioDeviceWriteIOps.size(); i++) {
            ThrottleDevice.validateJsonObject(jsonArrayblkioDeviceWriteIOps.get(i).getAsJsonObject());
          };
        }
      }
      if (jsonObj.get("BlkioWeightDevice") != null && !jsonObj.get("BlkioWeightDevice").isJsonNull()) {
        JsonArray jsonArrayblkioWeightDevice = jsonObj.getAsJsonArray("BlkioWeightDevice");
        if (jsonArrayblkioWeightDevice != null) {
          // ensure the json data is an array
          if (!jsonObj.get("BlkioWeightDevice").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `BlkioWeightDevice` to be an array in the JSON string but got `%s`", jsonObj.get("BlkioWeightDevice").toString()));
          }

          // validate the optional field `BlkioWeightDevice` (array)
          for (int i = 0; i < jsonArrayblkioWeightDevice.size(); i++) {
            WeightDevice.validateJsonObject(jsonArrayblkioWeightDevice.get(i).getAsJsonObject());
          };
        }
      }
      if ((jsonObj.get("CgroupParent") != null && !jsonObj.get("CgroupParent").isJsonNull()) && !jsonObj.get("CgroupParent").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `CgroupParent` to be a primitive type in the JSON string but got `%s`", jsonObj.get("CgroupParent").toString()));
      }
      if ((jsonObj.get("CpusetCpus") != null && !jsonObj.get("CpusetCpus").isJsonNull()) && !jsonObj.get("CpusetCpus").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `CpusetCpus` to be a primitive type in the JSON string but got `%s`", jsonObj.get("CpusetCpus").toString()));
      }
      if ((jsonObj.get("CpusetMems") != null && !jsonObj.get("CpusetMems").isJsonNull()) && !jsonObj.get("CpusetMems").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `CpusetMems` to be a primitive type in the JSON string but got `%s`", jsonObj.get("CpusetMems").toString()));
      }
      // ensure the json data is an array
      if ((jsonObj.get("DeviceCgroupRules") != null && !jsonObj.get("DeviceCgroupRules").isJsonNull()) && !jsonObj.get("DeviceCgroupRules").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `DeviceCgroupRules` to be an array in the JSON string but got `%s`", jsonObj.get("DeviceCgroupRules").toString()));
      }
      if (jsonObj.get("DeviceRequests") != null && !jsonObj.get("DeviceRequests").isJsonNull()) {
        JsonArray jsonArraydeviceRequests = jsonObj.getAsJsonArray("DeviceRequests");
        if (jsonArraydeviceRequests != null) {
          // ensure the json data is an array
          if (!jsonObj.get("DeviceRequests").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `DeviceRequests` to be an array in the JSON string but got `%s`", jsonObj.get("DeviceRequests").toString()));
          }

          // validate the optional field `DeviceRequests` (array)
          for (int i = 0; i < jsonArraydeviceRequests.size(); i++) {
            DeviceRequest.validateJsonObject(jsonArraydeviceRequests.get(i).getAsJsonObject());
          };
        }
      }
      if (jsonObj.get("Devices") != null && !jsonObj.get("Devices").isJsonNull()) {
        JsonArray jsonArraydevices = jsonObj.getAsJsonArray("Devices");
        if (jsonArraydevices != null) {
          // ensure the json data is an array
          if (!jsonObj.get("Devices").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Devices` to be an array in the JSON string but got `%s`", jsonObj.get("Devices").toString()));
          }

          // validate the optional field `Devices` (array)
          for (int i = 0; i < jsonArraydevices.size(); i++) {
            DeviceMapping.validateJsonObject(jsonArraydevices.get(i).getAsJsonObject());
          };
        }
      }
      if (jsonObj.get("Ulimits") != null && !jsonObj.get("Ulimits").isJsonNull()) {
        JsonArray jsonArrayulimits = jsonObj.getAsJsonArray("Ulimits");
        if (jsonArrayulimits != null) {
          // ensure the json data is an array
          if (!jsonObj.get("Ulimits").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Ulimits` to be an array in the JSON string but got `%s`", jsonObj.get("Ulimits").toString()));
          }

          // validate the optional field `Ulimits` (array)
          for (int i = 0; i < jsonArrayulimits.size(); i++) {
            Ulimit.validateJsonObject(jsonArrayulimits.get(i).getAsJsonObject());
          };
        }
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Resources.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Resources' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Resources> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Resources.class));

       return (TypeAdapter<T>) new TypeAdapter<Resources>() {
           @Override
           public void write(JsonWriter out, Resources value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Resources read(JsonReader in) throws IOException {
             JsonObject jsonObj = elementAdapter.read(in).getAsJsonObject();
             validateJsonObject(jsonObj);
             return thisAdapter.fromJsonTree(jsonObj);
           }

       }.nullSafe();
    }
  }

 /**
  * Create an instance of Resources given an JSON string
  *
  * @param jsonString JSON string
  * @return An instance of Resources
  * @throws IOException if the JSON string is invalid with respect to Resources
  */
  public static Resources fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Resources.class);
  }

 /**
  * Convert an instance of Resources to an JSON string
  *
  * @return JSON string
  */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

