/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.InspectExecProcess;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;

public class InspectExecSession
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CAN_REMOVE = "CanRemove";
    @SerializedName(value="CanRemove")
    private Boolean canRemove;
    public static final String SERIALIZED_NAME_CONTAINER_I_D = "ContainerID";
    @SerializedName(value="ContainerID")
    private String containerID;
    public static final String SERIALIZED_NAME_DETACH_KEYS = "DetachKeys";
    @SerializedName(value="DetachKeys")
    private String detachKeys;
    public static final String SERIALIZED_NAME_EXIT_CODE = "ExitCode";
    @SerializedName(value="ExitCode")
    private Long exitCode;
    public static final String SERIALIZED_NAME_I_D = "ID";
    @SerializedName(value="ID")
    private String ID;
    public static final String SERIALIZED_NAME_OPEN_STDERR = "OpenStderr";
    @SerializedName(value="OpenStderr")
    private Boolean openStderr;
    public static final String SERIALIZED_NAME_OPEN_STDIN = "OpenStdin";
    @SerializedName(value="OpenStdin")
    private Boolean openStdin;
    public static final String SERIALIZED_NAME_OPEN_STDOUT = "OpenStdout";
    @SerializedName(value="OpenStdout")
    private Boolean openStdout;
    public static final String SERIALIZED_NAME_PID = "Pid";
    @SerializedName(value="Pid")
    private Long pid;
    public static final String SERIALIZED_NAME_PROCESS_CONFIG = "ProcessConfig";
    @SerializedName(value="ProcessConfig")
    private InspectExecProcess processConfig;
    public static final String SERIALIZED_NAME_RUNNING = "Running";
    @SerializedName(value="Running")
    private Boolean running;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public InspectExecSession canRemove(Boolean canRemove) {
        this.canRemove = canRemove;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="CanRemove is legacy and used purely for compatibility reasons. Will always be set to true, unless the exec session is running.")
    public Boolean getCanRemove() {
        return this.canRemove;
    }

    public void setCanRemove(Boolean canRemove) {
        this.canRemove = canRemove;
    }

    public InspectExecSession containerID(String containerID) {
        this.containerID = containerID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ContainerID is the ID of the container this exec session is attached to.")
    public String getContainerID() {
        return this.containerID;
    }

    public void setContainerID(String containerID) {
        this.containerID = containerID;
    }

    public InspectExecSession detachKeys(String detachKeys) {
        this.detachKeys = detachKeys;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="DetachKeys are the detach keys used by the exec session. If set to \"\" the default keys are being used. Will show \"<none>\" if no detach keys are set.")
    public String getDetachKeys() {
        return this.detachKeys;
    }

    public void setDetachKeys(String detachKeys) {
        this.detachKeys = detachKeys;
    }

    public InspectExecSession exitCode(Long exitCode) {
        this.exitCode = exitCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ExitCode is the exit code of the exec session. Will be set to 0 if the exec session has not yet exited.")
    public Long getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(Long exitCode) {
        this.exitCode = exitCode;
    }

    public InspectExecSession ID(String ID) {
        this.ID = ID;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ID is the ID of the exec session.")
    public String getID() {
        return this.ID;
    }

    public void setID(String ID) {
        this.ID = ID;
    }

    public InspectExecSession openStderr(Boolean openStderr) {
        this.openStderr = openStderr;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="OpenStderr is whether the container's STDERR stream will be attached. Always set to true if the exec session created a TTY.")
    public Boolean getOpenStderr() {
        return this.openStderr;
    }

    public void setOpenStderr(Boolean openStderr) {
        this.openStderr = openStderr;
    }

    public InspectExecSession openStdin(Boolean openStdin) {
        this.openStdin = openStdin;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="OpenStdin is whether the container's STDIN stream will be attached to.")
    public Boolean getOpenStdin() {
        return this.openStdin;
    }

    public void setOpenStdin(Boolean openStdin) {
        this.openStdin = openStdin;
    }

    public InspectExecSession openStdout(Boolean openStdout) {
        this.openStdout = openStdout;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="OpenStdout is whether the container's STDOUT stream will be attached. Always set to true if the exec session created a TTY.")
    public Boolean getOpenStdout() {
        return this.openStdout;
    }

    public void setOpenStdout(Boolean openStdout) {
        this.openStdout = openStdout;
    }

    public InspectExecSession pid(Long pid) {
        this.pid = pid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Pid is the PID of the exec session's process. Will be set to 0 if the exec session is not running.")
    public Long getPid() {
        return this.pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public InspectExecSession processConfig(InspectExecProcess processConfig) {
        this.processConfig = processConfig;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public InspectExecProcess getProcessConfig() {
        return this.processConfig;
    }

    public void setProcessConfig(InspectExecProcess processConfig) {
        this.processConfig = processConfig;
    }

    public InspectExecSession running(Boolean running) {
        this.running = running;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Running is whether the exec session is running.")
    public Boolean getRunning() {
        return this.running;
    }

    public void setRunning(Boolean running) {
        this.running = running;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InspectExecSession inspectExecSession = (InspectExecSession)o;
        return Objects.equals(this.canRemove, inspectExecSession.canRemove) && Objects.equals(this.containerID, inspectExecSession.containerID) && Objects.equals(this.detachKeys, inspectExecSession.detachKeys) && Objects.equals(this.exitCode, inspectExecSession.exitCode) && Objects.equals(this.ID, inspectExecSession.ID) && Objects.equals(this.openStderr, inspectExecSession.openStderr) && Objects.equals(this.openStdin, inspectExecSession.openStdin) && Objects.equals(this.openStdout, inspectExecSession.openStdout) && Objects.equals(this.pid, inspectExecSession.pid) && Objects.equals(this.processConfig, inspectExecSession.processConfig) && Objects.equals(this.running, inspectExecSession.running);
    }

    public int hashCode() {
        return Objects.hash(this.canRemove, this.containerID, this.detachKeys, this.exitCode, this.ID, this.openStderr, this.openStdin, this.openStdout, this.pid, this.processConfig, this.running);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InspectExecSession {\n");
        sb.append("    canRemove: ").append(this.toIndentedString(this.canRemove)).append("\n");
        sb.append("    containerID: ").append(this.toIndentedString(this.containerID)).append("\n");
        sb.append("    detachKeys: ").append(this.toIndentedString(this.detachKeys)).append("\n");
        sb.append("    exitCode: ").append(this.toIndentedString(this.exitCode)).append("\n");
        sb.append("    ID: ").append(this.toIndentedString(this.ID)).append("\n");
        sb.append("    openStderr: ").append(this.toIndentedString(this.openStderr)).append("\n");
        sb.append("    openStdin: ").append(this.toIndentedString(this.openStdin)).append("\n");
        sb.append("    openStdout: ").append(this.toIndentedString(this.openStdout)).append("\n");
        sb.append("    pid: ").append(this.toIndentedString(this.pid)).append("\n");
        sb.append("    processConfig: ").append(this.toIndentedString(this.processConfig)).append("\n");
        sb.append("    running: ").append(this.toIndentedString(this.running)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in InspectExecSession is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `InspectExecSession` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTAINER_I_D) != null && !jsonObj.get(SERIALIZED_NAME_CONTAINER_I_D).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CONTAINER_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ContainerID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTAINER_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_DETACH_KEYS) != null && !jsonObj.get(SERIALIZED_NAME_DETACH_KEYS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_DETACH_KEYS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `DetachKeys` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DETACH_KEYS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_I_D) != null && !jsonObj.get(SERIALIZED_NAME_I_D).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_I_D).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `ID` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_I_D).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PROCESS_CONFIG) != null && !jsonObj.get(SERIALIZED_NAME_PROCESS_CONFIG).isJsonNull()) {
            InspectExecProcess.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PROCESS_CONFIG));
        }
    }

    public static InspectExecSession fromJson(String jsonString) throws IOException {
        return (InspectExecSession)JSON.getGson().fromJson(jsonString, InspectExecSession.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CAN_REMOVE);
        openapiFields.add(SERIALIZED_NAME_CONTAINER_I_D);
        openapiFields.add(SERIALIZED_NAME_DETACH_KEYS);
        openapiFields.add(SERIALIZED_NAME_EXIT_CODE);
        openapiFields.add(SERIALIZED_NAME_I_D);
        openapiFields.add(SERIALIZED_NAME_OPEN_STDERR);
        openapiFields.add(SERIALIZED_NAME_OPEN_STDIN);
        openapiFields.add(SERIALIZED_NAME_OPEN_STDOUT);
        openapiFields.add(SERIALIZED_NAME_PID);
        openapiFields.add(SERIALIZED_NAME_PROCESS_CONFIG);
        openapiFields.add(SERIALIZED_NAME_RUNNING);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!InspectExecSession.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(InspectExecSession.class));
            return new TypeAdapter<InspectExecSession>(){

                public void write(JsonWriter out, InspectExecSession value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public InspectExecSession read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    InspectExecSession.validateJsonObject(jsonObj);
                    return (InspectExecSession)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

