/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.LinuxBlockIO;
import io.github.pod4dev.libpodj.model.LinuxCPU;
import io.github.pod4dev.libpodj.model.LinuxDeviceCgroup;
import io.github.pod4dev.libpodj.model.LinuxHugepageLimit;
import io.github.pod4dev.libpodj.model.LinuxMemory;
import io.github.pod4dev.libpodj.model.LinuxNetwork;
import io.github.pod4dev.libpodj.model.LinuxPids;
import io.github.pod4dev.libpodj.model.LinuxRdma;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;

@ApiModel(description="LinuxResources has container runtime resource constraints")
public class LinuxResources
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_BLOCK_I_O = "blockIO";
    @SerializedName(value="blockIO")
    private LinuxBlockIO blockIO;
    public static final String SERIALIZED_NAME_CPU = "cpu";
    @SerializedName(value="cpu")
    private LinuxCPU cpu;
    public static final String SERIALIZED_NAME_DEVICES = "devices";
    @SerializedName(value="devices")
    private List<LinuxDeviceCgroup> devices = null;
    public static final String SERIALIZED_NAME_HUGEPAGE_LIMITS = "hugepageLimits";
    @SerializedName(value="hugepageLimits")
    private List<LinuxHugepageLimit> hugepageLimits = null;
    public static final String SERIALIZED_NAME_MEMORY = "memory";
    @SerializedName(value="memory")
    private LinuxMemory memory;
    public static final String SERIALIZED_NAME_NETWORK = "network";
    @SerializedName(value="network")
    private LinuxNetwork network;
    public static final String SERIALIZED_NAME_PIDS = "pids";
    @SerializedName(value="pids")
    private LinuxPids pids;
    public static final String SERIALIZED_NAME_RDMA = "rdma";
    @SerializedName(value="rdma")
    private Map<String, LinuxRdma> rdma = null;
    public static final String SERIALIZED_NAME_UNIFIED = "unified";
    @SerializedName(value="unified")
    private Map<String, String> unified = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public LinuxResources blockIO(LinuxBlockIO blockIO) {
        this.blockIO = blockIO;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public LinuxBlockIO getBlockIO() {
        return this.blockIO;
    }

    public void setBlockIO(LinuxBlockIO blockIO) {
        this.blockIO = blockIO;
    }

    public LinuxResources cpu(LinuxCPU cpu) {
        this.cpu = cpu;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public LinuxCPU getCpu() {
        return this.cpu;
    }

    public void setCpu(LinuxCPU cpu) {
        this.cpu = cpu;
    }

    public LinuxResources devices(List<LinuxDeviceCgroup> devices) {
        this.devices = devices;
        return this;
    }

    public LinuxResources addDevicesItem(LinuxDeviceCgroup devicesItem) {
        if (this.devices == null) {
            this.devices = new ArrayList<LinuxDeviceCgroup>();
        }
        this.devices.add(devicesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Devices configures the device allowlist.")
    public List<LinuxDeviceCgroup> getDevices() {
        return this.devices;
    }

    public void setDevices(List<LinuxDeviceCgroup> devices) {
        this.devices = devices;
    }

    public LinuxResources hugepageLimits(List<LinuxHugepageLimit> hugepageLimits) {
        this.hugepageLimits = hugepageLimits;
        return this;
    }

    public LinuxResources addHugepageLimitsItem(LinuxHugepageLimit hugepageLimitsItem) {
        if (this.hugepageLimits == null) {
            this.hugepageLimits = new ArrayList<LinuxHugepageLimit>();
        }
        this.hugepageLimits.add(hugepageLimitsItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Hugetlb limits (in bytes). Default to reservation limits if supported.")
    public List<LinuxHugepageLimit> getHugepageLimits() {
        return this.hugepageLimits;
    }

    public void setHugepageLimits(List<LinuxHugepageLimit> hugepageLimits) {
        this.hugepageLimits = hugepageLimits;
    }

    public LinuxResources memory(LinuxMemory memory) {
        this.memory = memory;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public LinuxMemory getMemory() {
        return this.memory;
    }

    public void setMemory(LinuxMemory memory) {
        this.memory = memory;
    }

    public LinuxResources network(LinuxNetwork network) {
        this.network = network;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public LinuxNetwork getNetwork() {
        return this.network;
    }

    public void setNetwork(LinuxNetwork network) {
        this.network = network;
    }

    public LinuxResources pids(LinuxPids pids) {
        this.pids = pids;
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public LinuxPids getPids() {
        return this.pids;
    }

    public void setPids(LinuxPids pids) {
        this.pids = pids;
    }

    public LinuxResources rdma(Map<String, LinuxRdma> rdma) {
        this.rdma = rdma;
        return this;
    }

    public LinuxResources putRdmaItem(String key, LinuxRdma rdmaItem) {
        if (this.rdma == null) {
            this.rdma = new HashMap<String, LinuxRdma>();
        }
        this.rdma.put(key, rdmaItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="Rdma resource restriction configuration. Limits are a set of key value pairs that define RDMA resource limits, where the key is device name and value is resource limits.")
    public Map<String, LinuxRdma> getRdma() {
        return this.rdma;
    }

    public void setRdma(Map<String, LinuxRdma> rdma) {
        this.rdma = rdma;
    }

    public LinuxResources unified(Map<String, String> unified) {
        this.unified = unified;
        return this;
    }

    public LinuxResources putUnifiedItem(String key, String unifiedItem) {
        if (this.unified == null) {
            this.unified = new HashMap<String, String>();
        }
        this.unified.put(key, unifiedItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Unified resources.")
    public Map<String, String> getUnified() {
        return this.unified;
    }

    public void setUnified(Map<String, String> unified) {
        this.unified = unified;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinuxResources linuxResources = (LinuxResources)o;
        return Objects.equals(this.blockIO, linuxResources.blockIO) && Objects.equals(this.cpu, linuxResources.cpu) && Objects.equals(this.devices, linuxResources.devices) && Objects.equals(this.hugepageLimits, linuxResources.hugepageLimits) && Objects.equals(this.memory, linuxResources.memory) && Objects.equals(this.network, linuxResources.network) && Objects.equals(this.pids, linuxResources.pids) && Objects.equals(this.rdma, linuxResources.rdma) && Objects.equals(this.unified, linuxResources.unified);
    }

    public int hashCode() {
        return Objects.hash(this.blockIO, this.cpu, this.devices, this.hugepageLimits, this.memory, this.network, this.pids, this.rdma, this.unified);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinuxResources {\n");
        sb.append("    blockIO: ").append(this.toIndentedString(this.blockIO)).append("\n");
        sb.append("    cpu: ").append(this.toIndentedString(this.cpu)).append("\n");
        sb.append("    devices: ").append(this.toIndentedString(this.devices)).append("\n");
        sb.append("    hugepageLimits: ").append(this.toIndentedString(this.hugepageLimits)).append("\n");
        sb.append("    memory: ").append(this.toIndentedString(this.memory)).append("\n");
        sb.append("    network: ").append(this.toIndentedString(this.network)).append("\n");
        sb.append("    pids: ").append(this.toIndentedString(this.pids)).append("\n");
        sb.append("    rdma: ").append(this.toIndentedString(this.rdma)).append("\n");
        sb.append("    unified: ").append(this.toIndentedString(this.unified)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayhugepageLimits;
        JsonArray jsonArraydevices;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in LinuxResources is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `LinuxResources` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_BLOCK_I_O) != null && !jsonObj.get(SERIALIZED_NAME_BLOCK_I_O).isJsonNull()) {
            LinuxBlockIO.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_BLOCK_I_O));
        }
        if (jsonObj.get(SERIALIZED_NAME_CPU) != null && !jsonObj.get(SERIALIZED_NAME_CPU).isJsonNull()) {
            LinuxCPU.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_CPU));
        }
        if (jsonObj.get(SERIALIZED_NAME_DEVICES) != null && !jsonObj.get(SERIALIZED_NAME_DEVICES).isJsonNull() && (jsonArraydevices = jsonObj.getAsJsonArray(SERIALIZED_NAME_DEVICES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_DEVICES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `devices` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_DEVICES).toString()));
            }
            for (int i = 0; i < jsonArraydevices.size(); ++i) {
                LinuxDeviceCgroup.validateJsonObject(jsonArraydevices.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_HUGEPAGE_LIMITS) != null && !jsonObj.get(SERIALIZED_NAME_HUGEPAGE_LIMITS).isJsonNull() && (jsonArrayhugepageLimits = jsonObj.getAsJsonArray(SERIALIZED_NAME_HUGEPAGE_LIMITS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_HUGEPAGE_LIMITS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `hugepageLimits` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HUGEPAGE_LIMITS).toString()));
            }
            for (int i = 0; i < jsonArrayhugepageLimits.size(); ++i) {
                LinuxHugepageLimit.validateJsonObject(jsonArrayhugepageLimits.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_MEMORY) != null && !jsonObj.get(SERIALIZED_NAME_MEMORY).isJsonNull()) {
            LinuxMemory.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_MEMORY));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETWORK) != null && !jsonObj.get(SERIALIZED_NAME_NETWORK).isJsonNull()) {
            LinuxNetwork.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_NETWORK));
        }
        if (jsonObj.get(SERIALIZED_NAME_PIDS) != null && !jsonObj.get(SERIALIZED_NAME_PIDS).isJsonNull()) {
            LinuxPids.validateJsonObject(jsonObj.getAsJsonObject(SERIALIZED_NAME_PIDS));
        }
    }

    public static LinuxResources fromJson(String jsonString) throws IOException {
        return (LinuxResources)JSON.getGson().fromJson(jsonString, LinuxResources.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BLOCK_I_O);
        openapiFields.add(SERIALIZED_NAME_CPU);
        openapiFields.add(SERIALIZED_NAME_DEVICES);
        openapiFields.add(SERIALIZED_NAME_HUGEPAGE_LIMITS);
        openapiFields.add(SERIALIZED_NAME_MEMORY);
        openapiFields.add(SERIALIZED_NAME_NETWORK);
        openapiFields.add(SERIALIZED_NAME_PIDS);
        openapiFields.add(SERIALIZED_NAME_RDMA);
        openapiFields.add(SERIALIZED_NAME_UNIFIED);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!LinuxResources.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(LinuxResources.class));
            return new TypeAdapter<LinuxResources>(){

                public void write(JsonWriter out, LinuxResources value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public LinuxResources read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    LinuxResources.validateJsonObject(jsonObj);
                    return (LinuxResources)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

