/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

@ApiModel(description="LinuxThrottleDevice struct holds a `major:minor rate_per_second` pair")
public class LinuxThrottleDevice
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_MAJOR = "major";
    @SerializedName(value="major")
    private Long major;
    public static final String SERIALIZED_NAME_MINOR = "minor";
    @SerializedName(value="minor")
    private Long minor;
    public static final String SERIALIZED_NAME_RATE = "rate";
    @SerializedName(value="rate")
    private Integer rate;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public LinuxThrottleDevice major(Long major) {
        this.major = major;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Major is the device's major number.")
    public Long getMajor() {
        return this.major;
    }

    public void setMajor(Long major) {
        this.major = major;
    }

    public LinuxThrottleDevice minor(Long minor) {
        this.minor = minor;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Minor is the device's minor number.")
    public Long getMinor() {
        return this.minor;
    }

    public void setMinor(Long minor) {
        this.minor = minor;
    }

    public LinuxThrottleDevice rate(Integer rate) {
        this.rate = rate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Rate is the IO rate limit per cgroup per device")
    public Integer getRate() {
        return this.rate;
    }

    public void setRate(Integer rate) {
        this.rate = rate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LinuxThrottleDevice linuxThrottleDevice = (LinuxThrottleDevice)o;
        return Objects.equals(this.major, linuxThrottleDevice.major) && Objects.equals(this.minor, linuxThrottleDevice.minor) && Objects.equals(this.rate, linuxThrottleDevice.rate);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.rate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LinuxThrottleDevice {\n");
        sb.append("    major: ").append(this.toIndentedString(this.major)).append("\n");
        sb.append("    minor: ").append(this.toIndentedString(this.minor)).append("\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in LinuxThrottleDevice is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `LinuxThrottleDevice` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
    }

    public static LinuxThrottleDevice fromJson(String jsonString) throws IOException {
        return (LinuxThrottleDevice)JSON.getGson().fromJson(jsonString, LinuxThrottleDevice.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_MAJOR);
        openapiFields.add(SERIALIZED_NAME_MINOR);
        openapiFields.add(SERIALIZED_NAME_RATE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!LinuxThrottleDevice.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(LinuxThrottleDevice.class));
            return new TypeAdapter<LinuxThrottleDevice>(){

                public void write(JsonWriter out, LinuxThrottleDevice value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public LinuxThrottleDevice read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    LinuxThrottleDevice.validateJsonObject(jsonObj);
                    return (LinuxThrottleDevice)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

