/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.Task;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;

@ApiModel(description="ServiceInfo represents service parameters with the list of service's tasks")
public class ServiceInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_LOCAL_L_B_INDEX = "LocalLBIndex";
    @SerializedName(value="LocalLBIndex")
    private Long localLBIndex;
    public static final String SERIALIZED_NAME_PORTS = "Ports";
    @SerializedName(value="Ports")
    private List<String> ports = null;
    public static final String SERIALIZED_NAME_TASKS = "Tasks";
    @SerializedName(value="Tasks")
    private List<Task> tasks = null;
    public static final String SERIALIZED_NAME_V_I_P = "VIP";
    @SerializedName(value="VIP")
    private String VIP;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ServiceInfo localLBIndex(Long localLBIndex) {
        this.localLBIndex = localLBIndex;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getLocalLBIndex() {
        return this.localLBIndex;
    }

    public void setLocalLBIndex(Long localLBIndex) {
        this.localLBIndex = localLBIndex;
    }

    public ServiceInfo ports(List<String> ports) {
        this.ports = ports;
        return this;
    }

    public ServiceInfo addPortsItem(String portsItem) {
        if (this.ports == null) {
            this.ports = new ArrayList<String>();
        }
        this.ports.add(portsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<String> getPorts() {
        return this.ports;
    }

    public void setPorts(List<String> ports) {
        this.ports = ports;
    }

    public ServiceInfo tasks(List<Task> tasks) {
        this.tasks = tasks;
        return this;
    }

    public ServiceInfo addTasksItem(Task tasksItem) {
        if (this.tasks == null) {
            this.tasks = new ArrayList<Task>();
        }
        this.tasks.add(tasksItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public List<Task> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<Task> tasks) {
        this.tasks = tasks;
    }

    public ServiceInfo VIP(String VIP) {
        this.VIP = VIP;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public String getVIP() {
        return this.VIP;
    }

    public void setVIP(String VIP) {
        this.VIP = VIP;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceInfo serviceInfo = (ServiceInfo)o;
        return Objects.equals(this.localLBIndex, serviceInfo.localLBIndex) && Objects.equals(this.ports, serviceInfo.ports) && Objects.equals(this.tasks, serviceInfo.tasks) && Objects.equals(this.VIP, serviceInfo.VIP);
    }

    public int hashCode() {
        return Objects.hash(this.localLBIndex, this.ports, this.tasks, this.VIP);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceInfo {\n");
        sb.append("    localLBIndex: ").append(this.toIndentedString(this.localLBIndex)).append("\n");
        sb.append("    ports: ").append(this.toIndentedString(this.ports)).append("\n");
        sb.append("    tasks: ").append(this.toIndentedString(this.tasks)).append("\n");
        sb.append("    VIP: ").append(this.toIndentedString(this.VIP)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArraytasks;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in ServiceInfo is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ServiceInfo` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PORTS) != null && !jsonObj.get(SERIALIZED_NAME_PORTS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PORTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Ports` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PORTS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TASKS) != null && !jsonObj.get(SERIALIZED_NAME_TASKS).isJsonNull() && (jsonArraytasks = jsonObj.getAsJsonArray(SERIALIZED_NAME_TASKS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_TASKS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `Tasks` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TASKS).toString()));
            }
            for (int i = 0; i < jsonArraytasks.size(); ++i) {
                Task.validateJsonObject(jsonArraytasks.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_V_I_P) != null && !jsonObj.get(SERIALIZED_NAME_V_I_P).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_V_I_P).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `VIP` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_V_I_P).toString()));
        }
    }

    public static ServiceInfo fromJson(String jsonString) throws IOException {
        return (ServiceInfo)JSON.getGson().fromJson(jsonString, ServiceInfo.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LOCAL_L_B_INDEX);
        openapiFields.add(SERIALIZED_NAME_PORTS);
        openapiFields.add(SERIALIZED_NAME_TASKS);
        openapiFields.add(SERIALIZED_NAME_V_I_P);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ServiceInfo.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ServiceInfo.class));
            return new TypeAdapter<ServiceInfo>(){

                public void write(JsonWriter out, ServiceInfo value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ServiceInfo read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    ServiceInfo.validateJsonObject(jsonObj);
                    return (ServiceInfo)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

