/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.SystemDfContainerReport;
import io.github.pod4dev.libpodj.model.SystemDfImageReport;
import io.github.pod4dev.libpodj.model.SystemDfVolumeReport;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.Valid;

@ApiModel(description="SystemDfReport describes the response for df information")
public class SystemDfReport
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CONTAINERS = "Containers";
    @SerializedName(value="Containers")
    private List<SystemDfContainerReport> containers = null;
    public static final String SERIALIZED_NAME_IMAGES = "Images";
    @SerializedName(value="Images")
    private List<SystemDfImageReport> images = null;
    public static final String SERIALIZED_NAME_IMAGES_SIZE = "ImagesSize";
    @SerializedName(value="ImagesSize")
    private Long imagesSize;
    public static final String SERIALIZED_NAME_VOLUMES = "Volumes";
    @SerializedName(value="Volumes")
    private List<SystemDfVolumeReport> volumes = null;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public SystemDfReport containers(List<SystemDfContainerReport> containers) {
        this.containers = containers;
        return this;
    }

    public SystemDfReport addContainersItem(SystemDfContainerReport containersItem) {
        if (this.containers == null) {
            this.containers = new ArrayList<SystemDfContainerReport>();
        }
        this.containers.add(containersItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public List<SystemDfContainerReport> getContainers() {
        return this.containers;
    }

    public void setContainers(List<SystemDfContainerReport> containers) {
        this.containers = containers;
    }

    public SystemDfReport images(List<SystemDfImageReport> images) {
        this.images = images;
        return this;
    }

    public SystemDfReport addImagesItem(SystemDfImageReport imagesItem) {
        if (this.images == null) {
            this.images = new ArrayList<SystemDfImageReport>();
        }
        this.images.add(imagesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public List<SystemDfImageReport> getImages() {
        return this.images;
    }

    public void setImages(List<SystemDfImageReport> images) {
        this.images = images;
    }

    public SystemDfReport imagesSize(Long imagesSize) {
        this.imagesSize = imagesSize;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Long getImagesSize() {
        return this.imagesSize;
    }

    public void setImagesSize(Long imagesSize) {
        this.imagesSize = imagesSize;
    }

    public SystemDfReport volumes(List<SystemDfVolumeReport> volumes) {
        this.volumes = volumes;
        return this;
    }

    public SystemDfReport addVolumesItem(SystemDfVolumeReport volumesItem) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<SystemDfVolumeReport>();
        }
        this.volumes.add(volumesItem);
        return this;
    }

    @Nullable
    @Valid
    @ApiModelProperty(value="")
    public List<SystemDfVolumeReport> getVolumes() {
        return this.volumes;
    }

    public void setVolumes(List<SystemDfVolumeReport> volumes) {
        this.volumes = volumes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemDfReport systemDfReport = (SystemDfReport)o;
        return Objects.equals(this.containers, systemDfReport.containers) && Objects.equals(this.images, systemDfReport.images) && Objects.equals(this.imagesSize, systemDfReport.imagesSize) && Objects.equals(this.volumes, systemDfReport.volumes);
    }

    public int hashCode() {
        return Objects.hash(this.containers, this.images, this.imagesSize, this.volumes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SystemDfReport {\n");
        sb.append("    containers: ").append(this.toIndentedString(this.containers)).append("\n");
        sb.append("    images: ").append(this.toIndentedString(this.images)).append("\n");
        sb.append("    imagesSize: ").append(this.toIndentedString(this.imagesSize)).append("\n");
        sb.append("    volumes: ").append(this.toIndentedString(this.volumes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        JsonArray jsonArrayvolumes;
        JsonArray jsonArrayimages;
        JsonArray jsonArraycontainers;
        if (jsonObj == null) {
            if (openapiRequiredFields.isEmpty()) {
                return;
            }
            throw new IllegalArgumentException(String.format("The required field(s) %s in SystemDfReport is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `SystemDfReport` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTAINERS) != null && !jsonObj.get(SERIALIZED_NAME_CONTAINERS).isJsonNull() && (jsonArraycontainers = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONTAINERS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONTAINERS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `Containers` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTAINERS).toString()));
            }
            for (int i = 0; i < jsonArraycontainers.size(); ++i) {
                SystemDfContainerReport.validateJsonObject(jsonArraycontainers.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_IMAGES) != null && !jsonObj.get(SERIALIZED_NAME_IMAGES).isJsonNull() && (jsonArrayimages = jsonObj.getAsJsonArray(SERIALIZED_NAME_IMAGES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_IMAGES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `Images` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMAGES).toString()));
            }
            for (int i = 0; i < jsonArrayimages.size(); ++i) {
                SystemDfImageReport.validateJsonObject(jsonArrayimages.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_VOLUMES) != null && !jsonObj.get(SERIALIZED_NAME_VOLUMES).isJsonNull() && (jsonArrayvolumes = jsonObj.getAsJsonArray(SERIALIZED_NAME_VOLUMES)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_VOLUMES).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `Volumes` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOLUMES).toString()));
            }
            for (int i = 0; i < jsonArrayvolumes.size(); ++i) {
                SystemDfVolumeReport.validateJsonObject(jsonArrayvolumes.get(i).getAsJsonObject());
            }
        }
    }

    public static SystemDfReport fromJson(String jsonString) throws IOException {
        return (SystemDfReport)JSON.getGson().fromJson(jsonString, SystemDfReport.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONTAINERS);
        openapiFields.add(SERIALIZED_NAME_IMAGES);
        openapiFields.add(SERIALIZED_NAME_IMAGES_SIZE);
        openapiFields.add(SERIALIZED_NAME_VOLUMES);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!SystemDfReport.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SystemDfReport.class));
            return new TypeAdapter<SystemDfReport>(){

                public void write(JsonWriter out, SystemDfReport value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public SystemDfReport read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    SystemDfReport.validateJsonObject(jsonObj);
                    return (SystemDfReport)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

