/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.libpodj.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.JSON;
import io.github.pod4dev.libpodj.model.ListPodContainer;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ListPodsReport
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CGROUP = "Cgroup";
    @SerializedName(value="Cgroup")
    private String cgroup;
    public static final String SERIALIZED_NAME_CONTAINERS = "Containers";
    @SerializedName(value="Containers")
    private List<@Valid ListPodContainer> containers = new ArrayList<ListPodContainer>();
    public static final String SERIALIZED_NAME_CREATED = "Created";
    @SerializedName(value="Created")
    private OffsetDateTime created;
    public static final String SERIALIZED_NAME_ID = "Id";
    @SerializedName(value="Id")
    private String id;
    public static final String SERIALIZED_NAME_INFRA_ID = "InfraId";
    @SerializedName(value="InfraId")
    private String infraId;
    public static final String SERIALIZED_NAME_LABELS = "Labels";
    @SerializedName(value="Labels")
    private Map<String, String> labels = new HashMap<String, String>();
    public static final String SERIALIZED_NAME_NAME = "Name";
    @SerializedName(value="Name")
    private String name;
    public static final String SERIALIZED_NAME_NAMESPACE = "Namespace";
    @SerializedName(value="Namespace")
    private String namespace;
    public static final String SERIALIZED_NAME_NETWORKS = "Networks";
    @SerializedName(value="Networks")
    private List<String> networks = new ArrayList<String>();
    public static final String SERIALIZED_NAME_STATUS = "Status";
    @SerializedName(value="Status")
    private String status;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ListPodsReport cgroup(String cgroup) {
        this.cgroup = cgroup;
        return this;
    }

    @Nullable
    public String getCgroup() {
        return this.cgroup;
    }

    public void setCgroup(String cgroup) {
        this.cgroup = cgroup;
    }

    public ListPodsReport containers(List<@Valid ListPodContainer> containers) {
        this.containers = containers;
        return this;
    }

    public ListPodsReport addContainersItem(ListPodContainer containersItem) {
        if (this.containers == null) {
            this.containers = new ArrayList<ListPodContainer>();
        }
        this.containers.add(containersItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid ListPodContainer> getContainers() {
        return this.containers;
    }

    public void setContainers(List<@Valid ListPodContainer> containers) {
        this.containers = containers;
    }

    public ListPodsReport created(OffsetDateTime created) {
        this.created = created;
        return this;
    }

    @Nullable
    @Valid
    public OffsetDateTime getCreated() {
        return this.created;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public ListPodsReport id(String id) {
        this.id = id;
        return this;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public ListPodsReport infraId(String infraId) {
        this.infraId = infraId;
        return this;
    }

    @Nullable
    public String getInfraId() {
        return this.infraId;
    }

    public void setInfraId(String infraId) {
        this.infraId = infraId;
    }

    public ListPodsReport labels(Map<String, String> labels) {
        this.labels = labels;
        return this;
    }

    public ListPodsReport putLabelsItem(String key, String labelsItem) {
        if (this.labels == null) {
            this.labels = new HashMap<String, String>();
        }
        this.labels.put(key, labelsItem);
        return this;
    }

    @Nullable
    public Map<String, String> getLabels() {
        return this.labels;
    }

    public void setLabels(Map<String, String> labels) {
        this.labels = labels;
    }

    public ListPodsReport name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ListPodsReport namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Nullable
    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public ListPodsReport networks(List<String> networks) {
        this.networks = networks;
        return this;
    }

    public ListPodsReport addNetworksItem(String networksItem) {
        if (this.networks == null) {
            this.networks = new ArrayList<String>();
        }
        this.networks.add(networksItem);
        return this;
    }

    @Nullable
    public List<String> getNetworks() {
        return this.networks;
    }

    public void setNetworks(List<String> networks) {
        this.networks = networks;
    }

    public ListPodsReport status(String status) {
        this.status = status;
        return this;
    }

    @Nullable
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListPodsReport listPodsReport = (ListPodsReport)o;
        return Objects.equals(this.cgroup, listPodsReport.cgroup) && Objects.equals(this.containers, listPodsReport.containers) && Objects.equals(this.created, listPodsReport.created) && Objects.equals(this.id, listPodsReport.id) && Objects.equals(this.infraId, listPodsReport.infraId) && Objects.equals(this.labels, listPodsReport.labels) && Objects.equals(this.name, listPodsReport.name) && Objects.equals(this.namespace, listPodsReport.namespace) && Objects.equals(this.networks, listPodsReport.networks) && Objects.equals(this.status, listPodsReport.status);
    }

    public int hashCode() {
        return Objects.hash(this.cgroup, this.containers, this.created, this.id, this.infraId, this.labels, this.name, this.namespace, this.networks, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListPodsReport {\n");
        sb.append("    cgroup: ").append(this.toIndentedString(this.cgroup)).append("\n");
        sb.append("    containers: ").append(this.toIndentedString(this.containers)).append("\n");
        sb.append("    created: ").append(this.toIndentedString(this.created)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    infraId: ").append(this.toIndentedString(this.infraId)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    namespace: ").append(this.toIndentedString(this.namespace)).append("\n");
        sb.append("    networks: ").append(this.toIndentedString(this.networks)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraycontainers;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in ListPodsReport is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `ListPodsReport` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_CGROUP) != null && !jsonObj.get(SERIALIZED_NAME_CGROUP).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CGROUP).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Cgroup` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CGROUP).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CONTAINERS) != null && !jsonObj.get(SERIALIZED_NAME_CONTAINERS).isJsonNull() && (jsonArraycontainers = jsonObj.getAsJsonArray(SERIALIZED_NAME_CONTAINERS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_CONTAINERS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `Containers` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTAINERS).toString()));
            }
            for (int i = 0; i < jsonArraycontainers.size(); ++i) {
                ListPodContainer.validateJsonElement(jsonArraycontainers.get(i));
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_INFRA_ID) != null && !jsonObj.get(SERIALIZED_NAME_INFRA_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_INFRA_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `InfraId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INFRA_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NAMESPACE) != null && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAMESPACE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Namespace` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAMESPACE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NETWORKS) != null && !jsonObj.get(SERIALIZED_NAME_NETWORKS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NETWORKS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Networks` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NETWORKS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `Status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
    }

    public static ListPodsReport fromJson(String jsonString) throws IOException {
        return (ListPodsReport)JSON.getGson().fromJson(jsonString, ListPodsReport.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CGROUP);
        openapiFields.add(SERIALIZED_NAME_CONTAINERS);
        openapiFields.add(SERIALIZED_NAME_CREATED);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_INFRA_ID);
        openapiFields.add(SERIALIZED_NAME_LABELS);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_NAMESPACE);
        openapiFields.add(SERIALIZED_NAME_NETWORKS);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ListPodsReport.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ListPodsReport.class));
            return new TypeAdapter<ListPodsReport>(){

                public void write(JsonWriter out, ListPodsReport value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ListPodsReport read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    ListPodsReport.validateJsonElement(jsonElement);
                    return (ListPodsReport)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

