/*
 * supports a RESTful API for the Libpod library
 * This documentation describes the Podman v2.x+ RESTful API. It consists of a Docker-compatible API and a Libpod API providing support for Podman’s unique features such as pods.  To start the service and keep it running for 5,000 seconds (-t 0 runs forever):  podman system service -t 5000 &  You can then use cURL on the socket using requests documented below.  NOTE: if you install the package podman-docker, it will create a symbolic link for /run/docker.sock to /run/podman/podman.sock  NOTE: Some fields in the API response JSON are encoded as omitempty, which means that if said field has a zero value, they will not be encoded in the API response. This is a feature to help reduce the size of the JSON responses returned via the API.  NOTE: Due to the limitations of [go-swagger](https://github.com/go-swagger/go-swagger), some field values that have a complex type show up as null in the docs as well as in the API responses. This is because the zero value for the field type is null. The field description in the docs will state what type the field is expected to be for such cases.  See podman-system-service(1) for more information.  Quick Examples:  'podman info'  curl --unix-socket /run/podman/podman.sock http://d/v5.0.0/libpod/info  'podman pull quay.io/containers/podman'  curl -XPOST --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/images/create?fromImage=quay.io%2Fcontainers%2Fpodman'  'podman list images'  curl --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/libpod/images/json' | jq
 *
 * The version of the OpenAPI document: 5.0.0
 * Contact: podman@lists.podman.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.pod4dev.libpodj.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.model.InspectSecret;
import io.github.pod4dev.libpodj.model.Schema2HealthConfig;
import io.github.pod4dev.libpodj.model.StartupHealthCheck;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.io.Serializable;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import io.github.pod4dev.libpodj.JSON;

/**
 * InspectContainerConfig holds further data about how a container was initially configured.
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.9.0")
public class InspectContainerConfig implements Serializable {
  private static final long serialVersionUID = 1L;

  public static final String SERIALIZED_NAME_ANNOTATIONS = "Annotations";
  @SerializedName(SERIALIZED_NAME_ANNOTATIONS)
  private Map<String, String> annotations = new HashMap<>();

  public static final String SERIALIZED_NAME_ATTACH_STDERR = "AttachStderr";
  @SerializedName(SERIALIZED_NAME_ATTACH_STDERR)
  private Boolean attachStderr;

  public static final String SERIALIZED_NAME_ATTACH_STDIN = "AttachStdin";
  @SerializedName(SERIALIZED_NAME_ATTACH_STDIN)
  private Boolean attachStdin;

  public static final String SERIALIZED_NAME_ATTACH_STDOUT = "AttachStdout";
  @SerializedName(SERIALIZED_NAME_ATTACH_STDOUT)
  private Boolean attachStdout;

  public static final String SERIALIZED_NAME_CHROOT_DIRS = "ChrootDirs";
  @SerializedName(SERIALIZED_NAME_CHROOT_DIRS)
  private List<String> chrootDirs = new ArrayList<>();

  public static final String SERIALIZED_NAME_CMD = "Cmd";
  @SerializedName(SERIALIZED_NAME_CMD)
  private List<String> cmd = new ArrayList<>();

  public static final String SERIALIZED_NAME_CREATE_COMMAND = "CreateCommand";
  @SerializedName(SERIALIZED_NAME_CREATE_COMMAND)
  private List<String> createCommand = new ArrayList<>();

  public static final String SERIALIZED_NAME_DOMAINNAME = "Domainname";
  @SerializedName(SERIALIZED_NAME_DOMAINNAME)
  private String domainname;

  public static final String SERIALIZED_NAME_ENTRYPOINT = "Entrypoint";
  @SerializedName(SERIALIZED_NAME_ENTRYPOINT)
  private List<String> entrypoint = new ArrayList<>();

  public static final String SERIALIZED_NAME_ENV = "Env";
  @SerializedName(SERIALIZED_NAME_ENV)
  private List<String> env = new ArrayList<>();

  public static final String SERIALIZED_NAME_EXPOSED_PORTS = "ExposedPorts";
  @SerializedName(SERIALIZED_NAME_EXPOSED_PORTS)
  private Map<String, Object> exposedPorts = new HashMap<>();

  public static final String SERIALIZED_NAME_HEALTH_LOG_DESTINATION = "HealthLogDestination";
  @SerializedName(SERIALIZED_NAME_HEALTH_LOG_DESTINATION)
  private String healthLogDestination;

  public static final String SERIALIZED_NAME_HEALTHCHECK = "Healthcheck";
  @SerializedName(SERIALIZED_NAME_HEALTHCHECK)
  private Schema2HealthConfig healthcheck;

  public static final String SERIALIZED_NAME_HEALTHCHECK_MAX_LOG_COUNT = "HealthcheckMaxLogCount";
  @SerializedName(SERIALIZED_NAME_HEALTHCHECK_MAX_LOG_COUNT)
  private Integer healthcheckMaxLogCount;

  public static final String SERIALIZED_NAME_HEALTHCHECK_MAX_LOG_SIZE = "HealthcheckMaxLogSize";
  @SerializedName(SERIALIZED_NAME_HEALTHCHECK_MAX_LOG_SIZE)
  private Integer healthcheckMaxLogSize;

  public static final String SERIALIZED_NAME_HEALTHCHECK_ON_FAILURE_ACTION = "HealthcheckOnFailureAction";
  @SerializedName(SERIALIZED_NAME_HEALTHCHECK_ON_FAILURE_ACTION)
  private String healthcheckOnFailureAction;

  public static final String SERIALIZED_NAME_HOSTNAME = "Hostname";
  @SerializedName(SERIALIZED_NAME_HOSTNAME)
  private String hostname;

  public static final String SERIALIZED_NAME_IMAGE = "Image";
  @SerializedName(SERIALIZED_NAME_IMAGE)
  private String image;

  public static final String SERIALIZED_NAME_LABELS = "Labels";
  @SerializedName(SERIALIZED_NAME_LABELS)
  private Map<String, String> labels = new HashMap<>();

  public static final String SERIALIZED_NAME_ON_BUILD = "OnBuild";
  @SerializedName(SERIALIZED_NAME_ON_BUILD)
  private String onBuild;

  public static final String SERIALIZED_NAME_OPEN_STDIN = "OpenStdin";
  @SerializedName(SERIALIZED_NAME_OPEN_STDIN)
  private Boolean openStdin;

  public static final String SERIALIZED_NAME_PASSWD = "Passwd";
  @SerializedName(SERIALIZED_NAME_PASSWD)
  private Boolean passwd;

  public static final String SERIALIZED_NAME_SECRETS = "Secrets";
  @SerializedName(SERIALIZED_NAME_SECRETS)
  private List<@Valid InspectSecret> secrets = new ArrayList<>();

  public static final String SERIALIZED_NAME_STARTUP_HEALTH_CHECK = "StartupHealthCheck";
  @SerializedName(SERIALIZED_NAME_STARTUP_HEALTH_CHECK)
  private StartupHealthCheck startupHealthCheck;

  public static final String SERIALIZED_NAME_STDIN_ONCE = "StdinOnce";
  @SerializedName(SERIALIZED_NAME_STDIN_ONCE)
  private Boolean stdinOnce;

  public static final String SERIALIZED_NAME_STOP_SIGNAL = "StopSignal";
  @SerializedName(SERIALIZED_NAME_STOP_SIGNAL)
  private String stopSignal;

  public static final String SERIALIZED_NAME_STOP_TIMEOUT = "StopTimeout";
  @SerializedName(SERIALIZED_NAME_STOP_TIMEOUT)
  private Integer stopTimeout;

  public static final String SERIALIZED_NAME_SYSTEMD_MODE = "SystemdMode";
  @SerializedName(SERIALIZED_NAME_SYSTEMD_MODE)
  private Boolean systemdMode;

  public static final String SERIALIZED_NAME_TIMEOUT = "Timeout";
  @SerializedName(SERIALIZED_NAME_TIMEOUT)
  private Integer timeout;

  public static final String SERIALIZED_NAME_TIMEZONE = "Timezone";
  @SerializedName(SERIALIZED_NAME_TIMEZONE)
  private String timezone;

  public static final String SERIALIZED_NAME_TTY = "Tty";
  @SerializedName(SERIALIZED_NAME_TTY)
  private Boolean tty;

  public static final String SERIALIZED_NAME_UMASK = "Umask";
  @SerializedName(SERIALIZED_NAME_UMASK)
  private String umask;

  public static final String SERIALIZED_NAME_USER = "User";
  @SerializedName(SERIALIZED_NAME_USER)
  private String user;

  public static final String SERIALIZED_NAME_VOLUMES = "Volumes";
  @SerializedName(SERIALIZED_NAME_VOLUMES)
  private Map<String, Object> volumes = new HashMap<>();

  public static final String SERIALIZED_NAME_WORKING_DIR = "WorkingDir";
  @SerializedName(SERIALIZED_NAME_WORKING_DIR)
  private String workingDir;

  public static final String SERIALIZED_NAME_SD_NOTIFY_MODE = "sdNotifyMode";
  @SerializedName(SERIALIZED_NAME_SD_NOTIFY_MODE)
  private String sdNotifyMode;

  public static final String SERIALIZED_NAME_SD_NOTIFY_SOCKET = "sdNotifySocket";
  @SerializedName(SERIALIZED_NAME_SD_NOTIFY_SOCKET)
  private String sdNotifySocket;

  public InspectContainerConfig() {
  }

  public InspectContainerConfig annotations(Map<String, String> annotations) {
    this.annotations = annotations;
    return this;
  }

  public InspectContainerConfig putAnnotationsItem(String key, String annotationsItem) {
    if (this.annotations == null) {
      this.annotations = new HashMap<>();
    }
    this.annotations.put(key, annotationsItem);
    return this;
  }

  /**
   * Container annotations
   * @return annotations
   */
  @jakarta.annotation.Nullable

  public Map<String, String> getAnnotations() {
    return annotations;
  }

  public void setAnnotations(Map<String, String> annotations) {
    this.annotations = annotations;
  }


  public InspectContainerConfig attachStderr(Boolean attachStderr) {
    this.attachStderr = attachStderr;
    return this;
  }

  /**
   * Unused, at present
   * @return attachStderr
   */
  @jakarta.annotation.Nullable

  public Boolean getAttachStderr() {
    return attachStderr;
  }

  public void setAttachStderr(Boolean attachStderr) {
    this.attachStderr = attachStderr;
  }


  public InspectContainerConfig attachStdin(Boolean attachStdin) {
    this.attachStdin = attachStdin;
    return this;
  }

  /**
   * Unused, at present
   * @return attachStdin
   */
  @jakarta.annotation.Nullable

  public Boolean getAttachStdin() {
    return attachStdin;
  }

  public void setAttachStdin(Boolean attachStdin) {
    this.attachStdin = attachStdin;
  }


  public InspectContainerConfig attachStdout(Boolean attachStdout) {
    this.attachStdout = attachStdout;
    return this;
  }

  /**
   * Unused, at present
   * @return attachStdout
   */
  @jakarta.annotation.Nullable

  public Boolean getAttachStdout() {
    return attachStdout;
  }

  public void setAttachStdout(Boolean attachStdout) {
    this.attachStdout = attachStdout;
  }


  public InspectContainerConfig chrootDirs(List<String> chrootDirs) {
    this.chrootDirs = chrootDirs;
    return this;
  }

  public InspectContainerConfig addChrootDirsItem(String chrootDirsItem) {
    if (this.chrootDirs == null) {
      this.chrootDirs = new ArrayList<>();
    }
    this.chrootDirs.add(chrootDirsItem);
    return this;
  }

  /**
   * ChrootDirs is an additional set of directories that need to be treated as root directories. Standard bind mounts will be mounted into paths relative to these directories.
   * @return chrootDirs
   */
  @jakarta.annotation.Nullable

  public List<String> getChrootDirs() {
    return chrootDirs;
  }

  public void setChrootDirs(List<String> chrootDirs) {
    this.chrootDirs = chrootDirs;
  }


  public InspectContainerConfig cmd(List<String> cmd) {
    this.cmd = cmd;
    return this;
  }

  public InspectContainerConfig addCmdItem(String cmdItem) {
    if (this.cmd == null) {
      this.cmd = new ArrayList<>();
    }
    this.cmd.add(cmdItem);
    return this;
  }

  /**
   * Container command
   * @return cmd
   */
  @jakarta.annotation.Nullable

  public List<String> getCmd() {
    return cmd;
  }

  public void setCmd(List<String> cmd) {
    this.cmd = cmd;
  }


  public InspectContainerConfig createCommand(List<String> createCommand) {
    this.createCommand = createCommand;
    return this;
  }

  public InspectContainerConfig addCreateCommandItem(String createCommandItem) {
    if (this.createCommand == null) {
      this.createCommand = new ArrayList<>();
    }
    this.createCommand.add(createCommandItem);
    return this;
  }

  /**
   * CreateCommand is the full command plus arguments of the process the container has been created with.
   * @return createCommand
   */
  @jakarta.annotation.Nullable

  public List<String> getCreateCommand() {
    return createCommand;
  }

  public void setCreateCommand(List<String> createCommand) {
    this.createCommand = createCommand;
  }


  public InspectContainerConfig domainname(String domainname) {
    this.domainname = domainname;
    return this;
  }

  /**
   * Container domain name - unused at present
   * @return domainname
   */
  @jakarta.annotation.Nullable

  public String getDomainname() {
    return domainname;
  }

  public void setDomainname(String domainname) {
    this.domainname = domainname;
  }


  public InspectContainerConfig entrypoint(List<String> entrypoint) {
    this.entrypoint = entrypoint;
    return this;
  }

  public InspectContainerConfig addEntrypointItem(String entrypointItem) {
    if (this.entrypoint == null) {
      this.entrypoint = new ArrayList<>();
    }
    this.entrypoint.add(entrypointItem);
    return this;
  }

  /**
   * Container entrypoint
   * @return entrypoint
   */
  @jakarta.annotation.Nullable

  public List<String> getEntrypoint() {
    return entrypoint;
  }

  public void setEntrypoint(List<String> entrypoint) {
    this.entrypoint = entrypoint;
  }


  public InspectContainerConfig env(List<String> env) {
    this.env = env;
    return this;
  }

  public InspectContainerConfig addEnvItem(String envItem) {
    if (this.env == null) {
      this.env = new ArrayList<>();
    }
    this.env.add(envItem);
    return this;
  }

  /**
   * Container environment variables
   * @return env
   */
  @jakarta.annotation.Nullable

  public List<String> getEnv() {
    return env;
  }

  public void setEnv(List<String> env) {
    this.env = env;
  }


  public InspectContainerConfig exposedPorts(Map<String, Object> exposedPorts) {
    this.exposedPorts = exposedPorts;
    return this;
  }

  public InspectContainerConfig putExposedPortsItem(String key, Object exposedPortsItem) {
    if (this.exposedPorts == null) {
      this.exposedPorts = new HashMap<>();
    }
    this.exposedPorts.put(key, exposedPortsItem);
    return this;
  }

  /**
   * ExposedPorts includes ports the container has exposed.
   * @return exposedPorts
   */
  @jakarta.annotation.Nullable

  public Map<String, Object> getExposedPorts() {
    return exposedPorts;
  }

  public void setExposedPorts(Map<String, Object> exposedPorts) {
    this.exposedPorts = exposedPorts;
  }


  public InspectContainerConfig healthLogDestination(String healthLogDestination) {
    this.healthLogDestination = healthLogDestination;
    return this;
  }

  /**
   * HealthLogDestination defines the destination where the log is stored
   * @return healthLogDestination
   */
  @jakarta.annotation.Nullable

  public String getHealthLogDestination() {
    return healthLogDestination;
  }

  public void setHealthLogDestination(String healthLogDestination) {
    this.healthLogDestination = healthLogDestination;
  }


  public InspectContainerConfig healthcheck(Schema2HealthConfig healthcheck) {
    this.healthcheck = healthcheck;
    return this;
  }

  /**
   * Get healthcheck
   * @return healthcheck
   */
  @jakarta.annotation.Nullable
  @Valid

  public Schema2HealthConfig getHealthcheck() {
    return healthcheck;
  }

  public void setHealthcheck(Schema2HealthConfig healthcheck) {
    this.healthcheck = healthcheck;
  }


  public InspectContainerConfig healthcheckMaxLogCount(Integer healthcheckMaxLogCount) {
    this.healthcheckMaxLogCount = healthcheckMaxLogCount;
    return this;
  }

  /**
   * HealthMaxLogCount is maximum number of attempts in the HealthCheck log file. (&#39;0&#39; value means an infinite number of attempts in the log file)
   * @return healthcheckMaxLogCount
   */
  @jakarta.annotation.Nullable

  public Integer getHealthcheckMaxLogCount() {
    return healthcheckMaxLogCount;
  }

  public void setHealthcheckMaxLogCount(Integer healthcheckMaxLogCount) {
    this.healthcheckMaxLogCount = healthcheckMaxLogCount;
  }


  public InspectContainerConfig healthcheckMaxLogSize(Integer healthcheckMaxLogSize) {
    this.healthcheckMaxLogSize = healthcheckMaxLogSize;
    return this;
  }

  /**
   * HealthMaxLogSize is the maximum length in characters of stored HealthCheck log (\&quot;0\&quot; value means an infinite log length)
   * @return healthcheckMaxLogSize
   */
  @jakarta.annotation.Nullable

  public Integer getHealthcheckMaxLogSize() {
    return healthcheckMaxLogSize;
  }

  public void setHealthcheckMaxLogSize(Integer healthcheckMaxLogSize) {
    this.healthcheckMaxLogSize = healthcheckMaxLogSize;
  }


  public InspectContainerConfig healthcheckOnFailureAction(String healthcheckOnFailureAction) {
    this.healthcheckOnFailureAction = healthcheckOnFailureAction;
    return this;
  }

  /**
   * HealthcheckOnFailureAction defines an action to take once the container turns unhealthy.
   * @return healthcheckOnFailureAction
   */
  @jakarta.annotation.Nullable

  public String getHealthcheckOnFailureAction() {
    return healthcheckOnFailureAction;
  }

  public void setHealthcheckOnFailureAction(String healthcheckOnFailureAction) {
    this.healthcheckOnFailureAction = healthcheckOnFailureAction;
  }


  public InspectContainerConfig hostname(String hostname) {
    this.hostname = hostname;
    return this;
  }

  /**
   * Container hostname
   * @return hostname
   */
  @jakarta.annotation.Nullable

  public String getHostname() {
    return hostname;
  }

  public void setHostname(String hostname) {
    this.hostname = hostname;
  }


  public InspectContainerConfig image(String image) {
    this.image = image;
    return this;
  }

  /**
   * Container image
   * @return image
   */
  @jakarta.annotation.Nullable

  public String getImage() {
    return image;
  }

  public void setImage(String image) {
    this.image = image;
  }


  public InspectContainerConfig labels(Map<String, String> labels) {
    this.labels = labels;
    return this;
  }

  public InspectContainerConfig putLabelsItem(String key, String labelsItem) {
    if (this.labels == null) {
      this.labels = new HashMap<>();
    }
    this.labels.put(key, labelsItem);
    return this;
  }

  /**
   * Container labels
   * @return labels
   */
  @jakarta.annotation.Nullable

  public Map<String, String> getLabels() {
    return labels;
  }

  public void setLabels(Map<String, String> labels) {
    this.labels = labels;
  }


  public InspectContainerConfig onBuild(String onBuild) {
    this.onBuild = onBuild;
    return this;
  }

  /**
   * On-build arguments - presently unused. More of Buildah&#39;s domain.
   * @return onBuild
   */
  @jakarta.annotation.Nullable

  public String getOnBuild() {
    return onBuild;
  }

  public void setOnBuild(String onBuild) {
    this.onBuild = onBuild;
  }


  public InspectContainerConfig openStdin(Boolean openStdin) {
    this.openStdin = openStdin;
    return this;
  }

  /**
   * Whether the container leaves STDIN open
   * @return openStdin
   */
  @jakarta.annotation.Nullable

  public Boolean getOpenStdin() {
    return openStdin;
  }

  public void setOpenStdin(Boolean openStdin) {
    this.openStdin = openStdin;
  }


  public InspectContainerConfig passwd(Boolean passwd) {
    this.passwd = passwd;
    return this;
  }

  /**
   * Passwd determines whether or not podman can add entries to /etc/passwd and /etc/group
   * @return passwd
   */
  @jakarta.annotation.Nullable

  public Boolean getPasswd() {
    return passwd;
  }

  public void setPasswd(Boolean passwd) {
    this.passwd = passwd;
  }


  public InspectContainerConfig secrets(List<@Valid InspectSecret> secrets) {
    this.secrets = secrets;
    return this;
  }

  public InspectContainerConfig addSecretsItem(InspectSecret secretsItem) {
    if (this.secrets == null) {
      this.secrets = new ArrayList<>();
    }
    this.secrets.add(secretsItem);
    return this;
  }

  /**
   * Secrets are the secrets mounted in the container
   * @return secrets
   */
  @jakarta.annotation.Nullable
  @Valid

  public List<@Valid InspectSecret> getSecrets() {
    return secrets;
  }

  public void setSecrets(List<@Valid InspectSecret> secrets) {
    this.secrets = secrets;
  }


  public InspectContainerConfig startupHealthCheck(StartupHealthCheck startupHealthCheck) {
    this.startupHealthCheck = startupHealthCheck;
    return this;
  }

  /**
   * Get startupHealthCheck
   * @return startupHealthCheck
   */
  @jakarta.annotation.Nullable
  @Valid

  public StartupHealthCheck getStartupHealthCheck() {
    return startupHealthCheck;
  }

  public void setStartupHealthCheck(StartupHealthCheck startupHealthCheck) {
    this.startupHealthCheck = startupHealthCheck;
  }


  public InspectContainerConfig stdinOnce(Boolean stdinOnce) {
    this.stdinOnce = stdinOnce;
    return this;
  }

  /**
   * Whether STDIN is only left open once. Presently not supported by Podman, unused.
   * @return stdinOnce
   */
  @jakarta.annotation.Nullable

  public Boolean getStdinOnce() {
    return stdinOnce;
  }

  public void setStdinOnce(Boolean stdinOnce) {
    this.stdinOnce = stdinOnce;
  }


  public InspectContainerConfig stopSignal(String stopSignal) {
    this.stopSignal = stopSignal;
    return this;
  }

  /**
   * Container stop signal
   * @return stopSignal
   */
  @jakarta.annotation.Nullable

  public String getStopSignal() {
    return stopSignal;
  }

  public void setStopSignal(String stopSignal) {
    this.stopSignal = stopSignal;
  }


  public InspectContainerConfig stopTimeout(Integer stopTimeout) {
    this.stopTimeout = stopTimeout;
    return this;
  }

  /**
   * StopTimeout is time before container is stopped when calling stop
   * @return stopTimeout
   */
  @jakarta.annotation.Nullable

  public Integer getStopTimeout() {
    return stopTimeout;
  }

  public void setStopTimeout(Integer stopTimeout) {
    this.stopTimeout = stopTimeout;
  }


  public InspectContainerConfig systemdMode(Boolean systemdMode) {
    this.systemdMode = systemdMode;
    return this;
  }

  /**
   * SystemdMode is whether the container is running in systemd mode. In systemd mode, the container configuration is customized to optimize running systemd in the container.
   * @return systemdMode
   */
  @jakarta.annotation.Nullable

  public Boolean getSystemdMode() {
    return systemdMode;
  }

  public void setSystemdMode(Boolean systemdMode) {
    this.systemdMode = systemdMode;
  }


  public InspectContainerConfig timeout(Integer timeout) {
    this.timeout = timeout;
    return this;
  }

  /**
   * Timeout is time before container is killed by conmon
   * @return timeout
   */
  @jakarta.annotation.Nullable

  public Integer getTimeout() {
    return timeout;
  }

  public void setTimeout(Integer timeout) {
    this.timeout = timeout;
  }


  public InspectContainerConfig timezone(String timezone) {
    this.timezone = timezone;
    return this;
  }

  /**
   * Timezone is the timezone inside the container. Local means it has the same timezone as the host machine
   * @return timezone
   */
  @jakarta.annotation.Nullable

  public String getTimezone() {
    return timezone;
  }

  public void setTimezone(String timezone) {
    this.timezone = timezone;
  }


  public InspectContainerConfig tty(Boolean tty) {
    this.tty = tty;
    return this;
  }

  /**
   * Whether the container creates a TTY
   * @return tty
   */
  @jakarta.annotation.Nullable

  public Boolean getTty() {
    return tty;
  }

  public void setTty(Boolean tty) {
    this.tty = tty;
  }


  public InspectContainerConfig umask(String umask) {
    this.umask = umask;
    return this;
  }

  /**
   * Umask is the umask inside the container.
   * @return umask
   */
  @jakarta.annotation.Nullable

  public String getUmask() {
    return umask;
  }

  public void setUmask(String umask) {
    this.umask = umask;
  }


  public InspectContainerConfig user(String user) {
    this.user = user;
    return this;
  }

  /**
   * User the container was launched with
   * @return user
   */
  @jakarta.annotation.Nullable

  public String getUser() {
    return user;
  }

  public void setUser(String user) {
    this.user = user;
  }


  public InspectContainerConfig volumes(Map<String, Object> volumes) {
    this.volumes = volumes;
    return this;
  }

  public InspectContainerConfig putVolumesItem(String key, Object volumesItem) {
    if (this.volumes == null) {
      this.volumes = new HashMap<>();
    }
    this.volumes.put(key, volumesItem);
    return this;
  }

  /**
   * Unused, at present. I&#39;ve never seen this field populated.
   * @return volumes
   */
  @jakarta.annotation.Nullable

  public Map<String, Object> getVolumes() {
    return volumes;
  }

  public void setVolumes(Map<String, Object> volumes) {
    this.volumes = volumes;
  }


  public InspectContainerConfig workingDir(String workingDir) {
    this.workingDir = workingDir;
    return this;
  }

  /**
   * Container working directory
   * @return workingDir
   */
  @jakarta.annotation.Nullable

  public String getWorkingDir() {
    return workingDir;
  }

  public void setWorkingDir(String workingDir) {
    this.workingDir = workingDir;
  }


  public InspectContainerConfig sdNotifyMode(String sdNotifyMode) {
    this.sdNotifyMode = sdNotifyMode;
    return this;
  }

  /**
   * SdNotifyMode is the sd-notify mode of the container.
   * @return sdNotifyMode
   */
  @jakarta.annotation.Nullable

  public String getSdNotifyMode() {
    return sdNotifyMode;
  }

  public void setSdNotifyMode(String sdNotifyMode) {
    this.sdNotifyMode = sdNotifyMode;
  }


  public InspectContainerConfig sdNotifySocket(String sdNotifySocket) {
    this.sdNotifySocket = sdNotifySocket;
    return this;
  }

  /**
   * SdNotifySocket is the NOTIFY_SOCKET in use by/configured for the container.
   * @return sdNotifySocket
   */
  @jakarta.annotation.Nullable

  public String getSdNotifySocket() {
    return sdNotifySocket;
  }

  public void setSdNotifySocket(String sdNotifySocket) {
    this.sdNotifySocket = sdNotifySocket;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InspectContainerConfig inspectContainerConfig = (InspectContainerConfig) o;
    return Objects.equals(this.annotations, inspectContainerConfig.annotations) &&
        Objects.equals(this.attachStderr, inspectContainerConfig.attachStderr) &&
        Objects.equals(this.attachStdin, inspectContainerConfig.attachStdin) &&
        Objects.equals(this.attachStdout, inspectContainerConfig.attachStdout) &&
        Objects.equals(this.chrootDirs, inspectContainerConfig.chrootDirs) &&
        Objects.equals(this.cmd, inspectContainerConfig.cmd) &&
        Objects.equals(this.createCommand, inspectContainerConfig.createCommand) &&
        Objects.equals(this.domainname, inspectContainerConfig.domainname) &&
        Objects.equals(this.entrypoint, inspectContainerConfig.entrypoint) &&
        Objects.equals(this.env, inspectContainerConfig.env) &&
        Objects.equals(this.exposedPorts, inspectContainerConfig.exposedPorts) &&
        Objects.equals(this.healthLogDestination, inspectContainerConfig.healthLogDestination) &&
        Objects.equals(this.healthcheck, inspectContainerConfig.healthcheck) &&
        Objects.equals(this.healthcheckMaxLogCount, inspectContainerConfig.healthcheckMaxLogCount) &&
        Objects.equals(this.healthcheckMaxLogSize, inspectContainerConfig.healthcheckMaxLogSize) &&
        Objects.equals(this.healthcheckOnFailureAction, inspectContainerConfig.healthcheckOnFailureAction) &&
        Objects.equals(this.hostname, inspectContainerConfig.hostname) &&
        Objects.equals(this.image, inspectContainerConfig.image) &&
        Objects.equals(this.labels, inspectContainerConfig.labels) &&
        Objects.equals(this.onBuild, inspectContainerConfig.onBuild) &&
        Objects.equals(this.openStdin, inspectContainerConfig.openStdin) &&
        Objects.equals(this.passwd, inspectContainerConfig.passwd) &&
        Objects.equals(this.secrets, inspectContainerConfig.secrets) &&
        Objects.equals(this.startupHealthCheck, inspectContainerConfig.startupHealthCheck) &&
        Objects.equals(this.stdinOnce, inspectContainerConfig.stdinOnce) &&
        Objects.equals(this.stopSignal, inspectContainerConfig.stopSignal) &&
        Objects.equals(this.stopTimeout, inspectContainerConfig.stopTimeout) &&
        Objects.equals(this.systemdMode, inspectContainerConfig.systemdMode) &&
        Objects.equals(this.timeout, inspectContainerConfig.timeout) &&
        Objects.equals(this.timezone, inspectContainerConfig.timezone) &&
        Objects.equals(this.tty, inspectContainerConfig.tty) &&
        Objects.equals(this.umask, inspectContainerConfig.umask) &&
        Objects.equals(this.user, inspectContainerConfig.user) &&
        Objects.equals(this.volumes, inspectContainerConfig.volumes) &&
        Objects.equals(this.workingDir, inspectContainerConfig.workingDir) &&
        Objects.equals(this.sdNotifyMode, inspectContainerConfig.sdNotifyMode) &&
        Objects.equals(this.sdNotifySocket, inspectContainerConfig.sdNotifySocket);
  }

  @Override
  public int hashCode() {
    return Objects.hash(annotations, attachStderr, attachStdin, attachStdout, chrootDirs, cmd, createCommand, domainname, entrypoint, env, exposedPorts, healthLogDestination, healthcheck, healthcheckMaxLogCount, healthcheckMaxLogSize, healthcheckOnFailureAction, hostname, image, labels, onBuild, openStdin, passwd, secrets, startupHealthCheck, stdinOnce, stopSignal, stopTimeout, systemdMode, timeout, timezone, tty, umask, user, volumes, workingDir, sdNotifyMode, sdNotifySocket);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InspectContainerConfig {\n");
    sb.append("    annotations: ").append(toIndentedString(annotations)).append("\n");
    sb.append("    attachStderr: ").append(toIndentedString(attachStderr)).append("\n");
    sb.append("    attachStdin: ").append(toIndentedString(attachStdin)).append("\n");
    sb.append("    attachStdout: ").append(toIndentedString(attachStdout)).append("\n");
    sb.append("    chrootDirs: ").append(toIndentedString(chrootDirs)).append("\n");
    sb.append("    cmd: ").append(toIndentedString(cmd)).append("\n");
    sb.append("    createCommand: ").append(toIndentedString(createCommand)).append("\n");
    sb.append("    domainname: ").append(toIndentedString(domainname)).append("\n");
    sb.append("    entrypoint: ").append(toIndentedString(entrypoint)).append("\n");
    sb.append("    env: ").append(toIndentedString(env)).append("\n");
    sb.append("    exposedPorts: ").append(toIndentedString(exposedPorts)).append("\n");
    sb.append("    healthLogDestination: ").append(toIndentedString(healthLogDestination)).append("\n");
    sb.append("    healthcheck: ").append(toIndentedString(healthcheck)).append("\n");
    sb.append("    healthcheckMaxLogCount: ").append(toIndentedString(healthcheckMaxLogCount)).append("\n");
    sb.append("    healthcheckMaxLogSize: ").append(toIndentedString(healthcheckMaxLogSize)).append("\n");
    sb.append("    healthcheckOnFailureAction: ").append(toIndentedString(healthcheckOnFailureAction)).append("\n");
    sb.append("    hostname: ").append(toIndentedString(hostname)).append("\n");
    sb.append("    image: ").append(toIndentedString(image)).append("\n");
    sb.append("    labels: ").append(toIndentedString(labels)).append("\n");
    sb.append("    onBuild: ").append(toIndentedString(onBuild)).append("\n");
    sb.append("    openStdin: ").append(toIndentedString(openStdin)).append("\n");
    sb.append("    passwd: ").append(toIndentedString(passwd)).append("\n");
    sb.append("    secrets: ").append(toIndentedString(secrets)).append("\n");
    sb.append("    startupHealthCheck: ").append(toIndentedString(startupHealthCheck)).append("\n");
    sb.append("    stdinOnce: ").append(toIndentedString(stdinOnce)).append("\n");
    sb.append("    stopSignal: ").append(toIndentedString(stopSignal)).append("\n");
    sb.append("    stopTimeout: ").append(toIndentedString(stopTimeout)).append("\n");
    sb.append("    systemdMode: ").append(toIndentedString(systemdMode)).append("\n");
    sb.append("    timeout: ").append(toIndentedString(timeout)).append("\n");
    sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
    sb.append("    tty: ").append(toIndentedString(tty)).append("\n");
    sb.append("    umask: ").append(toIndentedString(umask)).append("\n");
    sb.append("    user: ").append(toIndentedString(user)).append("\n");
    sb.append("    volumes: ").append(toIndentedString(volumes)).append("\n");
    sb.append("    workingDir: ").append(toIndentedString(workingDir)).append("\n");
    sb.append("    sdNotifyMode: ").append(toIndentedString(sdNotifyMode)).append("\n");
    sb.append("    sdNotifySocket: ").append(toIndentedString(sdNotifySocket)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("Annotations");
    openapiFields.add("AttachStderr");
    openapiFields.add("AttachStdin");
    openapiFields.add("AttachStdout");
    openapiFields.add("ChrootDirs");
    openapiFields.add("Cmd");
    openapiFields.add("CreateCommand");
    openapiFields.add("Domainname");
    openapiFields.add("Entrypoint");
    openapiFields.add("Env");
    openapiFields.add("ExposedPorts");
    openapiFields.add("HealthLogDestination");
    openapiFields.add("Healthcheck");
    openapiFields.add("HealthcheckMaxLogCount");
    openapiFields.add("HealthcheckMaxLogSize");
    openapiFields.add("HealthcheckOnFailureAction");
    openapiFields.add("Hostname");
    openapiFields.add("Image");
    openapiFields.add("Labels");
    openapiFields.add("OnBuild");
    openapiFields.add("OpenStdin");
    openapiFields.add("Passwd");
    openapiFields.add("Secrets");
    openapiFields.add("StartupHealthCheck");
    openapiFields.add("StdinOnce");
    openapiFields.add("StopSignal");
    openapiFields.add("StopTimeout");
    openapiFields.add("SystemdMode");
    openapiFields.add("Timeout");
    openapiFields.add("Timezone");
    openapiFields.add("Tty");
    openapiFields.add("Umask");
    openapiFields.add("User");
    openapiFields.add("Volumes");
    openapiFields.add("WorkingDir");
    openapiFields.add("sdNotifyMode");
    openapiFields.add("sdNotifySocket");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

  /**
   * Validates the JSON Element and throws an exception if issues found
   *
   * @param jsonElement JSON Element
   * @throws IOException if the JSON Element is invalid with respect to InspectContainerConfig
   */
  public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (jsonElement == null) {
        if (!InspectContainerConfig.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in InspectContainerConfig is not found in the empty JSON string", InspectContainerConfig.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!InspectContainerConfig.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `InspectContainerConfig` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      // ensure the optional json data is an array if present
      if (jsonObj.get("ChrootDirs") != null && !jsonObj.get("ChrootDirs").isJsonNull() && !jsonObj.get("ChrootDirs").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `ChrootDirs` to be an array in the JSON string but got `%s`", jsonObj.get("ChrootDirs").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("Cmd") != null && !jsonObj.get("Cmd").isJsonNull() && !jsonObj.get("Cmd").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `Cmd` to be an array in the JSON string but got `%s`", jsonObj.get("Cmd").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("CreateCommand") != null && !jsonObj.get("CreateCommand").isJsonNull() && !jsonObj.get("CreateCommand").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `CreateCommand` to be an array in the JSON string but got `%s`", jsonObj.get("CreateCommand").toString()));
      }
      if ((jsonObj.get("Domainname") != null && !jsonObj.get("Domainname").isJsonNull()) && !jsonObj.get("Domainname").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `Domainname` to be a primitive type in the JSON string but got `%s`", jsonObj.get("Domainname").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("Entrypoint") != null && !jsonObj.get("Entrypoint").isJsonNull() && !jsonObj.get("Entrypoint").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `Entrypoint` to be an array in the JSON string but got `%s`", jsonObj.get("Entrypoint").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("Env") != null && !jsonObj.get("Env").isJsonNull() && !jsonObj.get("Env").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `Env` to be an array in the JSON string but got `%s`", jsonObj.get("Env").toString()));
      }
      if ((jsonObj.get("HealthLogDestination") != null && !jsonObj.get("HealthLogDestination").isJsonNull()) && !jsonObj.get("HealthLogDestination").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `HealthLogDestination` to be a primitive type in the JSON string but got `%s`", jsonObj.get("HealthLogDestination").toString()));
      }
      // validate the optional field `Healthcheck`
      if (jsonObj.get("Healthcheck") != null && !jsonObj.get("Healthcheck").isJsonNull()) {
        Schema2HealthConfig.validateJsonElement(jsonObj.get("Healthcheck"));
      }
      if ((jsonObj.get("HealthcheckOnFailureAction") != null && !jsonObj.get("HealthcheckOnFailureAction").isJsonNull()) && !jsonObj.get("HealthcheckOnFailureAction").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `HealthcheckOnFailureAction` to be a primitive type in the JSON string but got `%s`", jsonObj.get("HealthcheckOnFailureAction").toString()));
      }
      if ((jsonObj.get("Hostname") != null && !jsonObj.get("Hostname").isJsonNull()) && !jsonObj.get("Hostname").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `Hostname` to be a primitive type in the JSON string but got `%s`", jsonObj.get("Hostname").toString()));
      }
      if ((jsonObj.get("Image") != null && !jsonObj.get("Image").isJsonNull()) && !jsonObj.get("Image").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `Image` to be a primitive type in the JSON string but got `%s`", jsonObj.get("Image").toString()));
      }
      if ((jsonObj.get("OnBuild") != null && !jsonObj.get("OnBuild").isJsonNull()) && !jsonObj.get("OnBuild").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `OnBuild` to be a primitive type in the JSON string but got `%s`", jsonObj.get("OnBuild").toString()));
      }
      if (jsonObj.get("Secrets") != null && !jsonObj.get("Secrets").isJsonNull()) {
        JsonArray jsonArraysecrets = jsonObj.getAsJsonArray("Secrets");
        if (jsonArraysecrets != null) {
          // ensure the json data is an array
          if (!jsonObj.get("Secrets").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `Secrets` to be an array in the JSON string but got `%s`", jsonObj.get("Secrets").toString()));
          }

          // validate the optional field `Secrets` (array)
          for (int i = 0; i < jsonArraysecrets.size(); i++) {
            InspectSecret.validateJsonElement(jsonArraysecrets.get(i));
          };
        }
      }
      // validate the optional field `StartupHealthCheck`
      if (jsonObj.get("StartupHealthCheck") != null && !jsonObj.get("StartupHealthCheck").isJsonNull()) {
        StartupHealthCheck.validateJsonElement(jsonObj.get("StartupHealthCheck"));
      }
      if ((jsonObj.get("StopSignal") != null && !jsonObj.get("StopSignal").isJsonNull()) && !jsonObj.get("StopSignal").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `StopSignal` to be a primitive type in the JSON string but got `%s`", jsonObj.get("StopSignal").toString()));
      }
      if ((jsonObj.get("Timezone") != null && !jsonObj.get("Timezone").isJsonNull()) && !jsonObj.get("Timezone").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `Timezone` to be a primitive type in the JSON string but got `%s`", jsonObj.get("Timezone").toString()));
      }
      if ((jsonObj.get("Umask") != null && !jsonObj.get("Umask").isJsonNull()) && !jsonObj.get("Umask").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `Umask` to be a primitive type in the JSON string but got `%s`", jsonObj.get("Umask").toString()));
      }
      if ((jsonObj.get("User") != null && !jsonObj.get("User").isJsonNull()) && !jsonObj.get("User").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `User` to be a primitive type in the JSON string but got `%s`", jsonObj.get("User").toString()));
      }
      if ((jsonObj.get("WorkingDir") != null && !jsonObj.get("WorkingDir").isJsonNull()) && !jsonObj.get("WorkingDir").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `WorkingDir` to be a primitive type in the JSON string but got `%s`", jsonObj.get("WorkingDir").toString()));
      }
      if ((jsonObj.get("sdNotifyMode") != null && !jsonObj.get("sdNotifyMode").isJsonNull()) && !jsonObj.get("sdNotifyMode").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `sdNotifyMode` to be a primitive type in the JSON string but got `%s`", jsonObj.get("sdNotifyMode").toString()));
      }
      if ((jsonObj.get("sdNotifySocket") != null && !jsonObj.get("sdNotifySocket").isJsonNull()) && !jsonObj.get("sdNotifySocket").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `sdNotifySocket` to be a primitive type in the JSON string but got `%s`", jsonObj.get("sdNotifySocket").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!InspectContainerConfig.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'InspectContainerConfig' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<InspectContainerConfig> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(InspectContainerConfig.class));

       return (TypeAdapter<T>) new TypeAdapter<InspectContainerConfig>() {
           @Override
           public void write(JsonWriter out, InspectContainerConfig value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public InspectContainerConfig read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

  /**
   * Create an instance of InspectContainerConfig given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of InspectContainerConfig
   * @throws IOException if the JSON string is invalid with respect to InspectContainerConfig
   */
  public static InspectContainerConfig fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, InspectContainerConfig.class);
  }

  /**
   * Convert an instance of InspectContainerConfig to an JSON string
   *
   * @return JSON string
   */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

