/*
 * supports a RESTful API for the Libpod library
 * This documentation describes the Podman v2.x+ RESTful API. It consists of a Docker-compatible API and a Libpod API providing support for Podman’s unique features such as pods.  To start the service and keep it running for 5,000 seconds (-t 0 runs forever):  podman system service -t 5000 &  You can then use cURL on the socket using requests documented below.  NOTE: if you install the package podman-docker, it will create a symbolic link for /run/docker.sock to /run/podman/podman.sock  NOTE: Some fields in the API response JSON are encoded as omitempty, which means that if said field has a zero value, they will not be encoded in the API response. This is a feature to help reduce the size of the JSON responses returned via the API.  NOTE: Due to the limitations of [go-swagger](https://github.com/go-swagger/go-swagger), some field values that have a complex type show up as null in the docs as well as in the API responses. This is because the zero value for the field type is null. The field description in the docs will state what type the field is expected to be for such cases.  See podman-system-service(1) for more information.  Quick Examples:  'podman info'  curl --unix-socket /run/podman/podman.sock http://d/v5.0.0/libpod/info  'podman pull quay.io/containers/podman'  curl -XPOST --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/images/create?fromImage=quay.io%2Fcontainers%2Fpodman'  'podman list images'  curl --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/libpod/images/json' | jq
 *
 * The version of the OpenAPI document: 5.0.0
 * Contact: podman@lists.podman.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.pod4dev.libpodj.api;

import io.github.pod4dev.libpodj.ApiCallback;
import io.github.pod4dev.libpodj.ApiClient;
import io.github.pod4dev.libpodj.ApiException;
import io.github.pod4dev.libpodj.ApiResponse;
import io.github.pod4dev.libpodj.Configuration;
import io.github.pod4dev.libpodj.Pair;
import io.github.pod4dev.libpodj.ProgressRequestBody;
import io.github.pod4dev.libpodj.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;

import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

import io.github.pod4dev.libpodj.model.ErrorModel;
import java.io.File;
import io.github.pod4dev.libpodj.model.HistoryResponse;
import io.github.pod4dev.libpodj.model.ImageBuildLibpod200Response;
import io.github.pod4dev.libpodj.model.ImageData;
import io.github.pod4dev.libpodj.model.ImageImportReport;
import io.github.pod4dev.libpodj.model.ImageLoadReport;
import io.github.pod4dev.libpodj.model.ImageSearch200Response;
import io.github.pod4dev.libpodj.model.ImageTreeReport;
import io.github.pod4dev.libpodj.model.LibpodImageSummary;
import io.github.pod4dev.libpodj.model.LibpodImagesPullReport;
import io.github.pod4dev.libpodj.model.LibpodImagesRemoveReport;
import io.github.pod4dev.libpodj.model.PruneReport;
import io.github.pod4dev.libpodj.model.ScpReport;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImagesApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;

    public ImagesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ImagesApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private okhttp3.Call imageBuildLibpodCall(String dockerfile, String t, Boolean allplatforms, String extrahosts, Boolean nohosts, String remote, Boolean q, Boolean compatvolumes, Boolean inheritlabels, Boolean nocache, String cachefrom, Boolean pull, Boolean rm, Boolean forcerm, Integer memory, Integer memswap, Integer cpushares, String cpusetcpus, Integer cpuperiod, Integer cpuquota, String buildargs, Integer shmsize, Boolean squash, String labels, List<String> layerLabel, Boolean layers, String networkmode, String platform, String target, String outputs, Boolean httpproxy, List<String> unsetenv, List<String> unsetlabel, List<String> volume, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/build";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (dockerfile != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("dockerfile", dockerfile));
        }

        if (t != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("t", t));
        }

        if (allplatforms != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("allplatforms", allplatforms));
        }

        if (extrahosts != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("extrahosts", extrahosts));
        }

        if (nohosts != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("nohosts", nohosts));
        }

        if (remote != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("remote", remote));
        }

        if (q != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("q", q));
        }

        if (compatvolumes != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("compatvolumes", compatvolumes));
        }

        if (inheritlabels != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("inheritlabels", inheritlabels));
        }

        if (nocache != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("nocache", nocache));
        }

        if (cachefrom != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("cachefrom", cachefrom));
        }

        if (pull != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("pull", pull));
        }

        if (rm != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("rm", rm));
        }

        if (forcerm != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("forcerm", forcerm));
        }

        if (memory != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("memory", memory));
        }

        if (memswap != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("memswap", memswap));
        }

        if (cpushares != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("cpushares", cpushares));
        }

        if (cpusetcpus != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("cpusetcpus", cpusetcpus));
        }

        if (cpuperiod != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("cpuperiod", cpuperiod));
        }

        if (cpuquota != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("cpuquota", cpuquota));
        }

        if (buildargs != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("buildargs", buildargs));
        }

        if (shmsize != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("shmsize", shmsize));
        }

        if (squash != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("squash", squash));
        }

        if (labels != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("labels", labels));
        }

        if (layerLabel != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "layerLabel", layerLabel));
        }

        if (layers != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("layers", layers));
        }

        if (networkmode != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("networkmode", networkmode));
        }

        if (platform != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("platform", platform));
        }

        if (target != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("target", target));
        }

        if (outputs != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("outputs", outputs));
        }

        if (httpproxy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("httpproxy", httpproxy));
        }

        if (unsetenv != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "unsetenv", unsetenv));
        }

        if (unsetlabel != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "unsetlabel", unsetlabel));
        }

        if (volume != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "volume", volume));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call imageBuildLibpodValidateBeforeCall(String dockerfile, String t, Boolean allplatforms, String extrahosts, Boolean nohosts, String remote, Boolean q, Boolean compatvolumes, Boolean inheritlabels, Boolean nocache, String cachefrom, Boolean pull, Boolean rm, Boolean forcerm, Integer memory, Integer memswap, Integer cpushares, String cpusetcpus, Integer cpuperiod, Integer cpuquota, String buildargs, Integer shmsize, Boolean squash, String labels, List<String> layerLabel, Boolean layers, String networkmode, String platform, String target, String outputs, Boolean httpproxy, List<String> unsetenv, List<String> unsetlabel, List<String> volume, final ApiCallback _callback) throws ApiException {
        return imageBuildLibpodCall(dockerfile, t, allplatforms, extrahosts, nohosts, remote, q, compatvolumes, inheritlabels, nocache, cachefrom, pull, rm, forcerm, memory, memswap, cpushares, cpusetcpus, cpuperiod, cpuquota, buildargs, shmsize, squash, labels, layerLabel, layers, networkmode, platform, target, outputs, httpproxy, unsetenv, unsetlabel, volume, _callback);

    }


    private ApiResponse<ImageBuildLibpod200Response> imageBuildLibpodWithHttpInfo(String dockerfile, String t, Boolean allplatforms, String extrahosts, Boolean nohosts, String remote, Boolean q, Boolean compatvolumes, Boolean inheritlabels, Boolean nocache, String cachefrom, Boolean pull, Boolean rm, Boolean forcerm, Integer memory, Integer memswap, Integer cpushares, String cpusetcpus, Integer cpuperiod, Integer cpuquota, String buildargs, Integer shmsize, Boolean squash, String labels, List<String> layerLabel, Boolean layers, String networkmode, String platform, String target, String outputs, Boolean httpproxy, List<String> unsetenv, List<String> unsetlabel, List<String> volume) throws ApiException {
        okhttp3.Call localVarCall = imageBuildLibpodValidateBeforeCall(dockerfile, t, allplatforms, extrahosts, nohosts, remote, q, compatvolumes, inheritlabels, nocache, cachefrom, pull, rm, forcerm, memory, memswap, cpushares, cpusetcpus, cpuperiod, cpuquota, buildargs, shmsize, squash, labels, layerLabel, layers, networkmode, platform, target, outputs, httpproxy, unsetenv, unsetlabel, volume, null);
        Type localVarReturnType = new TypeToken<ImageBuildLibpod200Response>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call imageBuildLibpodAsync(String dockerfile, String t, Boolean allplatforms, String extrahosts, Boolean nohosts, String remote, Boolean q, Boolean compatvolumes, Boolean inheritlabels, Boolean nocache, String cachefrom, Boolean pull, Boolean rm, Boolean forcerm, Integer memory, Integer memswap, Integer cpushares, String cpusetcpus, Integer cpuperiod, Integer cpuquota, String buildargs, Integer shmsize, Boolean squash, String labels, List<String> layerLabel, Boolean layers, String networkmode, String platform, String target, String outputs, Boolean httpproxy, List<String> unsetenv, List<String> unsetlabel, List<String> volume, final ApiCallback<ImageBuildLibpod200Response> _callback) throws ApiException {

        okhttp3.Call localVarCall = imageBuildLibpodValidateBeforeCall(dockerfile, t, allplatforms, extrahosts, nohosts, remote, q, compatvolumes, inheritlabels, nocache, cachefrom, pull, rm, forcerm, memory, memswap, cpushares, cpusetcpus, cpuperiod, cpuquota, buildargs, shmsize, squash, labels, layerLabel, layers, networkmode, platform, target, outputs, httpproxy, unsetenv, unsetlabel, volume, _callback);
        Type localVarReturnType = new TypeToken<ImageBuildLibpod200Response>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIimageBuildLibpodRequest {
        private String dockerfile;
        private String t;
        private Boolean allplatforms;
        private String extrahosts;
        private Boolean nohosts;
        private String remote;
        private Boolean q;
        private Boolean compatvolumes;
        private Boolean inheritlabels;
        private Boolean nocache;
        private String cachefrom;
        private Boolean pull;
        private Boolean rm;
        private Boolean forcerm;
        private Integer memory;
        private Integer memswap;
        private Integer cpushares;
        private String cpusetcpus;
        private Integer cpuperiod;
        private Integer cpuquota;
        private String buildargs;
        private Integer shmsize;
        private Boolean squash;
        private String labels;
        private List<String> layerLabel;
        private Boolean layers;
        private String networkmode;
        private String platform;
        private String target;
        private String outputs;
        private Boolean httpproxy;
        private List<String> unsetenv;
        private List<String> unsetlabel;
        private List<String> volume;

        private APIimageBuildLibpodRequest() {
        }

        /**
         * Set dockerfile
         * @param dockerfile Path within the build context to the &#x60;Dockerfile&#x60;. This is ignored if remote is specified and points to an external &#x60;Dockerfile&#x60;.  (optional, default to Dockerfile)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest dockerfile(String dockerfile) {
            this.dockerfile = dockerfile;
            return this;
        }

        /**
         * Set t
         * @param t A name and optional tag to apply to the image in the &#x60;name:tag&#x60; format.  If you omit the tag, the default latest value is assumed. You can provide several t parameters. (optional, default to latest)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest t(String t) {
            this.t = t;
            return this;
        }

        /**
         * Set allplatforms
         * @param allplatforms Instead of building for a set of platforms specified using the platform option, inspect the build&#39;s base images, and build for all of the platforms that are available.  Stages that use *scratch* as a starting point can not be inspected, so at least one non-*scratch* stage must be present for detection to work usefully.  (optional, default to false)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest allplatforms(Boolean allplatforms) {
            this.allplatforms = allplatforms;
            return this;
        }

        /**
         * Set extrahosts
         * @param extrahosts TBD Extra hosts to add to /etc/hosts (As of version 1.xx)  (optional)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest extrahosts(String extrahosts) {
            this.extrahosts = extrahosts;
            return this;
        }

        /**
         * Set nohosts
         * @param nohosts Not to create /etc/hosts when building the image  (optional)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest nohosts(Boolean nohosts) {
            this.nohosts = nohosts;
            return this;
        }

        /**
         * Set remote
         * @param remote A Git repository URI or HTTP/HTTPS context URI. If the URI points to a single text file, the file’s contents are placed into a file called Dockerfile and the image is built from that file. If the URI points to a tarball, the file is downloaded by the daemon and the contents therein used as the context for the build. If the URI points to a tarball and the dockerfile parameter is also specified, there must be a file with the corresponding path inside the tarball. (As of version 1.xx)  (optional)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest remote(String remote) {
            this.remote = remote;
            return this;
        }

        /**
         * Set q
         * @param q Suppress verbose build output  (optional, default to false)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest q(Boolean q) {
            this.q = q;
            return this;
        }

        /**
         * Set compatvolumes
         * @param compatvolumes Contents of base images to be modified on ADD or COPY only (As of Podman version v5.2)  (optional, default to false)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest compatvolumes(Boolean compatvolumes) {
            this.compatvolumes = compatvolumes;
            return this;
        }

        /**
         * Set inheritlabels
         * @param inheritlabels Inherit the labels from the base image or base stages (As of Podman version v5.5)  (optional, default to true)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest inheritlabels(Boolean inheritlabels) {
            this.inheritlabels = inheritlabels;
            return this;
        }

        /**
         * Set nocache
         * @param nocache Do not use the cache when building the image (As of version 1.xx)  (optional, default to false)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest nocache(Boolean nocache) {
            this.nocache = nocache;
            return this;
        }

        /**
         * Set cachefrom
         * @param cachefrom JSON array of images used to build cache resolution (As of version 1.xx)  (optional)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest cachefrom(String cachefrom) {
            this.cachefrom = cachefrom;
            return this;
        }

        /**
         * Set pull
         * @param pull Attempt to pull the image even if an older image exists locally (As of version 1.xx)  (optional, default to false)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest pull(Boolean pull) {
            this.pull = pull;
            return this;
        }

        /**
         * Set rm
         * @param rm Remove intermediate containers after a successful build (As of version 1.xx)  (optional, default to true)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest rm(Boolean rm) {
            this.rm = rm;
            return this;
        }

        /**
         * Set forcerm
         * @param forcerm Always remove intermediate containers, even upon failure (As of version 1.xx)  (optional, default to false)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest forcerm(Boolean forcerm) {
            this.forcerm = forcerm;
            return this;
        }

        /**
         * Set memory
         * @param memory Memory is the upper limit (in bytes) on how much memory running containers can use (As of version 1.xx)  (optional)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        /**
         * Set memswap
         * @param memswap MemorySwap limits the amount of memory and swap together (As of version 1.xx)  (optional)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest memswap(Integer memswap) {
            this.memswap = memswap;
            return this;
        }

        /**
         * Set cpushares
         * @param cpushares CPUShares (relative weight (As of version 1.xx)  (optional)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest cpushares(Integer cpushares) {
            this.cpushares = cpushares;
            return this;
        }

        /**
         * Set cpusetcpus
         * @param cpusetcpus CPUSetCPUs in which to allow execution (0-3, 0,1) (As of version 1.xx)  (optional)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest cpusetcpus(String cpusetcpus) {
            this.cpusetcpus = cpusetcpus;
            return this;
        }

        /**
         * Set cpuperiod
         * @param cpuperiod CPUPeriod limits the CPU CFS (Completely Fair Scheduler) period (As of version 1.xx)  (optional)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest cpuperiod(Integer cpuperiod) {
            this.cpuperiod = cpuperiod;
            return this;
        }

        /**
         * Set cpuquota
         * @param cpuquota CPUQuota limits the CPU CFS (Completely Fair Scheduler) quota (As of version 1.xx)  (optional)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest cpuquota(Integer cpuquota) {
            this.cpuquota = cpuquota;
            return this;
        }

        /**
         * Set buildargs
         * @param buildargs JSON map of string pairs denoting build-time variables. For example, the build argument &#x60;Foo&#x60; with the value of &#x60;bar&#x60; would be encoded in JSON as &#x60;[\&quot;Foo\&quot;:\&quot;bar\&quot;]&#x60;.  For example, buildargs&#x3D;{\&quot;Foo\&quot;:\&quot;bar\&quot;}.  Note(s): * This should not be used to pass secrets. * The value of buildargs should be URI component encoded before being passed to the API.  (As of version 1.xx)  (optional)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest buildargs(String buildargs) {
            this.buildargs = buildargs;
            return this;
        }

        /**
         * Set shmsize
         * @param shmsize ShmSize is the \&quot;size\&quot; value to use when mounting an shmfs on the container&#39;s /dev/shm directory. Default is 64MB (As of version 1.xx)  (optional, default to 67108864)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest shmsize(Integer shmsize) {
            this.shmsize = shmsize;
            return this;
        }

        /**
         * Set squash
         * @param squash Silently ignored. Squash the resulting images layers into a single layer (As of version 1.xx)  (optional, default to false)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest squash(Boolean squash) {
            this.squash = squash;
            return this;
        }

        /**
         * Set labels
         * @param labels JSON map of key, value pairs to set as labels on the new image (As of version 1.xx)  (optional)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest labels(String labels) {
            this.labels = labels;
            return this;
        }

        /**
         * Set layerLabel
         * @param layerLabel Add an intermediate image *label* (e.g. label&#x3D;*value*) to the intermediate image metadata. (optional)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest layerLabel(List<String> layerLabel) {
            this.layerLabel = layerLabel;
            return this;
        }

        /**
         * Set layers
         * @param layers Cache intermediate layers during build. (As of version 1.xx)  (optional, default to true)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest layers(Boolean layers) {
            this.layers = layers;
            return this;
        }

        /**
         * Set networkmode
         * @param networkmode Sets the networking mode for the run commands during build. Supported standard values are:   * &#x60;bridge&#x60; limited to containers within a single host, port mapping required for external access   * &#x60;host&#x60; no isolation between host and containers on this network   * &#x60;none&#x60; disable all networking for this container   * container:&lt;nameOrID&gt; share networking with given container   ---All other values are assumed to be a custom network&#39;s name (As of version 1.xx)  (optional, default to bridge)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest networkmode(String networkmode) {
            this.networkmode = networkmode;
            return this;
        }

        /**
         * Set platform
         * @param platform Platform format os[/arch[/variant]] (As of version 1.xx)  (optional)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest platform(String platform) {
            this.platform = platform;
            return this;
        }

        /**
         * Set target
         * @param target Target build stage (As of version 1.xx)  (optional)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest target(String target) {
            this.target = target;
            return this;
        }

        /**
         * Set outputs
         * @param outputs output configuration TBD (As of version 1.xx)  (optional)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest outputs(String outputs) {
            this.outputs = outputs;
            return this;
        }

        /**
         * Set httpproxy
         * @param httpproxy Inject http proxy environment variables into container (As of version 2.0.0)  (optional)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest httpproxy(Boolean httpproxy) {
            this.httpproxy = httpproxy;
            return this;
        }

        /**
         * Set unsetenv
         * @param unsetenv Unset environment variables from the final image. (optional)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest unsetenv(List<String> unsetenv) {
            this.unsetenv = unsetenv;
            return this;
        }

        /**
         * Set unsetlabel
         * @param unsetlabel Unset the image label, causing the label not to be inherited from the base image. (optional)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest unsetlabel(List<String> unsetlabel) {
            this.unsetlabel = unsetlabel;
            return this;
        }

        /**
         * Set volume
         * @param volume Extra volumes that should be mounted in the build container. (optional)
         * @return APIimageBuildLibpodRequest
         */
        public APIimageBuildLibpodRequest volume(List<String> volume) {
            this.volume = volume;
            return this;
        }

        /**
         * Build call for imageBuildLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK (As of version 1.xx) </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return imageBuildLibpodCall(dockerfile, t, allplatforms, extrahosts, nohosts, remote, q, compatvolumes, inheritlabels, nocache, cachefrom, pull, rm, forcerm, memory, memswap, cpushares, cpusetcpus, cpuperiod, cpuquota, buildargs, shmsize, squash, labels, layerLabel, layers, networkmode, platform, target, outputs, httpproxy, unsetenv, unsetlabel, volume, _callback);
        }

        /**
         * Execute imageBuildLibpod request
         * @return ImageBuildLibpod200Response
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK (As of version 1.xx) </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ImageBuildLibpod200Response execute() throws ApiException {
            ApiResponse<ImageBuildLibpod200Response> localVarResp = imageBuildLibpodWithHttpInfo(dockerfile, t, allplatforms, extrahosts, nohosts, remote, q, compatvolumes, inheritlabels, nocache, cachefrom, pull, rm, forcerm, memory, memswap, cpushares, cpusetcpus, cpuperiod, cpuquota, buildargs, shmsize, squash, labels, layerLabel, layers, networkmode, platform, target, outputs, httpproxy, unsetenv, unsetlabel, volume);
            return localVarResp.getData();
        }

        /**
         * Execute imageBuildLibpod request with HTTP info returned
         * @return ApiResponse&lt;ImageBuildLibpod200Response&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK (As of version 1.xx) </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<ImageBuildLibpod200Response> executeWithHttpInfo() throws ApiException {
            return imageBuildLibpodWithHttpInfo(dockerfile, t, allplatforms, extrahosts, nohosts, remote, q, compatvolumes, inheritlabels, nocache, cachefrom, pull, rm, forcerm, memory, memswap, cpushares, cpusetcpus, cpuperiod, cpuquota, buildargs, shmsize, squash, labels, layerLabel, layers, networkmode, platform, target, outputs, httpproxy, unsetenv, unsetlabel, volume);
        }

        /**
         * Execute imageBuildLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> OK (As of version 1.xx) </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<ImageBuildLibpod200Response> _callback) throws ApiException {
            return imageBuildLibpodAsync(dockerfile, t, allplatforms, extrahosts, nohosts, remote, q, compatvolumes, inheritlabels, nocache, cachefrom, pull, rm, forcerm, memory, memswap, cpushares, cpusetcpus, cpuperiod, cpuquota, buildargs, shmsize, squash, labels, layerLabel, layers, networkmode, platform, target, outputs, httpproxy, unsetenv, unsetlabel, volume, _callback);
        }
    }

    /**
     * Create image
     * Build an image from the given Dockerfile(s)
     * @return APIimageBuildLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> OK (As of version 1.xx) </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIimageBuildLibpodRequest imageBuildLibpod() {
        return new APIimageBuildLibpodRequest();
    }
    private okhttp3.Call imageChangesLibpodCall(String name, String parent, String diffType, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/images/{name}/changes"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (parent != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("parent", parent));
        }

        if (diffType != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("diffType", diffType));
        }

        final String[] localVarAccepts = {
            "application/json",
            "application/octet-stream",
            "text/plain"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call imageChangesLibpodValidateBeforeCall(String name, String parent, String diffType, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imageChangesLibpod(Async)");
        }

        return imageChangesLibpodCall(name, parent, diffType, _callback);

    }


    private ApiResponse<Void> imageChangesLibpodWithHttpInfo( @NotNull String name, String parent, String diffType) throws ApiException {
        okhttp3.Call localVarCall = imageChangesLibpodValidateBeforeCall(name, parent, diffType, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call imageChangesLibpodAsync(String name, String parent, String diffType, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = imageChangesLibpodValidateBeforeCall(name, parent, diffType, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIimageChangesLibpodRequest {
        private final String name;
        private String parent;
        private String diffType;

        private APIimageChangesLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set parent
         * @param parent specify a second layer which is used to compare against it instead of the parent layer (optional)
         * @return APIimageChangesLibpodRequest
         */
        public APIimageChangesLibpodRequest parent(String parent) {
            this.parent = parent;
            return this;
        }

        /**
         * Set diffType
         * @param diffType select what you want to match, default is all (optional)
         * @return APIimageChangesLibpodRequest
         */
        public APIimageChangesLibpodRequest diffType(String diffType) {
            this.diffType = diffType;
            return this;
        }

        /**
         * Build call for imageChangesLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Array of Changes </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return imageChangesLibpodCall(name, parent, diffType, _callback);
        }

        /**
         * Execute imageChangesLibpod request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Array of Changes </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            imageChangesLibpodWithHttpInfo(name, parent, diffType);
        }

        /**
         * Execute imageChangesLibpod request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Array of Changes </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return imageChangesLibpodWithHttpInfo(name, parent, diffType);
        }

        /**
         * Execute imageChangesLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Array of Changes </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return imageChangesLibpodAsync(name, parent, diffType, _callback);
        }
    }

    /**
     * Report on changes to images&#39;s filesystem; adds, deletes or modifications.
     * Returns which files in an image&#39;s filesystem have been added, deleted, or modified. The Kind of modification can be one of:  0: Modified 1: Added 2: Deleted 
     * @param name the name or id of the image (required)
     * @return APIimageChangesLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Array of Changes </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such container </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIimageChangesLibpodRequest imageChangesLibpod(String name) {
        return new APIimageChangesLibpodRequest(name);
    }
    private okhttp3.Call imageDeleteAllLibpodCall(List<String> images, Boolean all, Boolean force, Boolean ignore, Boolean lookupManifest, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/images/remove";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (images != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("csv", "images", images));
        }

        if (all != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("all", all));
        }

        if (force != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("force", force));
        }

        if (ignore != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ignore", ignore));
        }

        if (lookupManifest != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("lookupManifest", lookupManifest));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call imageDeleteAllLibpodValidateBeforeCall(List<String> images, Boolean all, Boolean force, Boolean ignore, Boolean lookupManifest, final ApiCallback _callback) throws ApiException {
        return imageDeleteAllLibpodCall(images, all, force, ignore, lookupManifest, _callback);

    }


    private ApiResponse<LibpodImagesRemoveReport> imageDeleteAllLibpodWithHttpInfo(List<String> images, Boolean all, Boolean force, Boolean ignore, Boolean lookupManifest) throws ApiException {
        okhttp3.Call localVarCall = imageDeleteAllLibpodValidateBeforeCall(images, all, force, ignore, lookupManifest, null);
        Type localVarReturnType = new TypeToken<LibpodImagesRemoveReport>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call imageDeleteAllLibpodAsync(List<String> images, Boolean all, Boolean force, Boolean ignore, Boolean lookupManifest, final ApiCallback<LibpodImagesRemoveReport> _callback) throws ApiException {

        okhttp3.Call localVarCall = imageDeleteAllLibpodValidateBeforeCall(images, all, force, ignore, lookupManifest, _callback);
        Type localVarReturnType = new TypeToken<LibpodImagesRemoveReport>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIimageDeleteAllLibpodRequest {
        private List<String> images;
        private Boolean all;
        private Boolean force;
        private Boolean ignore;
        private Boolean lookupManifest;

        private APIimageDeleteAllLibpodRequest() {
        }

        /**
         * Set images
         * @param images Images IDs or names to remove. (optional)
         * @return APIimageDeleteAllLibpodRequest
         */
        public APIimageDeleteAllLibpodRequest images(List<String> images) {
            this.images = images;
            return this;
        }

        /**
         * Set all
         * @param all Remove all images. (optional, default to true)
         * @return APIimageDeleteAllLibpodRequest
         */
        public APIimageDeleteAllLibpodRequest all(Boolean all) {
            this.all = all;
            return this;
        }

        /**
         * Set force
         * @param force Force image removal (including containers using the images). (optional)
         * @return APIimageDeleteAllLibpodRequest
         */
        public APIimageDeleteAllLibpodRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        /**
         * Set ignore
         * @param ignore Ignore if a specified image does not exist and do not throw an error. (optional)
         * @return APIimageDeleteAllLibpodRequest
         */
        public APIimageDeleteAllLibpodRequest ignore(Boolean ignore) {
            this.ignore = ignore;
            return this;
        }

        /**
         * Set lookupManifest
         * @param lookupManifest Resolves to manifest list instead of image. (optional)
         * @return APIimageDeleteAllLibpodRequest
         */
        public APIimageDeleteAllLibpodRequest lookupManifest(Boolean lookupManifest) {
            this.lookupManifest = lookupManifest;
            return this;
        }

        /**
         * Build call for imageDeleteAllLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Remove </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return imageDeleteAllLibpodCall(images, all, force, ignore, lookupManifest, _callback);
        }

        /**
         * Execute imageDeleteAllLibpod request
         * @return LibpodImagesRemoveReport
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Remove </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public LibpodImagesRemoveReport execute() throws ApiException {
            ApiResponse<LibpodImagesRemoveReport> localVarResp = imageDeleteAllLibpodWithHttpInfo(images, all, force, ignore, lookupManifest);
            return localVarResp.getData();
        }

        /**
         * Execute imageDeleteAllLibpod request with HTTP info returned
         * @return ApiResponse&lt;LibpodImagesRemoveReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Remove </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<LibpodImagesRemoveReport> executeWithHttpInfo() throws ApiException {
            return imageDeleteAllLibpodWithHttpInfo(images, all, force, ignore, lookupManifest);
        }

        /**
         * Execute imageDeleteAllLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Remove </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<LibpodImagesRemoveReport> _callback) throws ApiException {
            return imageDeleteAllLibpodAsync(images, all, force, ignore, lookupManifest, _callback);
        }
    }

    /**
     * Remove one or more images from the storage.
     * Remove one or more images from the storage.
     * @return APIimageDeleteAllLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Image Remove </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIimageDeleteAllLibpodRequest imageDeleteAllLibpod() {
        return new APIimageDeleteAllLibpodRequest();
    }
    private okhttp3.Call imageDeleteLibpodCall(String name, Boolean force, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/images/{name}"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (force != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("force", force));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call imageDeleteLibpodValidateBeforeCall(String name, Boolean force, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imageDeleteLibpod(Async)");
        }

        return imageDeleteLibpodCall(name, force, _callback);

    }


    private ApiResponse<LibpodImagesRemoveReport> imageDeleteLibpodWithHttpInfo( @NotNull String name, Boolean force) throws ApiException {
        okhttp3.Call localVarCall = imageDeleteLibpodValidateBeforeCall(name, force, null);
        Type localVarReturnType = new TypeToken<LibpodImagesRemoveReport>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call imageDeleteLibpodAsync(String name, Boolean force, final ApiCallback<LibpodImagesRemoveReport> _callback) throws ApiException {

        okhttp3.Call localVarCall = imageDeleteLibpodValidateBeforeCall(name, force, _callback);
        Type localVarReturnType = new TypeToken<LibpodImagesRemoveReport>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIimageDeleteLibpodRequest {
        private final String name;
        private Boolean force;

        private APIimageDeleteLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set force
         * @param force remove the image even if used by containers or has other tags (optional)
         * @return APIimageDeleteLibpodRequest
         */
        public APIimageDeleteLibpodRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        /**
         * Build call for imageDeleteLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Remove </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return imageDeleteLibpodCall(name, force, _callback);
        }

        /**
         * Execute imageDeleteLibpod request
         * @return LibpodImagesRemoveReport
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Remove </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public LibpodImagesRemoveReport execute() throws ApiException {
            ApiResponse<LibpodImagesRemoveReport> localVarResp = imageDeleteLibpodWithHttpInfo(name, force);
            return localVarResp.getData();
        }

        /**
         * Execute imageDeleteLibpod request with HTTP info returned
         * @return ApiResponse&lt;LibpodImagesRemoveReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Remove </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<LibpodImagesRemoveReport> executeWithHttpInfo() throws ApiException {
            return imageDeleteLibpodWithHttpInfo(name, force);
        }

        /**
         * Execute imageDeleteLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Remove </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<LibpodImagesRemoveReport> _callback) throws ApiException {
            return imageDeleteLibpodAsync(name, force, _callback);
        }
    }

    /**
     * Remove an image from the local storage.
     * Remove an image from the local storage.
     * @param name name or ID of image to remove (required)
     * @return APIimageDeleteLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Image Remove </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIimageDeleteLibpodRequest imageDeleteLibpod(String name) {
        return new APIimageDeleteLibpodRequest(name);
    }
    private okhttp3.Call imageExistsLibpodCall(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/images/{name}/exists"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call imageExistsLibpodValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imageExistsLibpod(Async)");
        }

        return imageExistsLibpodCall(name, _callback);

    }


    private ApiResponse<Void> imageExistsLibpodWithHttpInfo( @NotNull String name) throws ApiException {
        okhttp3.Call localVarCall = imageExistsLibpodValidateBeforeCall(name, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call imageExistsLibpodAsync(String name, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = imageExistsLibpodValidateBeforeCall(name, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIimageExistsLibpodRequest {
        private final String name;

        private APIimageExistsLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Build call for imageExistsLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> image exists </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return imageExistsLibpodCall(name, _callback);
        }

        /**
         * Execute imageExistsLibpod request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> image exists </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            imageExistsLibpodWithHttpInfo(name);
        }

        /**
         * Execute imageExistsLibpod request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> image exists </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return imageExistsLibpodWithHttpInfo(name);
        }

        /**
         * Execute imageExistsLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> image exists </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return imageExistsLibpodAsync(name, _callback);
        }
    }

    /**
     * Image exists
     * Check if image exists in local store
     * @param name the name or ID of the container (required)
     * @return APIimageExistsLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> image exists </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIimageExistsLibpodRequest imageExistsLibpod(String name) {
        return new APIimageExistsLibpodRequest(name);
    }
    private okhttp3.Call imageExportLibpodCall(String format, List<String> references, Boolean compress, Boolean ociAcceptUncompressedLayers, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/images/export";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (format != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("format", format));
        }

        if (references != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "references", references));
        }

        if (compress != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("compress", compress));
        }

        if (ociAcceptUncompressedLayers != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("ociAcceptUncompressedLayers", ociAcceptUncompressedLayers));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call imageExportLibpodValidateBeforeCall(String format, List<String> references, Boolean compress, Boolean ociAcceptUncompressedLayers, final ApiCallback _callback) throws ApiException {
        return imageExportLibpodCall(format, references, compress, ociAcceptUncompressedLayers, _callback);

    }


    private ApiResponse<File> imageExportLibpodWithHttpInfo(String format, List<String> references, Boolean compress, Boolean ociAcceptUncompressedLayers) throws ApiException {
        okhttp3.Call localVarCall = imageExportLibpodValidateBeforeCall(format, references, compress, ociAcceptUncompressedLayers, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call imageExportLibpodAsync(String format, List<String> references, Boolean compress, Boolean ociAcceptUncompressedLayers, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = imageExportLibpodValidateBeforeCall(format, references, compress, ociAcceptUncompressedLayers, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIimageExportLibpodRequest {
        private String format;
        private List<String> references;
        private Boolean compress;
        private Boolean ociAcceptUncompressedLayers;

        private APIimageExportLibpodRequest() {
        }

        /**
         * Set format
         * @param format format for exported image (only docker-archive is supported) (optional)
         * @return APIimageExportLibpodRequest
         */
        public APIimageExportLibpodRequest format(String format) {
            this.format = format;
            return this;
        }

        /**
         * Set references
         * @param references references to images to export (optional)
         * @return APIimageExportLibpodRequest
         */
        public APIimageExportLibpodRequest references(List<String> references) {
            this.references = references;
            return this;
        }

        /**
         * Set compress
         * @param compress use compression on image (optional)
         * @return APIimageExportLibpodRequest
         */
        public APIimageExportLibpodRequest compress(Boolean compress) {
            this.compress = compress;
            return this;
        }

        /**
         * Set ociAcceptUncompressedLayers
         * @param ociAcceptUncompressedLayers accept uncompressed layers when copying OCI images (optional)
         * @return APIimageExportLibpodRequest
         */
        public APIimageExportLibpodRequest ociAcceptUncompressedLayers(Boolean ociAcceptUncompressedLayers) {
            this.ociAcceptUncompressedLayers = ociAcceptUncompressedLayers;
            return this;
        }

        /**
         * Build call for imageExportLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return imageExportLibpodCall(format, references, compress, ociAcceptUncompressedLayers, _callback);
        }

        /**
         * Execute imageExportLibpod request
         * @return File
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public File execute() throws ApiException {
            ApiResponse<File> localVarResp = imageExportLibpodWithHttpInfo(format, references, compress, ociAcceptUncompressedLayers);
            return localVarResp.getData();
        }

        /**
         * Execute imageExportLibpod request with HTTP info returned
         * @return ApiResponse&lt;File&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<File> executeWithHttpInfo() throws ApiException {
            return imageExportLibpodWithHttpInfo(format, references, compress, ociAcceptUncompressedLayers);
        }

        /**
         * Execute imageExportLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<File> _callback) throws ApiException {
            return imageExportLibpodAsync(format, references, compress, ociAcceptUncompressedLayers, _callback);
        }
    }

    /**
     * Export multiple images
     * Export multiple images into a single object. Only &#x60;docker-archive&#x60; is currently supported.
     * @return APIimageExportLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIimageExportLibpodRequest imageExportLibpod() {
        return new APIimageExportLibpodRequest();
    }
    private okhttp3.Call imageGetLibpodCall(String name, String format, Boolean compress, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/images/{name}/get"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (format != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("format", format));
        }

        if (compress != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("compress", compress));
        }

        final String[] localVarAccepts = {
            "application/x-tar"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call imageGetLibpodValidateBeforeCall(String name, String format, Boolean compress, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imageGetLibpod(Async)");
        }

        return imageGetLibpodCall(name, format, compress, _callback);

    }


    private ApiResponse<File> imageGetLibpodWithHttpInfo( @NotNull String name, String format, Boolean compress) throws ApiException {
        okhttp3.Call localVarCall = imageGetLibpodValidateBeforeCall(name, format, compress, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call imageGetLibpodAsync(String name, String format, Boolean compress, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = imageGetLibpodValidateBeforeCall(name, format, compress, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIimageGetLibpodRequest {
        private final String name;
        private String format;
        private Boolean compress;

        private APIimageGetLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set format
         * @param format format for exported image (optional)
         * @return APIimageGetLibpodRequest
         */
        public APIimageGetLibpodRequest format(String format) {
            this.format = format;
            return this;
        }

        /**
         * Set compress
         * @param compress use compression on image (optional)
         * @return APIimageGetLibpodRequest
         */
        public APIimageGetLibpodRequest compress(Boolean compress) {
            this.compress = compress;
            return this;
        }

        /**
         * Build call for imageGetLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return imageGetLibpodCall(name, format, compress, _callback);
        }

        /**
         * Execute imageGetLibpod request
         * @return File
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public File execute() throws ApiException {
            ApiResponse<File> localVarResp = imageGetLibpodWithHttpInfo(name, format, compress);
            return localVarResp.getData();
        }

        /**
         * Execute imageGetLibpod request with HTTP info returned
         * @return ApiResponse&lt;File&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<File> executeWithHttpInfo() throws ApiException {
            return imageGetLibpodWithHttpInfo(name, format, compress);
        }

        /**
         * Execute imageGetLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<File> _callback) throws ApiException {
            return imageGetLibpodAsync(name, format, compress, _callback);
        }
    }

    /**
     * Export an image
     * Export an image
     * @param name the name or ID of the container (required)
     * @return APIimageGetLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIimageGetLibpodRequest imageGetLibpod(String name) {
        return new APIimageGetLibpodRequest(name);
    }
    private okhttp3.Call imageHistoryLibpodCall(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/images/{name}/history"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call imageHistoryLibpodValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imageHistoryLibpod(Async)");
        }

        return imageHistoryLibpodCall(name, _callback);

    }


    private ApiResponse<HistoryResponse> imageHistoryLibpodWithHttpInfo( @NotNull String name) throws ApiException {
        okhttp3.Call localVarCall = imageHistoryLibpodValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<HistoryResponse>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call imageHistoryLibpodAsync(String name, final ApiCallback<HistoryResponse> _callback) throws ApiException {

        okhttp3.Call localVarCall = imageHistoryLibpodValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<HistoryResponse>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIimageHistoryLibpodRequest {
        private final String name;

        private APIimageHistoryLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Build call for imageHistoryLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image History </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return imageHistoryLibpodCall(name, _callback);
        }

        /**
         * Execute imageHistoryLibpod request
         * @return HistoryResponse
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image History </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public HistoryResponse execute() throws ApiException {
            ApiResponse<HistoryResponse> localVarResp = imageHistoryLibpodWithHttpInfo(name);
            return localVarResp.getData();
        }

        /**
         * Execute imageHistoryLibpod request with HTTP info returned
         * @return ApiResponse&lt;HistoryResponse&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image History </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<HistoryResponse> executeWithHttpInfo() throws ApiException {
            return imageHistoryLibpodWithHttpInfo(name);
        }

        /**
         * Execute imageHistoryLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image History </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<HistoryResponse> _callback) throws ApiException {
            return imageHistoryLibpodAsync(name, _callback);
        }
    }

    /**
     * History of an image
     * Return parent layers of an image.
     * @param name the name or ID of the container (required)
     * @return APIimageHistoryLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Image History </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIimageHistoryLibpodRequest imageHistoryLibpod(String name) {
        return new APIimageHistoryLibpodRequest(name);
    }
    private okhttp3.Call imageImportLibpodCall(File upload, String contentType, List<String> changes, String message, String reference, String url, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = upload;

        // create path and map variables
        String localVarPath = "/libpod/images/import";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (changes != null) {
            localVarCollectionQueryParams.addAll(localVarApiClient.parameterToPairs("multi", "changes", changes));
        }

        if (message != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("message", message));
        }

        if (reference != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("reference", reference));
        }

        if (url != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("url", url));
        }

        if (contentType != null) {
            localVarHeaderParams.put("Content-Type", localVarApiClient.parameterToString(contentType));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/x-tar"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call imageImportLibpodValidateBeforeCall(File upload, String contentType, List<String> changes, String message, String reference, String url, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'upload' is set
        if (upload == null) {
            throw new ApiException("Missing the required parameter 'upload' when calling imageImportLibpod(Async)");
        }

        return imageImportLibpodCall(upload, contentType, changes, message, reference, url, _callback);

    }


    private ApiResponse<ImageImportReport> imageImportLibpodWithHttpInfo( @NotNull File upload, String contentType, List<String> changes, String message, String reference, String url) throws ApiException {
        okhttp3.Call localVarCall = imageImportLibpodValidateBeforeCall(upload, contentType, changes, message, reference, url, null);
        Type localVarReturnType = new TypeToken<ImageImportReport>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call imageImportLibpodAsync(File upload, String contentType, List<String> changes, String message, String reference, String url, final ApiCallback<ImageImportReport> _callback) throws ApiException {

        okhttp3.Call localVarCall = imageImportLibpodValidateBeforeCall(upload, contentType, changes, message, reference, url, _callback);
        Type localVarReturnType = new TypeToken<ImageImportReport>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIimageImportLibpodRequest {
        private final File upload;
        private String contentType;
        private List<String> changes;
        private String message;
        private String reference;
        private String url;

        private APIimageImportLibpodRequest(File upload) {
            this.upload = upload;
        }

        /**
         * Set contentType
         * @param contentType  (optional, default to application/x-tar)
         * @return APIimageImportLibpodRequest
         */
        public APIimageImportLibpodRequest contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * Set changes
         * @param changes Apply the following possible instructions to the created image: CMD | ENTRYPOINT | ENV | EXPOSE | LABEL | STOPSIGNAL | USER | VOLUME | WORKDIR.  JSON encoded string (optional)
         * @return APIimageImportLibpodRequest
         */
        public APIimageImportLibpodRequest changes(List<String> changes) {
            this.changes = changes;
            return this;
        }

        /**
         * Set message
         * @param message Set commit message for imported image (optional)
         * @return APIimageImportLibpodRequest
         */
        public APIimageImportLibpodRequest message(String message) {
            this.message = message;
            return this;
        }

        /**
         * Set reference
         * @param reference Optional Name[:TAG] for the image (optional)
         * @return APIimageImportLibpodRequest
         */
        public APIimageImportLibpodRequest reference(String reference) {
            this.reference = reference;
            return this;
        }

        /**
         * Set url
         * @param url Load image from the specified URL (optional)
         * @return APIimageImportLibpodRequest
         */
        public APIimageImportLibpodRequest url(String url) {
            this.url = url;
            return this;
        }

        /**
         * Build call for imageImportLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Import </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return imageImportLibpodCall(upload, contentType, changes, message, reference, url, _callback);
        }

        /**
         * Execute imageImportLibpod request
         * @return ImageImportReport
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Import </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ImageImportReport execute() throws ApiException {
            ApiResponse<ImageImportReport> localVarResp = imageImportLibpodWithHttpInfo(upload, contentType, changes, message, reference, url);
            return localVarResp.getData();
        }

        /**
         * Execute imageImportLibpod request with HTTP info returned
         * @return ApiResponse&lt;ImageImportReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Import </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<ImageImportReport> executeWithHttpInfo() throws ApiException {
            return imageImportLibpodWithHttpInfo(upload, contentType, changes, message, reference, url);
        }

        /**
         * Execute imageImportLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Import </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<ImageImportReport> _callback) throws ApiException {
            return imageImportLibpodAsync(upload, contentType, changes, message, reference, url, _callback);
        }
    }

    /**
     * Import image
     * Import a previously exported tarball as an image.
     * @param upload tarball for imported image (required)
     * @return APIimageImportLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Image Import </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIimageImportLibpodRequest imageImportLibpod(File upload) {
        return new APIimageImportLibpodRequest(upload);
    }
    private okhttp3.Call imageInspectLibpodCall(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/images/{name}/json"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call imageInspectLibpodValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imageInspectLibpod(Async)");
        }

        return imageInspectLibpodCall(name, _callback);

    }


    private ApiResponse<ImageData> imageInspectLibpodWithHttpInfo( @NotNull String name) throws ApiException {
        okhttp3.Call localVarCall = imageInspectLibpodValidateBeforeCall(name, null);
        Type localVarReturnType = new TypeToken<ImageData>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call imageInspectLibpodAsync(String name, final ApiCallback<ImageData> _callback) throws ApiException {

        okhttp3.Call localVarCall = imageInspectLibpodValidateBeforeCall(name, _callback);
        Type localVarReturnType = new TypeToken<ImageData>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIimageInspectLibpodRequest {
        private final String name;

        private APIimageInspectLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Build call for imageInspectLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Inspect Image </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return imageInspectLibpodCall(name, _callback);
        }

        /**
         * Execute imageInspectLibpod request
         * @return ImageData
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Inspect Image </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ImageData execute() throws ApiException {
            ApiResponse<ImageData> localVarResp = imageInspectLibpodWithHttpInfo(name);
            return localVarResp.getData();
        }

        /**
         * Execute imageInspectLibpod request with HTTP info returned
         * @return ApiResponse&lt;ImageData&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Inspect Image </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<ImageData> executeWithHttpInfo() throws ApiException {
            return imageInspectLibpodWithHttpInfo(name);
        }

        /**
         * Execute imageInspectLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Inspect Image </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<ImageData> _callback) throws ApiException {
            return imageInspectLibpodAsync(name, _callback);
        }
    }

    /**
     * Inspect an image
     * Obtain low-level information about an image
     * @param name the name or ID of the container (required)
     * @return APIimageInspectLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Inspect Image </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIimageInspectLibpodRequest imageInspectLibpod(String name) {
        return new APIimageInspectLibpodRequest(name);
    }
    private okhttp3.Call imageListLibpodCall(Boolean all, String filters, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/images/json";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (all != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("all", all));
        }

        if (filters != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("filters", filters));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call imageListLibpodValidateBeforeCall(Boolean all, String filters, final ApiCallback _callback) throws ApiException {
        return imageListLibpodCall(all, filters, _callback);

    }


    private ApiResponse<List<LibpodImageSummary>> imageListLibpodWithHttpInfo(Boolean all, String filters) throws ApiException {
        okhttp3.Call localVarCall = imageListLibpodValidateBeforeCall(all, filters, null);
        Type localVarReturnType = new TypeToken<List<LibpodImageSummary>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call imageListLibpodAsync(Boolean all, String filters, final ApiCallback<List<LibpodImageSummary>> _callback) throws ApiException {

        okhttp3.Call localVarCall = imageListLibpodValidateBeforeCall(all, filters, _callback);
        Type localVarReturnType = new TypeToken<List<LibpodImageSummary>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIimageListLibpodRequest {
        private Boolean all;
        private String filters;

        private APIimageListLibpodRequest() {
        }

        /**
         * Set all
         * @param all Show all images. Only images from a final layer (no children) are shown by default. (optional, default to false)
         * @return APIimageListLibpodRequest
         */
        public APIimageListLibpodRequest all(Boolean all) {
            this.all = all;
            return this;
        }

        /**
         * Set filters
         * @param filters A JSON encoded value of the filters (a &#x60;map[string][]string&#x60;) to process on the images list. Available filters: - &#x60;before&#x60;&#x3D;(&#x60;&lt;image-name&gt;[:&lt;tag&gt;]&#x60;,  &#x60;&lt;image id&gt;&#x60; or &#x60;&lt;image@digest&gt;&#x60;) - &#x60;dangling&#x3D;true&#x60; - &#x60;label&#x3D;key&#x60; or &#x60;label&#x3D;\&quot;key&#x3D;value\&quot;&#x60; of an image label - &#x60;reference&#x60;&#x3D;(&#x60;&lt;image-name&gt;[:&lt;tag&gt;]&#x60;) - &#x60;id&#x60;&#x3D;(&#x60;&lt;image-id&gt;&#x60;) - &#x60;since&#x60;&#x3D;(&#x60;&lt;image-name&gt;[:&lt;tag&gt;]&#x60;,  &#x60;&lt;image id&gt;&#x60; or &#x60;&lt;image@digest&gt;&#x60;)  (optional)
         * @return APIimageListLibpodRequest
         */
        public APIimageListLibpodRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        /**
         * Build call for imageListLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image summary for libpod API </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return imageListLibpodCall(all, filters, _callback);
        }

        /**
         * Execute imageListLibpod request
         * @return List&lt;LibpodImageSummary&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image summary for libpod API </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public List<LibpodImageSummary> execute() throws ApiException {
            ApiResponse<List<LibpodImageSummary>> localVarResp = imageListLibpodWithHttpInfo(all, filters);
            return localVarResp.getData();
        }

        /**
         * Execute imageListLibpod request with HTTP info returned
         * @return ApiResponse&lt;List&lt;LibpodImageSummary&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image summary for libpod API </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<LibpodImageSummary>> executeWithHttpInfo() throws ApiException {
            return imageListLibpodWithHttpInfo(all, filters);
        }

        /**
         * Execute imageListLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image summary for libpod API </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<LibpodImageSummary>> _callback) throws ApiException {
            return imageListLibpodAsync(all, filters, _callback);
        }
    }

    /**
     * List Images
     * Returns a list of images on the server
     * @return APIimageListLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Image summary for libpod API </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIimageListLibpodRequest imageListLibpod() {
        return new APIimageListLibpodRequest();
    }
    private okhttp3.Call imageLoadLibpodCall(String upload, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = upload;

        // create path and map variables
        String localVarPath = "/libpod/images/load";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
            "application/x-tar"
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call imageLoadLibpodValidateBeforeCall(String upload, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'upload' is set
        if (upload == null) {
            throw new ApiException("Missing the required parameter 'upload' when calling imageLoadLibpod(Async)");
        }

        return imageLoadLibpodCall(upload, _callback);

    }


    private ApiResponse<ImageLoadReport> imageLoadLibpodWithHttpInfo( @NotNull String upload) throws ApiException {
        okhttp3.Call localVarCall = imageLoadLibpodValidateBeforeCall(upload, null);
        Type localVarReturnType = new TypeToken<ImageLoadReport>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call imageLoadLibpodAsync(String upload, final ApiCallback<ImageLoadReport> _callback) throws ApiException {

        okhttp3.Call localVarCall = imageLoadLibpodValidateBeforeCall(upload, _callback);
        Type localVarReturnType = new TypeToken<ImageLoadReport>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIimageLoadLibpodRequest {
        private final String upload;

        private APIimageLoadLibpodRequest(String upload) {
            this.upload = upload;
        }

        /**
         * Build call for imageLoadLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Load </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return imageLoadLibpodCall(upload, _callback);
        }

        /**
         * Execute imageLoadLibpod request
         * @return ImageLoadReport
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Load </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ImageLoadReport execute() throws ApiException {
            ApiResponse<ImageLoadReport> localVarResp = imageLoadLibpodWithHttpInfo(upload);
            return localVarResp.getData();
        }

        /**
         * Execute imageLoadLibpod request with HTTP info returned
         * @return ApiResponse&lt;ImageLoadReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Load </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<ImageLoadReport> executeWithHttpInfo() throws ApiException {
            return imageLoadLibpodWithHttpInfo(upload);
        }

        /**
         * Execute imageLoadLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Load </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<ImageLoadReport> _callback) throws ApiException {
            return imageLoadLibpodAsync(upload, _callback);
        }
    }

    /**
     * Load image
     * Load an image (oci-archive or docker-archive) stream.
     * @param upload tarball of container image (required)
     * @return APIimageLoadLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Image Load </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIimageLoadLibpodRequest imageLoadLibpod(String upload) {
        return new APIimageLoadLibpodRequest(upload);
    }
    private okhttp3.Call imagePruneLibpodCall(Boolean all, Boolean external, Boolean buildcache, String filters, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/images/prune";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (all != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("all", all));
        }

        if (external != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("external", external));
        }

        if (buildcache != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("buildcache", buildcache));
        }

        if (filters != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("filters", filters));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call imagePruneLibpodValidateBeforeCall(Boolean all, Boolean external, Boolean buildcache, String filters, final ApiCallback _callback) throws ApiException {
        return imagePruneLibpodCall(all, external, buildcache, filters, _callback);

    }


    private ApiResponse<List<PruneReport>> imagePruneLibpodWithHttpInfo(Boolean all, Boolean external, Boolean buildcache, String filters) throws ApiException {
        okhttp3.Call localVarCall = imagePruneLibpodValidateBeforeCall(all, external, buildcache, filters, null);
        Type localVarReturnType = new TypeToken<List<PruneReport>>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call imagePruneLibpodAsync(Boolean all, Boolean external, Boolean buildcache, String filters, final ApiCallback<List<PruneReport>> _callback) throws ApiException {

        okhttp3.Call localVarCall = imagePruneLibpodValidateBeforeCall(all, external, buildcache, filters, _callback);
        Type localVarReturnType = new TypeToken<List<PruneReport>>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIimagePruneLibpodRequest {
        private Boolean all;
        private Boolean external;
        private Boolean buildcache;
        private String filters;

        private APIimagePruneLibpodRequest() {
        }

        /**
         * Set all
         * @param all Remove all images not in use by containers, not just dangling ones  (optional, default to false)
         * @return APIimagePruneLibpodRequest
         */
        public APIimagePruneLibpodRequest all(Boolean all) {
            this.all = all;
            return this;
        }

        /**
         * Set external
         * @param external Remove images even when they are used by external containers (e.g, by build containers)  (optional, default to false)
         * @return APIimagePruneLibpodRequest
         */
        public APIimagePruneLibpodRequest external(Boolean external) {
            this.external = external;
            return this;
        }

        /**
         * Set buildcache
         * @param buildcache Remove persistent build cache created by build instructions such as &#x60;--mount&#x3D;type&#x3D;cache&#x60;.  (optional, default to false)
         * @return APIimagePruneLibpodRequest
         */
        public APIimagePruneLibpodRequest buildcache(Boolean buildcache) {
            this.buildcache = buildcache;
            return this;
        }

        /**
         * Set filters
         * @param filters filters to apply to image pruning, encoded as JSON (map[string][]string). Available filters:   - &#x60;dangling&#x3D;&lt;boolean&gt;&#x60; When set to &#x60;true&#x60; (or &#x60;1&#x60;), prune only      unused *and* untagged images. When set to &#x60;false&#x60;      (or &#x60;0&#x60;), all unused images are pruned.   - &#x60;until&#x3D;&lt;string&gt;&#x60; Prune images created before this timestamp. The &#x60;&lt;timestamp&gt;&#x60; can be Unix timestamps, date formatted timestamps, or Go duration strings (e.g. &#x60;10m&#x60;, &#x60;1h30m&#x60;) computed relative to the daemon machine’s time.   - &#x60;label&#x60; (&#x60;label&#x3D;&lt;key&gt;&#x60;, &#x60;label&#x3D;&lt;key&gt;&#x3D;&lt;value&gt;&#x60;, &#x60;label!&#x3D;&lt;key&gt;&#x60;, or &#x60;label!&#x3D;&lt;key&gt;&#x3D;&lt;value&gt;&#x60;) Prune images with (or without, in case &#x60;label!&#x3D;...&#x60; is used) the specified labels.  (optional)
         * @return APIimagePruneLibpodRequest
         */
        public APIimagePruneLibpodRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        /**
         * Build call for imagePruneLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Prune </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return imagePruneLibpodCall(all, external, buildcache, filters, _callback);
        }

        /**
         * Execute imagePruneLibpod request
         * @return List&lt;PruneReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Prune </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public List<PruneReport> execute() throws ApiException {
            ApiResponse<List<PruneReport>> localVarResp = imagePruneLibpodWithHttpInfo(all, external, buildcache, filters);
            return localVarResp.getData();
        }

        /**
         * Execute imagePruneLibpod request with HTTP info returned
         * @return ApiResponse&lt;List&lt;PruneReport&gt;&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Prune </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<List<PruneReport>> executeWithHttpInfo() throws ApiException {
            return imagePruneLibpodWithHttpInfo(all, external, buildcache, filters);
        }

        /**
         * Execute imagePruneLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Prune </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<List<PruneReport>> _callback) throws ApiException {
            return imagePruneLibpodAsync(all, external, buildcache, filters, _callback);
        }
    }

    /**
     * Prune unused images
     * Remove images that are not being used by a container
     * @return APIimagePruneLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Image Prune </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIimagePruneLibpodRequest imagePruneLibpod() {
        return new APIimagePruneLibpodRequest();
    }
    private okhttp3.Call imagePullLibpodCall(String reference, Boolean quiet, Boolean compatMode, String arch, String OS, String variant, String policy, Boolean tlsVerify, Boolean allTags, String xRegistryAuth, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/images/pull";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (reference != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("reference", reference));
        }

        if (quiet != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("quiet", quiet));
        }

        if (compatMode != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("compatMode", compatMode));
        }

        if (arch != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("Arch", arch));
        }

        if (OS != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("OS", OS));
        }

        if (variant != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("Variant", variant));
        }

        if (policy != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("policy", policy));
        }

        if (tlsVerify != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tlsVerify", tlsVerify));
        }

        if (allTags != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("allTags", allTags));
        }

        if (xRegistryAuth != null) {
            localVarHeaderParams.put("X-Registry-Auth", localVarApiClient.parameterToString(xRegistryAuth));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call imagePullLibpodValidateBeforeCall(String reference, Boolean quiet, Boolean compatMode, String arch, String OS, String variant, String policy, Boolean tlsVerify, Boolean allTags, String xRegistryAuth, final ApiCallback _callback) throws ApiException {
        return imagePullLibpodCall(reference, quiet, compatMode, arch, OS, variant, policy, tlsVerify, allTags, xRegistryAuth, _callback);

    }


    private ApiResponse<LibpodImagesPullReport> imagePullLibpodWithHttpInfo(String reference, Boolean quiet, Boolean compatMode, String arch, String OS, String variant, String policy, Boolean tlsVerify, Boolean allTags, String xRegistryAuth) throws ApiException {
        okhttp3.Call localVarCall = imagePullLibpodValidateBeforeCall(reference, quiet, compatMode, arch, OS, variant, policy, tlsVerify, allTags, xRegistryAuth, null);
        Type localVarReturnType = new TypeToken<LibpodImagesPullReport>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call imagePullLibpodAsync(String reference, Boolean quiet, Boolean compatMode, String arch, String OS, String variant, String policy, Boolean tlsVerify, Boolean allTags, String xRegistryAuth, final ApiCallback<LibpodImagesPullReport> _callback) throws ApiException {

        okhttp3.Call localVarCall = imagePullLibpodValidateBeforeCall(reference, quiet, compatMode, arch, OS, variant, policy, tlsVerify, allTags, xRegistryAuth, _callback);
        Type localVarReturnType = new TypeToken<LibpodImagesPullReport>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIimagePullLibpodRequest {
        private String reference;
        private Boolean quiet;
        private Boolean compatMode;
        private String arch;
        private String OS;
        private String variant;
        private String policy;
        private Boolean tlsVerify;
        private Boolean allTags;
        private String xRegistryAuth;

        private APIimagePullLibpodRequest() {
        }

        /**
         * Set reference
         * @param reference Mandatory reference to the image (e.g., quay.io/image/name:tag) (optional)
         * @return APIimagePullLibpodRequest
         */
        public APIimagePullLibpodRequest reference(String reference) {
            this.reference = reference;
            return this;
        }

        /**
         * Set quiet
         * @param quiet silences extra stream data on pull (optional, default to false)
         * @return APIimagePullLibpodRequest
         */
        public APIimagePullLibpodRequest quiet(Boolean quiet) {
            this.quiet = quiet;
            return this;
        }

        /**
         * Set compatMode
         * @param compatMode Return the same JSON payload as the Docker-compat endpoint. (optional, default to false)
         * @return APIimagePullLibpodRequest
         */
        public APIimagePullLibpodRequest compatMode(Boolean compatMode) {
            this.compatMode = compatMode;
            return this;
        }

        /**
         * Set arch
         * @param arch Pull image for the specified architecture. (optional)
         * @return APIimagePullLibpodRequest
         */
        public APIimagePullLibpodRequest arch(String arch) {
            this.arch = arch;
            return this;
        }

        /**
         * Set OS
         * @param OS Pull image for the specified operating system. (optional)
         * @return APIimagePullLibpodRequest
         */
        public APIimagePullLibpodRequest OS(String OS) {
            this.OS = OS;
            return this;
        }

        /**
         * Set variant
         * @param variant Pull image for the specified variant. (optional)
         * @return APIimagePullLibpodRequest
         */
        public APIimagePullLibpodRequest variant(String variant) {
            this.variant = variant;
            return this;
        }

        /**
         * Set policy
         * @param policy Pull policy, \&quot;always\&quot; (default), \&quot;missing\&quot;, \&quot;newer\&quot;, \&quot;never\&quot;. (optional)
         * @return APIimagePullLibpodRequest
         */
        public APIimagePullLibpodRequest policy(String policy) {
            this.policy = policy;
            return this;
        }

        /**
         * Set tlsVerify
         * @param tlsVerify Require TLS verification. (optional, default to true)
         * @return APIimagePullLibpodRequest
         */
        public APIimagePullLibpodRequest tlsVerify(Boolean tlsVerify) {
            this.tlsVerify = tlsVerify;
            return this;
        }

        /**
         * Set allTags
         * @param allTags Pull all tagged images in the repository. (optional)
         * @return APIimagePullLibpodRequest
         */
        public APIimagePullLibpodRequest allTags(Boolean allTags) {
            this.allTags = allTags;
            return this;
        }

        /**
         * Set xRegistryAuth
         * @param xRegistryAuth base-64 encoded auth config. Must include the following four values: username, password, email and server address OR simply just an identity token. (optional)
         * @return APIimagePullLibpodRequest
         */
        public APIimagePullLibpodRequest xRegistryAuth(String xRegistryAuth) {
            this.xRegistryAuth = xRegistryAuth;
            return this;
        }

        /**
         * Build call for imagePullLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Pull </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return imagePullLibpodCall(reference, quiet, compatMode, arch, OS, variant, policy, tlsVerify, allTags, xRegistryAuth, _callback);
        }

        /**
         * Execute imagePullLibpod request
         * @return LibpodImagesPullReport
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Pull </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public LibpodImagesPullReport execute() throws ApiException {
            ApiResponse<LibpodImagesPullReport> localVarResp = imagePullLibpodWithHttpInfo(reference, quiet, compatMode, arch, OS, variant, policy, tlsVerify, allTags, xRegistryAuth);
            return localVarResp.getData();
        }

        /**
         * Execute imagePullLibpod request with HTTP info returned
         * @return ApiResponse&lt;LibpodImagesPullReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Pull </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<LibpodImagesPullReport> executeWithHttpInfo() throws ApiException {
            return imagePullLibpodWithHttpInfo(reference, quiet, compatMode, arch, OS, variant, policy, tlsVerify, allTags, xRegistryAuth);
        }

        /**
         * Execute imagePullLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Pull </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<LibpodImagesPullReport> _callback) throws ApiException {
            return imagePullLibpodAsync(reference, quiet, compatMode, arch, OS, variant, policy, tlsVerify, allTags, xRegistryAuth, _callback);
        }
    }

    /**
     * Pull images
     * Pull one or more images from a container registry.
     * @return APIimagePullLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Image Pull </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIimagePullLibpodRequest imagePullLibpod() {
        return new APIimagePullLibpodRequest();
    }
    private okhttp3.Call imagePushLibpodCall(String name, String destination, Boolean forceCompressionFormat, String compressionFormat, Integer compressionLevel, Boolean tlsVerify, Boolean quiet, String format, Boolean all, Boolean removeSignatures, Integer retry, String retryDelay, String xRegistryAuth, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/images/{name}/push"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (destination != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("destination", destination));
        }

        if (forceCompressionFormat != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("forceCompressionFormat", forceCompressionFormat));
        }

        if (compressionFormat != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("compressionFormat", compressionFormat));
        }

        if (compressionLevel != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("compressionLevel", compressionLevel));
        }

        if (tlsVerify != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tlsVerify", tlsVerify));
        }

        if (quiet != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("quiet", quiet));
        }

        if (format != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("format", format));
        }

        if (all != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("all", all));
        }

        if (removeSignatures != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("removeSignatures", removeSignatures));
        }

        if (retry != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("retry", retry));
        }

        if (retryDelay != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("retryDelay", retryDelay));
        }

        if (xRegistryAuth != null) {
            localVarHeaderParams.put("X-Registry-Auth", localVarApiClient.parameterToString(xRegistryAuth));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call imagePushLibpodValidateBeforeCall(String name, String destination, Boolean forceCompressionFormat, String compressionFormat, Integer compressionLevel, Boolean tlsVerify, Boolean quiet, String format, Boolean all, Boolean removeSignatures, Integer retry, String retryDelay, String xRegistryAuth, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imagePushLibpod(Async)");
        }

        return imagePushLibpodCall(name, destination, forceCompressionFormat, compressionFormat, compressionLevel, tlsVerify, quiet, format, all, removeSignatures, retry, retryDelay, xRegistryAuth, _callback);

    }


    private ApiResponse<File> imagePushLibpodWithHttpInfo( @NotNull String name, String destination, Boolean forceCompressionFormat, String compressionFormat, Integer compressionLevel, Boolean tlsVerify, Boolean quiet, String format, Boolean all, Boolean removeSignatures, Integer retry, String retryDelay, String xRegistryAuth) throws ApiException {
        okhttp3.Call localVarCall = imagePushLibpodValidateBeforeCall(name, destination, forceCompressionFormat, compressionFormat, compressionLevel, tlsVerify, quiet, format, all, removeSignatures, retry, retryDelay, xRegistryAuth, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call imagePushLibpodAsync(String name, String destination, Boolean forceCompressionFormat, String compressionFormat, Integer compressionLevel, Boolean tlsVerify, Boolean quiet, String format, Boolean all, Boolean removeSignatures, Integer retry, String retryDelay, String xRegistryAuth, final ApiCallback<File> _callback) throws ApiException {

        okhttp3.Call localVarCall = imagePushLibpodValidateBeforeCall(name, destination, forceCompressionFormat, compressionFormat, compressionLevel, tlsVerify, quiet, format, all, removeSignatures, retry, retryDelay, xRegistryAuth, _callback);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIimagePushLibpodRequest {
        private final String name;
        private String destination;
        private Boolean forceCompressionFormat;
        private String compressionFormat;
        private Integer compressionLevel;
        private Boolean tlsVerify;
        private Boolean quiet;
        private String format;
        private Boolean all;
        private Boolean removeSignatures;
        private Integer retry;
        private String retryDelay;
        private String xRegistryAuth;

        private APIimagePushLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set destination
         * @param destination Allows for pushing the image to a different destination than the image refers to. (optional)
         * @return APIimagePushLibpodRequest
         */
        public APIimagePushLibpodRequest destination(String destination) {
            this.destination = destination;
            return this;
        }

        /**
         * Set forceCompressionFormat
         * @param forceCompressionFormat Enforce compressing the layers with the specified --compression and do not reuse differently compressed blobs on the registry. (optional, default to false)
         * @return APIimagePushLibpodRequest
         */
        public APIimagePushLibpodRequest forceCompressionFormat(Boolean forceCompressionFormat) {
            this.forceCompressionFormat = forceCompressionFormat;
            return this;
        }

        /**
         * Set compressionFormat
         * @param compressionFormat Compression format used to compress image layers. (optional)
         * @return APIimagePushLibpodRequest
         */
        public APIimagePushLibpodRequest compressionFormat(String compressionFormat) {
            this.compressionFormat = compressionFormat;
            return this;
        }

        /**
         * Set compressionLevel
         * @param compressionLevel Compression level used to compress image layers. (optional)
         * @return APIimagePushLibpodRequest
         */
        public APIimagePushLibpodRequest compressionLevel(Integer compressionLevel) {
            this.compressionLevel = compressionLevel;
            return this;
        }

        /**
         * Set tlsVerify
         * @param tlsVerify Require TLS verification. (optional, default to true)
         * @return APIimagePushLibpodRequest
         */
        public APIimagePushLibpodRequest tlsVerify(Boolean tlsVerify) {
            this.tlsVerify = tlsVerify;
            return this;
        }

        /**
         * Set quiet
         * @param quiet Silences extra stream data on push. (optional, default to true)
         * @return APIimagePushLibpodRequest
         */
        public APIimagePushLibpodRequest quiet(Boolean quiet) {
            this.quiet = quiet;
            return this;
        }

        /**
         * Set format
         * @param format Manifest type (oci, v2s1, or v2s2) to use when pushing an image. Default is manifest type of source, with fallbacks. (optional)
         * @return APIimagePushLibpodRequest
         */
        public APIimagePushLibpodRequest format(String format) {
            this.format = format;
            return this;
        }

        /**
         * Set all
         * @param all All indicates whether to push all images related to the image list. (optional)
         * @return APIimagePushLibpodRequest
         */
        public APIimagePushLibpodRequest all(Boolean all) {
            this.all = all;
            return this;
        }

        /**
         * Set removeSignatures
         * @param removeSignatures Discard any pre-existing signatures in the image. (optional)
         * @return APIimagePushLibpodRequest
         */
        public APIimagePushLibpodRequest removeSignatures(Boolean removeSignatures) {
            this.removeSignatures = removeSignatures;
            return this;
        }

        /**
         * Set retry
         * @param retry Number of times to retry push in case of failure. (optional)
         * @return APIimagePushLibpodRequest
         */
        public APIimagePushLibpodRequest retry(Integer retry) {
            this.retry = retry;
            return this;
        }

        /**
         * Set retryDelay
         * @param retryDelay Delay between retries in case of push failures. Duration format such as \&quot;412ms\&quot;, or \&quot;3.5h\&quot;. (optional)
         * @return APIimagePushLibpodRequest
         */
        public APIimagePushLibpodRequest retryDelay(String retryDelay) {
            this.retryDelay = retryDelay;
            return this;
        }

        /**
         * Set xRegistryAuth
         * @param xRegistryAuth A base64-encoded auth configuration. (optional)
         * @return APIimagePushLibpodRequest
         */
        public APIimagePushLibpodRequest xRegistryAuth(String xRegistryAuth) {
            this.xRegistryAuth = xRegistryAuth;
            return this;
        }

        /**
         * Build call for imagePushLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return imagePushLibpodCall(name, destination, forceCompressionFormat, compressionFormat, compressionLevel, tlsVerify, quiet, format, all, removeSignatures, retry, retryDelay, xRegistryAuth, _callback);
        }

        /**
         * Execute imagePushLibpod request
         * @return File
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public File execute() throws ApiException {
            ApiResponse<File> localVarResp = imagePushLibpodWithHttpInfo(name, destination, forceCompressionFormat, compressionFormat, compressionLevel, tlsVerify, quiet, format, all, removeSignatures, retry, retryDelay, xRegistryAuth);
            return localVarResp.getData();
        }

        /**
         * Execute imagePushLibpod request with HTTP info returned
         * @return ApiResponse&lt;File&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<File> executeWithHttpInfo() throws ApiException {
            return imagePushLibpodWithHttpInfo(name, destination, forceCompressionFormat, compressionFormat, compressionLevel, tlsVerify, quiet, format, all, removeSignatures, retry, retryDelay, xRegistryAuth);
        }

        /**
         * Execute imagePushLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<File> _callback) throws ApiException {
            return imagePushLibpodAsync(name, destination, forceCompressionFormat, compressionFormat, compressionLevel, tlsVerify, quiet, format, all, removeSignatures, retry, retryDelay, xRegistryAuth, _callback);
        }
    }

    /**
     * Push Image
     * Push an image to a container registry
     * @param name Name of image to push. (required)
     * @return APIimagePushLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIimagePushLibpodRequest imagePushLibpod(String name) {
        return new APIimagePushLibpodRequest(name);
    }
    private okhttp3.Call imageResolveLibpodCall(String name, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/images/{name}/resolve"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call imageResolveLibpodValidateBeforeCall(String name, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imageResolveLibpod(Async)");
        }

        return imageResolveLibpodCall(name, _callback);

    }


    private ApiResponse<Void> imageResolveLibpodWithHttpInfo( @NotNull String name) throws ApiException {
        okhttp3.Call localVarCall = imageResolveLibpodValidateBeforeCall(name, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call imageResolveLibpodAsync(String name, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = imageResolveLibpodValidateBeforeCall(name, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIimageResolveLibpodRequest {
        private final String name;

        private APIimageResolveLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Build call for imageResolveLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> resolved image names </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return imageResolveLibpodCall(name, _callback);
        }

        /**
         * Execute imageResolveLibpod request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> resolved image names </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            imageResolveLibpodWithHttpInfo(name);
        }

        /**
         * Execute imageResolveLibpod request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> resolved image names </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return imageResolveLibpodWithHttpInfo(name);
        }

        /**
         * Execute imageResolveLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 204 </td><td> resolved image names </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return imageResolveLibpodAsync(name, _callback);
        }
    }

    /**
     * Resolve an image (short) name
     * Resolve the passed image name to a list of fully-qualified images referring to container registries.
     * @param name the (short) name to resolve (required)
     * @return APIimageResolveLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 204 </td><td> resolved image names </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIimageResolveLibpodRequest imageResolveLibpod(String name) {
        return new APIimageResolveLibpodRequest(name);
    }
    private okhttp3.Call imageScpLibpodCall(String name, String destination, Boolean quiet, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/images/scp/{name}"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (destination != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("destination", destination));
        }

        if (quiet != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("quiet", quiet));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call imageScpLibpodValidateBeforeCall(String name, String destination, Boolean quiet, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imageScpLibpod(Async)");
        }

        return imageScpLibpodCall(name, destination, quiet, _callback);

    }


    private ApiResponse<ScpReport> imageScpLibpodWithHttpInfo( @NotNull String name, String destination, Boolean quiet) throws ApiException {
        okhttp3.Call localVarCall = imageScpLibpodValidateBeforeCall(name, destination, quiet, null);
        Type localVarReturnType = new TypeToken<ScpReport>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call imageScpLibpodAsync(String name, String destination, Boolean quiet, final ApiCallback<ScpReport> _callback) throws ApiException {

        okhttp3.Call localVarCall = imageScpLibpodValidateBeforeCall(name, destination, quiet, _callback);
        Type localVarReturnType = new TypeToken<ScpReport>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIimageScpLibpodRequest {
        private final String name;
        private String destination;
        private Boolean quiet;

        private APIimageScpLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set destination
         * @param destination dest connection/image (optional)
         * @return APIimageScpLibpodRequest
         */
        public APIimageScpLibpodRequest destination(String destination) {
            this.destination = destination;
            return this;
        }

        /**
         * Set quiet
         * @param quiet quiet output (optional, default to false)
         * @return APIimageScpLibpodRequest
         */
        public APIimageScpLibpodRequest quiet(Boolean quiet) {
            this.quiet = quiet;
            return this;
        }

        /**
         * Build call for imageScpLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Scp </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return imageScpLibpodCall(name, destination, quiet, _callback);
        }

        /**
         * Execute imageScpLibpod request
         * @return ScpReport
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Scp </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ScpReport execute() throws ApiException {
            ApiResponse<ScpReport> localVarResp = imageScpLibpodWithHttpInfo(name, destination, quiet);
            return localVarResp.getData();
        }

        /**
         * Execute imageScpLibpod request with HTTP info returned
         * @return ApiResponse&lt;ScpReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Scp </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<ScpReport> executeWithHttpInfo() throws ApiException {
            return imageScpLibpodWithHttpInfo(name, destination, quiet);
        }

        /**
         * Execute imageScpLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Scp </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<ScpReport> _callback) throws ApiException {
            return imageScpLibpodAsync(name, destination, quiet, _callback);
        }
    }

    /**
     * Copy an image from one host to another
     * Copy an image from one host to another
     * @param name source connection/image (required)
     * @return APIimageScpLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Image Scp </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIimageScpLibpodRequest imageScpLibpod(String name) {
        return new APIimageScpLibpodRequest(name);
    }
    private okhttp3.Call imageSearchLibpodCall(String term, Integer limit, String filters, Boolean tlsVerify, Boolean listTags, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/images/search";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (term != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("term", term));
        }

        if (limit != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("limit", limit));
        }

        if (filters != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("filters", filters));
        }

        if (tlsVerify != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tlsVerify", tlsVerify));
        }

        if (listTags != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("listTags", listTags));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call imageSearchLibpodValidateBeforeCall(String term, Integer limit, String filters, Boolean tlsVerify, Boolean listTags, final ApiCallback _callback) throws ApiException {
        return imageSearchLibpodCall(term, limit, filters, tlsVerify, listTags, _callback);

    }


    private ApiResponse<ImageSearch200Response> imageSearchLibpodWithHttpInfo(String term, Integer limit, String filters, Boolean tlsVerify, Boolean listTags) throws ApiException {
        okhttp3.Call localVarCall = imageSearchLibpodValidateBeforeCall(term, limit, filters, tlsVerify, listTags, null);
        Type localVarReturnType = new TypeToken<ImageSearch200Response>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call imageSearchLibpodAsync(String term, Integer limit, String filters, Boolean tlsVerify, Boolean listTags, final ApiCallback<ImageSearch200Response> _callback) throws ApiException {

        okhttp3.Call localVarCall = imageSearchLibpodValidateBeforeCall(term, limit, filters, tlsVerify, listTags, _callback);
        Type localVarReturnType = new TypeToken<ImageSearch200Response>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIimageSearchLibpodRequest {
        private String term;
        private Integer limit;
        private String filters;
        private Boolean tlsVerify;
        private Boolean listTags;

        private APIimageSearchLibpodRequest() {
        }

        /**
         * Set term
         * @param term term to search (optional)
         * @return APIimageSearchLibpodRequest
         */
        public APIimageSearchLibpodRequest term(String term) {
            this.term = term;
            return this;
        }

        /**
         * Set limit
         * @param limit maximum number of results (optional, default to 25)
         * @return APIimageSearchLibpodRequest
         */
        public APIimageSearchLibpodRequest limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        /**
         * Set filters
         * @param filters A JSON encoded value of the filters (a &#x60;map[string][]string&#x60;) to process on the images list. Available filters: - &#x60;is-automated&#x3D;(true|false)&#x60; - &#x60;is-official&#x3D;(true|false)&#x60; - &#x60;stars&#x3D;&lt;number&gt;&#x60; Matches images that have at least &#39;number&#39; stars.  (optional)
         * @return APIimageSearchLibpodRequest
         */
        public APIimageSearchLibpodRequest filters(String filters) {
            this.filters = filters;
            return this;
        }

        /**
         * Set tlsVerify
         * @param tlsVerify Require HTTPS and verify signatures when contacting registries. (optional, default to true)
         * @return APIimageSearchLibpodRequest
         */
        public APIimageSearchLibpodRequest tlsVerify(Boolean tlsVerify) {
            this.tlsVerify = tlsVerify;
            return this;
        }

        /**
         * Set listTags
         * @param listTags list the available tags in the repository (optional, default to false)
         * @return APIimageSearchLibpodRequest
         */
        public APIimageSearchLibpodRequest listTags(Boolean listTags) {
            this.listTags = listTags;
            return this;
        }

        /**
         * Build call for imageSearchLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Registry Search </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return imageSearchLibpodCall(term, limit, filters, tlsVerify, listTags, _callback);
        }

        /**
         * Execute imageSearchLibpod request
         * @return ImageSearch200Response
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Registry Search </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ImageSearch200Response execute() throws ApiException {
            ApiResponse<ImageSearch200Response> localVarResp = imageSearchLibpodWithHttpInfo(term, limit, filters, tlsVerify, listTags);
            return localVarResp.getData();
        }

        /**
         * Execute imageSearchLibpod request with HTTP info returned
         * @return ApiResponse&lt;ImageSearch200Response&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Registry Search </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<ImageSearch200Response> executeWithHttpInfo() throws ApiException {
            return imageSearchLibpodWithHttpInfo(term, limit, filters, tlsVerify, listTags);
        }

        /**
         * Execute imageSearchLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Registry Search </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<ImageSearch200Response> _callback) throws ApiException {
            return imageSearchLibpodAsync(term, limit, filters, tlsVerify, listTags, _callback);
        }
    }

    /**
     * Search images
     * Search registries for images
     * @return APIimageSearchLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Registry Search </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIimageSearchLibpodRequest imageSearchLibpod() {
        return new APIimageSearchLibpodRequest();
    }
    private okhttp3.Call imageTagLibpodCall(String name, String repo, String tag, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/images/{name}/tag"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (repo != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("repo", repo));
        }

        if (tag != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tag", tag));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call imageTagLibpodValidateBeforeCall(String name, String repo, String tag, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imageTagLibpod(Async)");
        }

        return imageTagLibpodCall(name, repo, tag, _callback);

    }


    private ApiResponse<Void> imageTagLibpodWithHttpInfo( @NotNull String name, String repo, String tag) throws ApiException {
        okhttp3.Call localVarCall = imageTagLibpodValidateBeforeCall(name, repo, tag, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call imageTagLibpodAsync(String name, String repo, String tag, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = imageTagLibpodValidateBeforeCall(name, repo, tag, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIimageTagLibpodRequest {
        private final String name;
        private String repo;
        private String tag;

        private APIimageTagLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set repo
         * @param repo the repository to tag in (optional)
         * @return APIimageTagLibpodRequest
         */
        public APIimageTagLibpodRequest repo(String repo) {
            this.repo = repo;
            return this;
        }

        /**
         * Set tag
         * @param tag the name of the new tag (optional)
         * @return APIimageTagLibpodRequest
         */
        public APIimageTagLibpodRequest tag(String tag) {
            this.tag = tag;
            return this;
        }

        /**
         * Build call for imageTagLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return imageTagLibpodCall(name, repo, tag, _callback);
        }

        /**
         * Execute imageTagLibpod request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            imageTagLibpodWithHttpInfo(name, repo, tag);
        }

        /**
         * Execute imageTagLibpod request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return imageTagLibpodWithHttpInfo(name, repo, tag);
        }

        /**
         * Execute imageTagLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return imageTagLibpodAsync(name, repo, tag, _callback);
        }
    }

    /**
     * Tag an image
     * Tag an image so that it becomes part of a repository.
     * @param name the name or ID of the container (required)
     * @return APIimageTagLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIimageTagLibpodRequest imageTagLibpod(String name) {
        return new APIimageTagLibpodRequest(name);
    }
    private okhttp3.Call imageTreeLibpodCall(String name, Boolean whatrequires, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/images/{name}/tree"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (whatrequires != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("whatrequires", whatrequires));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call imageTreeLibpodValidateBeforeCall(String name, Boolean whatrequires, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imageTreeLibpod(Async)");
        }

        return imageTreeLibpodCall(name, whatrequires, _callback);

    }


    private ApiResponse<ImageTreeReport> imageTreeLibpodWithHttpInfo( @NotNull String name, Boolean whatrequires) throws ApiException {
        okhttp3.Call localVarCall = imageTreeLibpodValidateBeforeCall(name, whatrequires, null);
        Type localVarReturnType = new TypeToken<ImageTreeReport>(){}.getType();
        return localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private okhttp3.Call imageTreeLibpodAsync(String name, Boolean whatrequires, final ApiCallback<ImageTreeReport> _callback) throws ApiException {

        okhttp3.Call localVarCall = imageTreeLibpodValidateBeforeCall(name, whatrequires, _callback);
        Type localVarReturnType = new TypeToken<ImageTreeReport>(){}.getType();
        localVarApiClient.executeAsync(localVarCall, localVarReturnType, _callback);
        return localVarCall;
    }

    public class APIimageTreeLibpodRequest {
        private final String name;
        private Boolean whatrequires;

        private APIimageTreeLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set whatrequires
         * @param whatrequires show all child images and layers of the specified image (optional)
         * @return APIimageTreeLibpodRequest
         */
        public APIimageTreeLibpodRequest whatrequires(Boolean whatrequires) {
            this.whatrequires = whatrequires;
            return this;
        }

        /**
         * Build call for imageTreeLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Tree </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return imageTreeLibpodCall(name, whatrequires, _callback);
        }

        /**
         * Execute imageTreeLibpod request
         * @return ImageTreeReport
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Tree </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ImageTreeReport execute() throws ApiException {
            ApiResponse<ImageTreeReport> localVarResp = imageTreeLibpodWithHttpInfo(name, whatrequires);
            return localVarResp.getData();
        }

        /**
         * Execute imageTreeLibpod request with HTTP info returned
         * @return ApiResponse&lt;ImageTreeReport&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Tree </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<ImageTreeReport> executeWithHttpInfo() throws ApiException {
            return imageTreeLibpodWithHttpInfo(name, whatrequires);
        }

        /**
         * Execute imageTreeLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 200 </td><td> Image Tree </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<ImageTreeReport> _callback) throws ApiException {
            return imageTreeLibpodAsync(name, whatrequires, _callback);
        }
    }

    /**
     * Image tree
     * Retrieve the image tree for the provided image name or ID
     * @param name the name or ID of the container (required)
     * @return APIimageTreeLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 200 </td><td> Image Tree </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIimageTreeLibpodRequest imageTreeLibpod(String name) {
        return new APIimageTreeLibpodRequest(name);
    }
    private okhttp3.Call imageUntagLibpodCall(String name, String repo, String tag, final ApiCallback _callback) throws ApiException {
        String basePath = null;
        // Operation Servers
        String[] localBasePaths = new String[] {  };

        // Determine Base Path to Use
        if (localCustomBaseUrl != null){
            basePath = localCustomBaseUrl;
        } else if ( localBasePaths.length > 0 ) {
            basePath = localBasePaths[localHostIndex];
        } else {
            basePath = null;
        }

        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/libpod/images/{name}/untag"
            .replace("{" + "name" + "}", localVarApiClient.escapeString(name.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        Map<String, String> localVarHeaderParams = new HashMap<String, String>();
        Map<String, String> localVarCookieParams = new HashMap<String, String>();
        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        if (repo != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("repo", repo));
        }

        if (tag != null) {
            localVarQueryParams.addAll(localVarApiClient.parameterToPair("tag", tag));
        }

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }

        final String[] localVarContentTypes = {
        };
        final String localVarContentType = localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }

        String[] localVarAuthNames = new String[] {  };
        return localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    @SuppressWarnings("rawtypes")
    private okhttp3.Call imageUntagLibpodValidateBeforeCall(String name, String repo, String tag, final ApiCallback _callback) throws ApiException {
        // verify the required parameter 'name' is set
        if (name == null) {
            throw new ApiException("Missing the required parameter 'name' when calling imageUntagLibpod(Async)");
        }

        return imageUntagLibpodCall(name, repo, tag, _callback);

    }


    private ApiResponse<Void> imageUntagLibpodWithHttpInfo( @NotNull String name, String repo, String tag) throws ApiException {
        okhttp3.Call localVarCall = imageUntagLibpodValidateBeforeCall(name, repo, tag, null);
        return localVarApiClient.execute(localVarCall);
    }

    private okhttp3.Call imageUntagLibpodAsync(String name, String repo, String tag, final ApiCallback<Void> _callback) throws ApiException {

        okhttp3.Call localVarCall = imageUntagLibpodValidateBeforeCall(name, repo, tag, _callback);
        localVarApiClient.executeAsync(localVarCall, _callback);
        return localVarCall;
    }

    public class APIimageUntagLibpodRequest {
        private final String name;
        private String repo;
        private String tag;

        private APIimageUntagLibpodRequest(String name) {
            this.name = name;
        }

        /**
         * Set repo
         * @param repo the repository to untag (optional)
         * @return APIimageUntagLibpodRequest
         */
        public APIimageUntagLibpodRequest repo(String repo) {
            this.repo = repo;
            return this;
        }

        /**
         * Set tag
         * @param tag the name of the tag to untag (optional)
         * @return APIimageUntagLibpodRequest
         */
        public APIimageUntagLibpodRequest tag(String tag) {
            this.tag = tag;
            return this;
        }

        /**
         * Build call for imageUntagLibpod
         * @param _callback ApiCallback API callback
         * @return Call to execute
         * @throws ApiException If fail to serialize the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call buildCall(final ApiCallback _callback) throws ApiException {
            return imageUntagLibpodCall(name, repo, tag, _callback);
        }

        /**
         * Execute imageUntagLibpod request
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public void execute() throws ApiException {
            imageUntagLibpodWithHttpInfo(name, repo, tag);
        }

        /**
         * Execute imageUntagLibpod request with HTTP info returned
         * @return ApiResponse&lt;Void&gt;
         * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public ApiResponse<Void> executeWithHttpInfo() throws ApiException {
            return imageUntagLibpodWithHttpInfo(name, repo, tag);
        }

        /**
         * Execute imageUntagLibpod request (asynchronously)
         * @param _callback The callback to be executed when the API call finishes
         * @return The request call
         * @throws ApiException If fail to process the API call, e.g. serializing the request body object
         * @http.response.details
         <table summary="Response Details" border="1">
            <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
            <tr><td> 201 </td><td> no error </td><td>  -  </td></tr>
            <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
            <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
            <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
            <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
         </table>
         */
        public okhttp3.Call executeAsync(final ApiCallback<Void> _callback) throws ApiException {
            return imageUntagLibpodAsync(name, repo, tag, _callback);
        }
    }

    /**
     * Untag an image
     * Untag an image. If not repo and tag are specified, all tags are removed from the image.
     * @param name the name or ID of the container (required)
     * @return APIimageUntagLibpodRequest
     * @http.response.details
     <table summary="Response Details" border="1">
        <tr><td> Status Code </td><td> Description </td><td> Response Headers </td></tr>
        <tr><td> 201 </td><td> no error </td><td>  -  </td></tr>
        <tr><td> 400 </td><td> Bad parameter in request </td><td>  -  </td></tr>
        <tr><td> 404 </td><td> No such image </td><td>  -  </td></tr>
        <tr><td> 409 </td><td> Conflict error in operation </td><td>  -  </td></tr>
        <tr><td> 500 </td><td> Internal server error </td><td>  -  </td></tr>
     </table>
     */
    public APIimageUntagLibpodRequest imageUntagLibpod(String name) {
        return new APIimageUntagLibpodRequest(name);
    }
}
