/*
 * supports a RESTful API for the Libpod library
 * This documentation describes the Podman v2.x+ RESTful API. It consists of a Docker-compatible API and a Libpod API providing support for Podman’s unique features such as pods.  To start the service and keep it running for 5,000 seconds (-t 0 runs forever):  podman system service -t 5000 &  You can then use cURL on the socket using requests documented below.  NOTE: if you install the package podman-docker, it will create a symbolic link for /run/docker.sock to /run/podman/podman.sock  NOTE: Some fields in the API response JSON are encoded as omitempty, which means that if said field has a zero value, they will not be encoded in the API response. This is a feature to help reduce the size of the JSON responses returned via the API.  NOTE: Due to the limitations of [go-swagger](https://github.com/go-swagger/go-swagger), some field values that have a complex type show up as null in the docs as well as in the API responses. This is because the zero value for the field type is null. The field description in the docs will state what type the field is expected to be for such cases.  See podman-system-service(1) for more information.  Quick Examples:  'podman info'  curl --unix-socket /run/podman/podman.sock http://d/v5.0.0/libpod/info  'podman pull quay.io/containers/podman'  curl -XPOST --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/images/create?fromImage=quay.io%2Fcontainers%2Fpodman'  'podman list images'  curl --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/libpod/images/json' | jq
 *
 * The version of the OpenAPI document: 5.0.0
 * Contact: podman@lists.podman.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.pod4dev.libpodj.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.model.BindOptions;
import io.github.pod4dev.libpodj.model.ImageOptions;
import io.github.pod4dev.libpodj.model.TmpfsOptions;
import io.github.pod4dev.libpodj.model.VolumeOptions;
import java.io.IOException;
import java.util.Arrays;
import java.io.Serializable;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import io.github.pod4dev.libpodj.JSON;

/**
 * Mount
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.9.0")
public class Mount implements Serializable {
  private static final long serialVersionUID = 1L;

  public static final String SERIALIZED_NAME_BIND_OPTIONS = "BindOptions";
  @SerializedName(SERIALIZED_NAME_BIND_OPTIONS)
  private BindOptions bindOptions;

  public static final String SERIALIZED_NAME_CLUSTER_OPTIONS = "ClusterOptions";
  @SerializedName(SERIALIZED_NAME_CLUSTER_OPTIONS)
  private Object clusterOptions;

  public static final String SERIALIZED_NAME_CONSISTENCY = "Consistency";
  @SerializedName(SERIALIZED_NAME_CONSISTENCY)
  private String consistency;

  public static final String SERIALIZED_NAME_IMAGE_OPTIONS = "ImageOptions";
  @SerializedName(SERIALIZED_NAME_IMAGE_OPTIONS)
  private ImageOptions imageOptions;

  public static final String SERIALIZED_NAME_READ_ONLY = "ReadOnly";
  @SerializedName(SERIALIZED_NAME_READ_ONLY)
  private Boolean readOnly;

  public static final String SERIALIZED_NAME_SOURCE = "Source";
  @SerializedName(SERIALIZED_NAME_SOURCE)
  private String source;

  public static final String SERIALIZED_NAME_TARGET = "Target";
  @SerializedName(SERIALIZED_NAME_TARGET)
  private String target;

  public static final String SERIALIZED_NAME_TMPFS_OPTIONS = "TmpfsOptions";
  @SerializedName(SERIALIZED_NAME_TMPFS_OPTIONS)
  private TmpfsOptions tmpfsOptions;

  public static final String SERIALIZED_NAME_TYPE = "Type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private String type;

  public static final String SERIALIZED_NAME_VOLUME_OPTIONS = "VolumeOptions";
  @SerializedName(SERIALIZED_NAME_VOLUME_OPTIONS)
  private VolumeOptions volumeOptions;

  public Mount() {
  }

  public Mount bindOptions(BindOptions bindOptions) {
    this.bindOptions = bindOptions;
    return this;
  }

  /**
   * Get bindOptions
   * @return bindOptions
   */
  @jakarta.annotation.Nullable
  @Valid

  public BindOptions getBindOptions() {
    return bindOptions;
  }

  public void setBindOptions(BindOptions bindOptions) {
    this.bindOptions = bindOptions;
  }


  public Mount clusterOptions(Object clusterOptions) {
    this.clusterOptions = clusterOptions;
    return this;
  }

  /**
   * Get clusterOptions
   * @return clusterOptions
   */
  @jakarta.annotation.Nullable

  public Object getClusterOptions() {
    return clusterOptions;
  }

  public void setClusterOptions(Object clusterOptions) {
    this.clusterOptions = clusterOptions;
  }


  public Mount consistency(String consistency) {
    this.consistency = consistency;
    return this;
  }

  /**
   * Get consistency
   * @return consistency
   */
  @jakarta.annotation.Nullable

  public String getConsistency() {
    return consistency;
  }

  public void setConsistency(String consistency) {
    this.consistency = consistency;
  }


  public Mount imageOptions(ImageOptions imageOptions) {
    this.imageOptions = imageOptions;
    return this;
  }

  /**
   * Get imageOptions
   * @return imageOptions
   */
  @jakarta.annotation.Nullable
  @Valid

  public ImageOptions getImageOptions() {
    return imageOptions;
  }

  public void setImageOptions(ImageOptions imageOptions) {
    this.imageOptions = imageOptions;
  }


  public Mount readOnly(Boolean readOnly) {
    this.readOnly = readOnly;
    return this;
  }

  /**
   * Get readOnly
   * @return readOnly
   */
  @jakarta.annotation.Nullable

  public Boolean getReadOnly() {
    return readOnly;
  }

  public void setReadOnly(Boolean readOnly) {
    this.readOnly = readOnly;
  }


  public Mount source(String source) {
    this.source = source;
    return this;
  }

  /**
   * Source specifies the name of the mount. Depending on mount type, this may be a volume name or a host path, or even ignored. Source is not supported for tmpfs (must be an empty value)
   * @return source
   */
  @jakarta.annotation.Nullable

  public String getSource() {
    return source;
  }

  public void setSource(String source) {
    this.source = source;
  }


  public Mount target(String target) {
    this.target = target;
    return this;
  }

  /**
   * Get target
   * @return target
   */
  @jakarta.annotation.Nullable

  public String getTarget() {
    return target;
  }

  public void setTarget(String target) {
    this.target = target;
  }


  public Mount tmpfsOptions(TmpfsOptions tmpfsOptions) {
    this.tmpfsOptions = tmpfsOptions;
    return this;
  }

  /**
   * Get tmpfsOptions
   * @return tmpfsOptions
   */
  @jakarta.annotation.Nullable
  @Valid

  public TmpfsOptions getTmpfsOptions() {
    return tmpfsOptions;
  }

  public void setTmpfsOptions(TmpfsOptions tmpfsOptions) {
    this.tmpfsOptions = tmpfsOptions;
  }


  public Mount type(String type) {
    this.type = type;
    return this;
  }

  /**
   * Get type
   * @return type
   */
  @jakarta.annotation.Nullable

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }


  public Mount volumeOptions(VolumeOptions volumeOptions) {
    this.volumeOptions = volumeOptions;
    return this;
  }

  /**
   * Get volumeOptions
   * @return volumeOptions
   */
  @jakarta.annotation.Nullable
  @Valid

  public VolumeOptions getVolumeOptions() {
    return volumeOptions;
  }

  public void setVolumeOptions(VolumeOptions volumeOptions) {
    this.volumeOptions = volumeOptions;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Mount mount = (Mount) o;
    return Objects.equals(this.bindOptions, mount.bindOptions) &&
        Objects.equals(this.clusterOptions, mount.clusterOptions) &&
        Objects.equals(this.consistency, mount.consistency) &&
        Objects.equals(this.imageOptions, mount.imageOptions) &&
        Objects.equals(this.readOnly, mount.readOnly) &&
        Objects.equals(this.source, mount.source) &&
        Objects.equals(this.target, mount.target) &&
        Objects.equals(this.tmpfsOptions, mount.tmpfsOptions) &&
        Objects.equals(this.type, mount.type) &&
        Objects.equals(this.volumeOptions, mount.volumeOptions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bindOptions, clusterOptions, consistency, imageOptions, readOnly, source, target, tmpfsOptions, type, volumeOptions);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Mount {\n");
    sb.append("    bindOptions: ").append(toIndentedString(bindOptions)).append("\n");
    sb.append("    clusterOptions: ").append(toIndentedString(clusterOptions)).append("\n");
    sb.append("    consistency: ").append(toIndentedString(consistency)).append("\n");
    sb.append("    imageOptions: ").append(toIndentedString(imageOptions)).append("\n");
    sb.append("    readOnly: ").append(toIndentedString(readOnly)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    target: ").append(toIndentedString(target)).append("\n");
    sb.append("    tmpfsOptions: ").append(toIndentedString(tmpfsOptions)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    volumeOptions: ").append(toIndentedString(volumeOptions)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("BindOptions");
    openapiFields.add("ClusterOptions");
    openapiFields.add("Consistency");
    openapiFields.add("ImageOptions");
    openapiFields.add("ReadOnly");
    openapiFields.add("Source");
    openapiFields.add("Target");
    openapiFields.add("TmpfsOptions");
    openapiFields.add("Type");
    openapiFields.add("VolumeOptions");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

  /**
   * Validates the JSON Element and throws an exception if issues found
   *
   * @param jsonElement JSON Element
   * @throws IOException if the JSON Element is invalid with respect to Mount
   */
  public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (jsonElement == null) {
        if (!Mount.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in Mount is not found in the empty JSON string", Mount.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!Mount.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Mount` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      // validate the optional field `BindOptions`
      if (jsonObj.get("BindOptions") != null && !jsonObj.get("BindOptions").isJsonNull()) {
        BindOptions.validateJsonElement(jsonObj.get("BindOptions"));
      }
      if ((jsonObj.get("Consistency") != null && !jsonObj.get("Consistency").isJsonNull()) && !jsonObj.get("Consistency").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `Consistency` to be a primitive type in the JSON string but got `%s`", jsonObj.get("Consistency").toString()));
      }
      // validate the optional field `ImageOptions`
      if (jsonObj.get("ImageOptions") != null && !jsonObj.get("ImageOptions").isJsonNull()) {
        ImageOptions.validateJsonElement(jsonObj.get("ImageOptions"));
      }
      if ((jsonObj.get("Source") != null && !jsonObj.get("Source").isJsonNull()) && !jsonObj.get("Source").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `Source` to be a primitive type in the JSON string but got `%s`", jsonObj.get("Source").toString()));
      }
      if ((jsonObj.get("Target") != null && !jsonObj.get("Target").isJsonNull()) && !jsonObj.get("Target").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `Target` to be a primitive type in the JSON string but got `%s`", jsonObj.get("Target").toString()));
      }
      // validate the optional field `TmpfsOptions`
      if (jsonObj.get("TmpfsOptions") != null && !jsonObj.get("TmpfsOptions").isJsonNull()) {
        TmpfsOptions.validateJsonElement(jsonObj.get("TmpfsOptions"));
      }
      if ((jsonObj.get("Type") != null && !jsonObj.get("Type").isJsonNull()) && !jsonObj.get("Type").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `Type` to be a primitive type in the JSON string but got `%s`", jsonObj.get("Type").toString()));
      }
      // validate the optional field `VolumeOptions`
      if (jsonObj.get("VolumeOptions") != null && !jsonObj.get("VolumeOptions").isJsonNull()) {
        VolumeOptions.validateJsonElement(jsonObj.get("VolumeOptions"));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!Mount.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'Mount' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<Mount> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(Mount.class));

       return (TypeAdapter<T>) new TypeAdapter<Mount>() {
           @Override
           public void write(JsonWriter out, Mount value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public Mount read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

  /**
   * Create an instance of Mount given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of Mount
   * @throws IOException if the JSON string is invalid with respect to Mount
   */
  public static Mount fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, Mount.class);
  }

  /**
   * Convert an instance of Mount to an JSON string
   *
   * @return JSON string
   */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

