/*
 * supports a RESTful API for the Libpod library
 * This documentation describes the Podman v2.x+ RESTful API. It consists of a Docker-compatible API and a Libpod API providing support for Podman’s unique features such as pods.  To start the service and keep it running for 5,000 seconds (-t 0 runs forever):  podman system service -t 5000 &  You can then use cURL on the socket using requests documented below.  NOTE: if you install the package podman-docker, it will create a symbolic link for /run/docker.sock to /run/podman/podman.sock  NOTE: Some fields in the API response JSON are encoded as omitempty, which means that if said field has a zero value, they will not be encoded in the API response. This is a feature to help reduce the size of the JSON responses returned via the API.  NOTE: Due to the limitations of [go-swagger](https://github.com/go-swagger/go-swagger), some field values that have a complex type show up as null in the docs as well as in the API responses. This is because the zero value for the field type is null. The field description in the docs will state what type the field is expected to be for such cases.  See podman-system-service(1) for more information.  Quick Examples:  'podman info'  curl --unix-socket /run/podman/podman.sock http://d/v5.0.0/libpod/info  'podman pull quay.io/containers/podman'  curl -XPOST --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/images/create?fromImage=quay.io%2Fcontainers%2Fpodman'  'podman list images'  curl --unix-socket /run/podman/podman.sock -v 'http://d/v5.0.0/libpod/images/json' | jq
 *
 * The version of the OpenAPI document: 5.0.0
 * Contact: podman@lists.podman.io
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.github.pod4dev.libpodj.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.pod4dev.libpodj.model.IDMappingOptions;
import io.github.pod4dev.libpodj.model.ImageVolume;
import io.github.pod4dev.libpodj.model.LinuxResources;
import io.github.pod4dev.libpodj.model.Mount;
import io.github.pod4dev.libpodj.model.NamedVolume;
import io.github.pod4dev.libpodj.model.Namespace;
import io.github.pod4dev.libpodj.model.OverlayVolume;
import io.github.pod4dev.libpodj.model.PerNetworkOptions;
import io.github.pod4dev.libpodj.model.PortMapping;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.io.Serializable;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import io.github.pod4dev.libpodj.JSON;

/**
 * PodSpecGenerator describes options to create a pod
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.9.0")
public class PodSpecGenerator implements Serializable {
  private static final long serialVersionUID = 1L;

  public static final String SERIALIZED_NAME_NETWORKS = "Networks";
  @SerializedName(SERIALIZED_NAME_NETWORKS)
  private Map<String, PerNetworkOptions> networks = new HashMap<>();

  public static final String SERIALIZED_NAME_CGROUP_PARENT = "cgroup_parent";
  @SerializedName(SERIALIZED_NAME_CGROUP_PARENT)
  private String cgroupParent;

  public static final String SERIALIZED_NAME_CNI_NETWORKS = "cni_networks";
  @SerializedName(SERIALIZED_NAME_CNI_NETWORKS)
  private List<String> cniNetworks = new ArrayList<>();

  public static final String SERIALIZED_NAME_DNS_OPTION = "dns_option";
  @SerializedName(SERIALIZED_NAME_DNS_OPTION)
  private List<String> dnsOption = new ArrayList<>();

  public static final String SERIALIZED_NAME_DNS_SEARCH = "dns_search";
  @SerializedName(SERIALIZED_NAME_DNS_SEARCH)
  private List<String> dnsSearch = new ArrayList<>();

  public static final String SERIALIZED_NAME_DNS_SERVER = "dns_server";
  @SerializedName(SERIALIZED_NAME_DNS_SERVER)
  private List<String> dnsServer = new ArrayList<>();

  public static final String SERIALIZED_NAME_EXIT_POLICY = "exit_policy";
  @SerializedName(SERIALIZED_NAME_EXIT_POLICY)
  private String exitPolicy;

  public static final String SERIALIZED_NAME_HOSTADD = "hostadd";
  @SerializedName(SERIALIZED_NAME_HOSTADD)
  private List<String> hostadd = new ArrayList<>();

  public static final String SERIALIZED_NAME_HOSTNAME = "hostname";
  @SerializedName(SERIALIZED_NAME_HOSTNAME)
  private String hostname;

  public static final String SERIALIZED_NAME_HOSTS_FILE = "hostsFile";
  @SerializedName(SERIALIZED_NAME_HOSTS_FILE)
  private String hostsFile;

  public static final String SERIALIZED_NAME_IDMAPPINGS = "idmappings";
  @SerializedName(SERIALIZED_NAME_IDMAPPINGS)
  private IDMappingOptions idmappings;

  public static final String SERIALIZED_NAME_IMAGE_VOLUMES = "image_volumes";
  @SerializedName(SERIALIZED_NAME_IMAGE_VOLUMES)
  private List<@Valid ImageVolume> imageVolumes = new ArrayList<>();

  public static final String SERIALIZED_NAME_INFRA_COMMAND = "infra_command";
  @SerializedName(SERIALIZED_NAME_INFRA_COMMAND)
  private List<String> infraCommand = new ArrayList<>();

  public static final String SERIALIZED_NAME_INFRA_CONMON_PID_FILE = "infra_conmon_pid_file";
  @SerializedName(SERIALIZED_NAME_INFRA_CONMON_PID_FILE)
  private String infraConmonPidFile;

  public static final String SERIALIZED_NAME_INFRA_IMAGE = "infra_image";
  @SerializedName(SERIALIZED_NAME_INFRA_IMAGE)
  private String infraImage;

  public static final String SERIALIZED_NAME_INFRA_NAME = "infra_name";
  @SerializedName(SERIALIZED_NAME_INFRA_NAME)
  private String infraName;

  public static final String SERIALIZED_NAME_IPCNS = "ipcns";
  @SerializedName(SERIALIZED_NAME_IPCNS)
  private Namespace ipcns;

  public static final String SERIALIZED_NAME_LABELS = "labels";
  @SerializedName(SERIALIZED_NAME_LABELS)
  private Map<String, String> labels = new HashMap<>();

  public static final String SERIALIZED_NAME_MOUNTS = "mounts";
  @SerializedName(SERIALIZED_NAME_MOUNTS)
  private List<@Valid Mount> mounts = new ArrayList<>();

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_NETNS = "netns";
  @SerializedName(SERIALIZED_NAME_NETNS)
  private Namespace netns;

  public static final String SERIALIZED_NAME_NETWORK_OPTIONS = "network_options";
  @SerializedName(SERIALIZED_NAME_NETWORK_OPTIONS)
  private Map<String, List<String>> networkOptions = new HashMap<>();

  public static final String SERIALIZED_NAME_NO_INFRA = "no_infra";
  @SerializedName(SERIALIZED_NAME_NO_INFRA)
  private Boolean noInfra;

  public static final String SERIALIZED_NAME_NO_MANAGE_HOSTNAME = "no_manage_hostname";
  @SerializedName(SERIALIZED_NAME_NO_MANAGE_HOSTNAME)
  private Boolean noManageHostname;

  public static final String SERIALIZED_NAME_NO_MANAGE_HOSTS = "no_manage_hosts";
  @SerializedName(SERIALIZED_NAME_NO_MANAGE_HOSTS)
  private Boolean noManageHosts;

  public static final String SERIALIZED_NAME_NO_MANAGE_RESOLV_CONF = "no_manage_resolv_conf";
  @SerializedName(SERIALIZED_NAME_NO_MANAGE_RESOLV_CONF)
  private Boolean noManageResolvConf;

  public static final String SERIALIZED_NAME_OVERLAY_VOLUMES = "overlay_volumes";
  @SerializedName(SERIALIZED_NAME_OVERLAY_VOLUMES)
  private List<@Valid OverlayVolume> overlayVolumes = new ArrayList<>();

  public static final String SERIALIZED_NAME_PIDNS = "pidns";
  @SerializedName(SERIALIZED_NAME_PIDNS)
  private Namespace pidns;

  public static final String SERIALIZED_NAME_POD_CREATE_COMMAND = "pod_create_command";
  @SerializedName(SERIALIZED_NAME_POD_CREATE_COMMAND)
  private List<String> podCreateCommand = new ArrayList<>();

  public static final String SERIALIZED_NAME_POD_DEVICES = "pod_devices";
  @SerializedName(SERIALIZED_NAME_POD_DEVICES)
  private List<String> podDevices = new ArrayList<>();

  public static final String SERIALIZED_NAME_PORTMAPPINGS = "portmappings";
  @SerializedName(SERIALIZED_NAME_PORTMAPPINGS)
  private List<@Valid PortMapping> portmappings = new ArrayList<>();

  public static final String SERIALIZED_NAME_RESOURCE_LIMITS = "resource_limits";
  @SerializedName(SERIALIZED_NAME_RESOURCE_LIMITS)
  private LinuxResources resourceLimits;

  public static final String SERIALIZED_NAME_RESTART_POLICY = "restart_policy";
  @SerializedName(SERIALIZED_NAME_RESTART_POLICY)
  private String restartPolicy;

  public static final String SERIALIZED_NAME_RESTART_TRIES = "restart_tries";
  @SerializedName(SERIALIZED_NAME_RESTART_TRIES)
  private Integer restartTries;

  public static final String SERIALIZED_NAME_SECURITY_OPT = "security_opt";
  @SerializedName(SERIALIZED_NAME_SECURITY_OPT)
  private List<String> securityOpt = new ArrayList<>();

  public static final String SERIALIZED_NAME_SERVICE_CONTAINER_I_D = "serviceContainerID";
  @SerializedName(SERIALIZED_NAME_SERVICE_CONTAINER_I_D)
  private String serviceContainerID;

  public static final String SERIALIZED_NAME_SHARE_PARENT = "share_parent";
  @SerializedName(SERIALIZED_NAME_SHARE_PARENT)
  private Boolean shareParent;

  public static final String SERIALIZED_NAME_SHARED_NAMESPACES = "shared_namespaces";
  @SerializedName(SERIALIZED_NAME_SHARED_NAMESPACES)
  private List<String> sharedNamespaces = new ArrayList<>();

  public static final String SERIALIZED_NAME_SHM_SIZE = "shm_size";
  @SerializedName(SERIALIZED_NAME_SHM_SIZE)
  private Long shmSize;

  public static final String SERIALIZED_NAME_SHM_SIZE_SYSTEMD = "shm_size_systemd";
  @SerializedName(SERIALIZED_NAME_SHM_SIZE_SYSTEMD)
  private Long shmSizeSystemd;

  public static final String SERIALIZED_NAME_SYSCTL = "sysctl";
  @SerializedName(SERIALIZED_NAME_SYSCTL)
  private Map<String, String> sysctl = new HashMap<>();

  public static final String SERIALIZED_NAME_USERNS = "userns";
  @SerializedName(SERIALIZED_NAME_USERNS)
  private Namespace userns;

  public static final String SERIALIZED_NAME_UTSNS = "utsns";
  @SerializedName(SERIALIZED_NAME_UTSNS)
  private Namespace utsns;

  public static final String SERIALIZED_NAME_VOLUMES = "volumes";
  @SerializedName(SERIALIZED_NAME_VOLUMES)
  private List<@Valid NamedVolume> volumes = new ArrayList<>();

  public static final String SERIALIZED_NAME_VOLUMES_FROM = "volumes_from";
  @SerializedName(SERIALIZED_NAME_VOLUMES_FROM)
  private List<String> volumesFrom = new ArrayList<>();

  public PodSpecGenerator() {
  }

  public PodSpecGenerator networks(Map<String, PerNetworkOptions> networks) {
    this.networks = networks;
    return this;
  }

  public PodSpecGenerator putNetworksItem(String key, PerNetworkOptions networksItem) {
    if (this.networks == null) {
      this.networks = new HashMap<>();
    }
    this.networks.put(key, networksItem);
    return this;
  }

  /**
   * Map of networks names to ids the container should join to. You can request additional settings for each network, you can set network aliases, static ips, static mac address  and the network interface name for this container on the specific network. If the map is empty and the bridge network mode is set the container will be joined to the default network.
   * @return networks
   */
  @jakarta.annotation.Nullable
  @Valid

  public Map<String, PerNetworkOptions> getNetworks() {
    return networks;
  }

  public void setNetworks(Map<String, PerNetworkOptions> networks) {
    this.networks = networks;
  }


  public PodSpecGenerator cgroupParent(String cgroupParent) {
    this.cgroupParent = cgroupParent;
    return this;
  }

  /**
   * CgroupParent is the parent for the Cgroup that the pod will create. This pod cgroup will, in turn, be the default cgroup parent for all containers in the pod. Optional.
   * @return cgroupParent
   */
  @jakarta.annotation.Nullable

  public String getCgroupParent() {
    return cgroupParent;
  }

  public void setCgroupParent(String cgroupParent) {
    this.cgroupParent = cgroupParent;
  }


  public PodSpecGenerator cniNetworks(List<String> cniNetworks) {
    this.cniNetworks = cniNetworks;
    return this;
  }

  public PodSpecGenerator addCniNetworksItem(String cniNetworksItem) {
    if (this.cniNetworks == null) {
      this.cniNetworks = new ArrayList<>();
    }
    this.cniNetworks.add(cniNetworksItem);
    return this;
  }

  /**
   * CNINetworks is a list of CNI networks to join the container to. If this list is empty, the default CNI network will be joined instead. If at least one entry is present, we will not join the default network (unless it is part of this list). Only available if NetNS is set to bridge. Optional. Deprecated: as of podman 4.0 use \&quot;Networks\&quot; instead.
   * @return cniNetworks
   */
  @jakarta.annotation.Nullable

  public List<String> getCniNetworks() {
    return cniNetworks;
  }

  public void setCniNetworks(List<String> cniNetworks) {
    this.cniNetworks = cniNetworks;
  }


  public PodSpecGenerator dnsOption(List<String> dnsOption) {
    this.dnsOption = dnsOption;
    return this;
  }

  public PodSpecGenerator addDnsOptionItem(String dnsOptionItem) {
    if (this.dnsOption == null) {
      this.dnsOption = new ArrayList<>();
    }
    this.dnsOption.add(dnsOptionItem);
    return this;
  }

  /**
   * DNSOption is a set of DNS options that will be used in the infra container&#39;s resolv.conf, which will, by default, be shared with all containers in the pod. Conflicts with NoInfra&#x3D;true. Optional.
   * @return dnsOption
   */
  @jakarta.annotation.Nullable

  public List<String> getDnsOption() {
    return dnsOption;
  }

  public void setDnsOption(List<String> dnsOption) {
    this.dnsOption = dnsOption;
  }


  public PodSpecGenerator dnsSearch(List<String> dnsSearch) {
    this.dnsSearch = dnsSearch;
    return this;
  }

  public PodSpecGenerator addDnsSearchItem(String dnsSearchItem) {
    if (this.dnsSearch == null) {
      this.dnsSearch = new ArrayList<>();
    }
    this.dnsSearch.add(dnsSearchItem);
    return this;
  }

  /**
   * DNSSearch is a set of DNS search domains that will be used in the infra container&#39;s resolv.conf, which will, by default, be shared with all containers in the pod. If not provided, DNS search domains from the host&#39;s resolv.conf will be used. Conflicts with NoInfra&#x3D;true. Optional.
   * @return dnsSearch
   */
  @jakarta.annotation.Nullable

  public List<String> getDnsSearch() {
    return dnsSearch;
  }

  public void setDnsSearch(List<String> dnsSearch) {
    this.dnsSearch = dnsSearch;
  }


  public PodSpecGenerator dnsServer(List<String> dnsServer) {
    this.dnsServer = dnsServer;
    return this;
  }

  public PodSpecGenerator addDnsServerItem(String dnsServerItem) {
    if (this.dnsServer == null) {
      this.dnsServer = new ArrayList<>();
    }
    this.dnsServer.add(dnsServerItem);
    return this;
  }

  /**
   * DNSServer is a set of DNS servers that will be used in the infra container&#39;s resolv.conf, which will, by default, be shared with all containers in the pod. If not provided, the host&#39;s DNS servers will be used, unless the only server set is a localhost address. As the container cannot connect to the host&#39;s localhost, a default server will instead be set. Conflicts with NoInfra&#x3D;true. Optional.
   * @return dnsServer
   */
  @jakarta.annotation.Nullable

  public List<String> getDnsServer() {
    return dnsServer;
  }

  public void setDnsServer(List<String> dnsServer) {
    this.dnsServer = dnsServer;
  }


  public PodSpecGenerator exitPolicy(String exitPolicy) {
    this.exitPolicy = exitPolicy;
    return this;
  }

  /**
   * ExitPolicy determines the pod&#39;s exit and stop behaviour.
   * @return exitPolicy
   */
  @jakarta.annotation.Nullable

  public String getExitPolicy() {
    return exitPolicy;
  }

  public void setExitPolicy(String exitPolicy) {
    this.exitPolicy = exitPolicy;
  }


  public PodSpecGenerator hostadd(List<String> hostadd) {
    this.hostadd = hostadd;
    return this;
  }

  public PodSpecGenerator addHostaddItem(String hostaddItem) {
    if (this.hostadd == null) {
      this.hostadd = new ArrayList<>();
    }
    this.hostadd.add(hostaddItem);
    return this;
  }

  /**
   * HostAdd is a set of hosts that will be added to the infra container&#39;s etc/hosts that will, by default, be shared with all containers in the pod. Conflicts with NoInfra&#x3D;true and NoManageHosts. Optional.
   * @return hostadd
   */
  @jakarta.annotation.Nullable

  public List<String> getHostadd() {
    return hostadd;
  }

  public void setHostadd(List<String> hostadd) {
    this.hostadd = hostadd;
  }


  public PodSpecGenerator hostname(String hostname) {
    this.hostname = hostname;
    return this;
  }

  /**
   * Hostname is the pod&#39;s hostname. If not set, the name of the pod will be used (if a name was not provided here, the name auto-generated for the pod will be used). This will be used by the infra container and all containers in the pod as long as the UTS namespace is shared. Optional.
   * @return hostname
   */
  @jakarta.annotation.Nullable

  public String getHostname() {
    return hostname;
  }

  public void setHostname(String hostname) {
    this.hostname = hostname;
  }


  public PodSpecGenerator hostsFile(String hostsFile) {
    this.hostsFile = hostsFile;
    return this;
  }

  /**
   * HostsFile is the base file to create the &#x60;/etc/hosts&#x60; file inside the infra container. This must either be an absolute path to a file on the host system, or one of the special flags &#x60;image&#x60; or &#x60;none&#x60;. If it is empty it defaults to the base_hosts_file configuration in containers.conf. Conflicts with NoInfra&#x3D;true and NoManageHosts. Optional.
   * @return hostsFile
   */
  @jakarta.annotation.Nullable

  public String getHostsFile() {
    return hostsFile;
  }

  public void setHostsFile(String hostsFile) {
    this.hostsFile = hostsFile;
  }


  public PodSpecGenerator idmappings(IDMappingOptions idmappings) {
    this.idmappings = idmappings;
    return this;
  }

  /**
   * Get idmappings
   * @return idmappings
   */
  @jakarta.annotation.Nullable
  @Valid

  public IDMappingOptions getIdmappings() {
    return idmappings;
  }

  public void setIdmappings(IDMappingOptions idmappings) {
    this.idmappings = idmappings;
  }


  public PodSpecGenerator imageVolumes(List<@Valid ImageVolume> imageVolumes) {
    this.imageVolumes = imageVolumes;
    return this;
  }

  public PodSpecGenerator addImageVolumesItem(ImageVolume imageVolumesItem) {
    if (this.imageVolumes == null) {
      this.imageVolumes = new ArrayList<>();
    }
    this.imageVolumes.add(imageVolumesItem);
    return this;
  }

  /**
   * Image volumes bind-mount a container-image mount into the pod&#39;s infra container. Optional.
   * @return imageVolumes
   */
  @jakarta.annotation.Nullable
  @Valid

  public List<@Valid ImageVolume> getImageVolumes() {
    return imageVolumes;
  }

  public void setImageVolumes(List<@Valid ImageVolume> imageVolumes) {
    this.imageVolumes = imageVolumes;
  }


  public PodSpecGenerator infraCommand(List<String> infraCommand) {
    this.infraCommand = infraCommand;
    return this;
  }

  public PodSpecGenerator addInfraCommandItem(String infraCommandItem) {
    if (this.infraCommand == null) {
      this.infraCommand = new ArrayList<>();
    }
    this.infraCommand.add(infraCommandItem);
    return this;
  }

  /**
   * InfraCommand sets the command that will be used to start the infra container. If not set, the default set in the Libpod configuration file will be used. Conflicts with NoInfra&#x3D;true. Optional.
   * @return infraCommand
   */
  @jakarta.annotation.Nullable

  public List<String> getInfraCommand() {
    return infraCommand;
  }

  public void setInfraCommand(List<String> infraCommand) {
    this.infraCommand = infraCommand;
  }


  public PodSpecGenerator infraConmonPidFile(String infraConmonPidFile) {
    this.infraConmonPidFile = infraConmonPidFile;
    return this;
  }

  /**
   * InfraConmonPidFile is a custom path to store the infra container&#39;s conmon PID.
   * @return infraConmonPidFile
   */
  @jakarta.annotation.Nullable

  public String getInfraConmonPidFile() {
    return infraConmonPidFile;
  }

  public void setInfraConmonPidFile(String infraConmonPidFile) {
    this.infraConmonPidFile = infraConmonPidFile;
  }


  public PodSpecGenerator infraImage(String infraImage) {
    this.infraImage = infraImage;
    return this;
  }

  /**
   * InfraImage is the image that will be used for the infra container. If not set, the default set in the Libpod configuration file will be used. Conflicts with NoInfra&#x3D;true. Optional.
   * @return infraImage
   */
  @jakarta.annotation.Nullable

  public String getInfraImage() {
    return infraImage;
  }

  public void setInfraImage(String infraImage) {
    this.infraImage = infraImage;
  }


  public PodSpecGenerator infraName(String infraName) {
    this.infraName = infraName;
    return this;
  }

  /**
   * InfraName is the name that will be used for the infra container. If not set, the default set in the Libpod configuration file will be used. Conflicts with NoInfra&#x3D;true. Optional.
   * @return infraName
   */
  @jakarta.annotation.Nullable

  public String getInfraName() {
    return infraName;
  }

  public void setInfraName(String infraName) {
    this.infraName = infraName;
  }


  public PodSpecGenerator ipcns(Namespace ipcns) {
    this.ipcns = ipcns;
    return this;
  }

  /**
   * Get ipcns
   * @return ipcns
   */
  @jakarta.annotation.Nullable
  @Valid

  public Namespace getIpcns() {
    return ipcns;
  }

  public void setIpcns(Namespace ipcns) {
    this.ipcns = ipcns;
  }


  public PodSpecGenerator labels(Map<String, String> labels) {
    this.labels = labels;
    return this;
  }

  public PodSpecGenerator putLabelsItem(String key, String labelsItem) {
    if (this.labels == null) {
      this.labels = new HashMap<>();
    }
    this.labels.put(key, labelsItem);
    return this;
  }

  /**
   * Labels are key-value pairs that are used to add metadata to pods. Optional.
   * @return labels
   */
  @jakarta.annotation.Nullable

  public Map<String, String> getLabels() {
    return labels;
  }

  public void setLabels(Map<String, String> labels) {
    this.labels = labels;
  }


  public PodSpecGenerator mounts(List<@Valid Mount> mounts) {
    this.mounts = mounts;
    return this;
  }

  public PodSpecGenerator addMountsItem(Mount mountsItem) {
    if (this.mounts == null) {
      this.mounts = new ArrayList<>();
    }
    this.mounts.add(mountsItem);
    return this;
  }

  /**
   * Mounts are mounts that will be added to the pod. These will supersede Image Volumes and VolumesFrom volumes where there are conflicts. Optional.
   * @return mounts
   */
  @jakarta.annotation.Nullable
  @Valid

  public List<@Valid Mount> getMounts() {
    return mounts;
  }

  public void setMounts(List<@Valid Mount> mounts) {
    this.mounts = mounts;
  }


  public PodSpecGenerator name(String name) {
    this.name = name;
    return this;
  }

  /**
   * Name is the name of the pod. If not provided, a name will be generated when the pod is created. Optional.
   * @return name
   */
  @jakarta.annotation.Nullable

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }


  public PodSpecGenerator netns(Namespace netns) {
    this.netns = netns;
    return this;
  }

  /**
   * Get netns
   * @return netns
   */
  @jakarta.annotation.Nullable
  @Valid

  public Namespace getNetns() {
    return netns;
  }

  public void setNetns(Namespace netns) {
    this.netns = netns;
  }


  public PodSpecGenerator networkOptions(Map<String, List<String>> networkOptions) {
    this.networkOptions = networkOptions;
    return this;
  }

  public PodSpecGenerator putNetworkOptionsItem(String key, List<String> networkOptionsItem) {
    if (this.networkOptions == null) {
      this.networkOptions = new HashMap<>();
    }
    this.networkOptions.put(key, networkOptionsItem);
    return this;
  }

  /**
   * NetworkOptions are additional options for each network Optional.
   * @return networkOptions
   */
  @jakarta.annotation.Nullable
  @Valid

  public Map<String, List<String>> getNetworkOptions() {
    return networkOptions;
  }

  public void setNetworkOptions(Map<String, List<String>> networkOptions) {
    this.networkOptions = networkOptions;
  }


  public PodSpecGenerator noInfra(Boolean noInfra) {
    this.noInfra = noInfra;
    return this;
  }

  /**
   * NoInfra tells the pod not to create an infra container. If this is done, many networking-related options will become unavailable. Conflicts with setting any options in PodNetworkConfig, and the InfraCommand and InfraImages in this struct. Optional.
   * @return noInfra
   */
  @jakarta.annotation.Nullable

  public Boolean getNoInfra() {
    return noInfra;
  }

  public void setNoInfra(Boolean noInfra) {
    this.noInfra = noInfra;
  }


  public PodSpecGenerator noManageHostname(Boolean noManageHostname) {
    this.noManageHostname = noManageHostname;
    return this;
  }

  /**
   * NoManageHostname indicates that /etc/hostname should not be managed by the pod. Instead, each container will create a separate etc/hostname as they would if not in a pod.
   * @return noManageHostname
   */
  @jakarta.annotation.Nullable

  public Boolean getNoManageHostname() {
    return noManageHostname;
  }

  public void setNoManageHostname(Boolean noManageHostname) {
    this.noManageHostname = noManageHostname;
  }


  public PodSpecGenerator noManageHosts(Boolean noManageHosts) {
    this.noManageHosts = noManageHosts;
    return this;
  }

  /**
   * NoManageHosts indicates that /etc/hosts should not be managed by the pod. Instead, each container will create a separate /etc/hosts as they would if not in a pod. Conflicts with HostAdd.
   * @return noManageHosts
   */
  @jakarta.annotation.Nullable

  public Boolean getNoManageHosts() {
    return noManageHosts;
  }

  public void setNoManageHosts(Boolean noManageHosts) {
    this.noManageHosts = noManageHosts;
  }


  public PodSpecGenerator noManageResolvConf(Boolean noManageResolvConf) {
    this.noManageResolvConf = noManageResolvConf;
    return this;
  }

  /**
   * NoManageResolvConf indicates that /etc/resolv.conf should not be managed by the pod. Instead, each container will create and manage a separate resolv.conf as if they had not joined a pod. Conflicts with NoInfra&#x3D;true and DNSServer, DNSSearch, DNSOption. Optional.
   * @return noManageResolvConf
   */
  @jakarta.annotation.Nullable

  public Boolean getNoManageResolvConf() {
    return noManageResolvConf;
  }

  public void setNoManageResolvConf(Boolean noManageResolvConf) {
    this.noManageResolvConf = noManageResolvConf;
  }


  public PodSpecGenerator overlayVolumes(List<@Valid OverlayVolume> overlayVolumes) {
    this.overlayVolumes = overlayVolumes;
    return this;
  }

  public PodSpecGenerator addOverlayVolumesItem(OverlayVolume overlayVolumesItem) {
    if (this.overlayVolumes == null) {
      this.overlayVolumes = new ArrayList<>();
    }
    this.overlayVolumes.add(overlayVolumesItem);
    return this;
  }

  /**
   * Overlay volumes are named volumes that will be added to the pod. Optional.
   * @return overlayVolumes
   */
  @jakarta.annotation.Nullable
  @Valid

  public List<@Valid OverlayVolume> getOverlayVolumes() {
    return overlayVolumes;
  }

  public void setOverlayVolumes(List<@Valid OverlayVolume> overlayVolumes) {
    this.overlayVolumes = overlayVolumes;
  }


  public PodSpecGenerator pidns(Namespace pidns) {
    this.pidns = pidns;
    return this;
  }

  /**
   * Get pidns
   * @return pidns
   */
  @jakarta.annotation.Nullable
  @Valid

  public Namespace getPidns() {
    return pidns;
  }

  public void setPidns(Namespace pidns) {
    this.pidns = pidns;
  }


  public PodSpecGenerator podCreateCommand(List<String> podCreateCommand) {
    this.podCreateCommand = podCreateCommand;
    return this;
  }

  public PodSpecGenerator addPodCreateCommandItem(String podCreateCommandItem) {
    if (this.podCreateCommand == null) {
      this.podCreateCommand = new ArrayList<>();
    }
    this.podCreateCommand.add(podCreateCommandItem);
    return this;
  }

  /**
   * Get podCreateCommand
   * @return podCreateCommand
   */
  @jakarta.annotation.Nullable

  public List<String> getPodCreateCommand() {
    return podCreateCommand;
  }

  public void setPodCreateCommand(List<String> podCreateCommand) {
    this.podCreateCommand = podCreateCommand;
  }


  public PodSpecGenerator podDevices(List<String> podDevices) {
    this.podDevices = podDevices;
    return this;
  }

  public PodSpecGenerator addPodDevicesItem(String podDevicesItem) {
    if (this.podDevices == null) {
      this.podDevices = new ArrayList<>();
    }
    this.podDevices.add(podDevicesItem);
    return this;
  }

  /**
   * Devices contains user specified Devices to be added to the Pod
   * @return podDevices
   */
  @jakarta.annotation.Nullable

  public List<String> getPodDevices() {
    return podDevices;
  }

  public void setPodDevices(List<String> podDevices) {
    this.podDevices = podDevices;
  }


  public PodSpecGenerator portmappings(List<@Valid PortMapping> portmappings) {
    this.portmappings = portmappings;
    return this;
  }

  public PodSpecGenerator addPortmappingsItem(PortMapping portmappingsItem) {
    if (this.portmappings == null) {
      this.portmappings = new ArrayList<>();
    }
    this.portmappings.add(portmappingsItem);
    return this;
  }

  /**
   * PortMappings is a set of ports to map into the infra container. As, by default, containers share their network with the infra container, this will forward the ports to the entire pod. Only available if NetNS is set to Bridge, Slirp, or Pasta. Optional.
   * @return portmappings
   */
  @jakarta.annotation.Nullable
  @Valid

  public List<@Valid PortMapping> getPortmappings() {
    return portmappings;
  }

  public void setPortmappings(List<@Valid PortMapping> portmappings) {
    this.portmappings = portmappings;
  }


  public PodSpecGenerator resourceLimits(LinuxResources resourceLimits) {
    this.resourceLimits = resourceLimits;
    return this;
  }

  /**
   * Get resourceLimits
   * @return resourceLimits
   */
  @jakarta.annotation.Nullable
  @Valid

  public LinuxResources getResourceLimits() {
    return resourceLimits;
  }

  public void setResourceLimits(LinuxResources resourceLimits) {
    this.resourceLimits = resourceLimits;
  }


  public PodSpecGenerator restartPolicy(String restartPolicy) {
    this.restartPolicy = restartPolicy;
    return this;
  }

  /**
   * RestartPolicy is the pod&#39;s restart policy - an action which will be taken when one or all the containers in the pod exits. If not given, the default policy will be set to Always, which restarts the containers in the pod when they exit indefinitely. Optional.
   * @return restartPolicy
   */
  @jakarta.annotation.Nullable

  public String getRestartPolicy() {
    return restartPolicy;
  }

  public void setRestartPolicy(String restartPolicy) {
    this.restartPolicy = restartPolicy;
  }


  public PodSpecGenerator restartTries(Integer restartTries) {
    this.restartTries = restartTries;
    return this;
  }

  /**
   * RestartRetries is the number of attempts that will be made to restart the container. Only available when RestartPolicy is set to \&quot;on-failure\&quot;. Optional.
   * @return restartTries
   */
  @jakarta.annotation.Nullable

  public Integer getRestartTries() {
    return restartTries;
  }

  public void setRestartTries(Integer restartTries) {
    this.restartTries = restartTries;
  }


  public PodSpecGenerator securityOpt(List<String> securityOpt) {
    this.securityOpt = securityOpt;
    return this;
  }

  public PodSpecGenerator addSecurityOptItem(String securityOptItem) {
    if (this.securityOpt == null) {
      this.securityOpt = new ArrayList<>();
    }
    this.securityOpt.add(securityOptItem);
    return this;
  }

  /**
   * Get securityOpt
   * @return securityOpt
   */
  @jakarta.annotation.Nullable

  public List<String> getSecurityOpt() {
    return securityOpt;
  }

  public void setSecurityOpt(List<String> securityOpt) {
    this.securityOpt = securityOpt;
  }


  public PodSpecGenerator serviceContainerID(String serviceContainerID) {
    this.serviceContainerID = serviceContainerID;
    return this;
  }

  /**
   * The ID of the pod&#39;s service container.
   * @return serviceContainerID
   */
  @jakarta.annotation.Nullable

  public String getServiceContainerID() {
    return serviceContainerID;
  }

  public void setServiceContainerID(String serviceContainerID) {
    this.serviceContainerID = serviceContainerID;
  }


  public PodSpecGenerator shareParent(Boolean shareParent) {
    this.shareParent = shareParent;
    return this;
  }

  /**
   * PodCreateCommand is the command used to create this pod. This will be shown in the output of Inspect() on the pod, and may also be used by some tools that wish to recreate the pod (e.g. &#x60;podman generate systemd --new&#x60;). Optional. ShareParent determines if all containers in the pod will share the pod&#39;s cgroup as the cgroup parent
   * @return shareParent
   */
  @jakarta.annotation.Nullable

  public Boolean getShareParent() {
    return shareParent;
  }

  public void setShareParent(Boolean shareParent) {
    this.shareParent = shareParent;
  }


  public PodSpecGenerator sharedNamespaces(List<String> sharedNamespaces) {
    this.sharedNamespaces = sharedNamespaces;
    return this;
  }

  public PodSpecGenerator addSharedNamespacesItem(String sharedNamespacesItem) {
    if (this.sharedNamespaces == null) {
      this.sharedNamespaces = new ArrayList<>();
    }
    this.sharedNamespaces.add(sharedNamespacesItem);
    return this;
  }

  /**
   * SharedNamespaces instructs the pod to share a set of namespaces. Shared namespaces will be joined (by default) by every container which joins the pod. If not set and NoInfra is false, the pod will set a default set of namespaces to share. Conflicts with NoInfra&#x3D;true. Optional.
   * @return sharedNamespaces
   */
  @jakarta.annotation.Nullable

  public List<String> getSharedNamespaces() {
    return sharedNamespaces;
  }

  public void setSharedNamespaces(List<String> sharedNamespaces) {
    this.sharedNamespaces = sharedNamespaces;
  }


  public PodSpecGenerator shmSize(Long shmSize) {
    this.shmSize = shmSize;
    return this;
  }

  /**
   * ShmSize is the size of the tmpfs to mount in at /dev/shm, in bytes. Conflicts with ShmSize if IpcNS is not private. Optional.
   * @return shmSize
   */
  @jakarta.annotation.Nullable

  public Long getShmSize() {
    return shmSize;
  }

  public void setShmSize(Long shmSize) {
    this.shmSize = shmSize;
  }


  public PodSpecGenerator shmSizeSystemd(Long shmSizeSystemd) {
    this.shmSizeSystemd = shmSizeSystemd;
    return this;
  }

  /**
   * ShmSizeSystemd is the size of systemd-specific tmpfs mounts specifically /run, /run/lock, /var/log/journal and /tmp. Optional
   * @return shmSizeSystemd
   */
  @jakarta.annotation.Nullable

  public Long getShmSizeSystemd() {
    return shmSizeSystemd;
  }

  public void setShmSizeSystemd(Long shmSizeSystemd) {
    this.shmSizeSystemd = shmSizeSystemd;
  }


  public PodSpecGenerator sysctl(Map<String, String> sysctl) {
    this.sysctl = sysctl;
    return this;
  }

  public PodSpecGenerator putSysctlItem(String key, String sysctlItem) {
    if (this.sysctl == null) {
      this.sysctl = new HashMap<>();
    }
    this.sysctl.put(key, sysctlItem);
    return this;
  }

  /**
   * Sysctl sets kernel parameters for the pod
   * @return sysctl
   */
  @jakarta.annotation.Nullable

  public Map<String, String> getSysctl() {
    return sysctl;
  }

  public void setSysctl(Map<String, String> sysctl) {
    this.sysctl = sysctl;
  }


  public PodSpecGenerator userns(Namespace userns) {
    this.userns = userns;
    return this;
  }

  /**
   * Get userns
   * @return userns
   */
  @jakarta.annotation.Nullable
  @Valid

  public Namespace getUserns() {
    return userns;
  }

  public void setUserns(Namespace userns) {
    this.userns = userns;
  }


  public PodSpecGenerator utsns(Namespace utsns) {
    this.utsns = utsns;
    return this;
  }

  /**
   * Get utsns
   * @return utsns
   */
  @jakarta.annotation.Nullable
  @Valid

  public Namespace getUtsns() {
    return utsns;
  }

  public void setUtsns(Namespace utsns) {
    this.utsns = utsns;
  }


  public PodSpecGenerator volumes(List<@Valid NamedVolume> volumes) {
    this.volumes = volumes;
    return this;
  }

  public PodSpecGenerator addVolumesItem(NamedVolume volumesItem) {
    if (this.volumes == null) {
      this.volumes = new ArrayList<>();
    }
    this.volumes.add(volumesItem);
    return this;
  }

  /**
   * Volumes are named volumes that will be added to the pod. These will supersede Image Volumes and VolumesFrom  volumes where there are conflicts. Optional.
   * @return volumes
   */
  @jakarta.annotation.Nullable
  @Valid

  public List<@Valid NamedVolume> getVolumes() {
    return volumes;
  }

  public void setVolumes(List<@Valid NamedVolume> volumes) {
    this.volumes = volumes;
  }


  public PodSpecGenerator volumesFrom(List<String> volumesFrom) {
    this.volumesFrom = volumesFrom;
    return this;
  }

  public PodSpecGenerator addVolumesFromItem(String volumesFromItem) {
    if (this.volumesFrom == null) {
      this.volumesFrom = new ArrayList<>();
    }
    this.volumesFrom.add(volumesFromItem);
    return this;
  }

  /**
   * VolumesFrom is a set of containers whose volumes will be added to this pod. The name or ID of the container must be provided, and may optionally be followed by a : and then one or more comma-separated options. Valid options are &#39;ro&#39;, &#39;rw&#39;, and &#39;z&#39;. Options will be used for all volumes sourced from the container.
   * @return volumesFrom
   */
  @jakarta.annotation.Nullable

  public List<String> getVolumesFrom() {
    return volumesFrom;
  }

  public void setVolumesFrom(List<String> volumesFrom) {
    this.volumesFrom = volumesFrom;
  }



  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PodSpecGenerator podSpecGenerator = (PodSpecGenerator) o;
    return Objects.equals(this.networks, podSpecGenerator.networks) &&
        Objects.equals(this.cgroupParent, podSpecGenerator.cgroupParent) &&
        Objects.equals(this.cniNetworks, podSpecGenerator.cniNetworks) &&
        Objects.equals(this.dnsOption, podSpecGenerator.dnsOption) &&
        Objects.equals(this.dnsSearch, podSpecGenerator.dnsSearch) &&
        Objects.equals(this.dnsServer, podSpecGenerator.dnsServer) &&
        Objects.equals(this.exitPolicy, podSpecGenerator.exitPolicy) &&
        Objects.equals(this.hostadd, podSpecGenerator.hostadd) &&
        Objects.equals(this.hostname, podSpecGenerator.hostname) &&
        Objects.equals(this.hostsFile, podSpecGenerator.hostsFile) &&
        Objects.equals(this.idmappings, podSpecGenerator.idmappings) &&
        Objects.equals(this.imageVolumes, podSpecGenerator.imageVolumes) &&
        Objects.equals(this.infraCommand, podSpecGenerator.infraCommand) &&
        Objects.equals(this.infraConmonPidFile, podSpecGenerator.infraConmonPidFile) &&
        Objects.equals(this.infraImage, podSpecGenerator.infraImage) &&
        Objects.equals(this.infraName, podSpecGenerator.infraName) &&
        Objects.equals(this.ipcns, podSpecGenerator.ipcns) &&
        Objects.equals(this.labels, podSpecGenerator.labels) &&
        Objects.equals(this.mounts, podSpecGenerator.mounts) &&
        Objects.equals(this.name, podSpecGenerator.name) &&
        Objects.equals(this.netns, podSpecGenerator.netns) &&
        Objects.equals(this.networkOptions, podSpecGenerator.networkOptions) &&
        Objects.equals(this.noInfra, podSpecGenerator.noInfra) &&
        Objects.equals(this.noManageHostname, podSpecGenerator.noManageHostname) &&
        Objects.equals(this.noManageHosts, podSpecGenerator.noManageHosts) &&
        Objects.equals(this.noManageResolvConf, podSpecGenerator.noManageResolvConf) &&
        Objects.equals(this.overlayVolumes, podSpecGenerator.overlayVolumes) &&
        Objects.equals(this.pidns, podSpecGenerator.pidns) &&
        Objects.equals(this.podCreateCommand, podSpecGenerator.podCreateCommand) &&
        Objects.equals(this.podDevices, podSpecGenerator.podDevices) &&
        Objects.equals(this.portmappings, podSpecGenerator.portmappings) &&
        Objects.equals(this.resourceLimits, podSpecGenerator.resourceLimits) &&
        Objects.equals(this.restartPolicy, podSpecGenerator.restartPolicy) &&
        Objects.equals(this.restartTries, podSpecGenerator.restartTries) &&
        Objects.equals(this.securityOpt, podSpecGenerator.securityOpt) &&
        Objects.equals(this.serviceContainerID, podSpecGenerator.serviceContainerID) &&
        Objects.equals(this.shareParent, podSpecGenerator.shareParent) &&
        Objects.equals(this.sharedNamespaces, podSpecGenerator.sharedNamespaces) &&
        Objects.equals(this.shmSize, podSpecGenerator.shmSize) &&
        Objects.equals(this.shmSizeSystemd, podSpecGenerator.shmSizeSystemd) &&
        Objects.equals(this.sysctl, podSpecGenerator.sysctl) &&
        Objects.equals(this.userns, podSpecGenerator.userns) &&
        Objects.equals(this.utsns, podSpecGenerator.utsns) &&
        Objects.equals(this.volumes, podSpecGenerator.volumes) &&
        Objects.equals(this.volumesFrom, podSpecGenerator.volumesFrom);
  }

  @Override
  public int hashCode() {
    return Objects.hash(networks, cgroupParent, cniNetworks, dnsOption, dnsSearch, dnsServer, exitPolicy, hostadd, hostname, hostsFile, idmappings, imageVolumes, infraCommand, infraConmonPidFile, infraImage, infraName, ipcns, labels, mounts, name, netns, networkOptions, noInfra, noManageHostname, noManageHosts, noManageResolvConf, overlayVolumes, pidns, podCreateCommand, podDevices, portmappings, resourceLimits, restartPolicy, restartTries, securityOpt, serviceContainerID, shareParent, sharedNamespaces, shmSize, shmSizeSystemd, sysctl, userns, utsns, volumes, volumesFrom);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PodSpecGenerator {\n");
    sb.append("    networks: ").append(toIndentedString(networks)).append("\n");
    sb.append("    cgroupParent: ").append(toIndentedString(cgroupParent)).append("\n");
    sb.append("    cniNetworks: ").append(toIndentedString(cniNetworks)).append("\n");
    sb.append("    dnsOption: ").append(toIndentedString(dnsOption)).append("\n");
    sb.append("    dnsSearch: ").append(toIndentedString(dnsSearch)).append("\n");
    sb.append("    dnsServer: ").append(toIndentedString(dnsServer)).append("\n");
    sb.append("    exitPolicy: ").append(toIndentedString(exitPolicy)).append("\n");
    sb.append("    hostadd: ").append(toIndentedString(hostadd)).append("\n");
    sb.append("    hostname: ").append(toIndentedString(hostname)).append("\n");
    sb.append("    hostsFile: ").append(toIndentedString(hostsFile)).append("\n");
    sb.append("    idmappings: ").append(toIndentedString(idmappings)).append("\n");
    sb.append("    imageVolumes: ").append(toIndentedString(imageVolumes)).append("\n");
    sb.append("    infraCommand: ").append(toIndentedString(infraCommand)).append("\n");
    sb.append("    infraConmonPidFile: ").append(toIndentedString(infraConmonPidFile)).append("\n");
    sb.append("    infraImage: ").append(toIndentedString(infraImage)).append("\n");
    sb.append("    infraName: ").append(toIndentedString(infraName)).append("\n");
    sb.append("    ipcns: ").append(toIndentedString(ipcns)).append("\n");
    sb.append("    labels: ").append(toIndentedString(labels)).append("\n");
    sb.append("    mounts: ").append(toIndentedString(mounts)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    netns: ").append(toIndentedString(netns)).append("\n");
    sb.append("    networkOptions: ").append(toIndentedString(networkOptions)).append("\n");
    sb.append("    noInfra: ").append(toIndentedString(noInfra)).append("\n");
    sb.append("    noManageHostname: ").append(toIndentedString(noManageHostname)).append("\n");
    sb.append("    noManageHosts: ").append(toIndentedString(noManageHosts)).append("\n");
    sb.append("    noManageResolvConf: ").append(toIndentedString(noManageResolvConf)).append("\n");
    sb.append("    overlayVolumes: ").append(toIndentedString(overlayVolumes)).append("\n");
    sb.append("    pidns: ").append(toIndentedString(pidns)).append("\n");
    sb.append("    podCreateCommand: ").append(toIndentedString(podCreateCommand)).append("\n");
    sb.append("    podDevices: ").append(toIndentedString(podDevices)).append("\n");
    sb.append("    portmappings: ").append(toIndentedString(portmappings)).append("\n");
    sb.append("    resourceLimits: ").append(toIndentedString(resourceLimits)).append("\n");
    sb.append("    restartPolicy: ").append(toIndentedString(restartPolicy)).append("\n");
    sb.append("    restartTries: ").append(toIndentedString(restartTries)).append("\n");
    sb.append("    securityOpt: ").append(toIndentedString(securityOpt)).append("\n");
    sb.append("    serviceContainerID: ").append(toIndentedString(serviceContainerID)).append("\n");
    sb.append("    shareParent: ").append(toIndentedString(shareParent)).append("\n");
    sb.append("    sharedNamespaces: ").append(toIndentedString(sharedNamespaces)).append("\n");
    sb.append("    shmSize: ").append(toIndentedString(shmSize)).append("\n");
    sb.append("    shmSizeSystemd: ").append(toIndentedString(shmSizeSystemd)).append("\n");
    sb.append("    sysctl: ").append(toIndentedString(sysctl)).append("\n");
    sb.append("    userns: ").append(toIndentedString(userns)).append("\n");
    sb.append("    utsns: ").append(toIndentedString(utsns)).append("\n");
    sb.append("    volumes: ").append(toIndentedString(volumes)).append("\n");
    sb.append("    volumesFrom: ").append(toIndentedString(volumesFrom)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


  public static HashSet<String> openapiFields;
  public static HashSet<String> openapiRequiredFields;

  static {
    // a set of all properties/fields (JSON key names)
    openapiFields = new HashSet<String>();
    openapiFields.add("Networks");
    openapiFields.add("cgroup_parent");
    openapiFields.add("cni_networks");
    openapiFields.add("dns_option");
    openapiFields.add("dns_search");
    openapiFields.add("dns_server");
    openapiFields.add("exit_policy");
    openapiFields.add("hostadd");
    openapiFields.add("hostname");
    openapiFields.add("hostsFile");
    openapiFields.add("idmappings");
    openapiFields.add("image_volumes");
    openapiFields.add("infra_command");
    openapiFields.add("infra_conmon_pid_file");
    openapiFields.add("infra_image");
    openapiFields.add("infra_name");
    openapiFields.add("ipcns");
    openapiFields.add("labels");
    openapiFields.add("mounts");
    openapiFields.add("name");
    openapiFields.add("netns");
    openapiFields.add("network_options");
    openapiFields.add("no_infra");
    openapiFields.add("no_manage_hostname");
    openapiFields.add("no_manage_hosts");
    openapiFields.add("no_manage_resolv_conf");
    openapiFields.add("overlay_volumes");
    openapiFields.add("pidns");
    openapiFields.add("pod_create_command");
    openapiFields.add("pod_devices");
    openapiFields.add("portmappings");
    openapiFields.add("resource_limits");
    openapiFields.add("restart_policy");
    openapiFields.add("restart_tries");
    openapiFields.add("security_opt");
    openapiFields.add("serviceContainerID");
    openapiFields.add("share_parent");
    openapiFields.add("shared_namespaces");
    openapiFields.add("shm_size");
    openapiFields.add("shm_size_systemd");
    openapiFields.add("sysctl");
    openapiFields.add("userns");
    openapiFields.add("utsns");
    openapiFields.add("volumes");
    openapiFields.add("volumes_from");

    // a set of required properties/fields (JSON key names)
    openapiRequiredFields = new HashSet<String>();
  }

  /**
   * Validates the JSON Element and throws an exception if issues found
   *
   * @param jsonElement JSON Element
   * @throws IOException if the JSON Element is invalid with respect to PodSpecGenerator
   */
  public static void validateJsonElement(JsonElement jsonElement) throws IOException {
      if (jsonElement == null) {
        if (!PodSpecGenerator.openapiRequiredFields.isEmpty()) { // has required fields but JSON element is null
          throw new IllegalArgumentException(String.format("The required field(s) %s in PodSpecGenerator is not found in the empty JSON string", PodSpecGenerator.openapiRequiredFields.toString()));
        }
      }

      Set<Map.Entry<String, JsonElement>> entries = jsonElement.getAsJsonObject().entrySet();
      // check to see if the JSON string contains additional fields
      for (Map.Entry<String, JsonElement> entry : entries) {
        if (!PodSpecGenerator.openapiFields.contains(entry.getKey())) {
          throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `PodSpecGenerator` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
      }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
      if ((jsonObj.get("cgroup_parent") != null && !jsonObj.get("cgroup_parent").isJsonNull()) && !jsonObj.get("cgroup_parent").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `cgroup_parent` to be a primitive type in the JSON string but got `%s`", jsonObj.get("cgroup_parent").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("cni_networks") != null && !jsonObj.get("cni_networks").isJsonNull() && !jsonObj.get("cni_networks").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `cni_networks` to be an array in the JSON string but got `%s`", jsonObj.get("cni_networks").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("dns_option") != null && !jsonObj.get("dns_option").isJsonNull() && !jsonObj.get("dns_option").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `dns_option` to be an array in the JSON string but got `%s`", jsonObj.get("dns_option").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("dns_search") != null && !jsonObj.get("dns_search").isJsonNull() && !jsonObj.get("dns_search").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `dns_search` to be an array in the JSON string but got `%s`", jsonObj.get("dns_search").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("dns_server") != null && !jsonObj.get("dns_server").isJsonNull() && !jsonObj.get("dns_server").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `dns_server` to be an array in the JSON string but got `%s`", jsonObj.get("dns_server").toString()));
      }
      if ((jsonObj.get("exit_policy") != null && !jsonObj.get("exit_policy").isJsonNull()) && !jsonObj.get("exit_policy").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `exit_policy` to be a primitive type in the JSON string but got `%s`", jsonObj.get("exit_policy").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("hostadd") != null && !jsonObj.get("hostadd").isJsonNull() && !jsonObj.get("hostadd").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `hostadd` to be an array in the JSON string but got `%s`", jsonObj.get("hostadd").toString()));
      }
      if ((jsonObj.get("hostname") != null && !jsonObj.get("hostname").isJsonNull()) && !jsonObj.get("hostname").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `hostname` to be a primitive type in the JSON string but got `%s`", jsonObj.get("hostname").toString()));
      }
      if ((jsonObj.get("hostsFile") != null && !jsonObj.get("hostsFile").isJsonNull()) && !jsonObj.get("hostsFile").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `hostsFile` to be a primitive type in the JSON string but got `%s`", jsonObj.get("hostsFile").toString()));
      }
      // validate the optional field `idmappings`
      if (jsonObj.get("idmappings") != null && !jsonObj.get("idmappings").isJsonNull()) {
        IDMappingOptions.validateJsonElement(jsonObj.get("idmappings"));
      }
      if (jsonObj.get("image_volumes") != null && !jsonObj.get("image_volumes").isJsonNull()) {
        JsonArray jsonArrayimageVolumes = jsonObj.getAsJsonArray("image_volumes");
        if (jsonArrayimageVolumes != null) {
          // ensure the json data is an array
          if (!jsonObj.get("image_volumes").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `image_volumes` to be an array in the JSON string but got `%s`", jsonObj.get("image_volumes").toString()));
          }

          // validate the optional field `image_volumes` (array)
          for (int i = 0; i < jsonArrayimageVolumes.size(); i++) {
            ImageVolume.validateJsonElement(jsonArrayimageVolumes.get(i));
          };
        }
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("infra_command") != null && !jsonObj.get("infra_command").isJsonNull() && !jsonObj.get("infra_command").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `infra_command` to be an array in the JSON string but got `%s`", jsonObj.get("infra_command").toString()));
      }
      if ((jsonObj.get("infra_conmon_pid_file") != null && !jsonObj.get("infra_conmon_pid_file").isJsonNull()) && !jsonObj.get("infra_conmon_pid_file").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `infra_conmon_pid_file` to be a primitive type in the JSON string but got `%s`", jsonObj.get("infra_conmon_pid_file").toString()));
      }
      if ((jsonObj.get("infra_image") != null && !jsonObj.get("infra_image").isJsonNull()) && !jsonObj.get("infra_image").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `infra_image` to be a primitive type in the JSON string but got `%s`", jsonObj.get("infra_image").toString()));
      }
      if ((jsonObj.get("infra_name") != null && !jsonObj.get("infra_name").isJsonNull()) && !jsonObj.get("infra_name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `infra_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("infra_name").toString()));
      }
      // validate the optional field `ipcns`
      if (jsonObj.get("ipcns") != null && !jsonObj.get("ipcns").isJsonNull()) {
        Namespace.validateJsonElement(jsonObj.get("ipcns"));
      }
      if (jsonObj.get("mounts") != null && !jsonObj.get("mounts").isJsonNull()) {
        JsonArray jsonArraymounts = jsonObj.getAsJsonArray("mounts");
        if (jsonArraymounts != null) {
          // ensure the json data is an array
          if (!jsonObj.get("mounts").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `mounts` to be an array in the JSON string but got `%s`", jsonObj.get("mounts").toString()));
          }

          // validate the optional field `mounts` (array)
          for (int i = 0; i < jsonArraymounts.size(); i++) {
            Mount.validateJsonElement(jsonArraymounts.get(i));
          };
        }
      }
      if ((jsonObj.get("name") != null && !jsonObj.get("name").isJsonNull()) && !jsonObj.get("name").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get("name").toString()));
      }
      // validate the optional field `netns`
      if (jsonObj.get("netns") != null && !jsonObj.get("netns").isJsonNull()) {
        Namespace.validateJsonElement(jsonObj.get("netns"));
      }
      if (jsonObj.get("overlay_volumes") != null && !jsonObj.get("overlay_volumes").isJsonNull()) {
        JsonArray jsonArrayoverlayVolumes = jsonObj.getAsJsonArray("overlay_volumes");
        if (jsonArrayoverlayVolumes != null) {
          // ensure the json data is an array
          if (!jsonObj.get("overlay_volumes").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `overlay_volumes` to be an array in the JSON string but got `%s`", jsonObj.get("overlay_volumes").toString()));
          }

          // validate the optional field `overlay_volumes` (array)
          for (int i = 0; i < jsonArrayoverlayVolumes.size(); i++) {
            OverlayVolume.validateJsonElement(jsonArrayoverlayVolumes.get(i));
          };
        }
      }
      // validate the optional field `pidns`
      if (jsonObj.get("pidns") != null && !jsonObj.get("pidns").isJsonNull()) {
        Namespace.validateJsonElement(jsonObj.get("pidns"));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("pod_create_command") != null && !jsonObj.get("pod_create_command").isJsonNull() && !jsonObj.get("pod_create_command").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `pod_create_command` to be an array in the JSON string but got `%s`", jsonObj.get("pod_create_command").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("pod_devices") != null && !jsonObj.get("pod_devices").isJsonNull() && !jsonObj.get("pod_devices").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `pod_devices` to be an array in the JSON string but got `%s`", jsonObj.get("pod_devices").toString()));
      }
      if (jsonObj.get("portmappings") != null && !jsonObj.get("portmappings").isJsonNull()) {
        JsonArray jsonArrayportmappings = jsonObj.getAsJsonArray("portmappings");
        if (jsonArrayportmappings != null) {
          // ensure the json data is an array
          if (!jsonObj.get("portmappings").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `portmappings` to be an array in the JSON string but got `%s`", jsonObj.get("portmappings").toString()));
          }

          // validate the optional field `portmappings` (array)
          for (int i = 0; i < jsonArrayportmappings.size(); i++) {
            PortMapping.validateJsonElement(jsonArrayportmappings.get(i));
          };
        }
      }
      // validate the optional field `resource_limits`
      if (jsonObj.get("resource_limits") != null && !jsonObj.get("resource_limits").isJsonNull()) {
        LinuxResources.validateJsonElement(jsonObj.get("resource_limits"));
      }
      if ((jsonObj.get("restart_policy") != null && !jsonObj.get("restart_policy").isJsonNull()) && !jsonObj.get("restart_policy").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `restart_policy` to be a primitive type in the JSON string but got `%s`", jsonObj.get("restart_policy").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("security_opt") != null && !jsonObj.get("security_opt").isJsonNull() && !jsonObj.get("security_opt").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `security_opt` to be an array in the JSON string but got `%s`", jsonObj.get("security_opt").toString()));
      }
      if ((jsonObj.get("serviceContainerID") != null && !jsonObj.get("serviceContainerID").isJsonNull()) && !jsonObj.get("serviceContainerID").isJsonPrimitive()) {
        throw new IllegalArgumentException(String.format("Expected the field `serviceContainerID` to be a primitive type in the JSON string but got `%s`", jsonObj.get("serviceContainerID").toString()));
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("shared_namespaces") != null && !jsonObj.get("shared_namespaces").isJsonNull() && !jsonObj.get("shared_namespaces").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `shared_namespaces` to be an array in the JSON string but got `%s`", jsonObj.get("shared_namespaces").toString()));
      }
      // validate the optional field `userns`
      if (jsonObj.get("userns") != null && !jsonObj.get("userns").isJsonNull()) {
        Namespace.validateJsonElement(jsonObj.get("userns"));
      }
      // validate the optional field `utsns`
      if (jsonObj.get("utsns") != null && !jsonObj.get("utsns").isJsonNull()) {
        Namespace.validateJsonElement(jsonObj.get("utsns"));
      }
      if (jsonObj.get("volumes") != null && !jsonObj.get("volumes").isJsonNull()) {
        JsonArray jsonArrayvolumes = jsonObj.getAsJsonArray("volumes");
        if (jsonArrayvolumes != null) {
          // ensure the json data is an array
          if (!jsonObj.get("volumes").isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `volumes` to be an array in the JSON string but got `%s`", jsonObj.get("volumes").toString()));
          }

          // validate the optional field `volumes` (array)
          for (int i = 0; i < jsonArrayvolumes.size(); i++) {
            NamedVolume.validateJsonElement(jsonArrayvolumes.get(i));
          };
        }
      }
      // ensure the optional json data is an array if present
      if (jsonObj.get("volumes_from") != null && !jsonObj.get("volumes_from").isJsonNull() && !jsonObj.get("volumes_from").isJsonArray()) {
        throw new IllegalArgumentException(String.format("Expected the field `volumes_from` to be an array in the JSON string but got `%s`", jsonObj.get("volumes_from").toString()));
      }
  }

  public static class CustomTypeAdapterFactory implements TypeAdapterFactory {
    @SuppressWarnings("unchecked")
    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
       if (!PodSpecGenerator.class.isAssignableFrom(type.getRawType())) {
         return null; // this class only serializes 'PodSpecGenerator' and its subtypes
       }
       final TypeAdapter<JsonElement> elementAdapter = gson.getAdapter(JsonElement.class);
       final TypeAdapter<PodSpecGenerator> thisAdapter
                        = gson.getDelegateAdapter(this, TypeToken.get(PodSpecGenerator.class));

       return (TypeAdapter<T>) new TypeAdapter<PodSpecGenerator>() {
           @Override
           public void write(JsonWriter out, PodSpecGenerator value) throws IOException {
             JsonObject obj = thisAdapter.toJsonTree(value).getAsJsonObject();
             elementAdapter.write(out, obj);
           }

           @Override
           public PodSpecGenerator read(JsonReader in) throws IOException {
             JsonElement jsonElement = elementAdapter.read(in);
             validateJsonElement(jsonElement);
             return thisAdapter.fromJsonTree(jsonElement);
           }

       }.nullSafe();
    }
  }

  /**
   * Create an instance of PodSpecGenerator given an JSON string
   *
   * @param jsonString JSON string
   * @return An instance of PodSpecGenerator
   * @throws IOException if the JSON string is invalid with respect to PodSpecGenerator
   */
  public static PodSpecGenerator fromJson(String jsonString) throws IOException {
    return JSON.getGson().fromJson(jsonString, PodSpecGenerator.class);
  }

  /**
   * Convert an instance of PodSpecGenerator to an JSON string
   *
   * @return JSON string
   */
  public String toJson() {
    return JSON.getGson().toJson(this);
  }
}

