/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.java;

import io.github.pod4dev.java.exceptions.PodmanException;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Random;
import lombok.Generated;

public final class Utils {
    public static String readYaml(String yamlPath) throws IOException {
        List<Path> files = Files.isDirectory(Path.of(yamlPath, new String[0]), new LinkOption[0]) ? Files.list(Path.of(yamlPath, new String[0])).toList() : List.of(Path.of(yamlPath, new String[0]));
        StringBuilder resultStringBuilder = new StringBuilder();
        for (Path file : files) {
            if (!file.getFileName().toString().endsWith(".yaml") && !file.getFileName().toString().endsWith(".yml")) continue;
            try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file.toFile())));){
                String line;
                while ((line = br.readLine()) != null) {
                    resultStringBuilder.append(line).append(System.lineSeparator());
                }
                resultStringBuilder.append("---").append(System.lineSeparator());
            }
        }
        return resultStringBuilder.toString();
    }

    public static int findFreePort(List<Integer> binded) throws PodmanException {
        Integer result = null;
        Random randomizer = new Random();
        int min = 30000;
        int max = 50000;
        int counter = 20000;
        while (result == null && counter > 0) {
            int port = randomizer.nextInt(30000, 50000);
            if (binded.contains(port)) {
                --counter;
                continue;
            }
            try (ServerSocket serverSocket = new ServerSocket(port);){
                if (serverSocket.getLocalPort() != port) continue;
                result = port;
                break;
            }
            catch (IOException ignored) {
                --counter;
            }
        }
        if (result == null) {
            throw new PodmanException("There is no free port");
        }
        return result;
    }

    @Generated
    private Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

