/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.java.core;

import io.github.pod4dev.java.exceptions.PodmanException;
import io.github.pod4dev.java.podman.PodmanClient;
import io.github.pod4dev.libpodj.ApiClient;
import io.github.pod4dev.libpodj.ApiException;
import io.github.pod4dev.libpodj.api.SystemApi;
import io.github.pod4dev.libpodj.model.HostInfo;
import io.github.pod4dev.libpodj.model.LibpodInfo;
import java.util.Optional;

public interface GenericContainer
extends AutoCloseable {
    public boolean isRunning();

    public PodmanClient getClient();

    public void start() throws PodmanException;

    public void stop() throws PodmanException;

    public GenericContainer withExposedService(String var1, Integer var2) throws PodmanException;

    public GenericContainer withCleanup(boolean var1);

    public GenericContainer withRemoveVolumes(boolean var1);

    default public String getMappedHost() throws PodmanException {
        SystemApi systemApi = new SystemApi((ApiClient)this.getClient());
        LibpodInfo libpodInfo = null;
        try {
            libpodInfo = systemApi.systemInfoLibpod().execute();
        }
        catch (ApiException e) {
            throw new PodmanException(e);
        }
        return Optional.ofNullable(libpodInfo.getHost()).map(HostInfo::getHostname).orElse(null);
    }

    public Integer getMappedPort(String var1, Integer var2) throws PodmanException;

    @Override
    default public void close() throws Exception {
        this.stop();
    }
}

