/*
 * Decompiled with CFR 0.152.
 */
package io.github.pod4dev.java.service;

import io.github.pod4dev.java.core.GenericContainer;
import io.github.pod4dev.java.core.ServiceBinding;
import io.github.pod4dev.java.core.Utils;
import io.github.pod4dev.java.exceptions.PodmanException;
import io.github.pod4dev.java.podman.PodmanClient;
import io.github.pod4dev.libpodj.ApiClient;
import io.github.pod4dev.libpodj.ApiException;
import io.github.pod4dev.libpodj.api.PodsApi;
import io.github.pod4dev.libpodj.model.InspectHostPort;
import io.github.pod4dev.libpodj.model.InspectPodData;
import io.github.pod4dev.libpodj.model.InspectPodInfraConfig;
import io.github.pod4dev.libpodj.model.PlayKubeReport;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubePlayer
implements GenericContainer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KubePlayer.class);
    private final PodmanClient client;
    private final String yamlPath;
    private final List<ServiceBinding> servicesBindings = new ArrayList<ServiceBinding>();
    private boolean isRunning;
    private boolean doCleanup = true;
    private boolean doRemoveVolumes = true;

    private KubePlayer(URI podmanUri, String yamlPath) throws PodmanException {
        this.yamlPath = yamlPath;
        this.client = new PodmanClient(podmanUri);
    }

    public KubePlayer(String yamlPath) throws PodmanException {
        this(Utils.getPodmanUri(), yamlPath);
    }

    @Override
    public PodmanClient getClient() {
        return this.client;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public KubePlayer withExposedService(String serviceName, Integer exposedPort) throws PodmanException {
        Predicate<ServiceBinding> isBindingExist = serviceBinding -> Objects.equals(serviceBinding.getServiceName(), serviceName) && Objects.equals(serviceBinding.getExposedPort(), exposedPort);
        if (!this.servicesBindings.isEmpty() && this.servicesBindings.stream().anyMatch(isBindingExist)) {
            throw new PodmanException("Binging[serviceName=%s, exposedPort=%d] already exists".formatted(serviceName, exposedPort));
        }
        this.servicesBindings.add(new ServiceBinding(serviceName, this.getMappedHost(), exposedPort));
        return this;
    }

    @Override
    public KubePlayer withCleanup(boolean doCleanup) {
        this.doCleanup = doCleanup;
        return this;
    }

    @Override
    public KubePlayer withRemoveVolumes(boolean doRemoveVolumes) {
        this.doRemoveVolumes = doRemoveVolumes;
        return this;
    }

    @Override
    public void start() throws PodmanException {
        PlayKubeReport report;
        Runtime.getRuntime().addShutdownHook(new Thread(this::stop));
        PodsApi podsApi = new PodsApi((ApiClient)this.client);
        String yaml = Utils.readYaml(this.yamlPath);
        try {
            List<String> ports = this.servicesBindings.stream().map(serviceBinding -> "%d".formatted(serviceBinding.getExposedPort())).toList();
            report = podsApi.playKubeLibpod_0().publishPorts(ports).wait(Boolean.valueOf(this.doCleanup)).start(Boolean.valueOf(true)).request(yaml).execute();
        }
        catch (ApiException e) {
            throw new PodmanException(e);
        }
        if (report == null || report.getPods() == null || report.getPods().isEmpty()) {
            throw new PodmanException("There is no related pods");
        }
        report.getPods().forEach(pod -> {
            InspectPodData inspectation;
            try {
                inspectation = podsApi.podInspectLibpod(pod.getID()).execute();
            }
            catch (ApiException e) {
                throw new PodmanException(e);
            }
            Map<Integer, Integer> mappings = Optional.ofNullable(inspectation.getInfraConfig()).map(InspectPodInfraConfig::getPortBindings).stream().map(Map::entrySet).flatMap(Collection::stream).filter(entry -> ((List)entry.getValue()).stream().anyMatch(inspectHostPort -> "0.0.0.0".equals(inspectHostPort.getHostIp()))).collect(Collectors.toMap(entry -> Integer.valueOf(((String)entry.getKey()).split("/")[0]), entry -> Integer.valueOf(((List)entry.getValue()).stream().filter(inspectHostPort -> "0.0.0.0".equals(inspectHostPort.getHostIp())).findFirst().map(InspectHostPort::getHostPort).get())));
            for (ServiceBinding sb : this.servicesBindings) {
                if (!sb.getServiceName().equals(inspectation.getName())) continue;
                sb.setMappedPort(mappings.get(sb.getExposedPort()));
            }
        });
        this.isRunning = true;
    }

    @Override
    public void stop() throws PodmanException {
        PodsApi pods = new PodsApi((ApiClient)this.client);
        String yaml = Utils.readYaml(this.yamlPath);
        try {
            pods.playKubeDownLibpod_0().force(Boolean.valueOf(this.doRemoveVolumes)).request(yaml).execute();
        }
        catch (ApiException e) {
            throw new PodmanException(e);
        }
        this.isRunning = false;
    }

    @Override
    public Integer getMappedPort(String serviceName, Integer exposedPort) throws PodmanException {
        if (!this.isRunning) {
            throw new PodmanException("Is not running");
        }
        Predicate<ServiceBinding> isBindingExist = serviceBinding -> Objects.equals(serviceBinding.getServiceName(), serviceName) && Objects.equals(serviceBinding.getExposedPort(), exposedPort) && Objects.nonNull(serviceBinding.getMappedPort());
        return this.servicesBindings.stream().filter(isBindingExist).map(ServiceBinding::getMappedPort).findAny().orElseThrow(() -> new PodmanException("Here is no mapped port"));
    }
}

