/*
 * Decompiled with CFR 0.152.
 */
package javaforce.gl;

public class Vertex3 {
    public float x;
    public float y;
    public float z;
    public float u;
    public float v;

    public Vertex3() {
    }

    public Vertex3(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vertex3(float x, float y, float z, float u, float v) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.u = u;
        this.v = v;
    }

    public Vertex3 set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public Vertex3 set(float x, float y, float z, float u, float v) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.u = u;
        this.v = v;
        return this;
    }

    public void sub(Vertex3 a, Vertex3 b) {
        this.x = a.x - b.x;
        this.y = a.y - b.y;
        this.z = a.z - b.z;
    }

    public void cross(Vertex3 a, Vertex3 b) {
        this.x = a.y * b.z - a.z * b.y;
        this.y = a.z * b.x - a.x * b.z;
        this.z = a.x * b.y - a.y * b.x;
    }

    public void normalize() {
        float len = this.length();
        if (len == 0.0f) {
            return;
        }
        this.scale(1.0f / len);
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.dot(this);
    }

    public void scale(float s) {
        this.x *= s;
        this.y *= s;
        this.z *= s;
    }

    public float dot(Vertex3 v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public float length(Vertex3 v) {
        float _x = this.x - v.x;
        float _y = this.y - v.y;
        float _z = this.z - v.z;
        return (float)Math.sqrt(_x * _x + _y * _y + _z * _z);
    }
}

