/*
 * Decompiled with CFR 0.152.
 */
package javaforce.media;

import java.util.ArrayList;
import javaforce.BE;
import javaforce.JFLog;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;

public class AudioInput {
    private TargetDataLine tdl;
    private AudioFormat af;
    private byte[] buf8;

    public String[] listDevices() {
        ArrayList<String> mixers = new ArrayList<String>();
        Mixer.Info[] mi = AudioSystem.getMixerInfo();
        mixers.add("<default>");
        for (int a = 0; a < mi.length; ++a) {
            String name = mi[a].getName();
            Mixer m = AudioSystem.getMixer(mi[a]);
            if (m.getTargetLineInfo().length == 0) continue;
            mixers.add(name);
        }
        return mixers.toArray(new String[0]);
    }

    public boolean start(int chs, int freq, int bits, int frame_size, String device) {
        if (bits != 16) {
            return false;
        }
        this.buf8 = new byte[frame_size * 2];
        if (device == null) {
            device = "<default>";
        }
        this.af = new AudioFormat(freq, bits, chs, true, true);
        JFLog.log("AudioInput:AudioFormat=" + this.af);
        Mixer.Info[] mi = AudioSystem.getMixerInfo();
        int idx = -1;
        for (int a = 0; a < mi.length; ++a) {
            if (!mi[a].getName().equalsIgnoreCase(device)) continue;
            idx = a;
            break;
        }
        try {
            this.tdl = idx == -1 ? AudioSystem.getTargetDataLine(this.af) : AudioSystem.getTargetDataLine(this.af, mi[idx]);
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        try {
            this.tdl.open(this.af);
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        this.tdl.start();
        return true;
    }

    public boolean read(byte[] buf) {
        if (this.tdl.available() < buf.length) {
            return false;
        }
        int ret = this.tdl.read(buf, 0, buf.length);
        return ret == buf.length;
    }

    public boolean read(short[] buf16) {
        if (!this.read(this.buf8)) {
            return false;
        }
        BE.byteArray2shortArray(this.buf8, buf16);
        return true;
    }

    public void flush() {
        this.tdl.drain();
        this.tdl.flush();
    }

    public boolean stop() {
        if (this.tdl == null) {
            return false;
        }
        this.tdl.stop();
        this.tdl.close();
        this.tdl = null;
        return true;
    }
}

