/*
 * Decompiled with CFR 0.152.
 */
package javaforce.net;

import java.net.InetAddress;
import javaforce.JF;
import javaforce.JFLog;

public class IP4 {
    public short[] ip = new short[4];

    public static boolean isIP(String str) {
        String[] ips;
        if (str.equals("0:0:0:0:0:0:0:1")) {
            str = "127.0.0.1";
        }
        if ((ips = str.split("[.]")).length != 4) {
            return false;
        }
        for (int a = 0; a < 4; ++a) {
            int val = JF.atoi(ips[a]);
            if (val >= 0 && val <= 255) continue;
            return false;
        }
        return true;
    }

    public boolean setIP(String str) {
        String[] ips;
        if (str.equals("0:0:0:0:0:0:0:1")) {
            str = "127.0.0.1";
        }
        if ((ips = str.split("[.]")).length != 4) {
            JFLog.log("invalid ip:" + str);
            return false;
        }
        for (int a = 0; a < 4; ++a) {
            this.ip[a] = Short.valueOf(ips[a]);
        }
        return true;
    }

    public boolean setIP(InetAddress addr) {
        return this.setIP(addr.getHostAddress());
    }

    public InetAddress toInetAddress() {
        try {
            return InetAddress.getByName(this.toIP4String());
        }
        catch (Exception e) {
            JFLog.log("Error:IP4.toInetAddress() failed:" + this.toIP4String());
            return null;
        }
    }

    public String toIP4String() {
        return String.format("%d.%d.%d.%d", this.ip[0] & 0xFF, this.ip[1] & 0xFF, this.ip[2] & 0xFF, this.ip[3] & 0xFF);
    }

    public String toString() {
        return this.toIP4String();
    }

    public boolean isEmpty() {
        for (int a = 0; a < 4; ++a) {
            if (this.ip[a] == 0) continue;
            return false;
        }
        return true;
    }

    public boolean isMulticastAddress() {
        return this.toInetAddress().isMulticastAddress();
    }
}

