/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Iterator;
import javaforce.BE;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.KeyMgmt;
import javaforce.jbus.JBusClient;
import javaforce.jbus.JBusServer;
import javaforce.net.IP4;
import javaforce.net.IP4Port;
import javaforce.net.Subnet4;

public class SOCKS
extends Thread {
    public static final String busPack = "net.sf.jfsocks";
    public static boolean debug = false;
    private static ServerSocket ss;
    private static volatile boolean active;
    private static ArrayList<SocksWorker> socks_workers;
    private static ArrayList<ForwardLocalWorker> forward_local_workers;
    private static ArrayList<ForwardRemoteWorker> forward_remote_workers;
    private static Object lock;
    private static boolean socks4;
    private static boolean socks5;
    private static boolean socks_bind;
    private static int socks_bind_timeout;
    private static int forward_remote_timeout;
    private static IP4Port bind;
    private static IP4Port bind_cmd;
    private static boolean secure;
    private static ArrayList<String> user_pass_list;
    private static ArrayList<Subnet4> subnet_dest_list;
    private static ArrayList<Subnet4> subnet_src_list;
    private static ArrayList<ForwardLocal> forward_local_list;
    private static ArrayList<ForwardRemote> forward_remote_list;
    private static final String defaultConfig = "[global]\nport=1080\n#bind=192.168.100.2\n#bindcmd=192.168.110.2\nsecure=false\nsocks4=true\nsocks5=false\nsocks.bind=false\n#socks.bind.timeout=3600000\n#auth=user:pass\n#src.ipnet=192.168.2.0/255.255.255.0\n#src.ip=192.168.3.2\n#dest.ipnet=192.168.0.0/255.255.255.0\n#dest.ip=192.168.1.6\n#forwardlocal=192.168.100.2:80,192.168.200.2:80\n#forwardremote=[user:pass@]192.168.110.2:1080,0.0.0.0,80,192.168.200.2:80[,true]\n#forwardremote.timeout=300000\n";
    private static SOCKS socks;
    private static JBusServer busServer;
    private JBusClient busClient;
    private String config;

    public static String getConfigFile() {
        return JF.getConfigPath() + "/jfsocks.cfg";
    }

    public static String getLogFile() {
        return JF.getLogPath() + "/jfsocks.log";
    }

    public static int getBusPort() {
        if (JF.isWindows()) {
            return 33008;
        }
        return 777;
    }

    public SOCKS() {
    }

    public SOCKS(int port, boolean secure) {
        SOCKS.bind.port = port;
        SOCKS.secure = secure;
    }

    public void addUserPass(String user, String pass) {
        String user_pass = user + ":" + pass;
        user_pass_list.add(user_pass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSession(SocksWorker sess) {
        Object object = lock;
        synchronized (object) {
            socks_workers.add(sess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSession(SocksWorker sess) {
        Object object = lock;
        synchronized (object) {
            socks_workers.remove(sess);
        }
    }

    public static String getKeyFile() {
        return JF.getConfigPath() + "/jfsocks.key";
    }

    @Override
    public void run() {
        JFLog.append(JF.getLogPath() + "/jfsocks.log", true);
        JFLog.setRetention(30);
        JFLog.log("jfSocks starting...");
        try {
            this.loadConfig();
            this.busClient = new JBusClient(busPack, new JBusMethods());
            this.busClient.setPort(SOCKS.getBusPort());
            this.busClient.start();
            if (secure) {
                JFLog.log("CreateServerSocketSSL");
                Iterator<ForwardRemote> keys = new KeyMgmt();
                if (new File(SOCKS.getKeyFile()).exists()) {
                    FileInputStream fis = new FileInputStream(SOCKS.getKeyFile());
                    ((KeyMgmt)((Object)keys)).open(fis, "password".toCharArray());
                    fis.close();
                } else {
                    JFLog.log("Warning:Server SSL Keys not generated!");
                }
                ss = JF.createServerSocketSSL((KeyMgmt)((Object)keys));
            } else {
                ss = new ServerSocket();
            }
            ss.bind(bind.toInetSocketAddress());
            active = true;
            for (ForwardLocal fl : forward_local_list) {
                ForwardLocalWorker flw = new ForwardLocalWorker(fl);
                flw.start();
                forward_local_workers.add(flw);
            }
            for (ForwardRemote fr : forward_remote_list) {
                ForwardRemoteWorker frw = new ForwardRemoteWorker(fr);
                frw.start();
                forward_remote_workers.add(frw);
            }
            while (active) {
                try {
                    Socket s = ss.accept();
                    InetSocketAddress sa = (InetSocketAddress)s.getRemoteSocketAddress();
                    String src_ip = sa.getAddress().getHostAddress();
                    if (src_ip.equals("0:0:0:0:0:0:0:1")) {
                        src_ip = "127.0.0.1";
                    }
                    if (!SOCKS.ip_src_allowed(src_ip)) {
                        JFLog.log("SOCKS:Source IP blocked:" + src_ip);
                        s.close();
                        continue;
                    }
                    SocksWorker sess = new SocksWorker(s);
                    SOCKS.addSession(sess);
                    sess.start();
                }
                catch (Exception e) {
                    JFLog.log(e);
                }
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        active = false;
        try {
            ss.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Object object = lock;
        synchronized (object) {
            ForwardRemoteWorker[] remotes;
            ForwardLocalWorker[] locals;
            SocksWorker[] socks;
            for (SocksWorker s : socks = socks_workers.toArray(new SocksWorker[0])) {
                s.close();
            }
            socks_workers.clear();
            for (ForwardLocalWorker f : locals = forward_local_workers.toArray(new ForwardLocalWorker[0])) {
                f.close();
            }
            forward_local_workers.clear();
            for (ForwardRemoteWorker f : remotes = forward_remote_workers.toArray(new ForwardRemoteWorker[0])) {
                f.close();
            }
            forward_remote_workers.clear();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadConfig() {
        JFLog.log("loadConfig");
        user_pass_list = new ArrayList();
        subnet_src_list = new ArrayList();
        subnet_dest_list = new ArrayList();
        forward_local_list = new ArrayList();
        forward_remote_list = new ArrayList();
        Section section = Section.None;
        bind.setIP("0.0.0.0");
        SOCKS.bind.port = 1080;
        try {
            BufferedReader br = new BufferedReader(new FileReader(SOCKS.getConfigFile()));
            StringBuilder cfg = new StringBuilder();
            block50: while (true) {
                String ln;
                if ((ln = br.readLine()) == null) {
                    br.close();
                    this.config = cfg.toString();
                    return;
                }
                cfg.append(ln);
                cfg.append("\n");
                ln = ln.trim();
                int cmt = ln.indexOf(35);
                if (cmt != -1) {
                    ln = ln.substring(0, cmt).trim();
                }
                if (ln.length() == 0) continue;
                if (ln.equals("[global]")) {
                    section = Section.Global;
                    continue;
                }
                int idx = ln.indexOf("=");
                if (idx == -1) continue;
                String key = ln.substring(0, idx);
                String value = ln.substring(idx + 1);
                switch (section) {
                    case None: 
                    case Global: {
                        switch (key) {
                            case "port": {
                                SOCKS.bind.port = Integer.valueOf(ln.substring(5));
                                break;
                            }
                            case "bind": {
                                if (bind.setIP(value)) break;
                                JFLog.log("SOCKS:bind:Invalid IP:" + value);
                                break;
                            }
                            case "bindcmd": {
                                if (bind_cmd.setIP(value)) break;
                                JFLog.log("SOCKS:bindcmd:Invalid IP:" + value);
                                break;
                            }
                            case "secure": {
                                secure = value.equals("true");
                                break;
                            }
                            case "socks4": {
                                socks4 = value.equals("true");
                                break;
                            }
                            case "socks5": {
                                socks5 = value.equals("true");
                                break;
                            }
                            case "socks.bind": {
                                socks_bind = value.equals("true");
                                break;
                            }
                            case "socks.bind.timeout": {
                                socks_bind_timeout = Integer.valueOf(value);
                                if (socks_bind_timeout < 60000) {
                                    socks_bind_timeout = 60000;
                                }
                                if (socks_bind_timeout <= 86400000) break;
                                socks_bind_timeout = 86400000;
                                break;
                            }
                            case "forward.remote.wait": 
                            case "forwardremote.timeout": {
                                forward_remote_timeout = Integer.valueOf(value);
                                if (forward_remote_timeout < 60000) {
                                    forward_remote_timeout = 60000;
                                }
                                if (forward_remote_timeout <= 86400000) break;
                                forward_remote_timeout = 86400000;
                                break;
                            }
                            case "auth": {
                                user_pass_list.add(value);
                                break;
                            }
                            case "ipnet": 
                            case "dest.ipnet": {
                                Subnet4 subnet = new Subnet4();
                                idx = value.indexOf(47);
                                if (idx == -1) {
                                    JFLog.log("SOCKS:Invalid IP Subnet:" + value);
                                    break;
                                }
                                String ip = value.substring(0, idx);
                                String mask = value.substring(idx + 1);
                                if (!subnet.setIP(ip)) {
                                    JFLog.log("SOCKS:Invalid IP:" + ip);
                                    break;
                                }
                                if (!subnet.setMask(mask)) {
                                    JFLog.log("SOCKS:Invalid netmask:" + mask);
                                    break;
                                }
                                JFLog.log("Dest Allow IP Network=" + subnet.toString());
                                subnet_dest_list.add(subnet);
                                break;
                            }
                            case "ip": 
                            case "dest.ip": {
                                Subnet4 subnet = new Subnet4();
                                if (!subnet.setIP(value)) {
                                    JFLog.log("SOCKS:Invalid IP:" + value);
                                    break;
                                }
                                subnet.setMask("255.255.255.255");
                                JFLog.log("Dest Allow IP Address=" + subnet.toString());
                                subnet_dest_list.add(subnet);
                                break;
                            }
                            case "src.ipnet": {
                                Subnet4 subnet = new Subnet4();
                                idx = value.indexOf(47);
                                if (idx == -1) {
                                    JFLog.log("SOCKS:Invalid IP Subnet:" + value);
                                    break;
                                }
                                String ip = value.substring(0, idx);
                                String mask = value.substring(idx + 1);
                                if (!subnet.setIP(ip)) {
                                    JFLog.log("SOCKS:Invalid IP:" + ip);
                                    break;
                                }
                                if (!subnet.setMask(mask)) {
                                    JFLog.log("SOCKS:Invalid netmask:" + mask);
                                    break;
                                }
                                JFLog.log("Source Allow IP Network=" + subnet.toString());
                                subnet_src_list.add(subnet);
                                break;
                            }
                            case "src.ip": {
                                Subnet4 subnet = new Subnet4();
                                if (!subnet.setIP(value)) {
                                    JFLog.log("SOCKS:Invalid IP:" + value);
                                    break;
                                }
                                subnet.setMask("255.255.255.255");
                                JFLog.log("Source Allow IP Address=" + subnet.toString());
                                subnet_src_list.add(subnet);
                                break;
                            }
                            case "forward": 
                            case "forwardlocal": {
                                String[] p = value.split(",");
                                if (p.length != 2) {
                                    JFLog.log(key + ":Invalid option:" + value);
                                    break;
                                }
                                Object forward = new ForwardLocal();
                                if (!((ForwardLocal)forward).set_from(p[0])) {
                                    JFLog.log(key + ":Invalid from:" + p[0]);
                                    break;
                                }
                                if (!((ForwardLocal)forward).set_to(p[1])) {
                                    JFLog.log(key + ":Invalid to:" + p[1]);
                                    break;
                                }
                                forward_local_list.add((ForwardLocal)forward);
                                break;
                            }
                            case "forwardremote": {
                                String[] p = value.split(",");
                                if (p.length < 4) {
                                    JFLog.log("bindforward:Invalid option:" + value);
                                    break;
                                }
                                Object forward = new ForwardRemote();
                                String bind = p[0];
                                int atidx = bind.indexOf(64);
                                if (atidx != -1) {
                                    String user_pass = bind.substring(0, atidx);
                                    bind = bind.substring(atidx + 1);
                                    int colonidx = user_pass.indexOf(58);
                                    if (colonidx != -1) {
                                        ((ForwardRemote)forward).user = user_pass.substring(0, colonidx);
                                        ((ForwardRemote)forward).pass = user_pass.substring(colonidx + 1);
                                    }
                                }
                                if (!((ForwardRemote)forward).set_socks(bind)) {
                                    JFLog.log("bindforward:Invalid bind address:" + p[0]);
                                    break;
                                }
                                ((ForwardRemote)forward).set_from(p[1]);
                                ((ForwardRemote)forward).set_port(Integer.valueOf(p[2]));
                                if (!((ForwardRemote)forward).set_to(p[3])) {
                                    JFLog.log("bindforward:Invalid to:" + p[3]);
                                    break;
                                }
                                if (p.length > 4) {
                                    ((ForwardRemote)forward).secure = p[4].equals("true");
                                }
                                forward_remote_list.add((ForwardRemote)forward);
                                break;
                            }
                            case "debug": {
                                debug = value.equals("true");
                            }
                        }
                        continue block50;
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            JFLog.log("config not found, creating defaults.");
            try {
                FileOutputStream fos = new FileOutputStream(SOCKS.getConfigFile());
                fos.write(defaultConfig.getBytes());
                fos.close();
                this.config = defaultConfig;
                return;
            }
            catch (Exception e2) {
                JFLog.log(e2);
                return;
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    private static boolean ip_src_allowed(String ip4) {
        if (subnet_src_list.size() == 0) {
            return true;
        }
        IP4 target = new IP4();
        if (!target.setIP(ip4)) {
            return false;
        }
        for (Subnet4 net : subnet_src_list) {
            if (!net.matches(target)) continue;
            return true;
        }
        return false;
    }

    private static boolean ip_dest_allowed(String ip4) {
        if (subnet_dest_list.size() == 0) {
            return true;
        }
        IP4 target = new IP4();
        if (!target.setIP(ip4)) {
            return false;
        }
        for (Subnet4 net : subnet_dest_list) {
            if (!net.matches(target)) continue;
            return true;
        }
        return false;
    }

    public static void serviceStart(String[] args) {
        if (JF.isWindows()) {
            busServer = new JBusServer(SOCKS.getBusPort());
            busServer.start();
            while (true) {
                if (JBusServer.ready) break;
                JF.sleep(10);
            }
        }
        socks = new SOCKS();
        socks.start();
    }

    public static void serviceStop() {
        socks.close();
    }

    public static void main(String[] args) {
        SOCKS.serviceStart(args);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                SOCKS.serviceStop();
            }
        });
    }

    static {
        socks_workers = new ArrayList();
        forward_local_workers = new ArrayList();
        forward_remote_workers = new ArrayList();
        lock = new Object();
        socks4 = true;
        socks5 = false;
        socks_bind = false;
        socks_bind_timeout = 3600000;
        forward_remote_timeout = 300000;
        bind = new IP4Port();
        bind_cmd = new IP4Port();
        secure = false;
    }

    public static class JBusMethods {
        public void getConfig(String pack) {
            JBusClient cfr_ignored_0 = SOCKS.socks.busClient;
            JBusClient cfr_ignored_1 = SOCKS.socks.busClient;
            SOCKS.socks.busClient.call(pack, "getConfig", JBusClient.quote(JBusClient.encodeString(SOCKS.socks.config)));
        }

        public void setConfig(String cfg) {
            JFLog.log("setConfig");
            try {
                FileOutputStream fos = new FileOutputStream(SOCKS.getConfigFile());
                fos.write(JBusClient.decodeString(cfg).getBytes());
                fos.close();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        public void restart() {
            JFLog.log("restart");
            socks.close();
            socks = new SOCKS();
            socks.start();
        }

        public void genKeys(String pack) {
            if (KeyMgmt.keytool(new String[]{"-genkey", "-debug", "-alias", "jfsocks", "-keypass", "password", "-storepass", "password", "-keystore", SOCKS.getKeyFile(), "-validity", "3650", "-dname", "CN=jfsocks.sourceforge.net, OU=user, O=server, C=CA", "-keyalg", "RSA", "-keysize", "2048"})) {
                JFLog.log("Generated Keys");
                JBusClient cfr_ignored_0 = SOCKS.socks.busClient;
                SOCKS.socks.busClient.call(pack, "getKeys", JBusClient.quote("OK"));
            } else {
                JBusClient cfr_ignored_1 = SOCKS.socks.busClient;
                SOCKS.socks.busClient.call(pack, "getKeys", JBusClient.quote("ERROR"));
            }
        }
    }

    private static class ForwardLocal {
        public IP4Port from = new IP4Port();
        public IP4Port to = new IP4Port();

        private ForwardLocal() {
        }

        public boolean set_from(String ip_port) {
            int idx = ip_port.indexOf(58);
            if (idx == -1) {
                return false;
            }
            String ip = ip_port.substring(0, idx);
            String port = ip_port.substring(idx + 1);
            if (!this.from.setIP(ip)) {
                return false;
            }
            return this.from.setPort(port);
        }

        public boolean set_to(String ip_port) {
            int idx = ip_port.indexOf(58);
            if (idx == -1) {
                return false;
            }
            String ip = ip_port.substring(0, idx);
            String port = ip_port.substring(idx + 1);
            if (!this.to.setIP(ip)) {
                return false;
            }
            return this.to.setPort(port);
        }

        public String toString() {
            return this.from.toString() + " -> " + this.to.toString();
        }
    }

    public class ForwardLocalWorker
    extends Thread {
        private ForwardLocal forward;
        private ServerSocket ss;

        public ForwardLocalWorker(ForwardLocal forward) {
            this.forward = forward;
        }

        @Override
        public void run() {
            try {
                this.ss = new ServerSocket();
                this.ss.bind(this.forward.from.toInetSocketAddress());
                while (active) {
                    Socket from = this.ss.accept();
                    try {
                        Socket to = new Socket(this.forward.to.toInetAddress(), this.forward.to.port);
                        ProxyData pd1 = new ProxyData(from, to, "f-1");
                        pd1.start();
                        ProxyData pd2 = new ProxyData(to, from, "f-2");
                        pd2.start();
                    }
                    catch (Exception e) {
                        if (e instanceof SocketException) continue;
                        JFLog.log(e);
                    }
                }
            }
            catch (Exception e) {
                if (!(e instanceof SocketException)) {
                    JFLog.log(e);
                }
                JF.sleep(1000);
            }
        }

        public void close() {
            try {
                this.ss.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class ForwardRemote {
        public String user;
        public String pass;
        public IP4Port socks = new IP4Port();
        public IP4 from = new IP4();
        public int port;
        public IP4Port to = new IP4Port();
        public boolean secure;

        private ForwardRemote() {
        }

        public boolean set_socks(String ip_port) {
            int idx = ip_port.indexOf(58);
            if (idx == -1) {
                return false;
            }
            String ip = ip_port.substring(0, idx);
            String port = ip_port.substring(idx + 1);
            if (!this.socks.setIP(ip)) {
                return false;
            }
            return this.socks.setPort(port);
        }

        public boolean set_from(String host) {
            return this.from.setIP(host);
        }

        public void set_port(int port) {
            this.port = port;
        }

        public boolean set_to(String ip_port) {
            int idx = ip_port.indexOf(58);
            if (idx == -1) {
                return false;
            }
            String ip = ip_port.substring(0, idx);
            String port = ip_port.substring(idx + 1);
            if (!this.to.setIP(ip)) {
                return false;
            }
            return this.to.setPort(port);
        }

        public String toString() {
            return this.socks.toString() + " bind port " + this.port + " -> " + this.to.toString();
        }
    }

    public class ForwardRemoteWorker
    extends Thread {
        private ForwardRemote forward;

        public ForwardRemoteWorker(ForwardRemote forward) {
            this.forward = forward;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            block12: {
lbl1:
                // 3 sources

                try {
                    while (SOCKS.active) {
                        block13: {
                            wait = true;
                            try {
                                from = null;
                                from = this.forward.secure != false ? JF.connectSSL(this.forward.socks.toIP4String(), this.forward.socks.port) : new Socket(this.forward.socks.toInetAddress(), this.forward.socks.port);
                                if (this.forward.user != null && this.forward.pass != null) {
                                    if (!javaforce.SOCKS.bind(from, this.forward.from.toString(), this.forward.port, this.forward.user, this.forward.pass)) {
                                        throw new Exception("SOCKS5:bind:failed");
                                    }
                                } else if (!javaforce.SOCKS.bind(from, this.forward.from.toString(), this.forward.port)) {
                                    throw new Exception("SOCKS4:bind:failed");
                                }
                                to = new Socket(this.forward.to.toInetAddress(), this.forward.to.port);
                                pd1 = new ProxyData(from, to, "f-1");
                                pd1.start();
                                pd2 = new ProxyData(to, from, "f-2");
                                pd2.start();
                                wait = false;
                            }
                            catch (Exception e) {
                                if (!(e instanceof SocketException)) {
                                    JFLog.log(e);
                                }
                                JF.sleep(1000);
                            }
                            if (!wait) break block13;
                            for (wait_time = 0; SOCKS.active && wait_time < SOCKS.forward_remote_timeout; wait_time += 1000) {
                                JF.sleep(1000);
                            }
                            ** GOTO lbl1
                        }
                        for (wait_time = 0; SOCKS.active && wait_time < 5000; wait_time += 1000) {
                            JF.sleep(1000);
                        }
                        ** GOTO lbl1
                    }
                }
                catch (Exception e) {
                    if (e instanceof SocketException) break block12;
                    JFLog.log(e);
                }
            }
        }

        public void close() {
            try {
                ss.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class SocksWorker
    extends Thread {
        private Socket c;
        private Socket o;
        private ProxyData pd1;
        private ProxyData pd2;
        private boolean connected = false;
        private InputStream cis = null;
        private OutputStream cos = null;
        private byte[] req = new byte[1500];
        private int reqSize = 0;

        public SocksWorker(Socket s) {
            this.c = s;
        }

        public void close() {
            if (this.c != null) {
                try {
                    this.c.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.o != null) {
                try {
                    this.o.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.pd1 != null) {
                this.pd1.close();
            }
            if (this.pd2 != null) {
                this.pd2.close();
            }
        }

        @Override
        public void run() {
            block19: {
                try {
                    int read;
                    JFLog.log("Session start");
                    this.cis = this.c.getInputStream();
                    this.cos = this.c.getOutputStream();
                    while (this.c.isConnected() && (read = this.cis.read(this.req, this.reqSize, 1500 - this.reqSize)) >= 0) {
                        this.reqSize += read;
                        if (this.reqSize == 0) continue;
                        if (this.req[0] == 4) {
                            int a;
                            int null_count;
                            if (this.reqSize < 8) continue;
                            String ip3 = String.format("%d.%d.%d", this.req[4] & 0xFF, this.req[5] & 0xFF, this.req[6] & 0xFF);
                            if (ip3.equals("0.0.0")) {
                                null_count = 0;
                                for (a = 8; a < this.reqSize; ++a) {
                                    if (this.req[a] != 0) continue;
                                    ++null_count;
                                }
                                if (null_count == 2) break;
                                if (null_count <= 2) continue;
                                throw new Exception("SOCKS4:bad request:too many nulls:expect=2");
                            }
                            null_count = 0;
                            for (a = 8; a < this.reqSize; ++a) {
                                if (this.req[a] != 0) continue;
                                ++null_count;
                            }
                            if (null_count == 1) break;
                            if (null_count <= 1) continue;
                            throw new Exception("SOCKS4:bad request:too many nulls:expect=1");
                        }
                        if (this.req[0] == 5) {
                            int nauth;
                            if (this.reqSize < 3 || this.reqSize != (nauth = this.req[1] & 0xFF) + 2) continue;
                            break;
                        }
                        throw new Exception("bad request:not SOCKS4/5 request");
                    }
                    switch (this.req[0]) {
                        case 4: {
                            this.socks4();
                            break;
                        }
                        case 5: {
                            this.socks5();
                            break;
                        }
                        default: {
                            throw new Exception("bad request:not SOCKS4/5 request");
                        }
                    }
                }
                catch (Exception e) {
                    if (!(e instanceof SocketException)) {
                        JFLog.log(e);
                    }
                    if (this.connected) break block19;
                    byte[] reply = null;
                    switch (this.req[0]) {
                        case 4: {
                            reply = new byte[8];
                            break;
                        }
                        case 5: {
                            reply = new byte[10];
                            reply[3] = 1;
                        }
                    }
                    reply[0] = this.req[0];
                    reply[1] = 91;
                    try {
                        this.cos.write(reply);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            this.close();
            SOCKS.removeSession(this);
        }

        private void socks4() throws Exception {
            if (!socks4) {
                throw new Exception("SOCKS4:not enabled");
            }
            JFLog.log("socks4 connection started");
            switch (this.req[1]) {
                case 1: {
                    this.socks4_connect();
                    return;
                }
                case 2: {
                    this.socks4_bind();
                    return;
                }
            }
            throw new Exception("SOCKS4:bad request");
        }

        private void socks4_connect() throws Exception {
            String dest;
            int port = BE.getuint16(this.req, 2);
            String ip3 = String.format("%d.%d.%d", this.req[4] & 0xFF, this.req[5] & 0xFF, this.req[6] & 0xFF);
            if (ip3.equals("0.0.0")) {
                int user_null = -1;
                int domain_null = -1;
                for (int a = 8; a < this.reqSize; ++a) {
                    if (this.req[a] != 0) continue;
                    if (user_null == -1) {
                        user_null = a;
                        continue;
                    }
                    domain_null = a;
                }
                String user_id = new String(this.req, 8, user_null - 8);
                dest = new String(this.req, 8, domain_null - 8);
                dest = InetAddress.getByName(dest).getHostAddress();
            } else {
                dest = String.format("%d.%d.%d.%d", this.req[4] & 0xFF, this.req[5] & 0xFF, this.req[6] & 0xFF, this.req[7] & 0xFF);
            }
            if (!SOCKS.ip_dest_allowed(dest)) {
                throw new Exception("SOCKS:Target IP outside of allowed IP Subnets:" + dest);
            }
            this.o = new Socket(dest, port);
            this.connected = true;
            byte[] reply = new byte[8];
            reply[0] = 0;
            reply[1] = 90;
            this.cos.write(reply);
            this.pd1 = new ProxyData(this.c, this.o, "s4-1");
            this.pd1.start();
            this.pd2 = new ProxyData(this.o, this.c, "s4-2");
            this.pd2.start();
            this.pd1.join();
            this.pd2.join();
            JFLog.log("SOCKS4:connect() Session end");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void socks4_bind() throws Exception {
            if (!socks_bind) {
                throw new Exception("SOCKS.bind disabled!");
            }
            int port = BE.getuint16(this.req, 2);
            String src = String.format("%d.%d.%d.%d", this.req[4] & 0xFF, this.req[5] & 0xFF, this.req[6] & 0xFF, this.req[7] & 0xFF);
            byte[] reply = new byte[8];
            reply[0] = 0;
            reply[1] = 90;
            this.cos.write(reply);
            ServerSocket ss = null;
            try {
                if (bind_cmd.isEmpty()) {
                    ss = new ServerSocket(port);
                } else {
                    IP4Port iP4Port = bind_cmd;
                    synchronized (iP4Port) {
                        ss = new ServerSocket();
                        SOCKS.bind_cmd.port = port;
                        ss.bind(bind_cmd.toInetSocketAddress());
                    }
                }
                ss.setSoTimeout(socks_bind_timeout);
                this.o = ss.accept();
                String src_addr = this.o.getInetAddress().getHostAddress();
                if (src_addr.equals("0:0:0:0:0:0:0:1")) {
                    src_addr = "127.0.0.1";
                }
                int src_port = this.o.getPort();
                if (!src.equals("0.0.0.0") && !src.equals(src_addr)) {
                    throw new Exception("SOCKS4:bind:unexpected host connected:" + src_addr);
                }
                this.connected = true;
                reply[0] = 0;
                reply[1] = 90;
                IP4 src_ip = new IP4();
                src_ip.setIP(src_addr);
                reply[2] = (byte)(src_port & 0xFF);
                reply[3] = (byte)(src_port & 0xFF);
                for (int a = 0; a < 4; ++a) {
                    reply[4 + a] = (byte)src_ip.ip[0 + a];
                }
                this.cos.write(reply);
                this.pd1 = new ProxyData(this.c, this.o, "s4-1");
                this.pd1.start();
                this.pd2 = new ProxyData(this.o, this.c, "s4-2");
                this.pd2.start();
                this.pd1.join();
                this.pd2.join();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            JFLog.log("SOCKS4:bind() Session end");
        }

        private void socks5() throws Exception {
            int read;
            int pass_len;
            String pass;
            int user_len;
            String user;
            String user_pass;
            int read2;
            JFLog.log("socks5 connection started");
            if (!socks5) {
                throw new Exception("SOCKS5:not enabled");
            }
            int nauth = this.req[1] & 0xFF;
            boolean auth_type_2 = false;
            for (int a = 0; a < nauth; ++a) {
                if (this.req[a + 2] != 2) continue;
                auth_type_2 = true;
                break;
            }
            if (!auth_type_2) {
                throw new Exception("SOCKS5:auth not supported");
            }
            byte[] reply = new byte[]{5, 2};
            this.cos.write(reply);
            this.reqSize = 0;
            while (this.c.isConnected() && (read2 = this.cis.read(this.req, this.reqSize, 1500 - this.reqSize)) >= 0) {
                int pass_len2;
                this.reqSize += read2;
                if (this.reqSize < 5) continue;
                if (this.req[0] != 1) {
                    throw new Exception("SOCKS5:invalid auth request");
                }
                int user_len2 = this.req[1] & 0xFF;
                if (this.reqSize < 3 + user_len2 || this.reqSize < 3 + user_len2 + (pass_len2 = this.req[2 + user_len2] & 0xFF)) continue;
            }
            if (!user_pass_list.contains(user_pass = (user = new String(this.req, 2, user_len = this.req[1] & 0xFF)) + ":" + (pass = new String(this.req, 3 + user_len, pass_len = this.req[2 + user_len] & 0xFF)))) {
                throw new Exception("SOCKS5:user/pass not authorized");
            }
            reply = new byte[]{1, 0};
            this.cos.write(reply);
            this.reqSize = 0;
            int toRead = 10;
            while (this.c.isConnected() && (read = this.cis.read(this.req, this.reqSize, toRead - this.reqSize)) >= 0) {
                this.reqSize += read;
                if (this.reqSize < 10) continue;
                int dest_type = this.req[3] & 0xFF;
                if (dest_type == 1) {
                    if (this.reqSize != toRead) continue;
                    break;
                }
                if (dest_type == 3) {
                    int domain_len = this.req[4] & 0xFF;
                    toRead = 5 + domain_len + 2;
                    if (this.reqSize != toRead) continue;
                    break;
                }
                if (dest_type == 4) {
                    throw new Exception("SOCKS5:IP6 not supported");
                }
                throw new Exception("SOCKS5:dest_type not supported:" + dest_type);
            }
            if (this.req[0] != 5) {
                throw new Exception("SOCKS5:bad connection request:version != 0x05");
            }
            switch (this.req[1]) {
                case 1: {
                    this.socks5_connect();
                    return;
                }
                case 2: {
                    this.socks5_bind();
                    return;
                }
            }
            throw new Exception("SOCKS5:cmd not supported:" + this.req[1]);
        }

        private void socks5_connect() throws Exception {
            String dest = null;
            int port = BE.getuint16(this.req, this.reqSize - 2);
            switch (this.req[3]) {
                case 1: {
                    dest = String.format("%d.%d.%d.%d", this.req[4] & 0xFF, this.req[5] & 0xFF, this.req[6] & 0xFF, this.req[7] & 0xFF);
                    break;
                }
                case 3: {
                    dest = new String(this.req, 5, this.req[4] & 0xFF);
                    dest = InetAddress.getByName(dest).getHostAddress();
                    break;
                }
                default: {
                    throw new Exception("SOCKS5:bad connection request:addr type not supported:" + this.req[3]);
                }
            }
            if (!SOCKS.ip_dest_allowed(dest)) {
                throw new Exception("SOCKS:Target IP outside of allowed IP Subnets:" + dest);
            }
            byte[] reply = new byte[this.reqSize];
            System.arraycopy(this.req, 0, reply, 0, this.reqSize);
            reply[1] = 0;
            this.cos.write(reply);
            JFLog.log("SOCKS5:Connect:" + dest + ":" + port);
            this.o = new Socket(dest, port);
            this.connected = true;
            this.pd1 = new ProxyData(this.c, this.o, "s5-1");
            this.pd1.start();
            this.pd2 = new ProxyData(this.o, this.c, "s5-2");
            this.pd2.start();
            this.pd1.join();
            this.pd2.join();
            JFLog.log("SOCKS5:connect() Session end");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void socks5_bind() throws Exception {
            if (!socks_bind) {
                throw new Exception("SOCKS.bind disabled!");
            }
            String src = null;
            int port = BE.getuint16(this.req, this.reqSize - 2);
            switch (this.req[3]) {
                case 1: {
                    src = String.format("%d.%d.%d.%d", this.req[4] & 0xFF, this.req[5] & 0xFF, this.req[6] & 0xFF, this.req[7] & 0xFF);
                    break;
                }
                case 3: {
                    src = new String(this.req, 5, this.req[4] & 0xFF);
                    src = InetAddress.getByName(src).getHostAddress();
                    break;
                }
                default: {
                    throw new Exception("SOCKS5:bad connection request:addr type not supported:" + this.req[3]);
                }
            }
            byte[] reply = new byte[this.reqSize];
            System.arraycopy(this.req, 0, reply, 0, this.reqSize);
            reply[1] = 0;
            this.cos.write(reply);
            ServerSocket ss = null;
            try {
                if (bind_cmd.isEmpty()) {
                    ss = new ServerSocket(port);
                } else {
                    IP4Port iP4Port = bind_cmd;
                    synchronized (iP4Port) {
                        ss = new ServerSocket();
                        SOCKS.bind_cmd.port = port;
                        ss.bind(bind_cmd.toInetSocketAddress());
                    }
                }
                ss.setSoTimeout(socks_bind_timeout);
                this.o = ss.accept();
                String src_addr = this.o.getInetAddress().getHostAddress();
                if (src_addr.equals("0:0:0:0:0:0:0:1")) {
                    src_addr = "127.0.0.1";
                }
                int src_port = this.o.getPort();
                if (!src.equals("0.0.0.0") && !src.equals(src_addr)) {
                    throw new Exception("SOCKS5:bind:unexpected host connected:" + src_addr);
                }
                reply = new byte[10];
                reply[0] = 5;
                reply[1] = 0;
                reply[2] = 0;
                reply[3] = 1;
                IP4 src_ip = new IP4();
                src_ip.setIP(src_addr);
                for (int a = 0; a < 4; ++a) {
                    reply[4 + a] = (byte)src_ip.ip[0 + a];
                }
                reply[8] = (byte)(src_port & 0xFF);
                reply[9] = (byte)(src_port & 0xFF);
                this.cos.write(reply);
                this.connected = true;
                this.pd1 = new ProxyData(this.c, this.o, "s5-1");
                this.pd1.start();
                this.pd2 = new ProxyData(this.o, this.c, "s5-2");
                this.pd2.start();
                this.pd1.join();
                this.pd2.join();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            JFLog.log("SOCKS5:bind() Session end");
        }
    }

    static enum Section {
        None,
        Global;

    }

    public static class ProxyData
    extends Thread {
        private Socket sRead;
        private Socket sWrite;
        private volatile boolean active;
        private String name;

        public ProxyData(Socket sRead, Socket sWrite, String name) {
            this.sRead = sRead;
            this.sWrite = sWrite;
            this.name = name;
        }

        @Override
        public void run() {
            block7: {
                try {
                    int read;
                    InputStream is = this.sRead.getInputStream();
                    OutputStream os = this.sWrite.getOutputStream();
                    byte[] buf = new byte[1500];
                    this.active = true;
                    while (this.active && (read = is.read(buf)) >= 0) {
                        if (read <= 0) continue;
                        os.write(buf, 0, read);
                    }
                }
                catch (Exception e) {
                    if (e instanceof SocketException) break block7;
                    JFLog.log(e);
                }
            }
            try {
                this.sRead.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.sWrite.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void close() {
            this.active = false;
        }
    }
}

