/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Random;
import javaforce.awt.JFAWT;
import javaforce.awt.JFImage;
import javaforce.awt.ViewLog;
import javaforce.jbus.JBusClient;
import javaforce.service.SOCKS;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public class SOCKSApp
extends JFrame {
    private JTextArea config;
    private JButton gen_keys;
    private JButton help;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JButton save;
    private JButton viewLog;
    public ViewLog viewer;
    public JBusClient busClient;

    public SOCKSApp() {
        this.initComponents();
        JFImage img = new JFImage();
        img.loadPNG(this.getClass().getResourceAsStream("/javaforce/icons/socks.png"));
        this.setIconImage(img.getImage());
        new Thread(){

            @Override
            public void run() {
                Random r = new Random();
                SOCKSApp.this.busClient = new JBusClient("net.sf.jfsocks.client" + r.nextInt(), new JBusMethods());
                SOCKSApp.this.busClient.setPort(SOCKS.getBusPort());
                SOCKSApp.this.busClient.start();
                SOCKSApp.this.busClient.call("net.sf.jfsocks", "getConfig", "\"" + SOCKSApp.this.busClient.pack + "\"");
            }
        }.start();
        JFAWT.centerWindow(this);
    }

    public void writeConfig() {
        this.busClient.call("net.sf.jfsocks", "setConfig", JBusClient.quote(JBusClient.encodeString(this.config.getText())));
    }

    public void restart() {
        this.busClient.call("net.sf.jfsocks", "restart", "");
    }

    private void initComponents() {
        this.save = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.config = new JTextArea();
        this.jLabel1 = new JLabel();
        this.viewLog = new JButton();
        this.gen_keys = new JButton();
        this.help = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle("SOCKS Server");
        this.save.setText("Save");
        this.save.setEnabled(false);
        this.save.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SOCKSApp.this.saveActionPerformed(evt);
            }
        });
        this.config.setColumns(20);
        this.config.setRows(5);
        this.config.setText(" [ loading ... ]\n");
        this.config.setEnabled(false);
        this.jScrollPane1.setViewportView(this.config);
        this.jLabel1.setText("SOCKS Configuration:");
        this.viewLog.setText("View Log");
        this.viewLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SOCKSApp.this.viewLogActionPerformed(evt);
            }
        });
        this.gen_keys.setText("Generate SSL Key");
        this.gen_keys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SOCKSApp.this.gen_keysActionPerformed(evt);
            }
        });
        this.help.setText("Help");
        this.help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SOCKSApp.this.helpActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 583, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.viewLog).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.gen_keys).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.help).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.save)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 424, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.save).addComponent(this.viewLog).addComponent(this.gen_keys).addComponent(this.help)).addContainerGap()));
        this.pack();
    }

    private void saveActionPerformed(ActionEvent evt) {
        this.writeConfig();
        this.restart();
        JFAWT.showMessage("Notice", "Settings saved!");
    }

    private void viewLogActionPerformed(ActionEvent evt) {
        this.showViewLog();
    }

    private void gen_keysActionPerformed(ActionEvent evt) {
        this.genKeys();
    }

    private void helpActionPerformed(ActionEvent evt) {
        this.showHelp();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new SOCKSApp().setVisible(true);
            }
        });
    }

    public void showViewLog() {
        if (this.viewer == null || this.viewer.isClosed) {
            this.viewer = new ViewLog(SOCKS.getLogFile());
            this.viewer.setTitle("SOCKS Log");
        }
        this.viewer.setVisible(true);
        this.viewer.setExtendedState(0);
    }

    private void genKeys() {
        this.busClient.call("net.sf.jfsocks", "genKeys", "\"" + this.busClient.pack + "\"");
    }

    private void showHelp() {
        JFAWT.openURL("http://jfsocks.sf.net/help.html");
    }

    public class JBusMethods {
        public void getConfig(final String cfg) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SOCKSApp.this.config.setText(JBusClient.decodeString(cfg));
                    SOCKSApp.this.config.setEnabled(true);
                    SOCKSApp.this.save.setEnabled(true);
                }
            });
        }

        public void getKeys(final String status) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (status.equals("OK")) {
                        JFAWT.showMessage("GenKeys", "OK");
                    } else {
                        JFAWT.showError("GenKeys", "Error");
                    }
                }
            });
        }
    }
}

