/*
 * Decompiled with CFR 0.152.
 */
package javaforce.ui;

import javaforce.JFLog;
import javaforce.ui.Color;
import javaforce.ui.Container;
import javaforce.ui.Dimension;
import javaforce.ui.Image;
import javaforce.ui.KeyEvents;
import javaforce.ui.LayoutMetrics;
import javaforce.ui.MouseEvents;
import javaforce.ui.Point;
import javaforce.ui.theme.Theme;

public class Component
implements KeyEvents,
MouseEvents {
    protected Color foreClr;
    protected Color backClr;
    protected Color disabledClr;
    protected Color selectedClr;
    protected Point pos = new Point();
    protected Dimension size = new Dimension();
    protected Component parent;
    protected int layer = 0;
    protected int borderStyle = 0;
    protected boolean enabled = true;
    protected boolean editable = true;
    protected boolean focused = false;
    protected boolean focusable = false;
    protected boolean visible = true;
    protected boolean consumer = true;
    public static final Dimension zero = new Dimension();
    public static final boolean debug = true;
    private Point mousePos = new Point();
    private static boolean[] keyState = new boolean[512];

    public Component() {
        Theme theme = Theme.getTheme();
        this.setForeColor(theme.getForeColor());
        this.setBackColor(theme.getBackColor());
        this.setDisabledColor(theme.getDisabledColor());
        this.setSelectedColor(theme.getSelectedColor());
    }

    public static Component load(String fn) {
        return null;
    }

    public void save(String fn) {
    }

    public boolean isContainer() {
        return false;
    }

    protected boolean isConsumer() {
        return this.consumer;
    }

    protected void setParent(Component parent) {
        this.parent = parent;
    }

    protected void setConsumer(boolean consumes) {
        this.consumer = consumes;
    }

    public Point getPosition() {
        return this.pos;
    }

    public int getX() {
        return this.pos.x;
    }

    public int getY() {
        return this.pos.y;
    }

    public void setPosition(Point pt) {
        this.setPosition(pt.x, pt.y);
    }

    public void setPosition(int x, int y) {
        this.pos.x = x;
        this.pos.y = y;
    }

    public Dimension getSize() {
        return this.size;
    }

    public int getWidth() {
        return this.size.width;
    }

    public int getHeight() {
        return this.size.height;
    }

    public void setSize(Dimension dim) {
        this.setSize(dim.width, dim.height);
    }

    public void setSize(int width, int height) {
        this.size.width = width;
        this.size.height = height;
    }

    public Dimension getMinSize() {
        return this.size;
    }

    public int getMinWidth() {
        return this.getMinSize().width;
    }

    public int getMinHeight() {
        return this.getMinSize().height;
    }

    public int getLayer() {
        return this.layer;
    }

    public void setLayer(int layer) {
        this.layer = layer;
    }

    public boolean isInside(Point pt) {
        int x1 = this.pos.x;
        int y1 = this.pos.y;
        int x2 = x1 + this.size.width - 1;
        int y2 = y1 + this.size.height - 1;
        return pt.x >= x1 && pt.x <= x2 && pt.y >= y1 && pt.y <= y2;
    }

    public void render(Image image) {
        if (!this.isVisible()) {
            return;
        }
        image.fill(this.pos.x, this.pos.y, this.size.width, this.size.height, this.getBackColor().getColor());
        if (this.borderStyle != 0) {
            image.setLineStyle(this.borderStyle);
            image.setForeColor(this.foreClr);
            image.drawBox(this.pos.x, this.pos.y, this.size.width, this.size.height);
            image.setLineStyle(1);
        }
    }

    public void renderLayer(int layer, Image image) {
        if (this.getLayer() == layer) {
            this.render(image);
        }
    }

    public void layout(LayoutMetrics metrics) {
        this.setPosition(metrics.pos);
        this.setSize(metrics.size);
    }

    public void setFocusable(boolean state) {
        if (this.focusable == state) {
            return;
        }
        this.focusable = state;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean state) {
        this.visible = state;
    }

    public Container getTopContainer() {
        Component top = this.parent;
        while (top.parent != null) {
            if (top.parent == top) {
                JFLog.logTrace("UI Loop detected");
            }
            top = top.parent;
        }
        return (Container)top;
    }

    public void onFocus() {
        this.focused = true;
    }

    public void onBlur() {
        this.focused = false;
    }

    public void setFocus() {
        this.getTopContainer().setFocus(this);
    }

    public boolean isFocused() {
        return this.focused;
    }

    public boolean isFocusable() {
        return this.focusable;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean state) {
        this.enabled = state;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean state) {
        this.editable = state;
    }

    public Color getForeColor() {
        return this.foreClr;
    }

    public Color getBackColor() {
        return this.backClr;
    }

    public Color getDisabledColor() {
        return this.disabledClr;
    }

    public Color getSelectedColor() {
        return this.selectedClr;
    }

    public void setForeColor(Color clr) {
        this.foreClr = clr;
    }

    public void setBackColor(Color clr) {
        this.backClr = clr;
    }

    public void setDisabledColor(Color clr) {
        this.disabledClr = clr;
    }

    public void setSelectedColor(Color clr) {
        this.selectedClr = clr;
    }

    public int getBorderStyle() {
        return this.borderStyle;
    }

    public void setBorderStyle(int lineStyle) {
        this.borderStyle = lineStyle;
    }

    public int getMouseX() {
        return this.mousePos.x;
    }

    public int getMouseY() {
        return this.mousePos.y;
    }

    public Point getMousePosition() {
        return this.mousePos;
    }

    public boolean getKeyState(int vk) {
        if (vk < 0 || vk >= keyState.length) {
            return false;
        }
        return keyState[vk];
    }

    @Override
    public void keyTyped(char ch) {
    }

    @Override
    public void keyPressed(int key) {
        if (key >= 0 && key < keyState.length) {
            Component.keyState[key] = true;
        }
    }

    @Override
    public void keyReleased(int key) {
        if (key >= 0 && key < keyState.length) {
            Component.keyState[key] = false;
        }
    }

    @Override
    public void mouseMove(int x, int y) {
        this.mousePos.x = x;
        this.mousePos.y = y;
    }

    @Override
    public void mouseDown(int button) {
        if (this.isFocusable()) {
            this.setFocus();
        }
    }

    @Override
    public void mouseUp(int button) {
    }

    @Override
    public void mouseScroll(int dx, int dy) {
    }
}

