/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.utils.GenPkgInfo;

public class GenPAC {
    public static void main(String[] args) {
        String files;
        if (args.length != 3) {
            System.out.println("Usage:GenPAC app version home");
            System.exit(1);
        }
        if (!new File(files = "files.lst").exists()) {
            System.out.println("Error:files.lst not found");
            System.exit(1);
        }
        String arch = GenPAC.getArch();
        String archext = GenPAC.getArchExt();
        String out = args[0] + "-" + args[1] + "-" + archext + ".pkg.tar.xz";
        String home = args[2];
        String files_tmp = ".files.tmp";
        String data = ".MTREE";
        Runtime rt = Runtime.getRuntime();
        try {
            GenPkgInfo.main(new String[]{"arch", arch, files});
            new File(files_tmp).delete();
            JF.echoAppend(".PKGINFO\n", files_tmp);
            JF.echoAppend(".MTREE\n", files_tmp);
            JF.copyAllAppend(files, files_tmp);
            rt.exec(new String[]{"bsdtar", "-czf", data, "--format=mtree", "--options='!all,use-set,type,uid,gid,mode,time,size,md5,sha256,link'", "-T", files}).waitFor();
            rt.exec(new String[]{"tar", "cf", out, "-T", files_tmp}).waitFor();
            new File(data).delete();
            new File(".PKGINFO").delete();
            new File(data).delete();
            new File(files_tmp).delete();
            System.out.println(out + " created!");
            if (new File(home + "/repo/arch/readme.txt").exists()) {
                Files.copy(new File(out).toPath(), new File(home + "/repo/arch/" + archext + "/" + out).toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            System.exit(0);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static String getArch() {
        String arch = System.getenv("HOSTTYPE");
        if (arch == null && (arch = System.getProperty("os.arch")) == null) {
            JFLog.log("Error:Unable to detect CPU from env:HOSTTYPE or property:os.arch");
        }
        switch (arch) {
            case "amd64": {
                return "x86_64";
            }
            case "arm64": {
                return "aarch64";
            }
        }
        return arch;
    }

    public static String getArchExt() {
        return GenPAC.getArch();
    }
}

