/*
 * Decompiled with CFR 0.152.
 */
package javaforce.utils;

import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import javaforce.JFLog;
import javaforce.ShellProcess;

public class VSS {
    public static String[] listVolumes() {
        ShellProcess sh = new ShellProcess();
        sh.keepOutput(true);
        String out = sh.run(new String[]{"vssadmin", "list", "volumes"}, false);
        String[] lns = out.split("\r\n");
        ArrayList<String> vols = new ArrayList<String>();
        for (int a = 0; a < lns.length; ++a) {
            if (!lns[a].startsWith("Volume path:") || lns[a].charAt(13) == '\\') continue;
            vols.add(lns[a].substring(13, 15));
        }
        return vols.toArray(new String[vols.size()]);
    }

    public static String[] listShadows() {
        ShellProcess sh = new ShellProcess();
        sh.keepOutput(true);
        String out = sh.run(new String[]{"vssadmin", "list", "shadows"}, false);
        String[] lns = out.split("\r\n");
        ArrayList<CallSite> shadows = new ArrayList<CallSite>();
        String org = "?:";
        for (int a = 0; a < lns.length; ++a) {
            lns[a] = lns[a].trim();
            if (lns[a].startsWith("Original Volume:")) {
                org = lns[a].substring(18, 20);
            }
            if (!lns[a].startsWith("Shadow Copy Volume:")) continue;
            shadows.add((CallSite)((Object)(org + "=" + lns[a].substring(20))));
            org = null;
        }
        return shadows.toArray(new String[shadows.size()]);
    }

    public static boolean createShadow(String volume) {
        JFLog.log("VSS:createShadow:" + volume);
        ShellProcess sh = new ShellProcess();
        sh.keepOutput(true);
        String out = sh.run(new String[]{"vssadmin", "create", "shadow", "/For=" + volume}, false);
        String[] lns = out.split("\r\n");
        for (int a = 0; a < lns.length; ++a) {
            lns[a] = lns[a].trim();
            if (!lns[a].startsWith("Successfully")) continue;
            return true;
        }
        JFLog.log("Error:createShadow failed:" + volume);
        return false;
    }

    public static boolean deleteShadow(String volume) {
        boolean res;
        JFLog.log("VSS:deleteShadow:" + volume);
        ShellProcess sh = new ShellProcess();
        sh.keepOutput(true);
        String out = sh.run(new String[]{"vssadmin", "delete", "shadows", "/For=" + volume}, false);
        boolean bl = res = sh.getErrorLevel() == 0;
        if (!res) {
            JFLog.log(out);
        }
        if (res) {
            return true;
        }
        sh = new ShellProcess();
        sh.keepOutput(true);
        out = sh.run(new String[]{"vssadmin", "resize", "shadowstorage", "/For=" + volume, "/On=" + volume, "/maxsize=400MB"}, false);
        boolean bl2 = res = sh.getErrorLevel() == 0;
        if (!res) {
            JFLog.log(out);
        }
        sh = new ShellProcess();
        sh.keepOutput(true);
        out = sh.run(new String[]{"vssadmin", "resize", "shadowstorage", "/For=" + volume, "/On=" + volume, "/maxsize=unbounded"}, false);
        boolean bl3 = res = sh.getErrorLevel() == 0;
        if (!res) {
            JFLog.log(out);
        }
        sh = new ShellProcess();
        sh.keepOutput(true);
        out = sh.run(new String[]{"vssadmin", "delete", "shadows", "/For=" + volume}, false);
        boolean bl4 = res = sh.getErrorLevel() == 0;
        if (!res) {
            JFLog.log(out);
        }
        return res;
    }

    public static boolean deleteShadowAll() {
        boolean res;
        JFLog.log("VSS:deleteShadowAll");
        ShellProcess sh = new ShellProcess();
        sh.keepOutput(true);
        String out = sh.run(new String[]{"vssadmin", "delete", "shadows", "/All"}, false);
        boolean bl = res = sh.getErrorLevel() == 0;
        if (!res) {
            JFLog.log(out);
        }
        return res;
    }

    public static boolean mountShadow(String mountPath, String shadowPath) {
        JFLog.log("VSS:mount:" + mountPath + " to " + shadowPath);
        ShellProcess sh = new ShellProcess();
        sh.keepOutput(true);
        String out = sh.run(new String[]{"cmd", "/c", "mklink", "/d", mountPath.replaceAll("[/]", "\\\\"), shadowPath + "\\"}, true);
        JFLog.log("mklink output:" + out);
        return out.startsWith("symbolic link created for");
    }

    public static boolean unmountShadow(String mountPath) {
        JFLog.log("VSS:unmountShadow:" + mountPath);
        new File(mountPath).delete();
        return true;
    }

    public static void usage() {
        System.out.println("Usage : VSS {command}");
        System.out.println(" listvols : list volumes");
        System.out.println(" listshadows : list shadows");
        System.out.println(" createshadow {drive} : create shadow");
        System.out.println(" mountshadow {path} {shadow} : mount shadow");
        System.out.println(" unmountshadow {path} : unmount shadow");
        System.out.println(" deleteshadow {shadow} : delete shadow (/all for all shadows)");
        System.exit(1);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            VSS.usage();
        }
        switch (args[0]) {
            case "listvols": {
                VSS.listvols(args);
                break;
            }
            case "listshadows": {
                VSS.listshadows(args);
                break;
            }
            case "createshadow": {
                VSS.createshadow(args);
                break;
            }
            case "mountshadow": {
                VSS.mountshadow(args);
                break;
            }
            case "unmountshadow": {
                VSS.unmountshadow(args);
                break;
            }
            case "deleteshadow": {
                VSS.deleteshadow(args);
                break;
            }
            default: {
                VSS.usage();
            }
        }
    }

    public static void listvols(String[] args) {
        String[] vols;
        for (String vol : vols = VSS.listVolumes()) {
            System.out.println("Volume : " + vol);
        }
    }

    public static void listshadows(String[] args) {
        String[] shadows;
        for (String shadow : shadows = VSS.listShadows()) {
            System.out.println("Volume : " + shadow);
        }
    }

    public static void createshadow(String[] args) {
        if (args.length != 2) {
            VSS.usage();
        }
        if (VSS.createShadow(args[1])) {
            System.out.println("Shadow creation successful!");
        } else {
            System.out.println("Shadow creation failed!");
        }
    }

    public static void mountshadow(String[] args) {
        if (args.length != 3) {
            VSS.usage();
        }
        if (VSS.mountShadow(args[1], args[2])) {
            System.out.println("Shadow mount successful!");
        } else {
            System.out.println("Shadow mount failed!");
        }
    }

    public static void unmountshadow(String[] args) {
        if (args.length != 2) {
            VSS.usage();
        }
        if (VSS.unmountShadow(args[1])) {
            System.out.println("Shadow unmount successful!");
        } else {
            System.out.println("Shadow unmount failed!");
        }
    }

    public static void deleteshadow(String[] args) {
        if (args.length != 2) {
            VSS.usage();
        }
        if (args[1].equals("/all")) {
            if (VSS.deleteShadowAll()) {
                System.out.println("Shadow deletion(s) successful!");
            } else {
                System.out.println("Shadow deletion(s) failed!");
            }
        } else if (VSS.deleteShadow(args[1])) {
            System.out.println("Shadow deletion successful!");
        } else {
            System.out.println("Shadow deletion failed!");
        }
    }
}

