/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.Random;
import javaforce.BE;
import javaforce.JFLog;
import javaforce.media.AudioBuffer;
import javaforce.voip.Codec;
import javaforce.voip.Coder;
import javaforce.voip.DTMF;
import javaforce.voip.MusicOnHold;
import javaforce.voip.RTP;
import javaforce.voip.SDP;
import javaforce.voip.g711a;
import javaforce.voip.g711u;
import javaforce.voip.g722;
import javaforce.voip.g729a;
import javaforce.voip.gsm;

public class RTPChannel {
    private int seqnum = 0;
    private int timestamp = 0;
    protected int ssrc_src = -1;
    protected int ssrc_dst = -1;
    private static Random r = new Random();
    private static Object rlock = new Object();
    private short dtmfduration = 0;
    protected short turn1ch;
    protected short turn2ch;
    private int rfc2833_id = -1;
    private int vp8_id = -1;
    private int h264_id = -1;
    private int h263_1998_id = -1;
    private int h263_2000_id = -1;
    private char dtmfChar;
    private boolean dtmfSent = false;
    private AudioBuffer buffer = new AudioBuffer(8000, 1, 2);
    private DTMF dtmf;
    private static short[] silence8 = new short[160];
    private static short[] silence16 = new short[320];
    protected long turnBindExpires;
    private long lastPacket = 0L;
    protected boolean active = false;
    private MusicOnHold moh = new MusicOnHold();
    public RTP rtp;
    public SDP.Stream stream;
    public Coder coder_g711u;
    public Coder coder_g711a;
    public Coder coder_g722;
    public Coder coder_g729a;
    public Coder coder_gsm;
    public Coder coder;
    public int log;

    protected RTPChannel(RTP rtp, int ssrc, SDP.Stream stream) {
        this.rtp = rtp;
        this.ssrc_src = ssrc;
        this.stream = stream;
    }

    public void setLog(int id) {
        this.log = id;
    }

    public int getVP8id() {
        return this.vp8_id;
    }

    public int getH264id() {
        return this.h264_id;
    }

    public int getH263_1998id() {
        return this.h263_1998_id;
    }

    public int getH263_2000id() {
        return this.h263_2000_id;
    }

    public int getRFC2833id() {
        return this.rfc2833_id;
    }

    public void writeRTP(byte[] data, int off, int len) {
        if (!this.rtp.active) {
            JFLog.log(this.log, "RTPChannel.writeRTP() : not active");
            return;
        }
        if (this.stream.getPort() == -1) {
            JFLog.log(this.log, "RTPChannel.writeRTP() : not ready (NATing)");
            return;
        }
        if (!this.stream.canSend()) {
            JFLog.log(this.log, "RTPChannel.writeRTP() : stream without send");
            return;
        }
        try {
            if (RTP.useTURN) {
                this.rtp.stun1.sendData(this.turn1ch, data, off, len);
            } else {
                this.rtp.sock1.send(new DatagramPacket(data, off, len, InetAddress.getByName(this.stream.getIP()), this.stream.getPort()));
            }
        }
        catch (Exception e) {
            JFLog.log(this.log, (Throwable)e);
        }
    }

    public void writeRTCP(byte[] data, int off, int len) {
        if (!this.rtp.active) {
            return;
        }
        if (this.stream.getPort() == -1) {
            return;
        }
        try {
            if (RTP.useTURN) {
                this.rtp.stun2.sendData(this.turn2ch, data, off, len);
            } else {
                this.rtp.sock2.send(new DatagramPacket(data, off, len, InetAddress.getByName(this.stream.getIP()), this.stream.getPort() + 1));
            }
        }
        catch (Exception e) {
            JFLog.log(this.log, "err:RTP.writeRTCP:failed");
            JFLog.log(this.log, (Throwable)e);
        }
    }

    public void writeDTMF(char digit, boolean end) {
        byte[] data = new byte[16];
        RTPChannel.buildHeader(data, RTP.CODEC_RFC2833.id, this.getseqnum(), this.gettimestamp(160), this.getssrc(), false);
        switch (digit) {
            case '*': {
                data[12] = 10;
                break;
            }
            case '#': {
                data[12] = 11;
                break;
            }
            default: {
                data[12] = (byte)(digit - 48);
            }
        }
        data[13] = end ? -118 : 10;
        data[14] = (byte)((this.dtmfduration & 0xFF00) >> 8);
        data[15] = (byte)(this.dtmfduration & 0xFF);
        this.dtmfduration = (short)(this.dtmfduration + 160);
        this.writeRTP(data, 0, data.length);
        if (end) {
            this.writeRTP(data, 0, data.length);
            this.writeRTP(data, 0, data.length);
            this.dtmfduration = 0;
        }
    }

    public static void buildHeader(byte[] data, int id, int seqnum, int timestamp, int ssrc, boolean last) {
        data[0] = -128;
        data[1] = (byte)id;
        if (last) {
            data[1] = (byte)(data[1] | 0x80);
        }
        BE.setuint16(data, 2, seqnum);
        BE.setuint32(data, 4, timestamp);
        BE.setuint32(data, 8, ssrc);
    }

    public void buildHeader(byte[] data, int type) {
        RTPChannel.buildHeader(data, type, 0, 0, this.getssrc(), false);
    }

    public int getseqnum() {
        return this.seqnum++;
    }

    public int gettimestamp(int delta) {
        int ret = this.timestamp;
        this.timestamp += delta;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getssrc() {
        if (this.ssrc_src != -1) {
            return this.ssrc_src;
        }
        Object object = rlock;
        synchronized (object) {
            this.ssrc_src = r.nextInt() & Integer.MAX_VALUE;
        }
        return this.ssrc_src;
    }

    public static int getseqnum(byte[] data, int off) {
        return BE.getuint16(data, 2 + off);
    }

    public static int gettimestamp(byte[] data, int off) {
        return BE.getuint32(data, 4 + off);
    }

    public static int getssrc(byte[] data, int off) {
        return BE.getuint32(data, 8 + off);
    }

    public String getremoteip() {
        if (RTP.useTURN) {
            return this.rtp.stun1.getIP();
        }
        return this.stream.getIP();
    }

    public int getremoteport() {
        return this.stream.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        Object codec_rfc2833;
        this.lastPacket = System.currentTimeMillis();
        JFLog.log(this.log, "RTPChannel.start() : localhost:" + this.rtp.getlocalrtpport() + " remote=" + this.stream.getIP() + ":" + this.stream.getPort());
        if (this.stream.codecs != null && this.stream.codecs.length > 0) {
            Codec codec_h263_2000;
            Codec codec_h263_1998;
            Codec codec_h264;
            Codec codec_vp8;
            codec_rfc2833 = this.stream.getCodec(RTP.CODEC_RFC2833);
            if (codec_rfc2833 != null) {
                this.rfc2833_id = ((Codec)codec_rfc2833).id;
            }
            if ((codec_vp8 = this.stream.getCodec(RTP.CODEC_VP8)) != null) {
                this.vp8_id = codec_vp8.id;
            }
            if ((codec_h264 = this.stream.getCodec(RTP.CODEC_H264)) != null) {
                this.h264_id = codec_h264.id;
            }
            if ((codec_h263_1998 = this.stream.getCodec(RTP.CODEC_H263_1998)) != null) {
                this.h263_1998_id = codec_h263_1998.id;
            }
            if ((codec_h263_2000 = this.stream.getCodec(RTP.CODEC_H263_2000)) != null) {
                this.h263_2000_id = codec_h263_2000.id;
            }
            this.coder_g711u = new g711u(this.rtp);
            this.coder_g711a = new g711a(this.rtp);
            this.coder_gsm = new gsm(this.rtp);
            this.coder_g722 = new g722(this.rtp);
            this.coder_g729a = new g729a(this.rtp);
            if (this.stream.type == SDP.Type.audio) {
                this.coder = null;
                for (int a = 0; a < this.stream.codecs.length; ++a) {
                    Codec codec = this.stream.codecs[a];
                    if (codec.equals(RTP.CODEC_G711u)) {
                        this.coder = this.coder_g711u;
                        JFLog.log(this.log, "codec = g711u");
                        break;
                    }
                    if (codec.equals(RTP.CODEC_G711a)) {
                        this.coder = this.coder_g711a;
                        JFLog.log(this.log, "codec = g711a");
                        break;
                    }
                    if (codec.equals(RTP.CODEC_GSM)) {
                        this.coder = this.coder_gsm;
                        JFLog.log(this.log, "codec = gsm");
                        break;
                    }
                    if (codec.equals(RTP.CODEC_G722)) {
                        this.coder = this.coder_g722;
                        JFLog.log(this.log, "codec = g722");
                        break;
                    }
                    if (!codec.equals(RTP.CODEC_G729a)) continue;
                    this.coder = this.coder_g729a;
                    JFLog.log(this.log, "codec = g729a");
                    break;
                }
                if (this.coder == null) {
                    JFLog.log(this.log, "RTP.start() : Warning : no compatible audio codec selected");
                }
                this.dtmf = new DTMF(this.coder.getSampleRate());
            } else {
                boolean haveVcodec = false;
                for (int a = 0; a < this.stream.codecs.length; ++a) {
                    Codec codec = this.stream.codecs[a];
                    if (codec.equals(RTP.CODEC_H263)) {
                        JFLog.log(this.log, "codec = H.263");
                        break;
                    }
                    if (codec.equals(RTP.CODEC_H263_1998)) {
                        JFLog.log(this.log, "codec = H.263-1998");
                        break;
                    }
                    if (codec.equals(RTP.CODEC_H263_2000)) {
                        JFLog.log(this.log, "codec = H.263-2000");
                        break;
                    }
                    if (codec.equals(RTP.CODEC_JPEG)) {
                        JFLog.log(this.log, "codec = JPEG");
                        break;
                    }
                    if (codec.equals(RTP.CODEC_H264)) {
                        JFLog.log(this.log, "codec = H.264");
                        break;
                    }
                    if (!codec.equals(RTP.CODEC_VP8)) continue;
                    JFLog.log(this.log, "codec = VP8");
                    break;
                }
                if (!haveVcodec) {
                    JFLog.log(this.log, "RTP.start() : Warning : no compatible video codec selected");
                }
            }
        } else {
            JFLog.log(this.log, "RTP:Error:No codecs provided");
        }
        if (RTP.useTURN) {
            try {
                codec_rfc2833 = this.rtp.bindLock;
                synchronized (codec_rfc2833) {
                    this.rtp.bindingChannel = this;
                    this.turn1ch = this.rtp.getNextTURNChannel();
                    this.rtp.wait4reset();
                    this.rtp.stun1.requestBind(this.turn1ch, this.stream.getIP(), this.stream.getPort());
                    this.rtp.wait4reply();
                    this.turn2ch = this.rtp.getNextTURNChannel();
                    this.rtp.wait4reset();
                    this.rtp.stun2.requestBind(this.turn2ch, this.stream.getIP(), this.stream.getPort() + 1);
                    this.rtp.wait4reply();
                }
            }
            catch (Exception e) {
                JFLog.log(this.log, (Throwable)e);
                return false;
            }
        }
        this.active = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean change(SDP.Stream new_stream) {
        this.lastPacket = System.currentTimeMillis();
        this.stream = new_stream;
        if (this.stream.type == SDP.Type.audio) {
            if (new_stream.hasCodec(RTP.CODEC_G711u)) {
                this.coder = this.coder_g711u;
            } else if (new_stream.hasCodec(RTP.CODEC_G711a)) {
                this.coder = this.coder_g711a;
            } else if (new_stream.hasCodec(RTP.CODEC_GSM)) {
                this.coder = this.coder_gsm;
            } else if (new_stream.hasCodec(RTP.CODEC_G722)) {
                this.coder = this.coder_g722;
            } else if (new_stream.hasCodec(RTP.CODEC_G729a)) {
                this.coder = this.coder_g729a;
            }
            this.dtmf = new DTMF(this.coder.getSampleRate());
        }
        if (RTP.useTURN) {
            Object object = this.rtp.bindLock;
            synchronized (object) {
                this.rtp.bindingChannel = this;
                this.rtp.stun1.requestBind(this.turn1ch, this.stream.getIP(), this.stream.getPort());
                this.rtp.stun2.requestBind(this.turn2ch, this.stream.getIP(), this.stream.getPort() + 1);
            }
        }
        return true;
    }

    protected void processRTP(byte[] data, int off, int len) {
        this.lastPacket = RTP.now;
        if (this.rtp.rawMode) {
            this.rtp.iface.rtpPacket(this, data, off, len);
            return;
        }
        int id = data[off + 1] & 0x7F;
        if (id < 96) {
            switch (id) {
                case 0: {
                    this.dtmfSent = false;
                    if (len != 172) {
                        JFLog.log(this.log, "RTP:Bad g711u length");
                        break;
                    }
                    this.addSamples(this.coder_g711u.decode(data, off));
                    this.rtp.iface.rtpSamples(this);
                    break;
                }
                case 3: {
                    this.dtmfSent = false;
                    if (len != 45) {
                        JFLog.log(this.log, "RTP:Bad gsm length");
                        break;
                    }
                    this.addSamples(this.coder_gsm.decode(data, off));
                    this.rtp.iface.rtpSamples(this);
                    break;
                }
                case 8: {
                    this.dtmfSent = false;
                    if (len != 172) {
                        JFLog.log(this.log, "RTP:Bad g711a length");
                        break;
                    }
                    this.addSamples(this.coder_g711a.decode(data, off));
                    this.rtp.iface.rtpSamples(this);
                    break;
                }
                case 9: {
                    this.dtmfSent = false;
                    if (len != 172) {
                        JFLog.log(this.log, "RTP:Bad g722 length");
                        break;
                    }
                    this.addSamples(this.coder_g722.decode(data, off));
                    this.rtp.iface.rtpSamples(this);
                    break;
                }
                case 18: {
                    this.dtmfSent = false;
                    if (len != 32) {
                        JFLog.log(this.log, "RTP:Bad g729a length");
                        break;
                    }
                    this.addSamples(this.coder_g729a.decode(data, off));
                    this.rtp.iface.rtpSamples(this);
                    break;
                }
                case 26: {
                    this.rtp.iface.rtpJPEG(this, data, off, len);
                    break;
                }
                case 34: {
                    this.rtp.iface.rtpH263(this, data, off, len);
                }
            }
        } else if (id == this.rfc2833_id) {
            this.dtmfChar = (char)32;
            if (data[off + 12] >= 0 && data[off + 12] <= 9) {
                this.dtmfChar = (char)(48 + data[off + 12]);
            }
            if (data[off + 12] == 10) {
                this.dtmfChar = (char)42;
            }
            if (data[off + 12] == 11) {
                this.dtmfChar = (char)35;
            }
            if (data[off + 13] < 0) {
                this.dtmfSent = false;
                this.dtmfChar = (char)32;
            }
            if (this.dtmfChar == ' ') {
                switch (this.coder.getSampleRate()) {
                    case 8000: {
                        this.addSamples(silence8);
                        break;
                    }
                    case 16000: {
                        this.addSamples(silence16);
                    }
                }
            } else {
                this.addSamples(this.dtmf.getSamples(this.dtmfChar));
                if (!this.dtmfSent) {
                    this.rtp.iface.rtpDigit(this, this.dtmfChar);
                    this.dtmfSent = true;
                }
            }
        } else if (id == this.vp8_id) {
            this.rtp.iface.rtpVP8(this, data, off, len);
        } else if (id == this.h264_id) {
            this.rtp.iface.rtpH264(this, data, off, len);
        } else if (id == this.h263_1998_id) {
            this.rtp.iface.rtpH263_1998(this, data, off, len);
        } else if (id == this.h263_2000_id) {
            this.rtp.iface.rtpH263_2000(this, data, off, len);
        }
    }

    protected void processRTCP(byte[] data, int off, int len) {
        if (this.rtp.rawMode) {
            this.rtp.iface.rtcpPacket(this, data, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void keepalive(long now) {
        if (RTP.useTURN && now + 75000L > this.turnBindExpires) {
            Object object = this.rtp.bindLock;
            synchronized (object) {
                this.rtp.bindingChannel = this;
                this.rtp.stun1.requestBind(this.turn1ch, this.stream.getIP(), this.stream.getPort());
                this.rtp.stun2.requestBind(this.turn2ch, this.stream.getIP(), this.stream.getPort() + 1);
            }
        }
        if (this.active && this.stream.type == SDP.Type.audio && this.stream.canRecv() && now - 45000L > this.lastPacket) {
            this.rtp.iface.rtpInactive(this);
        }
    }

    public boolean getSamples(short[] data) {
        if (!this.stream.canRecv()) {
            return this.moh.getSamples(data);
        }
        return this.buffer.get(data, 0, data.length);
    }

    private void addSamples(short[] data) {
        this.buffer.add(data, 0, data.length);
    }

    public String toString() {
        return "RTPChannel:{src=" + this.ssrc_src + ",dst=" + this.ssrc_dst + ",ip=" + this.stream.getIP() + ":" + this.stream.getPort() + "}";
    }
}

