/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import java.util.ArrayList;
import java.util.Arrays;
import javaforce.voip.Packet;
import javaforce.voip.RTPChannel;
import javaforce.voip.RTPCodec;

public class RTPH263_1998
extends RTPCodec {
    private Packet packet = new Packet();
    private static final int mtu = 1444;
    private int seqnum;
    private int timestamp;
    private final int ssrc = this.random.nextInt();
    private byte[] partial;

    private int find_best_length(byte[] data, int offset, int length) {
        for (int a = 1; a < length - 3; ++a) {
            if (data[offset + a] != 0 || data[offset + a + 1] != 0 || data[offset + a + 2] == 0) continue;
            return a;
        }
        return length;
    }

    @Override
    public byte[][] encode(byte[] data, int x, int y, int id) {
        int packetLength;
        ArrayList<byte[]> packets = new ArrayList<byte[]>();
        int offset = 0;
        for (int len = data.length; len > 0; len -= packetLength) {
            boolean P = false;
            if (len > 2 && data[offset] == 0 && data[offset + 1] == 0) {
                P = true;
                offset += 2;
                len -= 2;
            }
            packetLength = len > 1444 ? this.find_best_length(data, offset, len) : len;
            byte[] packet = new byte[packetLength + 12 + 2];
            RTPChannel.buildHeader(packet, id, this.seqnum++, this.timestamp, this.ssrc, len == packetLength);
            packet[12] = (byte)(P ? 4 : 0);
            System.arraycopy(data, offset, packet, 14, packetLength);
            offset += packetLength;
            packets.add(packet);
        }
        this.timestamp += 100;
        return (byte[][])packets.toArray((T[])new byte[0][0]);
    }

    @Override
    public Packet decode(byte[] rtp, int offset, int length) {
        if (rtp.length < 14) {
            return null;
        }
        if (this.partial == null) {
            this.partial = new byte[0];
        }
        int h263Length = rtp.length - 12 - 2;
        boolean P = (rtp[12] & 4) == 4;
        int partialLength = this.partial.length;
        this.partial = Arrays.copyOf(this.partial, this.partial.length + (P ? 2 : 0) + h263Length);
        System.arraycopy(rtp, 14, this.partial, partialLength + (P ? 2 : 0), h263Length);
        if ((rtp[1] & 0x80) == 128) {
            this.packet.data = this.partial;
            this.partial = null;
            return this.packet;
        }
        return null;
    }
}

