/*
 * Decompiled with CFR 0.152.
 */
package javaforce.voip;

import java.util.ArrayList;
import javaforce.JFLog;
import javaforce.voip.Packet;
import javaforce.voip.RTPChannel;
import javaforce.voip.RTPCodec;

public class RTPH264
extends RTPCodec {
    public static int decodeSize = 0x400000;
    public int log;
    private static final int mtu = 1446;
    private int seqnum;
    private int timestamp;
    private final int ssrc = this.random.nextInt();
    private Packet packet = new Packet();
    private boolean reset_packet;
    private int lastseqnum = -1;

    public RTPH264() {
        this.packet.data = new byte[decodeSize];
    }

    public void setLog(int id) {
        this.log = id;
    }

    private int find_best_length(byte[] data, int offset, int length) {
        for (int a = 1; a < length - 3; ++a) {
            if (data[offset + a] != 0 || data[offset + a + 1] != 0 || data[offset + a + 2] != 1) continue;
            return a;
        }
        return length;
    }

    @Override
    public byte[][] encode(byte[] data, int x, int y, int id) {
        ArrayList<byte[]> packets = new ArrayList<byte[]>();
        int len = data.length;
        int offset = 0;
        while (len > 0) {
            byte[] packet;
            int packetLength;
            while (data[offset] == 0) {
                ++offset;
                --len;
            }
            if ((packetLength = --len > 1446 ? this.find_best_length(data, ++offset, len) : len) > 1446) {
                int nalLength = 1444;
                byte type = (byte)(data[offset] & 0x1F);
                byte nri = (byte)(data[offset] & 0x60);
                ++offset;
                --len;
                --packetLength;
                boolean first = true;
                while (packetLength > nalLength) {
                    packet = new byte[14 + nalLength];
                    RTPChannel.buildHeader(packet, id, this.seqnum++, this.timestamp, this.ssrc, false);
                    packet[12] = 28;
                    packet[12] = (byte)(packet[12] | nri);
                    packet[13] = type;
                    if (first) {
                        packet[13] = (byte)(packet[13] | 0x80);
                        first = false;
                    }
                    System.arraycopy(data, offset, packet, 14, nalLength);
                    offset += nalLength;
                    len -= nalLength;
                    packetLength -= nalLength;
                    packets.add(packet);
                }
                nalLength = packetLength;
                packet = new byte[14 + nalLength];
                RTPChannel.buildHeader(packet, id, this.seqnum++, this.timestamp, this.ssrc, len == nalLength);
                packet[12] = 28;
                packet[12] = (byte)(packet[12] | nri);
                packet[13] = type;
                packet[13] = (byte)(packet[13] | 0x40);
                System.arraycopy(data, offset, packet, 14, nalLength);
                offset += nalLength;
                len -= nalLength;
                packetLength -= nalLength;
                packets.add(packet);
                continue;
            }
            packet = new byte[packetLength + 12];
            RTPChannel.buildHeader(packet, id, this.seqnum++, this.timestamp, this.ssrc, len == packetLength);
            System.arraycopy(data, offset, packet, 12, packetLength);
            packets.add(packet);
            offset += packetLength;
            len -= packetLength;
        }
        this.timestamp += 100;
        return (byte[][])packets.toArray((T[])new byte[0][0]);
    }

    @Override
    public Packet decode(byte[] rtp, int offset, int length) {
        if (length < 14) {
            return null;
        }
        if (this.reset_packet) {
            this.packet.length = 0;
            this.reset_packet = false;
        }
        int h264Length = length - 12;
        int type = rtp[12] & 0x1F;
        int thisseqnum = RTPChannel.getseqnum(rtp, 0);
        if (type >= 1 && type <= 23) {
            System.arraycopy(rtp, 12, this.packet.data, 4, h264Length);
            this.packet.data[3] = 1;
            this.packet.length = 4 + h264Length;
            this.reset_packet = true;
            return this.packet;
        }
        if (type == 28) {
            boolean M;
            boolean first = (rtp[13] & 0x80) == 128;
            boolean last = (rtp[13] & 0x40) == 64;
            int realtype = rtp[13] & 0x1F;
            boolean bl = M = (rtp[12] & 0x80) == 128;
            if (M && !last) {
                JFLog.log(this.log, "Error : H264 : FU-A : M bit set but not last packet : seq=" + thisseqnum);
                return null;
            }
            if (first) {
                if (this.packet.length != 0) {
                    JFLog.log(this.log, "Warning : H264 : FU-A : first packet again, last frame lost?");
                }
                int nri = rtp[12] & 0x60;
                System.arraycopy(rtp, 14, this.packet.data, 5, h264Length -= 2);
                this.packet.length = 5 + h264Length;
                this.packet.data[3] = 1;
                this.packet.data[4] = (byte)(nri + realtype);
                this.lastseqnum = thisseqnum;
            } else {
                if (this.packet.length == 0) {
                    JFLog.log(this.log, "Error : H264 : partial packet received before first packet : seq=" + thisseqnum);
                    return null;
                }
                if (thisseqnum != this.nextseqnum()) {
                    JFLog.log(this.log, "Error : H264 : Received FU-A packet out of order, discarding frame : seq=" + thisseqnum);
                    this.packet.length = 0;
                    this.lastseqnum = -1;
                    return null;
                }
                this.lastseqnum = thisseqnum;
                int partialLength = this.packet.length;
                System.arraycopy(rtp, 14, this.packet.data, partialLength, h264Length -= 2);
                this.packet.length += h264Length;
                if (last) {
                    this.reset_packet = true;
                    return this.packet;
                }
            }
        } else {
            JFLog.log(this.log, "H264:Unsupported packet type:" + type);
            this.packet.length = 0;
            this.lastseqnum = -1;
            return null;
        }
        return null;
    }

    private int nextseqnum() {
        if (this.lastseqnum == 65535) {
            return 0;
        }
        return this.lastseqnum + 1;
    }
}

