package javaforce.net;

/** WebRelay
 *
 * Man in the middle tests.
 * To view secure web traffic using wireshark.
 *
 * @author pquiring
 */

import java.io.*;
import java.net.*;
import java.util.*;

import javaforce.*;

public class WebRelay {
  private static String host;
  private static int port = 80;
  private static boolean secure;
  public static void main(String[] args) {
    if (args.length == 0) {
      System.out.println("Usage: WebRelay URL");
      System.exit(0);
    }
    String url = args[0];
    System.out.println("WebRelay to " + url);
    if (url.startsWith("https://")) {
      url = url.substring(8);
      port = 443;
      secure = true;
    }
    else if (url.startsWith("http://")) {
      url = url.substring(7);
      port = 80;
      secure = false;
    }
    else {
      System.out.println("Unknown protocol");
      System.exit(0);
    }
    JF.initHttps();
    int idx = url.indexOf(':');
    if (idx == -1) {
      host = url;
    } else {
      host = url.substring(0, idx);
      port = JF.atoi(url.substring(idx+1));
    }

    try {
      ServerSocket ss = new ServerSocket(80);
      while (true) {
        System.out.println("Waiting for request");
        Socket s = ss.accept();
        Worker w = new Worker(s);
        w.start();
      }
    } catch (Exception e) {
      e.printStackTrace();
      System.exit(1);
    }
  }
  private static class Worker extends Thread {
    private Socket s;
    private InputStream is;
    private OutputStream os;
    private Socket web;
    private InputStream webis;
    private OutputStream webos;
    private byte[] buf = new byte[1024];
    private int pos;
    private int len;
    private int avail;
    private String[] lns;
    private String encoding;
    public Worker(Socket s) {
      this.s = s;
    }
    public void run() {
      try {
        is = s.getInputStream();
        os = s.getOutputStream();
        while (true) {
          //read request
          len = 0;
          pos = 0;
          avail = buf.length;
          System.out.println("reading request headers");
          do {
            if (avail < 512) {
              grow();
            }
            int read = is.read(buf, pos, avail);
            if (read == -1) break;
            pos += read;
            len += read;
            avail -= read;
            String req = new String(buf, 0, len);
            lns = req.split("\r\n", -1);
            if (lns[lns.length-1].equals("")) break;  //end of headers
          } while (true);
          StringBuilder webreq = new StringBuilder();
          for(String ln : lns) {
            System.out.println("REQ:" + ln);
            if (ln.contains("localhost")) {
              ln = ln.replaceAll("localhost", host);
            }
            webreq.append(ln);
            webreq.append("\r\n");
          }

          //connect to real host
          System.out.println("connecting to:" + host + ":" + port);
          web = new Socket(host, port);
          if (secure) {
            System.out.println("securing connection");
            web = JF.connectSSL(web);  //upgrade to SSL
          }
          webis = web.getInputStream();
          webos = web.getOutputStream();

          //write request
          System.out.println("write to web:" + webreq.length());
          byte[] webreqbin = webreq.toString().getBytes();
          webos.write(webreqbin);
          webos.flush();

          //read reply
          len = 0;
          pos = 0;
          avail = buf.length;
          System.out.println("reading web headers");
          do {
            if (avail < 512) {
              grow();
            }
            int read = webis.read(buf, pos, avail);
            if (read == -1) break;
            pos += read;
            len += read;
            avail -= read;
            String req = new String(buf, 0, len);
            lns = req.split("\r\n", -1);
            if (lns[lns.length-1].equals("")) break;  //end of headers
          } while (true);
          int contentLength = -1;
          encoding = "";
          for(String ln : lns) {
            System.out.println("WEB:" + ln);
            int idx = ln.indexOf(':');
            if (idx == -1) continue;
            String key = ln.substring(0, idx).trim();
            String value = ln.substring(idx+1).trim();
            String[] values = value.split(";", -1);
            switch (key) {
              case "Content-Length": {
                contentLength = JF.atoi(values[0].trim());
                break;
              }
              case "Transfer-Encoding": {
                encoding = value;
                break;
              }
            }
          }
          System.out.println("content-length=" + contentLength);
          //write headers back
          os.write(buf, 0, len);
          if (encoding.contains("chunked")) {
            //TODO : support "chunked" data
            System.out.println("TODO:chunked content");
          }
          if (contentLength <= 0) continue;

          //read content
          len = 0;
          pos = 0;
          avail = buf.length;
          System.out.println("reading web content");
          do {
            if (avail < 512) {
              grow();
            }
            int read = webis.read(buf, pos, avail);
            if (read == -1) break;
            pos += read;
            len += read;
            avail -= read;
          } while (len < contentLength);
          System.out.println("OUT:" + new String(buf, 0, contentLength, "ISO-8859-1"));
          System.out.println("OUT:" + hexToString(Arrays.copyOfRange(buf, 0, contentLength)));

          //write content back
          os.write(buf, 0, contentLength);
        }
      } catch (Exception e) {
        e.printStackTrace();
      }
    }
    public void grow() {
      buf = Arrays.copyOf(buf, buf.length << 1);
      avail = buf.length - len;
    }
    public static String hexToString(byte[] hex) {
      StringBuilder str = new StringBuilder();
      for(int a=0;a<hex.length;a++) {
        if (a > 0) str.append(",");
        str.append(String.format("%02x", hex[a] & 0xff));
      }
      return str.toString();
    }
  }
}
