/*
 * Decompiled with CFR 0.152.
 */
package javaforce;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javaforce.BE;
import javaforce.JF;
import javaforce.JFLog;

public class SOCKS {
    public static boolean connect(Socket s, String host, int port) {
        byte[] req = new byte[9];
        byte[] reply = new byte[8];
        req[0] = 4;
        req[1] = 1;
        BE.setuint16(req, 2, port);
        String[] ips = host.split("[.]");
        if (ips == null || ips.length != 4) {
            JFLog.log("SOCKS.connect() : host is not an IP4 address");
            return false;
        }
        for (int a = 0; a < 4; ++a) {
            req[4 + a] = (byte)JF.atoi(ips[a]);
        }
        try {
            OutputStream os = s.getOutputStream();
            InputStream is = s.getInputStream();
            os.write(req);
            int totalread = 0;
            while (totalread != reply.length) {
                int read = is.read(reply, totalread, reply.length - totalread);
                if (read < 0) {
                    throw new Exception("bad read");
                }
                if (read <= 0) continue;
                totalread += read;
            }
            return reply[1] == 90;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public static boolean bind(Socket s, String host, int port) {
        int read;
        int totalread;
        InputStream is;
        OutputStream os;
        byte[] req = new byte[9];
        byte[] reply = new byte[8];
        req[0] = 4;
        req[1] = 2;
        BE.setuint16(req, 2, port);
        String[] ips = host.split("[.]");
        if (ips == null || ips.length != 4) {
            JFLog.log("SOCKS.bind() : host is not an IP4 address");
            return false;
        }
        for (int a = 0; a < 4; ++a) {
            req[4 + a] = (byte)JF.atoi(ips[a]);
        }
        try {
            os = s.getOutputStream();
            is = s.getInputStream();
            os.write(req);
            totalread = 0;
            while (totalread != reply.length) {
                read = is.read(reply, totalread, reply.length - totalread);
                if (read < 0) {
                    throw new Exception("bad read");
                }
                if (read <= 0) continue;
                totalread += read;
            }
            if (reply[1] != 90) {
                return false;
            }
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        try {
            os = s.getOutputStream();
            is = s.getInputStream();
            os.write(req);
            totalread = 0;
            while (totalread != reply.length) {
                read = is.read(reply, totalread, reply.length - totalread);
                if (read < 0) {
                    throw new Exception("bad read");
                }
                if (read <= 0) continue;
                totalread += read;
            }
            return reply[1] == 90;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public static boolean connect(Socket s, String host, int port, String user, String pass) {
        if (!SOCKS.socks5_authenticate(s, user, pass)) {
            return false;
        }
        byte[] req = new byte[10];
        byte[] reply = new byte[10];
        req[0] = 5;
        req[1] = 1;
        req[2] = 0;
        String[] ips = host.split("[.]");
        if (ips == null || ips.length != 4) {
            JFLog.log("SOCKS.connect() : host is not an IP4 address");
            return false;
        }
        req[3] = 1;
        for (int a = 0; a < 4; ++a) {
            req[4 + a] = (byte)JF.atoi(ips[a]);
        }
        BE.setuint16(req, 8, port);
        try {
            OutputStream os = s.getOutputStream();
            InputStream is = s.getInputStream();
            os.write(req);
            int totalread = 0;
            while (totalread != reply.length) {
                int read = is.read(reply, totalread, reply.length - totalread);
                if (read < 0) {
                    throw new Exception("bad read");
                }
                if (read <= 0) continue;
                totalread += read;
            }
            return reply[1] == 0;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    public static boolean bind(Socket s, String host, int port, String user, String pass) {
        if (!SOCKS.socks5_authenticate(s, user, pass)) {
            return false;
        }
        byte[] req = new byte[10];
        byte[] reply = new byte[10];
        req[0] = 5;
        req[1] = 2;
        req[2] = 0;
        String[] ips = host.split("[.]");
        if (ips == null || ips.length != 4) {
            JFLog.log("SOCKS.connect() : host is not an IP4 address");
            return false;
        }
        req[3] = 1;
        for (int a = 0; a < 4; ++a) {
            req[4 + a] = (byte)JF.atoi(ips[a]);
        }
        BE.setuint16(req, 8, port);
        try {
            int read;
            OutputStream os = s.getOutputStream();
            InputStream is = s.getInputStream();
            os.write(req);
            int totalread = 0;
            while (totalread != reply.length) {
                read = is.read(reply, totalread, reply.length - totalread);
                if (read < 0) {
                    throw new Exception("bad read");
                }
                if (read <= 0) continue;
                totalread += read;
            }
            if (reply[1] != 0) {
                return false;
            }
            totalread = 0;
            while (totalread != reply.length) {
                read = is.read(reply, totalread, reply.length - totalread);
                if (read < 0) {
                    throw new Exception("bad read");
                }
                if (read <= 0) continue;
                totalread += read;
            }
            return reply[1] == 0;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }

    private static boolean socks5_authenticate(Socket s, String user, String pass) {
        try {
            int read;
            OutputStream os = s.getOutputStream();
            InputStream is = s.getInputStream();
            byte[] req = new byte[]{5, 1, 2};
            os.write(req);
            byte[] reply = new byte[2];
            int totalread = 0;
            while (totalread != reply.length) {
                read = is.read(reply, totalread, reply.length - totalread);
                if (read < 0) {
                    throw new Exception("bad read");
                }
                if (read <= 0) continue;
                totalread += read;
            }
            if (reply[1] == 255) {
                return false;
            }
            req = new byte[2 + user.length() + 1 + pass.length()];
            req[0] = 1;
            int offset = 1;
            int userlen = user.length();
            req[offset++] = (byte)userlen;
            BE.setString(req, offset, userlen, user);
            offset += userlen;
            int passlen = pass.length();
            req[offset++] = (byte)passlen;
            BE.setString(req, offset, passlen, pass);
            offset += passlen;
            os.write(req);
            reply = new byte[2];
            totalread = 0;
            while (totalread != reply.length) {
                read = is.read(reply, totalread, reply.length - totalread);
                if (read < 0) {
                    throw new Exception("bad read");
                }
                if (read <= 0) continue;
                totalread += read;
            }
            return reply[1] == 0;
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
    }
}

