/*
 * Decompiled with CFR 0.152.
 */
package javaforce.controls.ab;

import javaforce.controls.Controller;
import javaforce.controls.ab.ABContext;
import javaforce.controls.ab.CIP_Reply_Read;
import javaforce.controls.ab.CIP_Reply_Write;
import javaforce.controls.ab.CIP_Request;
import javaforce.controls.ab.ENIP;

public class ABPacket {
    public static byte[] makeConnectPacket(ABContext context) {
        ENIP ip = new ENIP(101);
        ip.setSizes(0);
        int size = ip.size();
        byte[] packet = new byte[size];
        int offset = 0;
        try {
            ip.write(packet, offset, context);
            offset += ip.size();
            return packet;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] makeReadPacket(String tag, ABContext context) {
        ENIP ip = new ENIP(111);
        CIP_Request cip = new CIP_Request();
        cip.setRead(tag);
        ip.setSizes(cip.size());
        int size = ip.size() + cip.size();
        byte[] packet = new byte[size];
        int offset = 0;
        try {
            ip.write(packet, offset, context);
            cip.write(packet, offset += ip.size());
            return packet;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] makeWritePacket(String tag, byte type, byte[] data, ABContext context) {
        ENIP ip = new ENIP(111);
        CIP_Request cip = new CIP_Request();
        cip.setWrite(tag, type, data);
        ip.setSizes(cip.size());
        int size = ip.size() + cip.size();
        byte[] packet = new byte[size];
        int offset = 0;
        try {
            ip.write(packet, offset, context);
            cip.write(packet, offset += ip.size());
            return packet;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] decodePacket(byte[] data) {
        ENIP ip = new ENIP();
        int offset = 0;
        try {
            ip.read(data, offset);
            offset += ip.size();
            if (ip.cmd == 101) {
                return new byte[0];
            }
            switch (data[offset]) {
                case -52: {
                    CIP_Reply_Read cip_read = new CIP_Reply_Read();
                    cip_read.read(data, offset);
                    return cip_read.tagdata;
                }
                case -51: {
                    CIP_Reply_Write cip_write = new CIP_Reply_Write();
                    cip_write.read(data, offset);
                    return new byte[0];
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isPacketComplete(byte[] data) {
        try {
            return ABPacket.decodePacket(data) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static byte getType(Controller.datatype type) {
        switch (type) {
            case INTEGER8: {
                return -62;
            }
            case INTEGER16: {
                return -61;
            }
            case INTEGER32: {
                return -60;
            }
            case INTEGER64: {
                return -59;
            }
            case FLOAT: {
                return -54;
            }
            case DOUBLE: {
                return -53;
            }
            case BOOLEAN: {
                return -63;
            }
        }
        return 0;
    }
}

