/*
 * Decompiled with CFR 0.152.
 */
package javaforce.gl;

import java.util.ArrayList;
import javaforce.JFLog;
import javaforce.gl.Matrix;
import javaforce.gl.Object3;

public class Model
implements Cloneable {
    public ArrayList<Object3> ol;
    public ArrayList<String> textures;
    public Matrix m;
    public boolean visible = true;
    public int refcnt;

    public Model() {
        this.m = new Matrix();
        this.m.setIdentity();
        this.ol = new ArrayList();
        this.textures = new ArrayList();
    }

    private Model(Matrix m) {
        this.m = m;
        this.ol = new ArrayList();
    }

    public Object clone() {
        Model c = new Model((Matrix)this.m.clone());
        int objs = this.ol.size();
        for (int a = 0; a < objs; ++a) {
            c.ol.add((Object3)this.ol.get(a).clone());
        }
        c.textures = this.textures;
        return c;
    }

    public void setVisible(boolean state) {
        this.visible = state;
    }

    public void addObject(Object3 obj) {
        this.ol.add(obj);
    }

    public Object3 getObject(String name) {
        for (int a = 0; a < this.ol.size(); ++a) {
            Object3 o = this.ol.get(a);
            if (!o.name.equals(name)) continue;
            return o;
        }
        JFLog.log("GLModel:Could not find object:" + name);
        return null;
    }

    public void setIdentity() {
        this.m.setIdentity();
    }

    public void rotate(float angle, float x, float y, float z) {
        this.m.addRotate(angle, x, y, z);
    }

    public void translate(float x, float y, float z) {
        this.m.addTranslate(x, y, z);
    }

    public void scale(float x, float y, float z) {
        this.m.addScale(x, y, z);
    }

    public void nextFrame() {
        int size = this.ol.size();
        for (int i = 0; i < size; ++i) {
            Object3 obj = this.ol.get(i);
            obj.nextFrame();
        }
    }

    public void setFrame(int idx) {
        int size = this.ol.size();
        for (int i = 0; i < size; ++i) {
            Object3 obj = this.ol.get(i);
            obj.setFrame(idx);
        }
    }

    public int addTexture(String fn) {
        for (int a = 0; a < this.textures.size(); ++a) {
            if (!this.textures.get(a).equals(fn)) continue;
            return a;
        }
        this.textures.add(fn);
        return this.textures.size() - 1;
    }

    public String getTexture(int idx) {
        return this.textures.get(idx);
    }

    public void print() {
        System.out.println("Model data");
        for (int a = 0; a < this.ol.size(); ++a) {
            this.ol.get(a).print(this);
        }
    }
}

