/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.LDAP;
import javaforce.jbus.JBusClient;
import javaforce.jbus.JBusServer;
import javaforce.net.EMail;
import javaforce.net.IP4Port;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.file.virtualfs.VirtualFileSystemFactory;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.scp.server.ScpCommandFactory;
import org.apache.sshd.server.SshServer;
import org.apache.sshd.server.command.CommandFactory;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.shell.ProcessShellFactory;
import org.apache.sshd.server.shell.ShellFactory;
import org.apache.sshd.sftp.server.SftpSubsystemFactory;

public class SSH
extends Thread {
    public static final String busPack = "net.sf.jfssh";
    public static boolean debug = false;
    private static SSH ssh;
    private static JBusServer busServer;
    private JBusClient busClient;
    private String config;
    private static String ldap_domain;
    private static String ldap_server;
    private static ArrayList<EMail> users;
    private static IP4Port bind;
    private boolean active;
    private SshServer sshd;
    private String root = null;
    private boolean enable_shell = true;
    private boolean enable_sftp = true;
    private boolean enable_scp = true;
    private static final String defaultConfig = "[global]\nport=22\n#root=/\n#bind=192.168.100.2\n#ldap_domain=example.com\n#ldap_server=192.168.200.2\n#account=user:pass\n#shell=true\n#scp=true\n#sftp=true\n";

    public static String getConfigFile() {
        return JF.getConfigPath() + "/jfssh.cfg";
    }

    public static String getLogFile() {
        return JF.getLogPath() + "/jfssh.log";
    }

    public static int getBusPort() {
        if (JF.isWindows()) {
            return 33012;
        }
        return 777;
    }

    public static void serviceStart(String[] args) {
        if (JF.isWindows()) {
            busServer = new JBusServer(SSH.getBusPort());
            busServer.start();
            while (true) {
                if (JBusServer.ready) break;
                JF.sleep(10);
            }
        }
        ssh = new SSH();
        ssh.start();
    }

    public static void serviceStop() {
        ssh.close();
    }

    public static void main(String[] args) {
        SSH.serviceStart(args);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                SSH.serviceStop();
            }
        });
    }

    @Override
    public void run() {
        JFLog.append(JF.getLogPath() + "/jfssh.log", true);
        JFLog.setRetention(30);
        JFLog.log("jfSSH starting...");
        try {
            this.loadConfig();
            this.busClient = new JBusClient(busPack, new JBusMethods());
            this.busClient.setPort(SSH.getBusPort());
            this.busClient.start();
            this.sshd = SshServer.setUpDefaultServer();
            this.sshd.setPort(SSH.bind.port);
            this.sshd.setHost(bind.toIP4String());
            this.sshd.setKeyPairProvider((KeyPairProvider)new SimpleGeneratorHostKeyProvider());
            this.sshd.setPublickeyAuthenticator((s, publicKey, serverSession) -> true);
            this.sshd.setPasswordAuthenticator((username, password, serverSession) -> {
                for (EMail acct : users) {
                    if (!acct.user.equals(username)) continue;
                    return acct.pass.equals(password);
                }
                if (ldap_server != null && ldap_domain != null) {
                    LDAP ldap = new LDAP();
                    return ldap.login(ldap_server, ldap_domain, username, password);
                }
                return false;
            });
            Path dir = Paths.get(this.root, new String[0]);
            VirtualFileSystemFactory vfs = new VirtualFileSystemFactory(dir.toAbsolutePath());
            this.sshd.setFileSystemFactory((FileSystemFactory)vfs);
            if (this.enable_sftp) {
                ArrayList<SftpSubsystemFactory> sftpCommandFactory = new ArrayList<SftpSubsystemFactory>();
                SftpSubsystemFactory sftp = new SftpSubsystemFactory();
                sftpCommandFactory.add(sftp);
                this.sshd.setSubsystemFactories(sftpCommandFactory);
            }
            if (this.enable_scp) {
                ScpCommandFactory scp = new ScpCommandFactory.Builder().build();
                this.sshd.setCommandFactory((CommandFactory)scp);
            }
            if (this.enable_shell) {
                if (JF.isWindows()) {
                    this.sshd.setShellFactory((ShellFactory)new ProcessShellFactory("cmd.exe", new String[]{"cmd.exe"}));
                } else {
                    this.sshd.setShellFactory((ShellFactory)new ProcessShellFactory("/bin/bash", new String[]{"/bin/bash"}));
                }
            }
            this.sshd.start();
            this.active = true;
            while (this.sshd.isStarted() && this.active) {
                JF.sleep(1000);
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    public void close() {
        this.active = false;
        if (this.sshd != null) {
            try {
                this.sshd.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sshd = null;
        }
    }

    private void loadConfig() {
        JFLog.log("loadConfig");
        users = new ArrayList();
        Section section = Section.None;
        bind.setIP("0.0.0.0");
        SSH.bind.port = 22;
        this.root = JF.isWindows() ? "c:/" : "/";
        try {
            String ln;
            BufferedReader br = new BufferedReader(new FileReader(SSH.getConfigFile()));
            StringBuilder cfg = new StringBuilder();
            while ((ln = br.readLine()) != null) {
                block37: {
                    cfg.append(ln);
                    cfg.append("\n");
                    ln = ln.trim();
                    int cmt = ln.indexOf(35);
                    if (cmt != -1) {
                        ln = ln.substring(0, cmt).trim();
                    }
                    if (ln.length() == 0) continue;
                    if (ln.equals("[global]")) {
                        section = Section.Global;
                        continue;
                    }
                    int idx = ln.indexOf("=");
                    if (idx == -1) continue;
                    String key = ln.substring(0, idx);
                    String value = ln.substring(idx + 1);
                    block2 : switch (section.ordinal()) {
                        case 0: 
                        case 1: {
                            switch (key) {
                                case "port": {
                                    SSH.bind.port = JF.atoi(value);
                                    break block2;
                                }
                                case "bind": {
                                    if (!bind.setIP(value)) {
                                        JFLog.log("SMTP:bind:Invalid IP:" + value);
                                        break block2;
                                    }
                                    break block37;
                                }
                                case "account": {
                                    int cln = value.indexOf(58);
                                    if (cln != -1) {
                                        String user = value.substring(0, cln);
                                        String pass = value.substring(cln + 1);
                                        EMail acct = new EMail();
                                        acct.user = user;
                                        acct.pass = pass;
                                        users.add(acct);
                                        break block2;
                                    }
                                    break block37;
                                }
                                case "ldap_domain": {
                                    ldap_domain = value;
                                    break block2;
                                }
                                case "root": {
                                    this.root = value;
                                    break block2;
                                }
                                case "ldap_server": {
                                    ldap_server = value;
                                    break block2;
                                }
                                case "debug": {
                                    debug = value.equals("true");
                                    break block2;
                                }
                                case "shell": {
                                    this.enable_shell = value.equals("true");
                                    break block2;
                                }
                                case "scp": {
                                    this.enable_scp = value.equals("true");
                                    break block2;
                                }
                                case "sftp": {
                                    this.enable_sftp = value.equals("true");
                                }
                            }
                        }
                    }
                }
            }
            br.close();
            this.config = cfg.toString();
        }
        catch (FileNotFoundException e) {
            JFLog.log("config not found, creating defaults.");
            try {
                FileOutputStream fos = new FileOutputStream(SSH.getConfigFile());
                fos.write(defaultConfig.getBytes());
                fos.close();
                this.config = defaultConfig;
            }
            catch (Exception e2) {
                JFLog.log(e2);
            }
        }
        catch (Exception e) {
            JFLog.log(e);
        }
    }

    static {
        ldap_domain = null;
        ldap_server = null;
        bind = new IP4Port();
    }

    public static class JBusMethods {
        public void getConfig(String pack) {
            JBusClient cfr_ignored_0 = SSH.ssh.busClient;
            JBusClient cfr_ignored_1 = SSH.ssh.busClient;
            SSH.ssh.busClient.call(pack, "getConfig", JBusClient.quote(JBusClient.encodeString(SSH.ssh.config)));
        }

        public void setConfig(String cfg) {
            JFLog.log("setConfig");
            try {
                FileOutputStream fos = new FileOutputStream(SSH.getConfigFile());
                fos.write(JBusClient.decodeString(cfg).getBytes());
                fos.close();
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        public void restart() {
            JFLog.log("restart");
            ssh.close();
            ssh = new SSH();
            ssh.start();
        }
    }

    static enum Section {
        None,
        Global;

    }
}

