/*
 * Decompiled with CFR 0.152.
 */
package javaforce.service;

import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javaforce.Base64;
import javaforce.JF;
import javaforce.JFLog;
import javaforce.service.WebHandler;
import javaforce.service.WebRequest;
import javaforce.service.WebResponse;
import javaforce.service.WebSocket;
import javaforce.service.WebSocketHandler;
import javax.net.ssl.SSLServerSocketFactory;

public class Web {
    private WebHandler api;
    private WebSocketHandler wsapi;
    private ServerSocket ss;
    private boolean active = true;
    public static boolean config_enable_gzip = true;

    public boolean start(WebHandler api, int port, boolean secure) {
        this.api = api;
        try {
            this.ss = secure ? SSLServerSocketFactory.getDefault().createServerSocket(port) : new ServerSocket(port);
            new Server(this).start();
        }
        catch (Exception e) {
            JFLog.log(e);
            return false;
        }
        return true;
    }

    public void setWebSocketHandler(WebSocketHandler wsapi) {
        this.wsapi = wsapi;
    }

    public void stop() {
        this.active = false;
        try {
            this.ss.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static byte[] chunkHeader(byte[] in) {
        return String.format("%x\r\n", in.length).getBytes();
    }

    private static class Server
    extends Thread {
        private Web web;

        public Server(Web web2) {
            this.web = web2;
        }

        @Override
        public void run() {
            while (this.web.active) {
                try {
                    Socket s = this.web.ss.accept();
                    new Connection(this.web, s).start();
                }
                catch (Exception e) {
                    JFLog.log(e);
                }
            }
        }
    }

    private static class Connection
    extends Thread {
        private Socket s;
        private InputStream is;
        private Web web;

        public Connection(Web web2, Socket s) {
            this.web = web2;
            this.s = s;
        }

        @Override
        public void run() {
            try {
                int ch;
                StringBuilder request = new StringBuilder();
                this.is = this.s.getInputStream();
                while (this.s.isConnected() && (ch = this.is.read()) != -1) {
                    request.append((char)ch);
                    if (!request.toString().endsWith("\r\n\r\n")) continue;
                    WebRequest req = new WebRequest();
                    req.request = request.toString();
                    req.fields = req.request.split("\r\n");
                    req.is = this.is;
                    req.serverIP = this.s.getLocalAddress().getHostAddress();
                    if (req.serverIP.equals("0:0:0:0:0:0:0:1")) {
                        req.serverIP = "127.0.0.1";
                    }
                    req.serverPort = this.s.getLocalPort();
                    req.remoteIP = this.s.getInetAddress().getHostAddress();
                    req.remotePort = this.s.getPort();
                    WebResponse res = new WebResponse();
                    res.os = this.s.getOutputStream();
                    req.fields0 = req.fields[0].split(" ");
                    req.init(res);
                    if (this.isWebSocketRequest(req)) {
                        WebSocket socket = new WebSocket(this.s.getInetAddress().getHostAddress());
                        socket.is = this.is;
                        socket.os = res.os;
                        socket.url = req.fields0[1];
                        if (this.web.wsapi != null && this.web.wsapi.doWebSocketConnect(socket)) {
                            this.sendWebSocketAccepted(req, res);
                            this.processWebSocket(socket);
                            break;
                        }
                        this.sendWebSocketDenied(req, res);
                        break;
                    }
                    if (req.fields0[0].equals("GET")) {
                        req.method = "GET";
                        this.web.api.doGet(req, res);
                    } else if (req.fields0[0].equals("POST")) {
                        req.method = "POST";
                        this.web.api.doPost(req, res);
                    } else {
                        res.setStatus(501, "Error - Unsupported Method");
                    }
                    if (res.liveStream) {
                        return;
                    }
                    res.writeAll(req);
                    if (req.fields0[2].equals("HTTP/1.0")) break;
                    request.setLength(0);
                }
                this.s.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private boolean isWebSocketRequest(WebRequest req) {
            boolean upgrade = false;
            boolean websocket = false;
            boolean haveKey = false;
            for (int a = 0; a < req.fields.length; ++a) {
                String field = req.fields[a];
                if (field.startsWith("Connection:") && field.indexOf("Upgrade") != -1) {
                    upgrade = true;
                }
                if (field.startsWith("Upgrade:") && field.indexOf("websocket") != -1) {
                    websocket = true;
                }
                if (!field.startsWith("Sec-WebSocket-Key:")) continue;
                haveKey = true;
            }
            return upgrade && websocket && haveKey;
        }

        private String encodeKey(String inKey) {
            inKey = (String)inKey + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
            MessageDigest md = null;
            try {
                md = MessageDigest.getInstance("SHA-1");
            }
            catch (NoSuchAlgorithmException e) {
                JFLog.log(e);
            }
            byte[] sha1 = md.digest(((String)inKey).getBytes());
            String base64 = new String(Base64.encode(sha1));
            return base64;
        }

        private void sendWebSocketAccepted(WebRequest req, WebResponse res) {
            res.setStatus(101, "Switching Protocols");
            res.addHeader("Upgrade: websocket");
            res.addHeader("Connection: Upgrade");
            String inKey = null;
            String[] protocols = null;
            for (int a = 0; a < req.fields.length; ++a) {
                String field = req.fields[a];
                if (field.startsWith("Sec-WebSocket-Key:")) {
                    inKey = field.substring(18).trim();
                }
                if (!field.startsWith("Sec-WebSocket-Protcol:")) continue;
                protocols = field.substring(22).trim().split(",");
            }
            String outKey = this.encodeKey(inKey);
            res.addHeader("Sec-WebSocket-Accept: " + outKey);
            try {
                res.writeAll(req);
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        private void sendWebSocketDenied(WebRequest req, WebResponse res) {
            res.setStatus(403, "Access Denied");
            try {
                res.writeAll(req);
            }
            catch (Exception e) {
                JFLog.log(e);
            }
        }

        private void processWebSocket(WebSocket socket) {
            byte[] maskKey = new byte[4];
            try {
                while (true) {
                    boolean fin;
                    int opcode;
                    if ((opcode = socket.is.read()) == -1) {
                        throw new Exception("socket error");
                    }
                    boolean bl = fin = (opcode & 0x80) == 128;
                    if ((opcode &= 0xF) != 8) {
                        int a;
                        long length = 0L;
                        int len7 = socket.is.read();
                        if (len7 == -1) {
                            throw new Exception("socket error");
                        }
                        boolean hasMask = (len7 & 0x80) == 128;
                        switch (len7 &= 0x7F) {
                            case 126: {
                                for (a = 0; a < 2; ++a) {
                                    int len8 = socket.is.read();
                                    if (len8 == -1) {
                                        throw new Exception("socket error");
                                    }
                                    length <<= 8;
                                    length |= (long)len8;
                                }
                                break;
                            }
                            case 127: {
                                for (int a2 = 0; a2 < 8; ++a2) {
                                    long len8 = socket.is.read();
                                    if (len8 == -1L) {
                                        throw new Exception("socket error");
                                    }
                                    length <<= 8;
                                    length |= len8;
                                }
                                break;
                            }
                            default: {
                                length = len7;
                            }
                        }
                        if (hasMask) {
                            for (a = 0; a < 4; ++a) {
                                int mask8 = socket.is.read();
                                if (mask8 == -1) {
                                    throw new Exception("socket error");
                                }
                                maskKey[a] = (byte)mask8;
                            }
                        } else {
                            throw new Exception("WebSocket message without mask");
                        }
                        if (length > 0x1000000L) {
                            throw new Exception("WebSocket message > 16MB");
                        }
                        byte[] data = JF.readAll(socket.is, (int)length);
                        int a3 = 0;
                        while ((long)a3 < length) {
                            int n = a3;
                            data[n] = (byte)(data[n] ^ maskKey[a3 % 4]);
                            ++a3;
                        }
                        if (opcode == 9) {
                            socket.write(data, 10);
                            continue;
                        }
                        if (opcode > 8) continue;
                        this.web.wsapi.doWebSocketMessage(socket, data, opcode);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                JFLog.log(e);
            }
            this.web.wsapi.doWebSocketClosed(socket);
        }
    }
}

